; -------------------------------------------------------------------------------------------------------------- ;
; Bounty Bob Strikes Back Original (Copy Protected) - bounty bob.prg
; -------------------------------------------------------------------------------------------------------------- ;
; Memory Map
; -------------------------------------------------------------------------------------------------------------- ;
; $0000 - $00ff:  Zero Page Values
; $0100 - $01ff:  Processor Stack
; $0200 - $02ff:  C64 system
; 
; $0300 - $04bf:  Sprite Storage - Low
; $04c0 - $07ff:  Game Code Area #01
; $0800 - $0bf7:  Screen: HiRes - Colors
; $0bf8 - $0bff:  Sprite Pointers
; $0c00 - $0fbf:  Sprite Storage - High
; $0fc0 - $117f:  Game Code Area #02
; $1180 - $1247:  Table: Adr HiRes Rows low
; $1248 - $130f:  Table: Adr HiRes Rows high
; $1310 - $137f:  Table: Adr HiRes Cols low
; $1380 - $134f:  Table: Adr HiRes Cols low
; $1450 - $169d:  Character Set 01
; $169e - $18eb:  Character Set 02
; $18ec - $1b39:  Character Set 03
; $1b3a - $134f:  Character Set 04
; $1d88 - $1e21:  High Score Table
; $1e22 - $1e35:  Work: Game Options
; $1e36 - $1efd:  Work: Items
; $1efe - $1ff7:  Work: Ladder
; $1ff8 - $1ffd:  Work: Level Time
; $1ffe        :  Misc: Master Cheat Level No
; $1fff        :  Misc: Number of Item Just Picked Up
; $2000 - $3f3f:  Screen: HiRes - Game/Intro/Score
; $3f40 - $3f4a:  ---<unused>---
; $3f4b - $b4f0:  Game Main Code
; $b4f1 - $b7ff:  Level Data Area
; $b800 - $caff:  ---<unused>--- (except $c1ca)
; $cb00 - $cbca:  Level Loader (bb2.asm)
; $cbcb - $ccff:  ---<unused>--- (except $ce40-$ce41)
; $cd00 - $ce40:  save area
; $ce41 - $cfff:  ---<unused>---
; $d000 - $d6bf:  Sprite Data: Bob
; $da20 - $dfd8:  Game Code Area #03
; $dfd9 - $dfff:  ---<unused>---
; $e000 - $e5ea:  Level Start Info Character Set
; $e5eb - $e6ea:  Save Area Zero Page
; $e6eb - $e725:  Tab: Character Data Pointers Hi
; $e726 - $e760:  Tab: Character Data Pointers Lo
; $e761 - $e769:  Misc: Work Values
; $e76a - $e76b:  ---<unused>---
; $e76c - $e793:  Tab: Status Pointer Lo
; $e794 - $e7bb:  Tab: Status Pointer Hi
; $e7bc - $e7c2:  Buf: Scorer Name Input
; $e7c3 - $e7d9:  SID Registers Save Area
; $e7da - $e7df:  ???
; $e7e0 - $e7ff:  Work: Sprites PosX
; $e800 - $ebe7:  Screen: Level Start Info/Game Over
; $ebe8 - $ebff:  ---<unused>---
; $ec00 - $efe7:  Color Ram Save Area
; $efe8 - $efff:  ---<unused>---
; $f000 - $f0ff:  Work: Floor/Float Platform
; $f100 - $f28f:  Work: Sprites
; $f290 - $f357:  Work: Ladder
; $f358 - $f375:  Work: Level Borders
; $f376 - $f38f:  Work: Matter Transmitter
; $f394 - $f3e3:  Work: Float Platforms
; $f394 - $f3e3:  Work: Float Platforms
; $f3e4 - $f40b:  Work: Suction Tubes
; $f40c - $f429:  Work: Pulverizor
; $f42a - $f489:  Work: Acid Rain
; $f48a - $f4a4:  Buf: Level Start Tunes
; $f4a5        :  Count: Enemy Sprites
; $f4a6 - $f4a8:  Code: Level Select
; $f4a9 - $f4aa:  Level Secret Messages
; $f4ab - $f4af:  Code: Master Cheat
; $f6b0 - $f6b5:  Work: Scores To Add
; $f6b6 - $f6c1:  Play Game Data Player 01
; $f6c2 - $f783:  ---<unused>---
; $f784 - $f959:  Work: Item Data
; $f95a - $f967:  Work: Scores
; $f968 - $f987:  Play Game Data Player 02
; $f988 - $f9a7:  Save Game Data Player 02
; $f9a8 - $faa7:  Tab: Random Colors
; $faa8 - $faac:  Buffer: Item Colors
; $faad - $facf:  ---<unused>---
; $fad0 - $fae7:  Tab: Color Screen Pointer Lo
; $fae8 - $fcff:  Tab: Color Screen Pointer Hi
; $fb00 - $fb5a:  Tab: Character Data Pointers Lo
; $fb5b - $fbb5:  Tab: Character Data Pointers Hi
; $fbb6 - $fd61:  Game Code Area #04
; $fd62 - $fff9:  ---<unused>---
; $fffa - $ffff:  IRQ/--/NMI Vectors
; -------------------------------------------------------------------------------------------------------------- ;
                        * equ $27c0                       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; compiler settings
; -------------------------------------------------------------------------------------------------------------- ;
                        incdir  ..\inc                    ; C64 System Includes
                        
C64CIA1                 include c64_cia1.asm              ; Complex Interface Adapter (CIA) #1 Registers  $dc00-$dc0f
C64CIA2                 include c64_cia2.asm              ; Complex Interface Adapter (CIA) #2 Registers  $dd00-$dd0f
C64SID                  include c64_sid.asm               ; Sound Interface Device (SID) Registers        $d400-$d41c
C64VicII                include c64_vic.asm               ; Video Interface Chip (VIC-II) Registers       $d000-$d02e
C64Colors               include c64_color.asm             ; Colour RAM Address / Colours
C64Kernal               include c64_kernal.asm            ; Kernal Routines entry points                  $e000-$ffff
C64Memory               include c64_mem.asm               ; Standard Zeropage / Stack / Vector constants
                        
Game                    include inc\BB_VarsGame.asm       ; Game Variables
WorkAreas               include inc\BB_WorkAreas.asm      ; Game Work Areas
ZeroPage                include inc\BB_Zpg.asm            ; Zero Page Addresses

LevelCtrl               include asm\data\BB_LevelCtrl.asm ; Level Data Blocks
BobSprites              include asm\data\BB_Sprite.asm    ; Sprite Definitios
MusicDataCharSet        include asm\data\BB_Data.asm      ; Music / Character Set
; -------------------------------------------------------------------------------------------------------------- ;
; InitOnce              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitOnce                subroutine                        ; .hbu001. change to make it run (copy prot)
.EntryPoint             jmp $0d00                         ; endless return to MainBobData of bob-data.asm
                                                          ; will be replaced in bob-data.asm
                        dc.b $ff ; low of: ldx #$ff
                        dc.b $9a ; txs
; -------------------------------------------------------------------------------------------------------------- ;
; Code Replacement in MainBobData of bob-data.asm after a successfull disk check
; -------------------------------------------------------------------------------------------------------------- ;
;.EntryPoint            cld                               ; 
;                       sei                               ; 
;                       
;                       ldx #$ff                          ; 
;                       txs                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetNMI                 lda #<NMI                         ; 
                        sta VNMI_LO                       ; .hbu001. change to HNMI_LO to make it run (copy prot)
                        lda #>NMI                         ; 
                        sta HNMI_HI                       ; Kernal($FFFA) Non-Maskable Interrupt Hardware Vector ($FE43)
                        
                        lda #$00                          ; 
                        ldx #$18                          ; 
.InitCIAsSID            sta CIA1,x                        ; CIA1($dc00)
                        sta CIA2,x                        ; CIA2($DD00) 
                        sta SID,x                         ; SID ($D400)
                        dex                               ; 
                        bpl .InitCIAsSID                  ; 
                        
.IniTimerStart          lda #$80                          ; #....... - PM for TODHRS
.IniTimerOffset         ldx #$03                          ; Tod Timers - TODTEN/TODSEC/TODMIN/TODHRS
.SetTimerStart          sta TODTEN,x                      ; CIA1($DC08) Time of Day Clock Tenths
                        lda #$00                          ; ........ - AM for TO2HRS
                        sta TO2TEN,x                      ; CIA2($DD08) Time of Day Clock Tenths
                        dex                               ; 
                        bpl .SetTimerStart                ; start on write to TODTEN
                        
.OverWriteSurvive       ldx #[* - .EntryPoint]            ; $00 destroy code from .EntryPoint to .OverWriteSurvive
.OverWriteCode          sta [.EntryPoint - $01],x         ; 
                        dex                               ; 
                        bne .OverWriteCode                ; 
                        
                        sta SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        sta EXTCOL                        ; VIC($D020) Border Color
                        
                        ldx #$02                          ; 
.ClrZeroPage            sta D6510,x                       ; leave out D6510 and R6510
                        inx                               ; 
                        bne .ClrZeroPage                  ; 
                        
                        ldx #$1f                          ; 
                        stx CI2ICR                        ; CIA2($DD0D) Interrupt Control Register
                        stx [CIAICR + $f0]                ; CIA1($DD0D) Interrupt Control Register - Register Images - Mirror of $DC00-$DC0F
                        
                        lda #D6510_INI                    ; $2f = Tap_Motor | Tap_Out | Mem_Ini]
                        sta D6510                         ; 
                        
                        lda R6510                         ; 
                        and #[KERNAL_OFF & BASIC_OFF]     ; ##### #.. = io=off basic=off kernal=off
                        sta R6510                         ; 
                        
                        ldx #$00                          ; 
                        stx BBZ_TabHiResAdrColLo          ; 
                        stx BBZ_TabHiResAdrColHi          ; 
                        
                        ldy #$04                          ; 
.IniTabHiResPtrOff      lda BBZ_TabHiResAdrColHi          ; 
                        sta BB_TabHiResAdrColHi,x         ; 
                        lda BBZ_TabHiResAdrColLo          ; 
                        sta BB_TabHiResAdrColLo,x         ; 
                        dey                               ; 
                        bne .IncOffset                    ; 
                        
                        clc                               ; 
                        adc #$08                          ; 
                        sta BBZ_TabHiResAdrColLo          ; 
                        bcc .SetCount                     ; 
                        inc BBZ_TabHiResAdrColHi          ; 
                        
.SetCount               ldy #$04                          ; 
.IncOffset              inx                               ; 
                        cpx #$a0                          ; 
                        bcc .IniTabHiResPtrOff            ; 
                        
.IniTabCharAdrMax       lda #<[BB_Scrn_HiResCharSet1 - BB_Scrn_HiResCharDataLen] ; $94
                        ldy #>[BB_Scrn_HiResCharSet1 - BB_Scrn_HiResCharDataLen] ; $16
                        ldx #DataCharCount                ; char number "z" + 1
.IniTabCharAdr          sta [BB_InfoCharDataPtrLo - $01],x; $e726-$e760: Lo - BB_Scrn_HiResCharSet0 + BB_Scrn_HiResCharDataLen
                        pha                               ; 
                        tya                               ; 
                        sta [BB_InfoCharDataPtrHi - $01],x; $e6eb-$e725: Hi - BB_Scrn_HiResCharSet0 + BB_Scrn_HiResCharDataLen
                        pla                               ; 
                        sec                               ; 
                        sbc #BB_Scrn_HiResCharDataLen     ; 
                        bcs .DecOffset                    ; 
                        
                        dey                               ; 
                        
.DecOffset              dex                               ; 
                        bne .IniTabCharAdr                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Generate 4 $02*$05 sprite char sets with each char shifted 2 bits further to the right
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #$04                          ; 
.IniGenNextCharZeroPtr  lda TabGenCharSetsIni,x           ; 
                        sta [BBZ_ShiftCharDataCount - $01],x ; 
                        dex                               ; 
                        bne .IniGenNextCharZeroPtr        ; 
                        
.GenNextCharForSet0     ldy #$00                          ; 
.GetNextShiftCountSet0  lda #$04                          ; 
                        sta BBZ_ShiftCount                ; 
                        
                        lda #$00                          ; 
                        sta BBZ_CharSetData               ; 
.GetNextCharValue       jsr ShiftGetCharData              ; 
                        
                        php                               ; 
                        rol BBZ_CharSetData               ; 
                        plp                               ; 
                        rol BBZ_CharSetData               ; 
                        
                        dec BBZ_ShiftCount                ; 
                        bne .GetNextCharValue             ; 
                        
                        lda BBZ_CharSetData               ; 
                        sta (BBZ_HiResCharSetPtr),y       ; 
                        
                        iny                               ; 
                        jsr ShiftGetCharData              ; 
                        
                        php                               ; 
                        ror a                             ; 
                        plp                               ; 
                        ror a                             ; 
                        and #$c0                          ; ##......
                        sta (BBZ_HiResCharSetPtr),y       ; 
                        
                        iny                               ; 
                        cpy #BB_Scrn_HiResCharDataLen     ; 
                        bcc .GetNextShiftCountSet0        ; 
                        
                        tya                               ; 
                        clc                               ; 
                        adc BBZ_HiResCharSetPtrLo         ; 
                        sta BBZ_HiResCharSetPtrLo         ; 
                        bcc .DecCharCounter               ; 
                        inc BBZ_HiResCharSetPtrHi         ; 
                        
.DecCharCounter         dec BBZ_HiResSetCharCount         ; 
                        bne .GenNextCharForSet0           ; 
                        
                        lda #<BB_Scrn_HiResCharSet1       ; 
                        sta BBZ_HiResCharSet0PtrLo        ; 
                        lda #>BB_Scrn_HiResCharSet1       ; 
                        sta BBZ_HiResCharSet0PtrHi        ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Generate the $02*$05 sprite char set at BB_Scrn_HiResCharSet1 - BB_Scrn_HiResCharSet3
; -------------------------------------------------------------------------------------------------------------- ;
.GenNextCharForSet1     ldy #$01                          ; 
                        lda #$02                          ; 
.SetNextShiftCountSet1  sta BBZ_CharSetsShiftCount        ; 
                        
                        lda #<BB_Scrn_HiResCharSet0       ; 
                        sta BBZ_HiResCharSet1PtrLo        ; 
                        lda #>BB_Scrn_HiResCharSet0       ; 
                        sta BBZ_HiResCharSet1PtrHi        ; 
                        
.GetNextCharPtrSet1     lda (BBZ_HiResCharSet1Ptr),y      ; 
                        sta BBZ_CharSetDataRaw            ; 
                        
                        dey                               ; 
                        
                        lda (BBZ_HiResCharSet1Ptr),y      ; 
                        ldx BBZ_CharSetsShiftCount        ; 
                        
.ShiftCharVal           lsr a                             ; 
                        ror BBZ_CharSetDataRaw            ; 
                        dex                               ; 
                        bne .ShiftCharVal                 ; 
                        
.SetShiftedCharVal      sta (BBZ_HiResCharSet0Ptr),y      ; 
                        iny                               ; 
                        lda BBZ_CharSetDataRaw            ; 
                        sta (BBZ_HiResCharSet0Ptr),y      ; 
                        
.SetNextCharPtrSet0     lda BBZ_HiResCharSet0PtrLo        ; 3 shifted char sets
                        clc                               ; 
                        adc #BB_Scrn_HiResCharWidth       ; char width
                        sta BBZ_HiResCharSet0PtrLo        ; 
                        bcc .SetNextCharPtrSet1           ; 
                        inc BBZ_HiResCharSet0PtrHi        ; 
                        
.SetNextCharPtrSet1     lda BBZ_HiResCharSet1PtrLo        ; 
                        clc                               ; 
                        adc #BB_Scrn_HiResCharWidth       ; char width
                        sta BBZ_HiResCharSet1PtrLo        ; 
                        bcc .ChkNextCharPtrSet1Max        ; 
                        inc BBZ_HiResCharSet1PtrHi        ; 
                        
.ChkNextCharPtrSet1Max  cmp #<BB_Scrn_HiResCharSet1       ; 
                        bne .GetNextCharPtrSet1           ; 
                        
                        lda BBZ_HiResCharSet1PtrHi        ; 
                        cmp #>BB_Scrn_HiResCharSet1       ; 
                        bne .GetNextCharPtrSet1           ; 
                        
                        lda BBZ_CharSetsShiftCount        ; 
                        clc                               ; 
                        adc #$02                          ; 
                        cmp #$08                          ; 
                        bcc .SetNextShiftCountSet1        ; lower
; -------------------------------------------------------------------------------------------------------------- ;
                        ldx #BB_WA_Score_LenMax           ; leave last $06 bytes untouched - $1e36-$1e3b 
                        lda #$00                          ; 
.IniHighScores          sta [BB_WA_Score - $01],x         ; set last chrs $f0-$ff to $00
                        dex                               ; 
                        bne .IniHighScores                ; 
                        
                        ldx #$5a                          ; DataChar_5a
                        lda #<DataSmall_z                 ; address of small z
                        ldy #>DataSmall_z                 ; 
.IniTabDataChrPtr       sta BB_StatusCharDataPtrLo,x      ; 
                        pha                               ; 
                        tya                               ; 
                        sta BB_StatusCharDataPtrHi,x      ; 
                        pla                               ; 
                        sec                               ; 
                        sbc #$08                          ; 
                        bcs .DecDataChrNo                 ; 
                        
                        dey                               ; 
                        
.DecDataChrNo           dex                               ; 
                        bpl .IniTabDataChrPtr             ; 
                        
                        ldx #[BB_StatusRowPosPtrLen - $01] ; $28 positions
                        lda #<[BB_Scrn_Status + BB_Scrn_HiResRowLen - $08] ; 
                        ldy #>[BB_Scrn_Status + BB_Scrn_HiResRowLen - $08] ; 
.IniTabHiResPtrStat     sta BB_StatusRowPosPtrLo,x        ; 
                        pha                               ; 
                        tya                               ; 
                        sta BB_StatusRowPosPtrHi,x        ; 
                        pla                               ; 
                        sec                               ; 
                        sbc #$08                          ; 
                        bcs .DecHiresStatPos              ; 
                        
                        dey                               ; 
                        
.DecHiresStatPos        dex                               ; 
                        bpl .IniTabHiResPtrStat           ; 
                        
.CopyRoutines_01        lda #<CopyCode_01                 ; 
                        sta BBZ_CopyCodeFromPtrLo         ; 
                        lda #>CopyCode_01                 ; 
                        sta BBZ_CopyCodeFromPtrHi         ; ($80/$81) = $32fa - start
                        lda #<BB_Code_IrqGame             ; 
                        sta BBZ_CopyCodeToPtrLo           ; 
                        lda #>BB_Code_IrqGame             ; 
                        sta BBZ_CopyCodeToPtrHi           ; ($82/$83) = $04c0 - target
                        lda #<[$FFFF - [CopyCode_01_X - CopyCode_01 - $01]] ; 
                        sta BBZ_CopyCodeLenLo             ; 
                        lda #>[$FFFF - [CopyCode_01_X - CopyCode_01 - $01]] ; 
                        sta BBZ_CopyCodeLenHi             ; ($84/$85) = $fcc5 - length
                        jsr CopyDataPages                 ; 
                        
.CopyRoutines_02        lda #<CopyCode_02                 ; 
                        sta BBZ_CopyCodeFromPtrLo         ; 
                        lda #>CopyCode_02                 ; 
                        sta BBZ_CopyCodeFromPtrHi         ; ($80/$81) = $3635 - start
                        lda #<BB_Code_IrqStatus           ; 
                        sta BBZ_CopyCodeToPtrLo           ; 
                        lda #>BB_Code_IrqStatus           ; 
                        sta BBZ_CopyCodeToPtrHi           ; ($82/$83) = $0fc0 - target
                        lda #<[$FFFF - [CopyCode_02_X - CopyCode_02 - $01]] ; 
                        sta BBZ_CopyCodeLenLo             ; 
                        lda #>[$FFFF - [CopyCode_02_X - CopyCode_02 - $01]] ; 
                        sta BBZ_CopyCodeLenHi             ; ($84/$85) = $fe4f - length ($1b0)
                        jsr CopyDataPages                 ; 
                        
.CopyRoutines_03        lda #<CopyCode_03                 ; 
                        sta BBZ_CopyCodeFromPtrLo         ; 
                        lda #>CopyCode_03                 ; 
                        sta BBZ_CopyCodeFromPtrHi         ; ($80/$81) = $37e6 - start
                        lda #<BB_Code_GameOptsScore       ; 
                        sta BBZ_CopyCodeToPtrLo           ; 
                        lda #>BB_Code_GameOptsScore       ; 
                        sta BBZ_CopyCodeToPtrHi           ; ($82/$83) = $da20 - target
                        lda #<[$FFFF - [CopyCode_03_X - CopyCode_03 - $01]] ; 
                        sta BBZ_CopyCodeLenLo             ; 
                        lda #>[$FFFF - [CopyCode_03_X - CopyCode_03 - $01]] ; 
                        sta BBZ_CopyCodeLenHi             ; ($84/$85) = $fa47 - length
                        jsr CopyDataPages                 ; 
                        
.CopyRoutines_04        lda #<CopyCode_04                 ; 
                        sta BBZ_CopyCodeFromPtrLo         ; 
                        lda #>CopyCode_04                 ; 
                        sta BBZ_CopyCodeFromPtrHi         ; ($80/$81) = $2879 - start
                        lda #<BB_Code_CharSfxData         ; 
                        sta BBZ_CopyCodeToPtrLo           ; 
                        lda #>BB_Code_CharSfxData         ; 
                        sta BBZ_CopyCodeToPtrHi           ; ($82/$83) = $e000 - target
                        lda #<[$FFFF - [CopyCode_04_X - CopyCode_04 - $01]] ; 
                        sta BBZ_CopyCodeLenLo             ; 
                        lda #>[$FFFF - [CopyCode_04_X - CopyCode_04 - $01]] ; 
                        sta BBZ_CopyCodeLenHi             ; ($84/$85) = $fa15 - length
                        jsr CopyDataPages                 ; 
                        
.CopyRoutines_05        lda #<CopyCode_05                 ; 
                        sta BBZ_CopyCodeFromPtrLo         ; 
                        lda #>CopyCode_05                 ; 
                        sta BBZ_CopyCodeFromPtrHi         ; ($80/$81) = $3d9f - start
                        lda #<BB_Code_ScoreInput          ; 
                        sta BBZ_CopyCodeToPtrLo           ; 
                        lda #>BB_Code_ScoreInput          ; 
                        sta BBZ_CopyCodeToPtrHi           ; ($82/$83) = $fbb6 - target
                        lda #<[$FFFF - [CopyCode_05_X - CopyCode_05 - $01]] ; 
                        sta BBZ_CopyCodeLenLo             ; 
                        lda #>[$FFFF - [CopyCode_05_X - CopyCode_05 - $01]] ; 
                        sta BBZ_CopyCodeLenHi             ; ($84/$85) = $fe54 - length
                        jsr CopyDataPages                 ; 
                        
                        lda #<BB_BobSpriteData            ; 
                        sta BBZ_BobSpriteDataPtrLo        ; 
                        sta BBZ_BobSpriteDataRawPtrLo     ; 
                        
                        lda #>BB_BobSpriteData            ; 
                        sta BBZ_BobSpriteDataPtrHi        ; 
                        sta BBZ_BobSpriteDataRawPtrHi     ; 
                        
                        lda #BBZ_MirrorShiftFlag_No       ; 
                        sta BBZ_MirrorShiftFlag           ; 
                        
.GenBobSpriteIni        ldx #$00                          ; 
.GenBobSprite           stx BBZ_BobSpriteCtrlTabPos       ; 
                        ldy TabBobSpriteCtrl_01,x         ; BBZ_BobSpriteDataPos_01
                        lda TabBobSpriteCtrl_02,x         ; BBZ_BobSpriteDataPos_02
                        jsr GenBobSpriteData              ; 
                        
                        ldy #$81                          ; BBZ_BobSpriteDataPos_01
                        lda TabBobSpriteCtrl_03,x         ; BBZ_BobSpriteDataPos_02
                        jsr GenBobSpriteData              ; 
                        
                        inx                               ; 
                        cpx #TabBobSpriteCtrl_Len         ; 
                        bcc .GenBobSprite                 ; 
                        
                        dec BBZ_MirrorShiftFlag           ; BBZ_MirrorShiftFlag_Yes
                        bpl .GenBobSpriteIni              ; 
                        
                        lda #$30                          ; 
.SetBobSprtMax          sta BBZ_BobSpriteDataMax          ; 
                        
.SetBobSprtCount        lda #$12                          ; 
                        sta BBZ_SpriteDataCount           ; 
                        
.GetNextBobSprtData     ldy #$00                          ; 
                        lda (BBZ_BobSpriteDataRawPtr),y   ; 
                        
                        ldy #$04                          ; 
                        
.NextBobSprtRow         ldx #$02                          ; 
                        
.SaveDataByte           pha                               ; 
                        
                        asl a                             ; 
                        rol BBZ_BobSpriteDataByteLo01     ; 
                        rol BBZ_BobSpriteDataByteHi01     ; 
                        asl a                             ; 
                        rol BBZ_BobSpriteDataByteLo01     ; 
                        rol BBZ_BobSpriteDataByteHi01     ; 
                        
.RestoreDataByte        pla                               ; 
                        
                        dex                               ; 
                        bne .SaveDataByte                 ; 
                        
                        asl a                             ; 
                        asl a                             ; 
                        
                        dey                               ; 
                        bne .NextBobSprtRow               ; 
                        
                        lda BBZ_BobSpriteDataByteHi01     ; 
                        sta (BBZ_BobSpriteDataPtr),y      ; 
                        
                        ldy #$12                          ; 
                        lda BBZ_BobSpriteDataByteLo01     ; 
                        sta (BBZ_BobSpriteDataPtr),y      ; 
                        
.IncDataPtr             inc BBZ_BobSpriteDataPtrLo        ; 
                        bne .IncDataRawPtr                ; 
                        inc BBZ_BobSpriteDataPtrHi        ; 
                        
.IncDataRawPtr          inc BBZ_BobSpriteDataRawPtrLo     ; 
                        bne .DecSpriteCount               ; 
                        inc BBZ_BobSpriteDataRawPtrHi     ; 
                        
.DecSpriteCount         dec BBZ_SpriteDataCount           ; 
                        bne .GetNextBobSprtData           ; 
                        
                        lda BBZ_BobSpriteDataPtrLo        ; 
                        clc                               ; 
                        adc #$12                          ; 
                        sta BBZ_BobSpriteDataPtrLo        ; 
                        bcc .DecBobSprtMax                ; 
                        inc BBZ_BobSpriteDataPtrHi        ; 
                        
.DecBobSprtMax          dec BBZ_BobSpriteDataMax          ; 
                        bne .SetBobSprtCount              ; 
                        
                        lda #<[BB_BobSpriteData + $03]    ; 
                        sta BBZ_GetDataBytePtrLo          ; 
                        lda #>[BB_BobSpriteData + $03]    ; 
                        sta BBZ_GetDataBytePtrHi          ; 
                        
                        lda #BBZ_TabDrawLineColor_03      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        sta BBZ_BobSpriteFullCount        ; 
                        
.GetSingleHeight        ldx #$12                          ; $01 * sprite hight
                        jsr FixBobSprtData_21             ; 
                        
                        ldx #$36                          ; $03 * sprite hight
                        jsr FixBobSprtData_21             ; 
                        
                        dec BBZ_TabDrawLineColorPtr       ; 
                        bne .GetSingleHeight              ; 
                        
.FullFix                jsr FixBobSprtDataFull            ; 
                        jsr FixBobSprtDataFull            ; 
                        jsr FixBobSprtDataFull            ; 
                        
                        ldx #$5a                          ; $05 * sprite hight
                        jsr FixBobSprtData_45             ; 
                        
                        dec BBZ_BobSpriteFullCount        ; 
                        bne .FullFix                      ; 
                        
                        lda [TabItems + $00]              ; 
                        ldx [TabItems + $01]              ; 
                        jsr IniDataBytePtr                ; 
                        
                        ldx #$00                          ; 
.GetNextItemData        jsr GetDataByteIncPtr             ; 
                        beq .IncItemCount                 ; end of item data
                        
                        sta BB_WA_ItemDataCols,x          ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_ItemDataRows,x          ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_ItemDataScore,x         ; 
                        
                        lda BBZ_GetDataBytePtrLo          ; 
                        sta BB_WA_ItemDataPtrLo,x         ; 
                        lda BBZ_GetDataBytePtrHi          ; 
                        sta BB_WA_ItemDataPtrHi,x         ; 
                        
                        lda BB_WA_ItemDataCols,x          ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        lsr a                             ; /2
                        lsr a                             ; /4
                        sta BBZ_ItemWidth                 ; 
                        inc BBZ_ItemWidth                 ; 
                        
.GetItemRows            lda BBZ_TabDrawLineColorPtr       ; 
                        sta BBZ_ItemHight                 ; 
                        
.ReadPastHeight         jsr GetDataByteIncPtr             ; 
                        
                        dec BBZ_ItemHight                 ; item height
                        bne .ReadPastHeight               ; 
                        
                        dec BBZ_ItemWidth                 ; item width
                        bne .GetItemRows                  ; 
                        
.IncItemCount           inx                               ; item count
.ChkItemCountMax        cpx #$54                          ; 
                        bcc .GetNextItemData              ; lower
                        
                        lda R6510                         ; 
                        ora #[IO_ON | BASIC_ON]           ; .....#.# - io=on kernal=keep basic=on (if kernal=on)
                        sta R6510                         ; 
                        
.WaitBeamOffScreen      lda SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        bpl .WaitBeamOffScreen            ; VIC_RasterHi - wait for raster scanning is off-screen to avoid flickers
                        
                        lda RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        cmp #$14                          ; 
                        bne .WaitBeamOffScreen            ; 
                        
InitOnceX               jmp IrqDis_ColdStart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FixBobSprtDataFull    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FixBobSprtDataFull      subroutine                        ; 
                        ldx #$12                          ; full height
; -------------------------------------------------------------------------------------------------------------- ;
; FixBobSprtData_45     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FixBobSprtData_45       subroutine                        ; 
                        lda #$45                          ; 
                        bne FixBobSprtDataLen             ; always
; -------------------------------------------------------------------------------------------------------------- ;
; FixBobSprtData_21     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FixBobSprtData_21       subroutine                        ; 
                        lda #$21                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FixBobSprtDataLen     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FixBobSprtDataLen       subroutine                        ; 
                        ldy #$0e                          ; 
                        
                        clc                               ; 
                        adc BBZ_GetDataBytePtrLo          ; 
                        sta BBZ_GetBobDataBytePtrLo       ; 
                        
                        lda BBZ_GetDataBytePtrHi          ; 
                        adc #$00                          ; 
                        sta BBZ_GetBobDataBytePtrHi       ; 
                        
.GetNextSpriteData      lda (BBZ_GetBobDataBytePtr),y     ; 
                        lsr a                             ; 
                        ora (BBZ_GetBobDataBytePtr),y     ; 
                        eor #$ff                          ; ########
                        and (BBZ_GetDataBytePtr),y        ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        dey                               ; 
                        bpl .GetNextSpriteData            ; 
                        
                        txa                               ; 
                        
                        clc                               ; 
                        adc BBZ_GetDataBytePtrLo          ; 
                        sta BBZ_GetDataBytePtrLo          ; 
                        bcc FixBobSprtDataLenX            ; 
                        inc BBZ_GetDataBytePtrHi          ; 
                        
FixBobSprtDataLenX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteDataRaw     dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $7e ; .######.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7f ; .#######
                        dc.b $7f ; .#######
                        dc.b $7e ; .######.
                        dc.b $66 ; .##..##.
                        dc.b $66 ; .##..##.
                        dc.b $60 ; .##.....
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $34 ; ..##.#..
                        dc.b $3e ; ..#####.
                        dc.b $34 ; ..##.#..
                        dc.b $38 ; ..###...
                        dc.b $1c ; ...###..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $02 ; ......#.
                        dc.b $10 ; ...#....
                        dc.b $20 ; ..#.....
                        dc.b $40 ; .#......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $05 ; .....#.#
                        dc.b $57 ; .#.#.###
                        dc.b $72 ; .###..#.
                        dc.b $20 ; ..#.....
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $3c ; ..####..
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $7e ; .######.
                        dc.b $3c ; ..####..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $10 ; ...#....
                        dc.b $10 ; ...#....
                        dc.b $08 ; ....#...
                        dc.b $04 ; .....#..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $14 ; ...#.#..
                        dc.b $14 ; ...#.#..
                        dc.b $1e ; ...####.
                        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $ff ; ########
                        dc.b $3c ; ..####..
                        dc.b $34 ; ..##.#..
                        dc.b $3e ; ..#####.
                        dc.b $3c ; ..####..
                        dc.b $30 ; ..##....
                        dc.b $1c ; ...###..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $7e ; .######.
                        dc.b $7e ; .######.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $10 ; ...#....
                        dc.b $10 ; ...#....
                        dc.b $10 ; ...#....
                        dc.b $10 ; ...#....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $18 ; ...##...
                        dc.b $18 ; ...##...
                        dc.b $1c ; ...###..
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $10 ; ...#....
                        dc.b $10 ; ...#....
                        dc.b $20 ; ..#.....
                        dc.b $40 ; .#......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $24 ; ..#..#..
                        dc.b $24 ; ..#..#..
                        dc.b $36 ; ..##.##.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $83 ; #.....##
                        dc.b $81 ; #......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $24 ; ..#..#..
                        dc.b $26 ; ..#..##.
                        dc.b $60 ; .##.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $01 ; .......#
                        dc.b $41 ; .#.....#
                        dc.b $c0 ; ##......
                        dc.b $80 ; #.......
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $04 ; .....#..
                        dc.b $26 ; ..#..##.
                        dc.b $20 ; ..#.....
                        dc.b $60 ; .##.....
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteCtrl_01     dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $12 ; 
                        dc.b $00 ; 
TabBobSpriteCtrl_Len    equ  [* - TabBobSpriteCtrl_01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteCtrl_02     dc.b $24 ; 
                        dc.b $24 ; 
                        dc.b $24 ; 
                        dc.b $45 ; 
                        dc.b $55 ; 
                        dc.b $72 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteCtrl_03     dc.b $8a ; 
                        dc.b $60 ; 
                        dc.b $9c ; 
                        dc.b $ae ; 
                        dc.b $c0 ; 
                        dc.b $33 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GenBobSpriteData      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GenBobSpriteData        subroutine                        ; 
                        sty BBZ_BobSpriteDataPos_01       ; 
                        sta BBZ_BobSpriteDataPos_02       ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_DrawPosY                  ; 
                        ldy #$12                          ; 
                        sty BBZ_DrawPosX                  ; 
                        
.GetBobDataPosPart_01   ldx BBZ_BobSpriteDataPos_01       ; 
                        lda TabBobSpriteDataRaw,x         ; 
                        jsr MirrorByteCheck               ; swap if BBZ_MirrorShiftFlag_Yes
                        
.Shift_01               clc                               ; 
                        rol BBZ_BobSpriteDataByteLo01     ; 
                        rol BBZ_BobSpriteDataByteHi01     ; 
                        asl a                             ; 
                        rol BBZ_BobSpriteDataByteLo01     ; 
                        rol BBZ_BobSpriteDataByteHi01     ; 
                        dex                               ; 
                        bne .Shift_01                     ; 
                        
.GetBobDataPosPart_02   ldx BBZ_BobSpriteDataPos_02       ; 
                        lda TabBobSpriteDataRaw,x         ; 
                        jsr MirrorByteCheck               ; swap if BBZ_MirrorShiftFlag_Yes
                        
.Shift_02               asl a                             ; 
                        rol BBZ_BobSpriteDataByteLo02     ; 
                        rol BBZ_BobSpriteDataByteHi02     ; 
                        clc                               ; 
                        rol BBZ_BobSpriteDataByteLo02     ; 
                        rol BBZ_BobSpriteDataByteHi02     ; 
                        dex                               ; 
                        bne .Shift_02                     ; 
                        
                        lda BBZ_BobSpriteDataByteHi01     ; 
                        ora BBZ_BobSpriteDataByteHi02     ; 
                        ldy BBZ_DrawPosY                  ; 
                        sta (BBZ_BobSpriteDataPtr),y      ; 
                        
                        lda BBZ_BobSpriteDataByteLo01     ; 
                        ora BBZ_BobSpriteDataByteLo02     ; 
                        ldy BBZ_DrawPosX                  ; 
                        sta (BBZ_BobSpriteDataPtr),y      ; 
                        
                        inc BBZ_BobSpriteDataPos_01       ; 
                        inc BBZ_BobSpriteDataPos_02       ; 
                        inc BBZ_DrawPosY                  ; 
                        inc BBZ_DrawPosX                  ; 
                        
                        cpy #$23                          ; 
                        bcc .GetBobDataPosPart_01         ; 
                        
                        lda BBZ_BobSpriteDataPtrLo        ; 
                        clc                               ; 
                        adc #$24                          ; 
                        sta BBZ_BobSpriteDataPtrLo        ; 
                        bcc .GetCtrlTabPos                ; 
                        inc BBZ_BobSpriteDataPtrHi        ; 
                        
.GetCtrlTabPos          ldx BBZ_BobSpriteCtrlTabPos       ; 
                        
GenBobSpriteDataX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShiftGetCharData      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShiftGetCharData        subroutine                        ; 
                        dec BBZ_ShiftCharDataCount        ; 
                        bne .ShiftData                    ; 
                        
.GetData                lda TabCharSetData,x              ; 
                        sta BBZ_CharSetDataRaw            ; 
                        
.SetShiftCount          lda #$08                          ; 
                        sta BBZ_ShiftCharDataCount        ; 
                        
                        inx                               ; 
                        
.ShiftData              asl BBZ_CharSetDataRaw            ; 
                        
ShiftGetCharDataX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabGenCharSetsIni       equ [* - $01]                     ;
                        dc.b $01                          ; -> BBZ_ShiftCharDataCount
                        dc.b BB_Scrn_HiResCharCount       ; -> BBZ_HiResSetCharCount
                        
                        dc.b <BB_Scrn_HiResCharSet0       ; -> BBZ_HiResCharSetPtrLo
                        dc.b >BB_Scrn_HiResCharSet0       ; -> BBZ_HiResCharSetPtrHi
; -------------------------------------------------------------------------------------------------------------- ;
; StartOfCopies         
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_01             equ *                             ; 
                        rorg BB_Code_IrqGame              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameCheckInput    Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameCheckInput      subroutine                        ; 
__IRQSetDispatchSub     equ [IRQ_GameCheckInput + $01]    ; set on bob - sprite collisions
                        lda #BB_IrqSubID_None             ; 
                        beq .GoIrqDispatchSub             ; 
                        
.ClrDispatchSub         lda #BB_IrqSubID_None             ; 
                        sta __IRQSetDispatchSub           ; clear again
                        
                        jsr BobSetDeath                   ; 
                        
.GoIrqDispatchSub       jsr IrqDispatchSub                ; set number in __IrqDispatchSubID
                        
__IRQKeyPressed         equ [* + $01]                     ; 
                        lda #$ff                          ; key pressed
                        cmp #$ff                          ; none
                        beq .IniXmitCount                 ; 
                        
                        sta BBZ_KeyPressed                ; 
                        cmp #$19                          ; "9"
                        bcs .IniXmitCount                 ; greater/equal - past digits
                        
.WasDigit               sta __NumberKeyPressed            ; 
                        
.IniXmitCount           ldx #$00                          ; 
                        stx BBZ_BobXmitSpriteCount        ; 
                        
.GetRasterIni           lda #$fb                          ; preset raster
                        
                        cpx BBZ_CountSprites              ; 
                        bcs .SetNewRasterLine             ; greater/equal
                        
.GetRaster1st           lda BB_WA_SpriteRaster            ; plus $35 (1st plus $34)
                        
.SetNewRasterLine       jsr IRQ_IniNewRaster              ; ac=raster line
                        
                        inx                               ; $01
                        stx BBZ_SpriteNoToHandle          ; 
                        
                        ldx #[$00 & VIC_On & VIC_MCM_Off | VIC_Cols40 & VIC_SoftX_Clear] ; ....#... bit3=1 40_columns
                        stx SCROLX                        ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        ldx #$00                          ; 
                        ldy #$02                          ; 
                        
                        lda BBZ_LevelNumEquiv             ; 
                        cmp #BBZ_LevelNumEquiv_22         ; Level VV - Advanced Cannon
                        bne .SetEnemySprtNum              ; 
                        
                        ldx #$02                          ; 
                        ldy #$03                          ; 
                        
.SetEnemySprtNum        stx __GetXmitSpriteColor_P1       ; 
                        sty __GetXmitSpriteColor_P2       ; 
                        
                        cmp #BBZ_LevelNumEquiv_20         ; Level TT - Mobile Suction Unit
                        beq .GoIRQ_HoistMoTubes           ; 
                        
                        cmp #BBZ_LevelNumEquiv_02         ; Level BB - Utility Hoist
                        bne .GetJoystick                  ; 
                        
.GoIRQ_HoistMoTubes     jsr IRQ_MovTubHoistIni            ; 
                        
.GetJoystick            lda [CIAPRB + $f0]                ; CIA1(CIAPRB=$DC01) mirror: Data Port Register B
                        
                        ldy BBZ_ActivePlayer              ; 
                        bmi .IsolateMoves                 ; player 1
                        
                        ldy GameOptsSticks                ; 
                        beq .IsolateMoves                 ; 
                        
                        lda [CIAPRA + $f0]                ; CIA1(CIAPRA=$DC00) mirror: Data Port Register A
                        
.IsolateMoves           and #$1f                          ; ...##### - joystick moves
                        sta BBZ_JoystickMovesGame         ; 
                        
                        asl a                             ; ..#####.
                        asl a                             ; .#####..
                        asl a                             ; #####...
                        and #$80                          ; #....... - fire shifted to bit7
                        ora BBZ_JoystickMovesGame         ; #..#####
                        sta BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        
                        lda BBZ_GamePause                 ; 
                        bne IRQ_GameAction                ; BBZ_GamePauseOff
                        
.WasGamePause           jsr BobMoveSprite                 ; still check f_keys
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameCheckF_Keys   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameCheckF_Keys     subroutine                        ; 
                        lda #$00                          ; 
                        jsr CheckKeyBoard                 ; 
                        sta __IRQKeyPressed               ; key pressed or $ff
                        
                        jsr IntroCheck_F3                 ; 
                        
                        lda BBZ_GameDemoMode              ; 
                        beq .GoChk_F7                     ; BBZ_GameDemoModeOff
                        
                        jsr IntroCheck_Fire_F7            ; 
                        jmp .GoChk_F5                     ; 
                        
.GoChk_F7               jsr IntroCheck_F7                 ; 
.GoChk_F5               jsr IntroCheck_F5                 ; 
                        bcs IRQ_GameExitPrep              ; 
                        
                        ldx #BB_IrqSubID_ShowScores       ; 
                        stx __IrqDispatchSubID            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameExitPrep      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameExitPrep        subroutine                        ; 
.RestoreConfig          pla                               ; 
                        sta R6510                         ; 
                        
IRQ_GameExitPrepX       jmp IRQ_GameExit                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameAction        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameAction          subroutine                        ; 
                        lda BBZ_GameDemoMode              ; 
                        beq .EnableSprites                ; BBZ_GameDemoModeOff
                        
                        jsr BobDemoMove                   ; 
                        
.EnableSprites          lda #$ff                          ; 
                        sta SPENA                         ; VIC($D015) Sprite Enable Register
                        
                        ldx BBZ_CountSprites              ; 
                        beq .ScoreEnemies                 ; 
                        
.GetNextEneSprtNumA     lda BB_WA_SpriteNumberA,x         ; 
                        cmp BB_WA_SpriteNumberB,x         ; 
                        beq .GetNextEneSprtNumB           ; 
                        
                        sta BB_WA_SpriteNumberB,x         ; 
                        
                        tay                               ; 
                        cpy #$10                          ; score sprite numbers $10 $11
                        bcc .SetNextEneSprtPtrA           ; lower
                        
.ScoreEnemiesA          lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        lsr a                             ; $00 or $01 - keep in carry for pointer add
                        php                               ; save status
                        
                        lda BBZ_ScoreToAddEnemyAc         ; 
                        adc #$08                          ; score $80 or $90
                        sta BBZ_ScoreToAddEnemyAc         ; 
                        
                        tya                               ; 
                        plp                               ; restore status
                        adc #$00                          ; $00 or $01 - keep in carry for pointer add
                        tay                               ; point to score sprite $80 or $90
                        
.SetNextEneSprtPtrA     lda TabEnemySpritePtr,y           ; 
                        sta BB_WA_SpritePtrA,x            ; 
                        
.GetNextEneSprtNumB     lda BB_WA_SpriteNumberA_P2,x      ; 
                        cmp BB_WA_SpriteNumberB_P2,x      ; 
                        beq .SetNextEnemy                 ; 
                        
                        sta BB_WA_SpriteNumberB_P2,x      ; 
                        tay                               ; 
                        cpy #$10                          ; score sprite numbers $10 $11
                        bcc .SetNextEneSprtPtrB           ; lower
                        
.ScoreEnemiesB          lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        lsr a                             ; $00 or $01 - keep in carry for pointer add
                        php                               ; save status
                        
                        lda BBZ_ScoreToAddEnemyAc         ; 
                        adc #$08                          ; score $80 or $90
                        sta BBZ_ScoreToAddEnemyAc         ; 
                        
                        tya                               ; 
                        plp                               ; restore status
                        adc #$00                          ; $00 or $01 - keep in carry for pointer add
                        tay                               ; point to score sprite $80 or $90
                        
.SetNextEneSprtPtrB     lda TabEnemySpritePtr,y           ; 
                        sta BB_WA_SpritePtrB,x            ; 
                        
.SetNextEnemy           dex                               ; 
                        bpl .GetNextEneSprtNumA           ; 
                        
.ScoreEnemies           lda BBZ_ScoreToAddEnemyAc         ; 
                        sta BBZ_ScoreToAddEnemy           ; 
                        
                        lda #BBZ_EnemyStateBad            ; 
                        sta BBZ_ScoreToAddEnemyAc         ; 
                        sta BBZ_EnemyState                ; 
                        
                        lda BBZ_EnemyFlipFlag             ; 
                        beq .ChkGoodTimes                 ; 
                        
.Reset                  dec BBZ_EnemyFlipFlag             ; BBZ_EnemyFlipFlagNo
                        
                        lda #BBZ_EnemyGoodTimeIni         ; 
                        sta BBZ_EnemyGoodTime             ; 
                        sta BBZ_EnemyGoodTimeBlink        ; 
                        
                        lda #GREEN                        ; 
                        sta BBZ_EnemyGoodFlipColor        ; 
                        
                        lda #BBZ_EnemyGoodFlipCountIni    ; 
                        sta BBZ_EnemyGoodFlipCount        ; 
                        sta BBZ_EnemyState                ; BBZ_EnemyStateGood
                        
.ChkGoodTimes           ldx BBZ_EnemyGoodTime             ; 
                        bne .DecGoodTimes                 ; 
                        
.ColorFlipFlop          lda BBZ_EnemyGoodFlipColor        ; 
                        eor #$07                          ; .....### - flip green red
                        sta BBZ_EnemyGoodFlipColor        ; 
                        
                        cmp #GREEN                        ; 
                        beq .NextBlinkPeriod              ; 
                        
.DecFlipCount           dec BBZ_EnemyGoodFlipCount        ; 
                        ldx BBZ_EnemyGoodFlipCount        ; 
                        bne .SetGoodTimes                 ; 
                        
.NextBlinkPeriod        lsr BBZ_EnemyGoodTimeBlink        ; 
                        ldx BBZ_EnemyGoodTimeBlink        ; 
                        inx                               ; 
                        
.DecGoodTimes           dex                               ; 
.SetGoodTimes           stx BBZ_EnemyGoodTime             ; 

.GetBlueTimeColor       ldx #HR_WhiteBlue                 ; preset
                        ldy #$01                          ; 
                        
                        lda BB_WA_LevelTimesLo_1000       ; 
                        bne .GetBobFlickerColor           ; 
                        
                        lda BB_WA_LevelTimesLo_100        ; 
                        ora BB_WA_LevelTimesLo_10         ; 
                        beq .GetRedTimeColor              ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$01                          ; 
                        tay                               ; random orange/brown
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$10                          ; 
                        bne .GetBobFlickerColor           ; 
                        
.GetRedTimeColor        ldx #HR_WhiteRed                  ; 
                        
.GetBobFlickerColor     lda TabBobTimeFlicker,y           ; 
                        sta SP3COL                        ; VIC($D02A) Color Sprite 3
                        sta SP2COL                        ; VIC($D029) Color Sprite 2
                        
                        stx [BB_Scrn_ColorStatTime + $03] ; 1
                        
                        lda #$00                          ; preset zero
                        
                        ldy BB_WA_LevelTimesLo_10         ; 
                        bne .SetColorTime_10              ; 
                        
                        tax                               ; set zero
                        
.SetColorTime_10        stx [BB_Scrn_ColorStatTime + $02] ; 10
                        ldy BB_WA_LevelTimesLo_100        ; 
                        bne .SetColorTime_100             ; 
                        
                        tax                               ; set zero
                        
.SetColorTime_100       stx [BB_Scrn_ColorStatTime + $01] ; 100
                        ldy BB_WA_LevelTimesLo_1000       ; 
                        bne .SetColorTime_1000            ; 
                        
                        tax                               ; set zero
                        
.SetColorTime_1000      stx [BB_Scrn_ColorStatTime + $00] ; 1000
                        
                        lda #$00                          ; 
                        sta BBZ_ScoreToAddFloor           ; 
                        
.IncTimer               inc BBZ_IRQ_GameTimer             ; 
                        
                        jsr MasterCheatCheck              ; 
                        beq .CheatGetKey                  ; 
                        
                        jmp IRQ_GameCheckSolved           ; 
                        
.CheatGetKey            ldx BBZ_KeyPressed                ; 
.CheatChk_B             cpx #$22                          ; "b" - return to last non cheat point
                        bne .CheatChk_F                   ; 
                        
                        jsr ClearKeyPressed               ; and xr
                        
.CheatSet_B             lda #$80                          ; 
                        sta BBZ_CheatKeyValue             ; 
                        bmi .CheatGetBobPos               ; always
                        
.CheatChk_F             lda BBZ_CheatKeyValue             ; 
                        cpx #$26                          ; "f" - float bob around without death/time checks
                        bne .CheatSet_F                   ; 
                        
                        jsr ClearKeyPressed               ; and xr
                        
.CheatFlip_F            eor #$01                          ; .......#
.CheatSet_F             and #$7f                          ; .#######
                        sta BBZ_CheatKeyValue             ; 
                        beq IRQ_GameCheckSolved           ; 
                        
.CheatGetBobPos         ldx BBZ_BobPosX                   ; 
                        ldy BBZ_BobPosY                   ; 
                        
                        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
.CheatChk_Up            lsr a                             ; 
                        bcs .CheatChk_Down                ; 
                        
.CheatWas_Up            cpy #$ec                          ; 
                        beq .CheatChk_Down                ; 
                        
                        dey                               ; set further up
                        
.CheatChk_Down          lsr a                             ; 
                        bcs .CheatChkPosY_F               ; 
                        
.CheatWas_Down          iny                               ; set further down
                        
.CheatChkPosY_F         cpy #$ab                          ; BBZ_BobPosY
                        bcc .CheatChk_Le                  ; 
                        
                        cpy #$e0                          ; BBZ_BobPosY
                        bcs .CheatChk_Le                  ; 
                        
                        ldy #$aa                          ; max BBZ_BobPosY
                        
.CheatChk_Le            lsr a                             ; 
                        bcs .CheatChk_Ri                  ; 
                        
.CheatWas_Le            cpx #$00                          ; min BBZ_BobPosX
                        beq .CheatChk_Ri                  ; 
                        
                        dex                               ; set further left
                        
.CheatChk_Ri            lsr a                             ; 
                        bcs .CheatIniSpriteNo             ; 
                        
.CheatWas_Ri            cpx #$98                          ; max BBZ_BobPosX
                        beq .CheatIniSpriteNo             ; 
                        
                        inx                               ; set further right
                        
.CheatIniSpriteNo       lda #NumSpriteBobRight_01         ; 
                        sta BBZ_BobSpriteNo               ; 
                        
.CheatChkReset          lda BBZ_CheatKeyValue             ; 
                        bpl .CheatSetBobPos_F             ; no "b" pressed
                        
.CheatResetLastPos      ldx BBZ_BobPosXStart              ; 
                        ldy BBZ_BobPosYStart              ; 
                        
                        lda BBZ_BobSpriteNoSave           ; 
                        sta BBZ_BobSpriteNo               ; 
                        
.CheatSetBobPos_F       stx BBZ_BobPosX                   ; 
                        sty BBZ_BobPosY                   ; 
                        
                        ldy #$ff                          ; 
                        sty BBZ_BobDeadWobbleTime         ; 
                        
                        iny                               ; $00
                        sty VCREG1                        ; SID($D404) Oscillator 1 Control
                        sty BB_SaveSid_SUREL1             ; 
                        sty BBZ_XmitFlipFlopPos           ; 
                        sty BBZ_PlayerStatus              ; 
                        sty BBZ_BobMoveType               ; 
                        sty BBZ_CannonHoistCheck          ; 
                        sty BBZ_ErasorSoreOffset          ; 
                        sty BBZ_CannonStatus              ; 
                        
                        tya                               ; 
                        ldy #$07                          ; 
.CheatClrSprite         sta [BB_SpriteStore00 + $36],y    ; 
                        sta [BB_SpriteStore01 + $36],y    ; 
                        sta [BB_SpriteStore02 + $36],y    ; 
                        sta [BB_SpriteStore03 + $36],y    ; 
                        dey                               ; 
                        bpl .CheatClrSprite               ; 
                        
                        jsr DynDispGameSprites            ; 
                        
                        jmp IRQ_GameBobMovCheck           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameCheckSolved   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameCheckSolved     subroutine                        ; 
                        lda BBZ_CountFloorTilesToFlip     ; 
                        cmp BBZ_FloorPiecesFlipped        ; 
                        bne .HandleXtraLevels             ; 
                        
.LevelSolved            lda #$00                          ; 
                        sta BBZ_PlayerStatus              ; BBZ_PlayerStatusAlive
                        sta BBZ_BobMoveType               ; BBZ_BobMoveTypeWalk
                        
.BobOff                 lda #$f0                          ; ####....
                        sta SPENA                         ; VIC($D015) Sprite Enable Register
                        
.ChkDemo                lda BBZ_GameDemoMode              ; 
                        bne .ChkScoreTime                 ; BBZ_GameDemoModeOn
                        
                        lda BB_WA_LevelTimesLo_1000       ; 
                        ora BB_WA_LevelTimesLo_100        ; 
                        ora BB_WA_LevelTimesLo_10         ; 
                        beq .ChkScoreTime                 ; 
                        
                        ldx #BB_WA_LevelTimeLen           ; 
.GetNextLvlTimeData     lda [BB_WA_LevelTimeLo - $01],x   ; 
                        beq .SetNextLvlTimeData           ; 
                        
                        cmp BB_LivesNo_P2,x               ; 
                        bne .GetTimePingCount             ; 
                        
.SetNextLvlTimeData     dex                               ; 
                        bne .GetNextLvlTimeData           ; 
                        beq .ChkScoreTime                 ; 
                        
.GetTimePingCount       lda BBZ_TonePingCount             ; 
                        bne .GetLvlTimeScore              ; 
                        
                        ldx #$01                          ; 
                        ldy #$0c                          ; 
                        jsr SetTonePing                   ; 
                        
.GetLvlTimeScore        ldx #$01                          ; 
                        stx BBZ_ScoreToAddFloor           ; 
                        
                        inx                               ; $02
                        
.IncScoreTimeLeft       inc BB_ScoreTimeLeft,x            ; 
                        lda BB_ScoreTimeLeft,x            ; 
                        cmp #$1a                          ; "9" + $01
                        bcc .HandleXtraLevels             ; lower
                        
                        lda #$10                          ; "0"
                        sta BB_ScoreTimeLeft,x            ; 
                        dex                               ; 
                        bpl .IncScoreTimeLeft             ; 
                        
.ChkScoreTime           lda BBZ_TimeScoreTime             ; 
                        beq .HandleXtraLevels             ; 
                        
                        dec BBZ_TimeScoreTime             ; 
                        
.HandleXtraLevels       jsr CheckCallXtraLevels           ; 
                        jsr FloatTileMove                 ; 
                        
                        lda #BBZ_BobOnFloorNoNone         ; 
                        sta BBZ_BobOnFloorNo              ; 
                        
                        lda BBZ_XmitFlipFlopPos           ; 
                        beq .ChkLevelSolved               ; BBZ_XmitFlipFlopPosNone
                        
.DecXmitTime            dec BBZ_BobXmitTime               ; 
                        bne .TheXmitAction                ; 
                        
.ClrXmit                lda #BBZ_XmitFlipFlopPosNone      ; xmit ready
                        sta BBZ_XmitFlipFlopPos           ; 
                        jmp IRQ_GameBobMovCheck           ; 
                        
.TheXmitAction          lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$1e                          ; ...####.
                        adc #$05                          ; 
                        tax                               ; 
                        ldy #$a8                          ; 
                        jsr BobSoundHandler               ; xmit 
                        jsr DynDispGameSprites            ; 
                        jsr BobMoveSprite                 ; 
                        jsr BobXmitSpriteGfx              ; 
                        
                        jmp IRQ_GameBobCheck              ; 
                        
.ChkLevelSolved         lda BBZ_CountFloorTilesToFlip     ; 
                        cmp BBZ_FloorPiecesFlipped        ; 
                        beq IRQ_GameBobMovCheck           ; 
                        
                        lda BBZ_CannonHoistCheck          ; 
                        ora BBZ_CannonStatus              ; 
                        ora BBZ_HoistStatus               ; 
                        bne IRQ_GameBobMovCheck           ; 
                        
.GoBobMoveHandler       jsr BobMoveHandler                ; 
                        
                        lda BBZ_XmitFlipFlopPos           ; 
.WasXmit                bne .DecXmitTime                  ; ongoing xmit
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameBobMovCheck     jsr BobMoveSprite                 ; BBZ_XmitFlipFlopPosNone
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameBobCheck      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameBobCheck        subroutine                        ; 
                        ldx BBZ_PlayerStatus              ; 
                        beq .GetStatsScoreColor           ; BBZ_PlayerStateAlive
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$03                          ; 
                        bne .GetStatsScoreColor           ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$0f                          ; 
                        tax                               ; 
                        ldy #$8e                          ; 
                        jsr SoundBobAction                ; 
                        
.GetStatsScoreColor     ldx #HR_WhiteBlack                ; score color
                        
                        lda BBZ_CannonBobTNTAmount        ; 
                        cmp #BBZ_CannonBobTNTAmountBad    ; 
                        bcs .TNTOverloaded                ; greater/equal
                        
                        cpx [BB_Scrn_ColorStat + $11]     ; 
                        beq .ChkBobDead                   ; 
                        bne .ColorBackBorder              ; always
                        
.TNTOverloaded          lda BBZ_IRQ_GameTimer             ; 
                        and #$3f                          ; ..######
                        cmp #$2b                          ; 43
                        bcc .ColorBackBorder              ; lower
                        
                        ldx #HR_WhiteRed                  ; 
                        
.ColorBackBorder        txa                               ; 
                        sta BGCOL0                        ; VIC($D021) Background Color 0
                        sta EXTCOL                        ; VIC($D020) Border Color
                        
                        ldx #$11                          ; 
.ColorStatusScores      sta [BB_Scrn_ColorStat + $00],x   ; 
                        sta [BB_Scrn_ColorStat + $16],x   ; 
                        dex                               ; 
                        bpl .ColorStatusScores            ; 
                        
                        ldx #$02                          ; 
.ColorStatusLives       ldy [BB_Scrn_ColorStat + $12],x   ; 
                        bne .NextLivePos                  ; 
                        
                        sta [BB_Scrn_ColorStat + $12],x   ; 
                        
.NextLivePos            dex                               ; 
                        bpl .ColorStatusLives             ; 
                        
.ChkBobDead             lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeDead          ; 
                        bne .ChkPingCount                 ; 
                        
                        lda BBZ_BobDeadWobbleTime         ; 
                        beq .ChkPingCount                 ; 
                        
                        dec BBZ_BobDeadWobbleTime         ; 
                        
.ChkPingCount           lda BBZ_TonePingCount             ; 
                        beq .GoIrqGameScoreHits           ; 
                        
                        dec BBZ_TonePingSusRel            ; 
                        lda BBZ_TonePingSusRel            ; 
                        bne .IniPingTone                  ; 
                        
                        dec BBZ_TonePingCount             ; 
                        
                        ldx #$10                          ; 
                        stx BBZ_TonePingSusRel            ; 
                        
.IniPingTone            ora #$40                          ; .#......
                        tax                               ; Oscillator Ctrl/SustainRelease
                        lda BBZ_TonePingHeight            ; Oscillator Offset DataSfxFreq
                        ldy #$00                          ; Oscillator SID Offset
                        jsr SoundEffects                  ; ping time left to score
                        
.GoIrqGameScoreHits     jmp IRQ_GameScoreHits             ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rend                              ; 
CopyCode_01_X           equ *                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_02             equ *                             ; 
                        rorg  BB_Code_IrqStatus           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_StatusLine        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_StatusLine          subroutine                        ; 
                        lda #$39                          ; 
.WaitRaster             cmp RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        bcs .WaitRaster                   ; greater/equal
                        
                        lda SP0Y                          ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        cmp #$39                          ; 
                        bcc .Nop_09                       ; lower
                        
                        cmp #$3a                          ; 
                        bcc .Nop_08                       ; lower
                        
                        cmp #$3b                          ; 
                        bcc .Nop_07                       ; lower
                        
                        cmp #$3c                          ; 
                        bcc .Nop_06                       ; lower
                        
                        cmp #$3d                          ; 
                        bcc .Nop_02                       ; lower
                        
.Nop_09                 nop                               ; 2 cycles = 19
.Nop_08                 nop                               ; 2 cycles = 17
                        
.Nop_07                 lda D6510                         ; 3 cycles = 15
                        
.Nop_06                 nop                               ; 2 cycles = 12
                        nop                               ; 
                        nop                               ; 
                        nop                               ; 
                        
.Nop_02                 nop                               ; 2 cycles = 4
                        nop                               ; 
                        
                        lda #[$00 & VIC_On | VIC_MCM_On | VIC_Cols40 & VIC_SoftX_Clear] ; bit4=1 Multi Color Mode   bit3=1 40 columns
                        sta SCROLX                        ; VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
IRQ_StatusLineX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameScoreHits     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameScoreHits       subroutine                        ; 
                        ldy BBZ_CannonBobTNTAmount        ; 
                        cpy BBZ_CannonBobTNTCleared       ; 
                        beq .ChkCannonSound               ; 
                        
.GetAmountPosX          ldx #Lvl_22_ValTNTPosX            ; 
                        stx BBZ_DrawPosX                  ; 
                        
                        ldx #BBZ_TabDrawLineColor_03      ; 
                        stx BBZ_TabDrawLineColorPtr       ; 
                        
.GetAmountPosY          lda #Lvl_22_ValTNTPosY            ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        ldx #$00                          ; 
                        
                        tya                               ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        
                        pha                               ; 
                        jsr IRQ_GameOutTNT                ; 
                        pla                               ; 
                        tax                               ; 
                        
                        lda BBZ_CannonBobTNTAmount        ; 
                        sta BBZ_CannonBobTNTCleared       ; make equal
                        and #$0f                          ; ....####
                        jsr IRQ_GameOutTNT                ; 
                        
.ChkCannonSound         ldx BBZ_CannonBobFlySound         ; 
                        beq .GoSoundHandler               ; BBZ_CannonBobFlySoundUp
                        
                        dex                               ; 
                        stx BBZ_CannonBobFlySound         ; BBZ_CannonBobFlySoundDown
                        stx BBZ_CannonStatus              ; 
                        
.GoSoundHandler         jsr SoundTimeHandler              ; 
                        
                        lda BBZ_GameDemoMode              ; 
                        bne .GoItemHandler                ; BBZ_GameDemoModeOn
                        
                        jsr LevelWarpHandler              ; secret actions
                        
.GoItemHandler          jsr ItemHandler                   ; 
                        
                        lda BBZ_ScoreToAddFloor           ; 
                        clc                               ; 
                        adc BBZ_ScoreToAddEnemy           ; 
                        bcs .GetScoreFloor                ; 
                        
                        adc BBZ_ScoreToAddItem            ; 
                        beq .ChkBonusP1                   ; $00 - no score to add
                        bcc .GoAddScore                   ; 
                        
.GetScoreFloor          lda BBZ_ScoreToAddFloor           ; 
                        jsr ScoreAdd                      ; 
                        
                        lda BBZ_ScoreToAddItem            ; 
                        jsr ScoreAdd                      ; 
                        
                        lda BBZ_ScoreToAddEnemy           ; 
.GoAddScore             jsr ScoreAdd                      ; 
                        
                        lda #$00                          ; 
                        sta BBZ_ScoreToAddItem            ; 
                        
.ChkBonusP1             lda BB_FlagBonusLife_P1           ; 
                        bne .ChkBonusP2                   ; get a bonus live only once
                        
                        lda GameOptsBonus                 ; 
                        beq .ChkBonusP2                   ; bonus set to NONE
                        
                        cmp BB_WA_Scores_P1_10000         ; 
                        bne .ChkBonusP2                   ; 
                        
                        inc BB_FlagBonusLife_P1           ; 
                        inc BB_LivesNo_P1                 ; 
                        jmp .IniPing                      ; 
                        
.ChkBonusP2             lda BB_FlagBonusLife_P2           ; 
                        bne .GoShowScores                 ; get a bonus live only once
                        
                        lda GameOptsBonus                 ; 
                        beq .GoShowScores                 ; bonus set to NONE
                        
                        cmp BB_WA_Scores_P2_10000         ; 
                        bne .GoShowScores                 ; 
                        
                        inc BB_FlagBonusLife_P2           ; 
                        inc BB_LivesNo_P2                 ; 
                        
.IniPing                ldx #$05                          ; 
                        ldy #$3c                          ; 
                        jsr SetTonePing                   ; 
                        
.GoShowScores           jsr ShowScoreHandler              ; 
                        jsr TimeCountDown                 ; 
                        
                        dec BBZ_FlagScoreBlinkRate        ; 
                        bne .DecWait                      ; 
                        
                        lda BBZ_FlagScoreBlink            ; 
                        eor #BBZ_FlagScoreBlinkYes        ; flip blink state
                        jsr ScoreBlinkSet                 ; 
                        
.DecWait                dec TabChkSolvedWait              ; 
                        bne .GoChkF_Keys                  ; 
                        
                        lda #$ea                          ; nop
                        sta __BobSetDeath                 ; activate sub BobSetDeath
                        
.GoChkF_Keys            jmp IRQ_GameCheckF_Keys           ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabChkSolvedWait        dc.b $00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameOutTNT        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameOutTNT          subroutine                        ; 
                        bne .MakeDigit                    ; 
                        
                        dex                               ; 
                        bmi IRQ_GameOutTNTX               ; 
                        
.MakeDigit              clc                               ; 
                        adc #$10                          ; 
IRQ_GameOutTNTX         jmp PrintTextChar                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MasterCheatCheck      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MasterCheatCheck        subroutine                        ; 
                        ldx #BB_TabMasterCheatLen         ; 
.ChkNextCodeChr         lda [BB_TabMasterCheat - $01],x   ; 
                        cmp [TabMasterCheat - $01],x      ; 
                        bne MasterCheatCheckX             ; wrong code
                        
                        dex                               ; 
                        bne .ChkNextCodeChr               ; 
                        
MasterCheatCheckX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteNumMinX     dc.b $03 ; BobRight_01
                        dc.b $03 ; BobRight_02
                        dc.b $03 ; BobRight_03
                        dc.b $02 ; BobLeft_01
                        dc.b $02 ; BobLeft_02
                        dc.b $02 ; BobLeft_03
                        dc.b $01 ; BobLadder_01
                        dc.b $05 ; BobLadder_02
                        dc.b $01 ; BobLadderTop_01
                        dc.b $05 ; BobLadderTop_02
                        dc.b $03 ; BobJumpSlideRi
                        dc.b $02 ; BobJumpSlideLe
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteNumMaxX     dc.b $05 ; BobRight_01
                        dc.b $05 ; BobRight_02
                        dc.b $05 ; BobRight_03
                        dc.b $04 ; BobLeft_01
                        dc.b $04 ; BobLeft_02
                        dc.b $04 ; BobLeft_03
                        dc.b $02 ; BobLadder_01
                        dc.b $06 ; BobLadder_02
                        dc.b $02 ; BobLadderTop_01
                        dc.b $06 ; BobLadderTop_02
                        dc.b $05 ; BobJumpSlideRi
                        dc.b $04 ; BobJumpSlideLe
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveCheckFallXit     lda BBZ_BobFall                   ; 
                        
                        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveCheckFall      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveCheckFall        subroutine                        ; 
                        jsr BobMoveAdjustPosX             ; 
                        
                        ldx BBZ_CountFloorsFlows          ; floors and flow tiles
                        inx                               ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$15                          ; 
                        tay                               ; 
                        
                        lda #BBZ_BobFallYes               ; preset
                        sta BBZ_BobFall                   ; 
                        
.GetBobPosY             tya                               ; 
.SetNextPlatform        dex                               ; BBZ_CountFloorsFlows
                        beq BobMoveCheckFallXit           ; 
                        
.ChkFloorPosY           cmp [BB_WA_FloorPosY - $01],x     ; 
                        bne .SetNextPlatform              ; 
                        
.ChkFloorMinPosX        lda BBZ_BobChkMaxPos              ; 
                        cmp [BB_WA_FloorMinX - $01],x     ; 
                        bcc .ChkFloorMaxPosX              ; 
                        
                        cmp [BB_WA_FloorMaxX - $01],x     ; 
                        bcc .SetBobOnGround               ; 
                        
.ChkFloorMaxPosX        lda BBZ_BobChkMinPos              ; 
                        cmp [BB_WA_FloorMinX - $01],x     ; 
                        bcc .GetBobPosY                   ; 
                        
                        cmp [BB_WA_FloorMaxX - $01],x     ; 
                        bcs .GetBobPosY                   ; 
                        
.SetBobOnGround         inc BBZ_BobFall                   ; BBZ_BobFallNo
                        
                        cpx BBZ_BobOnFloorNo              ; 
                        bcc .ChkBobFall                   ; lower
                        
                        stx BBZ_BobOnFloorNo              ; 
                        
.ChkBobFall             lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeFall          ; 
                        bne .BobLanded                    ; 
                        
                        lda BBZ_BobFallHeight             ; 
                        cmp #BBZ_BobFallHeightMax         ; 
                        bcc .BobLanded                    ; lower
                        
.SetBobFallToDeath      lda #BBZ_BobFallDeath             ; 
                        sta BBZ_BobFall                   ; 
                        jmp .GetBobPosY                   ; 
                        
.BobLanded              lda BBZ_BobSpriteNo               ; 
                        sta BBZ_BobSpriteNoSave           ; 
                        
                        lda BBZ_BobPosX                   ; 
                        sta BBZ_BobPosXStart              ; 
                        
                        lda BBZ_BobPosY                   ; 
                        sta BBZ_BobPosYStart              ; 
                        
                        lda BBZ_PlayerStatus              ; 
                        bne .GetBobPosY                   ; BBZ_PlayerStateDead
                        
                        lda [BB_WA_FloorTileNum - $01],x  ; 
                        bmi .GetBobPosY                   ; 
                        
                        txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        lda BBZ_MoveFloorPtrHi            ; 
                        pha                               ; 
                        lda BBZ_MoveFloorPtrLo            ; 
                        pha                               ; 
                        lda BBZ_DrawFloorMinX             ; 
                        pha                               ; 
                        
                        txa                               ; 
                        pha                               ; 
                        lda BBZ_BobChkMaxPos              ; 
                        jsr BobMoveFillFloor              ; 
                        
                        pla                               ; 
                        tax                               ; 
                        lda BBZ_BobChkMinPos              ; 
                        jsr BobMoveFillFloor              ; 
                        
                        pla                               ; 
                        sta BBZ_DrawFloorMinX             ; 
                        pla                               ; 
                        sta BBZ_MoveFloorPtrLo            ; 
                        pla                               ; 
                        sta BBZ_MoveFloorPtrHi            ; 
                        
                        pla                               ; 
                        tay                               ; 
                        pla                               ; 
                        tax                               ; 
                        
BobMoveCheckFallX       jmp .GetBobPosY                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveAdjustPosX     Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveAdjustPosX       subroutine                        ; 
                        ldx BBZ_BobSpriteNo               ; 
                        lda TabBobSpriteNumMinX,x         ; 
                        clc                               ; 
                        adc BBZ_BobPosX                   ; 
                        sta BBZ_BobChkMaxPos              ; 
                        
                        lda TabBobSpriteNumMaxX,x         ; 
                        adc BBZ_BobPosX                   ; 
                        sta BBZ_BobChkMinPos              ; 
                        
BobMoveAdjustPosXX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rend                              ; 
CopyCode_02_X           equ *                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_03             equ *                             ; 
                        rorg  BB_Code_GameOptsScore       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispHidden_04      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GameOptsValInit         subroutine                        ; 
                        ldx #BBZ_GameOptsNumMin           ; 
.NetxValueOut           stx BBZ_GameOptsNum               ; 
                        jsr GameOptsValuesOut             ; 
                        
                        ldx BBZ_GameOptsNum               ; 
                        inx                               ; 
                        cpx #BBZ_GameOptsNumMax           ; 
                        bcc .NetxValueOut                 ; lower
                        
                        lda #BBZ_GameOptsNumMin           ; 
                        sta BBZ_GameOptsNum               ; 
                        
                        ldx #$09                          ; 
.IniJoystickMovBuf      sta [BBZ_GameOptsRepeat - $01],x  ; $00
                        dex                               ; 
                        bne .IniJoystickMovBuf            ; 
                        
                        ldx #$07                          ; 
                        jsr ClearSpriteStorSetPtr         ; 
                        
                        ldx #$08                          ; 
                        ldy #$18                          ; 
.SetOptFrameEnds        lda TabOptFrameSpriteEndRi,x      ; 
                        sta BB_OptFrameSpriteEndRi,y      ; 
                        lda TabOptFrameSpriteEndLe,x      ; 
                        sta BB_OptFrameSpriteEndLe,y      ; 
                        
                        dey                               ; 
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl .SetOptFrameEnds              ; 
                        
                        stx BBZ_KeyPressed                ; BBZ_KeyPressedNone
                        
                        ldx #$02                          ; 
.SetOptFrameMids        sta [BB_OptFrameSpriteMidTop + $00],x ; ########
                        sta [BB_OptFrameSpriteMidTop + $18],x ; 
                        sta [BB_OptFrameSpriteMidBot + $00],x ; 
                        sta [BB_OptFrameSpriteMidBot + $18],x ; 
                        dex                               ; 
                        bpl .SetOptFrameMids              ; 
                        
GameOptsValInitX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabOptFrameSpriteEndRi  dc.b $ff ; ########
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $ff ; ########
; -------------------------------------------------------------------------------------------------------------- ;
TabOptFrameSpriteEndLe  dc.b $ff ; ########
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        dc.b $ff ; ########
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispHidden_02      Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GamePlayInit            subroutine                        ; 
                        lda #$08                          ; 
                        sta BBZ_NotUsed_35                ; 
                        
                        lda #$00                          ; 
                        sta BB_NumItemJustTaken           ; 
                        sta BB_SecMsgLevelMax_P1          ; 
                        sta BB_SecMsgLevelMax_P2          ; 
                        sta BBZ_JoystickMenuCheck         ; 
                        sta BBZ_NotUsed_27                ; 
                        sta BB_FlagBonusLife_P1           ; 
                        sta BB_FlagBonusLife_P2           ; 
                        sta BBZ_FloorPiecesFlipped        ; 
                        sta BB_FloorPiecesFlipped         ; 
                        
                        ldx #BB_WA_Scores_Len             ; 
.ClrScores              sta [BB_WA_Scores - $01],x        ; 
                        dex                               ; 
                        bne .ClrScores                    ; 
                        
                        lda #BBZ_ActivePlayer_01          ; 
                        sta BBZ_ActivePlayer              ; 
                        
                        ldx GameOptsLives                 ; 
                        inx                               ; 
                        stx BB_LivesNo_P1                 ; 
                        stx BB_LivesNo_P2                 ; 
                        
                        ldx #[BB_SpriteStatusPlayLen * $02] ; 
                        txa                               ; 
.IniPlayDataSA_P2       sta [BB_SpriteStatusPlay - $01],x ; 
                        dex                               ; 
                        bne .IniPlayDataSA_P2             ; 
                        
                        sed                               ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_ScoreTabVal               ; 
                        
                        ldx #$00                          ; 
.IniScoreTab            txa                               ; 
                        sta BB_TabScores_1000,y           ; 
                        
                        lda BBZ_ScoreTabVal               ; 
                        sta BB_TabScores_100_10,y         ; 
                        
                        clc                               ; 
                        adc #$01                          ; 
                        bcc .SetScoreTabVal               ; 
                        
                        inx                               ; 
                        
.SetScoreTabVal         sta BBZ_ScoreTabVal               ; 
                        
                        iny                               ; 
                        bne .IniScoreTab                  ; 
                        
                        cld                               ; 
                        
.ChkLevelSelect         ldx TabLevelNumEquivStart         ; preset 1st entry
                        
                        lda BBZ_GameDemoMode              ; 
                        bne .SetLevelEquivNum             ; BBZ_GameDemoModeOn
                        
                        jsr CheckLevelSelect              ; 
                        bne .SetLevelEquivNum             ; 
                        
                        lda GameOptsCodeHi                ; 
                        bne .SetLevelEquivNum             ; far too high
                        
                        ldy GameOptsCodeLo                ; no code set
                        beq .SetLevelEquivNum             ; 
                        
                        cpy #BBZ_LevelNumEquivMax         ; Level ZZ - Congratulations ... 
                        bcs .SetLevelEquivNum             ; greater/equal - but still too high
                        
.GetLevelEquivNum       ldx TabLevelNumEquiv,y            ; get level no equivalent
                        
.SetLevelEquivNum       stx BBZ_LevelNumEquiv             ; 
                        stx BB_LevelNumEquiv              ; 
                        
                        lda #$02                          ; 
                        sta BBZ_MelodyType                ; 
                        
                        lda #BB_GameOptsTextHeight        ; 
                        sta GameTextRowHeight             ; 
                        
                        ldx #>[BB_Scrn_HiRes + BB_Scrn_HiResRowLen] ; start value hi - leave out status row
                        lda #<[BB_Scrn_HiRes + BB_Scrn_HiResRowLen] ; start value lo
                        jsr InitHiResTabGame              ; 
                        
                        ldx #$00                          ; 
.IniShiftCount          lda #$06                          ; 
                        sta BBZ_RndColorShiftCount        ; 
                        
                        lda #$00                          ; 
                        sta BB_ItemRndColors,x            ; 
                        
.GetNextColorPos        txa                               ; 
                        ldy BBZ_RndColorShiftCount        ; 
                        beq .LimitColorPtr                ; 
                        
.ShiftColorPtr          lsr a                             ; 
                        dey                               ; 
                        bne .ShiftColorPtr                ; 
                        
.LimitColorPtr          and #$03                          ; ......## - four start colors
                        tay                               ; 
                        lda TabRndColorStartVal,y         ; 
                        ora BB_ItemRndColors,x            ; 
                        sta BB_ItemRndColors,x            ; 
                        
                        dec BBZ_RndColorShiftCount        ; 
                        dec BBZ_RndColorShiftCount        ; 
                        bpl .GetNextColorPos              ; 
                        
.SetNextColorPos        inx                               ; 
                        bne .IniShiftCount                ; 
                        
                        stx BBZ_PlayerLooseLife           ; BBZ_PlayerLooseLifeYes - flag loose 1 live if killed
                        
                        ldx #[BB_Scrn_ColorRows - $01]    ; 
                        lda #<[BB_Scrn_ColorRows * BB_Scrn_ColorRowLen + BB_Scrn_Color] ; $c0
                        ldy #>[BB_Scrn_ColorRows * BB_Scrn_ColorRowLen + BB_Scrn_Color] ; $0b
.SetNextScrnPtr         sta BB_TabColorScrnPtrLo,x        ; 
                        pha                               ; 
                        tya                               ; 
                        sta BB_TabColorScrnPtrHi,x        ; 
                        pla                               ; 
                        sec                               ; 
                        sbc #BB_Scrn_ColorRowLen          ; 
                        bcs .DecScreenRows                ; 
                        
                        dey                               ; 
                        
.DecScreenRows          dex                               ; 
                        bpl .SetNextScrnPtr               ; 
                        
GamePlayInitX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabEnemySpriteData      equ  *   ; 
TabEnemySprite01        dc.b $18 ; ...##...
                        dc.b $78 ; .####...
                        dc.b $7c ; .#####..
                        dc.b $9c ; #..###..
                        dc.b $f2 ; ####..#.
                        dc.b $2e ; ..#.###.
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $6c ; .##.##..
                        dc.b $cc ; ##..##..
TabEnemySprite_Len      equ  [* - TabEnemySpriteData] ; 
                        
TabEnemySprite02        dc.b $18 ; ...##...
                        dc.b $78 ; .####...
                        dc.b $7c ; .#####..
                        dc.b $9c ; #..###..
                        dc.b $f2 ; ####..#.
                        dc.b $2e ; ..#.###.
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $36 ; ..##.##.
                        dc.b $33 ; ..##..##
                        
TabEnemySprite03        dc.b $18 ; ...##...
                        dc.b $1e ; ...####.
                        dc.b $3e ; ..#####.
                        dc.b $39 ; ..###..#
                        dc.b $4f ; .#..####
                        dc.b $74 ; .###.#..
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $6c ; .##.##..
                        dc.b $cc ; ##..##..
                        
TabEnemySprite04        dc.b $18 ; ...##...
                        dc.b $1e ; ...####.
                        dc.b $3e ; ..#####.
                        dc.b $39 ; ..###..#
                        dc.b $4f ; .#..####
                        dc.b $74 ; .###.#..
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $36 ; ..##.##.
                        dc.b $33 ; ..##..##
                        
TabEnemySprite05        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $42 ; .#....#.
                        dc.b $7e ; .######.
                        dc.b $5a ; .#.##.#.
                        dc.b $66 ; .##..##.
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $66 ; .##..##.
                        dc.b $c3 ; ..####..
                        
TabEnemySprite06        dc.b $18 ; ...##...
                        dc.b $3c ; ..####..
                        dc.b $42 ; .#....#.
                        dc.b $7e ; .######.
                        dc.b $5a ; .#.##.#.
                        dc.b $66 ; .##..##.
                        dc.b $3c ; ..####..
                        dc.b $18 ; ...##...
                        dc.b $18 ; ...##...
                        dc.b $66 ; .##..##.
                        
TabEnemySprite07        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ee ; ###.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ee ; ###.###.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
TabEnemySprite08        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ee ; ###.###.
                        dc.b $aa ; #.#.#.#.
                        dc.b $ea ; ###.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $ee ; ###.###.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispHidden_03      Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetEnemySpriteData      subroutine                        ; 
                        lda #<BB_EnemySpriteGame          ; enemy sprites
                        sta BBZ_GetDataBytePtrLo          ; 
                        lda #>BB_EnemySpriteGame          ; 
                        sta BBZ_GetDataBytePtrHi          ; 
                        
                        ldx #$00                          ; 
.IniCopySpriteData      ldy #$00                          ; 
.CopyNextSpriteData     lda TabEnemySpriteData,x          ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        
                        inx                               ; 
                        
                        iny                               ; 
                        iny                               ; 
                        iny                               ; 
                        cpy #[$03 * $0a]                  ; 
                        bcc .CopyNextSpriteData           ; 
                        
.SetNextSpritePos       lda BBZ_GetDataBytePtrLo          ; 
                        clc                               ; 
                        adc #$40                          ; 64 bytes per sprite stor
                        sta BBZ_GetDataBytePtrLo          ; 
                        bcc .ChkSpriteMax                 ; 
                        inc BBZ_GetDataBytePtrHi          ; 
                        
.ChkSpriteMax           cpx #[$08 * TabEnemySprite_Len]   ; 8 different sprites 
                        bcc .IniCopySpriteData            ; 
                        
SetEnemySpriteDataX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteDataPtrLo   dc.b <BobRight_01      ; 
                        dc.b <BobRight_02      ; 
                        dc.b <BobRight_03      ; 
                        dc.b <BobLeft_01       ; 
                        dc.b <BobLeft_02       ; 
                        dc.b <BobLeft_03       ; 
                        dc.b <BobLadder_01     ; 
                        dc.b <BobLadder_02     ; 
                        dc.b <BobLadderTop_01  ; 
                        dc.b <BobLadderTop_02  ; 
                        dc.b <BobJumpSlideRi   ; 
                        dc.b <BobJumpSlideLe   ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataPtrLo   dc.b <WobRight_01      ; 
                        dc.b <WobRight_02      ; 
                        dc.b <WobRight_03      ; 
                        dc.b <WobLeft_01       ; 
                        dc.b <WobLeft_02       ; 
                        dc.b <WobLeft_03       ; 
                        dc.b <WobLadder_01     ; 
                        dc.b <WobLadder_02     ; 
                        dc.b <WobLadderTop_01  ; 
                        dc.b <WobLadderTop_02  ; 
                        dc.b <WobJumpSlideRi   ; 
                        dc.b <WobJumpSlideLe   ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteDataPtrHi   dc.b >BobRight_01      ; 
                        dc.b >BobRight_02      ; 
                        dc.b >BobRight_03      ; 
                        dc.b >BobLeft_01       ; 
                        dc.b >BobLeft_02       ; 
                        dc.b >BobLeft_03       ; 
                        dc.b >BobLadder_01     ; 
                        dc.b >BobLadder_02     ; 
                        dc.b >BobLadderTop_01  ; 
                        dc.b >BobLadderTop_02  ; 
                        dc.b >BobJumpSlideRi   ; 
                        dc.b >BobJumpSlideLe   ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataPtrHi   dc.b >WobRight_01      ; 
                        dc.b >WobRight_02      ; 
                        dc.b >WobRight_03      ; 
                        dc.b >WobLeft_01       ; 
                        dc.b >WobLeft_02       ; 
                        dc.b >WobLeft_03       ; 
                        dc.b >WobLadder_01     ; 
                        dc.b >WobLadder_02     ; 
                        dc.b >WobLadderTop_01  ; 
                        dc.b >WobLadderTop_02  ; 
                        dc.b >WobJumpSlideRi   ; 
                        dc.b >WobJumpSlideLe   ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataSmileLe dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $2a ; ..#.#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataSmileRi dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a8 ; #.#.#...
                        dc.b $a8 ; #.#.#...
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0a ; ....#.#.
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataHead    dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $a0 ; #.#.....
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataHead_15 dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $aa ; #.#.#.#.
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataHead_12 dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
; -------------------------------------------------------------------------------------------------------------- ;
TabWobSpriteDataHead_13 dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
; -------------------------------------------------------------------------------------------------------------- ;
TabCopyWobFromLen       dc.b $00 ; $00
                        dc.b $01 ; $01
                        dc.b $02 ; $02
                        dc.b $03 ; $03
                        dc.b $04 ; $04
                        dc.b $05 ; $05
                        dc.b $06 ; $06
                        dc.b $07 ; $07
                        dc.b $08 ; $08
                        dc.b $09 ; $09
                        dc.b $0a ; $0a
                        dc.b $0b ; $0b
                        dc.b $0c ; $0c
                        dc.b $0d ; $0d
                        dc.b $0e ; $0e
                        dc.b $0f ; $0f
                        dc.b $10 ; $10
                        dc.b $11 ; $11
                        dc.b $11 ; $12
                        dc.b $11 ; $13
                        dc.b $11 ; $14
; -------------------------------------------------------------------------------------------------------------- ;
TabCopyWobTargLen       dc.b $3d ; $00
                        dc.b $3d ; $01
                        dc.b $3d ; $02
                        dc.b $3d ; $03
                        dc.b $3d ; $04
                        dc.b $3d ; $05
                        dc.b $3d ; $06
                        dc.b $3d ; $07
                        dc.b $3d ; $08
                        dc.b $3d ; $09
                        dc.b $3d ; $0a
                        dc.b $3d ; $0b
                        dc.b $3d ; $0c
                        dc.b $3d ; $0d
                        dc.b $3d ; $0e
                        dc.b $3d ; $0f
                        dc.b $3d ; $10
                        dc.b $3d ; $11
                        dc.b $3a ; $12
                        dc.b $37 ; $13
                        dc.b $34 ; $14
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispHidden_05      Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobRemoveHat            subroutine                        ; 
                        lda #<BB_BobSpriteData            ; 
                        sta BBZ_BobSpriteHatDataPtrLo     ; 
                        lda #>BB_BobSpriteData            ; 
                        sta BBZ_BobSpriteHatDataPtrHi     ; 
                        
                        lda #<[$ffff - $0a1f]             ; 
                        sta BBZ_BobSpriteHatCopyLenLo     ; 
                        lda #>[$ffff - $0a1f]             ; 
                        sta BBZ_BobSpriteHatCopyLenHi     ; 
                        
                        ldy #$00                          ; 
.GetBobData             lda (BBZ_BobSpriteHatDataPtr),y   ; 
                        lsr a                             ; 
                        and (BBZ_BobSpriteHatDataPtr),y   ; 
                        and #$55                          ; .#.#.#.#
                        sta .__DataMask                   ; 
                        asl a                             ; 
                        
.__DataMask             equ [* + $01]                     ; 
                        ora #$00                          ; 
                        eor (BBZ_BobSpriteHatDataPtr),y   ; 
                        sta (BBZ_BobSpriteHatDataPtr),y   ; 
                        iny                               ; 
                        bne .DecDataCount                 ; 
                        
                        inc BBZ_BobSpriteHatDataPtrHi     ; 
                        
.DecDataCount           inc BBZ_BobSpriteHatCopyLenLo     ; 
                        bne .GetBobData                   ; 
                        inc BBZ_BobSpriteHatCopyLenHi     ; 
                        bne .GetBobData                   ; 
                        
BobRemoveHatX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
Copy_ScoreHandlerOrig   equ *                             ; 
                        rorg  BB_Code_ScoreHandlerExe     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreNameHandler      Does    : 
;                       Expects : 
;                       Returns : 
;                       Info    ; BB_Code_ScoreHandlerOrg is origin store - 1st target
;                               ; BB_Code_ScoreHandlerExe is exec   store - 2nd target -> CopyBirdsScoreHandlers
; -------------------------------------------------------------------------------------------------------------- ;
Copy_ScoreHandlerExe    equ *                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreNameHandler        subroutine                        ; 
                        ldx BBZ_ScoreKeyBufGot            ; 
                        cpx BBZ_ScoreKeyBufNew            ; 
                        beq .ChkJoyStickFire              ; 
                        
                        jsr TextOutScoreActionBox         ; 
                        
.GetNextScorKeyPtr      ldx BBZ_ScoreKeyBufGot            ; 
.SetNextScorKeyPtr      inc BBZ_ScoreKeyBufGot            ; 
                        lda BB_WA_ScoreKeyBuffer,x        ; 
.ChkKey_Space           beq .SetTextBoxForSpace           ; " "
                        
.ChkKey_Del             cmp #$6b                          ; Delete
                        beq .Activate_Del                 ; 
                        
.ChkKey_Return          cmp #$6a                          ; Return
                        beq ScoreDispatchBirds            ; 
                        
.ChkKey_A               cmp #$21                          ; "A"
                        bcc .ChkJoyStickFire              ; 
                        
.ChkKey_Z               cmp #$3b                          ; "Z" + $01
                        bcs .ChkJoyStickFire              ; greater/equal
                        
.SetColBulldozer_Le     ldx #BBZ_ScoreActiveColNumBLe     ; Bulldozer left
                        stx BBZ_ScoreActiveColNum         ; 
                        
.SetWorkValsOffset_Le   dex                               ; 
                        
.ChkKey_N               cmp #$2e                          ; "N"
                        bcc .GetCharRowNum                ; lower
                        
                        sbc #$0d                          ; 
.SetWorkValsOffset_Ri   ldx #$03                          ; 
                        
.SetColBulldozer_Ri     inc BBZ_ScoreActiveColNum         ; 
                        
.GetCharRowNum          sec                               ; 
                        sbc #$21                          ; 
                        
.SetCharRowNum          sta BBZ_ScoreLiftRowNum,x         ; 
                        
                        tay                               ; 
                        lda TabScreenRowPosY,y            ; 
                        sec                               ; 
                        sbc #$06                          ; 
.SetLiftNewTarget       sta BBZ_ScoreLiftTargetPos,x      ; 
                        
.WaitForLiftAtNewTarget cmp BBZ_ScoreLiftActualPos,x      ; 
                        bne .WaitForLiftAtNewTarget       ; 
                        
                        ldx BBZ_ScoreActiveColNum         ; 
                        bpl ScoreSelCharHandler           ; always
; -------------------------------------------------------------------------------------------------------------- ;
.SetTextBoxForSpace     ldx #BBZ_ScoreActiveColNumTxt     ; $00
                        stx BBZ_ScoreActiveColNum         ; 
                        stx BBZ_ScoreTextBoxRowNum        ; 
                        beq ScoreClearCharInput           ; always
; -------------------------------------------------------------------------------------------------------------- ;
.Activate_Del           ldx #BBZ_ScoreActiveColNumTxt     ; 
                        stx BBZ_ScoreActiveColNum         ; 
                        
                        inx                               ; BBZ_ScoreTextBoxRowNumDe
                        stx BBZ_ScoreTextBoxRowNum        ; 
                        bne ScoreEraseCharHandler         ; always
                        
.ChkJoyStickFire        jsr JoyStickCheckFireSc           ; 
.Exit                   bcs ScoreCheckNameLenMinX         ; 
                        
                        ldx BBZ_ScoreActiveColNum         ; 
.WasBulldozer           bne ScoreSelCharHandler           ; Bulldozer Left/Right
                        
.WasTextBox             ldx BBZ_ScoreTextBoxRowNum        ; 
.WasSpace               beq ScoreClearCharInput           ; 
                        
.WasDelOrEnd            dex                               ; 
.WasDel                 beq ScoreEraseCharHandler         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreDispatchBirds    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreDispatchBirds      subroutine                        ; 
                        lda #BB_IrqSubID_ScoreBirds       ; 
                        sta __IrqDispatchSubID            ; 
.WaitForDispatch        bne .WaitForDispatch              ; wait to be dispatched
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreEraseCharHandler Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreEraseCharHandler   subroutine                        ; 
                        lda BBZ_ScoreNameActualLen        ; 
.NothingToDo            beq ScoreCheckNameLenMinX         ; 
                        
                        jsr TextOutScoreActionBox         ; 
                        
ScoreEraseCharHandlerX  jmp ScoreEraseChar                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreClearCharInput   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreClearCharInput     subroutine                        ; 
                        jsr ScoreCheckNameLenMin          ; 
.Exit                   beq ScoreCheckNameLenMinX         ; max len reached
                        
                        jsr TextOutScoreActionBox         ; 
                        jsr ScoreCheckNameLenMax          ; 
                        
                        ldx BBZ_ScoreNameActualLen        ; 
                        lda #$00                          ; " "
                        sta BB_ScorerInputBuffer,x        ; 
                        
ScoreClearCharInputX    jmp ScoreMoveConveyorLeft         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreCheckNameLenMin  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreCheckNameLenMin    subroutine                        ; 
                        lda BBZ_ScoreNameActualLen        ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        cmp GameOptsScoreNamLen           ; 
                        
ScoreCheckNameLenMinX   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreSelCharHandler   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreSelCharHandler     subroutine                        ; 
                        jsr ScoreCheckNameLenMin          ; 
.ExitMinLenRight        beq ScoreCheckNameLenMinX         ; min len reached
                        
                        jsr ScoreCheckNameLenMax          ; 
                        
                        dex                               ; 
.WasCharColLeft         beq .ChkLiftOnTarget              ; 
                        
.WasCharColRight        ldx #$03                          ; 
                        
.ChkLiftOnTarget        lda BBZ_ScoreLiftActualPos,x      ; 
                        cmp BBZ_ScoreLiftTargetPos,x      ; 
.ExitStillMoving        bne ScoreCheckNameLenMinX         ; 
                        
                        sec                               ; 
                        sbc #$05                          ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        lda #$f0                          ; 
                        sta BBZ_CharSpriteFallPosY        ; 
                        
                        lda #$66                          ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        inx                               ; 
                        dex                               ; 
.ChkActiveSelSide       beq .HandleLeftSideChar           ; 
; -------------------------------------------------------------------------------------------------------------- ;
.HandleRightSideChar    ldx BBZ_ScoreLiftRowNumRi         ; 
                        stx BBZ_ScoreCharRowNum           ; 
                        
                        lda [BB_ScoreCharsAmount + BB_ScoreCharsAmountHalf],x ; chars on right side 
.ExitCharRowEmpty       beq ScoreCheckNameLenMinX         ; 
                        
                        sta BBZ_ScoreRowCharsNum          ; 
.SaveRowCharNum_Ri      pha                               ; 
                        
.DecRowCharsAmount_Ri   dec [BB_ScoreCharsAmount + BB_ScoreCharsAmountHalf],x ; chars on right side 
                        
.GetCharRowNum_Ri       txa                               ; 
                        clc                               ; 
.MakeChar_Ri            adc #$2e                          ; "N"
                        jsr ScoreGenCharSprites           ; 
                        
.RestoreRowCharNum_Ri   pla                               ; 
                        tax                               ; 
                        
                        lda [TabScoreCharRowsPosX_Ri - $01],x ; 
                        clc                               ; 
                        adc #$2f                          ; 
.SetCharNewTarget_Ri    sta BBZ_ScoreCharTargetPosRi      ; 
                        clc                               ; 
                        adc #$07                          ; 
                        
.WaitCharOnNewTarget_Ri cmp BBZ_ScoreCharActualPosRi      ; 
                        bne .WaitCharOnNewTarget_Ri       ; 
                        
                        lda #$10                          ; 
                        sta BBZ_ScoreActionSfxPop         ; 
                        
                        lda #$6b                          ; 
.NextStepPushLeft       pha                               ; PosX
                        ldy BBZ_DrawPosY                  ; PosY
                        ldx #$05                          ; Shift Step Count
                        jsr ScoreMoveCharsLeft            ; 
                        jsr ScoreActionStartPop           ; 
                        
                        ldy BBZ_DrawPosY                  ; 
                        
.GetPushStepLoc_Ri      pla                               ; 
                        sec                               ; 
.DecPushStepLoc_Ri      sbc #$01                          ; 
.ChkPushStepLocMax_Ri   cmp #$66                          ; 
                        bcs .NextStepPushLeft             ; greater/equal
                        bcc .LetCharFallDown              ; lower - always
                        
.ExitRightSideChar      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
.HandleLeftSideChar     ldx BBZ_ScoreLiftRowNumLe         ; 
                        stx BBZ_ScoreCharRowNum           ; 
                        
                        lda BB_ScoreCharsAmount,x         ; 
.ExitMinLenLeft         beq .ExitRightSideChar            ; 
                        
                        sta BBZ_ScoreRowCharsNum          ; 
.SaveRowCharNum_Le      pha                               ; 
                        
.DecRowCharsAmount_Le   dec BB_ScoreCharsAmount,x         ; 
                        
.GetCharRowNum_Le       txa                               ; 
                        clc                               ; 
.MakeChar_Le            adc #$21                          ; "A"
                        jsr ScoreGenCharSprites           ; 
                        
.RestoreRowCharNum_Le   pla                               ; 
                        tax                               ; 
                        
                        lda [TabScoreCharRowsPosX_Le - $01],x ; 
                        clc                               ; 
                        adc #$2e                          ; 
                        sta BBZ_ScoreCharTargetPosLe      ; 
                        sec                               ; 
                        sbc #$07                          ; 
.WaitCharOnNewTarget_Le cmp BBZ_ScoreCharActualPosLe      ; 
                        bne .WaitCharOnNewTarget_Le       ; 
                        
                        lda #$10                          ; 
                        sta BBZ_ScoreActionSfxPop         ; 
                        
                        lda #$3c                          ; 
.NextStepPushRight      pha                               ; PosX
                        ldy BBZ_DrawPosY                  ; PosY
                        ldx #$05                          ; Shift Step Count
                        jsr ScoreMoveCharsRight           ; 
                        jsr ScoreActionStartPop           ; 
                        
                        ldy BBZ_DrawPosY                  ; 
                        
.GetPushStepLoc_Le      pla                               ; 
                        clc                               ; 
.IncPushStepLoc_Le      adc #$01                          ; 
.ChkPushStepLocMax_Le   cmp #$42                          ; 
                        bcc .NextStepPushRight            ; 
; -------------------------------------------------------------------------------------------------------------- ;
.LetCharFallDown        lda #$72                          ; 
                        sta BBZ_CharSpritePosX            ; 
                        
                        ldx BBZ_DrawPosY                  ; 
                        lda BB_TabHiResAdrRowLo,x         ; 
                        sta BBZ_CharRowHiResPtrLo         ; 
                        lda BB_TabHiResAdrRowHi,x         ; 
                        sta BBZ_CharRowHiResPtrHi         ; 
                        
.GetCharColor           lda BBZ_ScoreCharRowNum           ; 
                        lsr a                             ; *2 - two rows of the same colors
                        tax                               ; 
                        lda TabGameOptsColor,x            ; 
                        sta BBZ_GameOptsColorNum          ; 
                        
                        ldx BBZ_ScoreNameActualLen        ; 
                        sta BB_GameOptsRowColor,x         ; 
                        
                        lda BBZ_DrawPosY                  ; 
                        sta BBZ_CharSpriteFallPosY        ; 
                        
                        jsr TimerWaitFull                 ; 
                        
                        lda #$3c                          ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
                        lda #$00                          ; 
                        jsr PrintTextChar                 ; 
                        
                        lda #$05                          ; 
                        sta BBZ_ScoreActionSfxFall        ; 
                        
.FallDownNextStep       lda BBZ_ScoreActionSfxFall        ; Oscillator Offset DataSfxFreq
                        ldx #$48                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffectSelOsc_01          ; 
                        
                        inc BBZ_ScoreActionSfxFall        ; 
                        jsr TimerWaitFull                 ; 
                        
                        ldx BBZ_CharSpriteFallPosY        ; 
                        cpx #$9f                          ; 
.ChkFallDownStepMax     beq .GetSoundSfxLand              ; 
                        
                        inc BBZ_CharSpriteFallPosY        ; 
                        inc BBZ_CharSpriteFallPosY        ; 
                        bne .FallDownNextStep             ; 
                        
.GetSoundSfxLand        lda BBZ_ScoreActionSfxFall        ; Oscillator Offset DataSfxFreq
                        ldx #$8a                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffectSelOsc_01          ; 
                        
                        ldx BBZ_ScoreNameActualLen        ; 
                        cpx #$06                          ; 
                        beq ScoreSelCharHandlerX          ; 
                        
                        jsr ScoreSetSpriteStorePtr        ; returns yr=$0d
                        
.GetNextSpriteCount     ldx #$02                          ; 
.GetNextSpriteData      lda [BB_SpriteStoreLo01 + $30],y  ; 
                        sta (BBZ_ScoreSpriteStorePtr),y   ; 
                        
                        dey                               ; 
                        
                        dex                               ; 
                        bne .GetNextSpriteData            ; 
                        
                        dey                               ; 
                        bpl .GetNextSpriteCount           ; 
                        
                        lda #$f0                          ; 
                        sta BBZ_CharSpriteFallPosY        ; 
                        
ScoreSelCharHandlerX    jsr TimerWaitFull                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreMoveConveyorLeft Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreMoveConveyorLeft   subroutine                        ; 
                        lda #$06                          ; 
.IniConveyorSteps       sta BBZ_ConveyorStepsLeft         ; 
                        
                        lda #$94                          ; 
                        sta BBZ_ConveyorCharMovePosLe     ; 
                        
                        lda #$10                          ; 
                        sta BBZ_ScoreActionSfxPop         ; 
                        
                        lda #$06                          ; 
                        
.StepConveyorLeft       jsr ScoreActionStartPop           ; 
                        
.StepCharLeft           dec BBZ_CharSpritePosX            ; 
                        
                        lda BBZ_ConveyorCharPos           ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        
                        ldx #$01                          ; 
                        ldy #$a5                          ; 
                        sty BBZ_DrawPosY                  ; 
                        jsr ScoreMoveCharsLeft            ; 
                        
                        dec BBZ_ConveyorCharPos           ; 
                        dec BBZ_ConveyorWheelPos          ; 
                        dec BBZ_ConveyorCharMovePosLe     ; 
                        
.DrawConveyorLeft       jsr ScoreDrawConveyor             ; 
                        
.DecConveyorSteps       dec BBZ_ConveyorStepsLeft         ; 
.ChkConveyorSteps       bne .StepConveyorLeft             ; 
                        
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
                        stx BBZ_ScoreRowCharsNum          ; 
                        jsr SoundEffectSelOsc_01          ; 
                        
                        inc BBZ_ScoreNameActualLen        ; 
                        
ScoreMoveConveyorLeftX  rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreActionStartPop   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreActionStartPop     subroutine                        ; 
                        inc BBZ_ScoreActionSfxPop         ; 
                        inc BBZ_ScoreActionSfxPop         ; 
                        
                        lda BBZ_ScoreActionSfxPop         ; 
                        and #$0f                          ; ....####
                        ora #$80                          ; #.......
                        tax                               ; Oscillator Ctrl/SustainRelease
                        lda BBZ_ScoreActionSfxPop         ; Oscillator Offset DataSfxFreq
                        
;__SoundEffectY00Lo     equ [* + $01]                     ; diff - 
ScoreActionStartPopX    jmp SoundEffectSelOsc_01          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreEraseChar        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreEraseChar          subroutine                        ; 
                        dec BBZ_ScoreNameActualLen        ; 
                        
                        ldx BBZ_ScoreNameActualLen        ; 
                        lda BB_ScorerInputBuffer,x        ; 
                        
.SaveProcStatus         php                               ; 
.ChkSpace_Ri            beq .IniConveyorSteps             ; 
                        
.IniErasor              lda #$94                          ; 
                        sta BBZ_ErasorTargetPosX          ; 
                        
                        lda #$bf                          ; 
                        sta BBZ_ErasorTargetPosY          ; 
                        
                        lda #BBZ_ErasorActionTypeEras     ; move to conveyor char pos
                        sta BBZ_ErasorActionType          ; 
                        
.IniConveyorSteps       lda #$06                          ; step move conveyor right
                        sta BBZ_ConveyorStepsRight        ; 
                        
                        lda #$8e                          ; 
                        sta BBZ_ErasorEraseCharPosY       ; 
                        
                        lda #$10                          ; 
                        sta BBZ_ScoreActionSfxPop         ; 
                        
.StepConveyorRight      jsr ScoreActionStartPop           ; 
                        
                        inc BBZ_CharSpritePosX            ; 
                        
                        lda BBZ_ConveyorCharPos           ; PosX
                        ldx #$01                          ; Shift Step Count
                        ldy #$a5                          ; PosY
                        sty BBZ_DrawPosY                  ; 
                        jsr ScoreMoveCharsRight           ; 
                        
                        inc BBZ_ConveyorCharPos           ; 
                        inc BBZ_ConveyorWheelPos          ; 
.DrawConveyorRight      jsr ScoreDrawConveyor             ; 
                        
                        inc BBZ_ErasorEraseCharPosY       ; 
.DecConveyorSteps       dec BBZ_ConveyorStepsRight        ; 
.ChkConveyorSteps       bne .StepConveyorRight            ; 
                        
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
.StartPopOff            jsr SoundEffectSelOsc_01          ; 
                        
.RestoreProcStatus      plp                               ; 
.WasSpace_Le            beq ScoreMoveConveyorLeftX        ; 
                        
                        ldx #$88                          ; Oscillator Ctrl/SustainRelease
                        lda #$0d                          ; Oscillator Offset DataSfxFreq
                        jsr SoundEffectSelOsc_01          ; 
                        jsr ScoreEraseWaitCharPosY        ; 
                        
.IniOscCtrlErase        lda #$82                          ; 
.IniCharHightDelete     ldx #$06                          ; 
.SetNextDelCharHight    stx .__SaveCharHightDelete        ; step erasor down to hide deleted char
                        
.SaveOscCtrlSusRes      pha                               ; 
                        
                        tax                               ; Oscillator Ctrl/SustainRelease
                        lda #$02                          ; Oscillator Offset DataSfxFreq
                        jsr SoundEffectSelOsc_01          ; 
                        
.__SaveCharHightDelete  equ [* + $01]                     ; 
                        ldx #$00                          ; 
                        
.RestoreOscCtrlSusRes   pla                               ; 
                        
                        clc                               ; 
.IncOscCtrlSusRes       adc #$02                          ; 
                        
                        ldy BBZ_IRQ_GameTimer             ; 
                        iny                               ; 
                        iny                               ; 
                        iny                               ; 
                        jsr TimerWait                     ; 
                        
.StepCharErasorForward  inc BBZ_ErasorTargetPosY          ; 
                        
.DecCharHightDelete     dex                               ; 
.ChkCharHightDeleteMax  bne .SetNextDelCharHight          ; 
                        
                        ldx #$88                          ; Oscillator Ctrl/SustainRelease
                        lda #$0a                          ; Oscillator Offset DataSfxFreq
                        jsr SoundEffectSelOsc_01          ; 
                        
                        ldx BBZ_ScoreNameActualLen        ; 
                        jsr ScoreSetSpriteStorePtr        ; returns yr=$0d
                        
.IniClearSprite         lda #$00                          ; 
.ClearNextSpriteByte    sta (BBZ_ScoreSpriteStorePtr),y   ; 
                        dey                               ; 
                        bpl .ClearNextSpriteByte          ; 
                        
.ClearSpritePosX        sta BBZ_CharSpritePosX            ; 
                        
                        lda #BBZ_ErasorActionTypeRstr     ; move to restore char pos
                        sta BBZ_ErasorActionType          ; 
                        
                        ldy BBZ_ScoreNameActualLen        ; 
.GetScoreNameChar       ldx BB_ScorerInputBuffer,y        ; 
                        lda [TabScoreCharRowsPosY - $21],x; subtract "A"
                        sta BBZ_DrawPosY                  ; for auto move
                        
                        clc                               ; 
                        adc #$25                          ; 
.SetErasorTargetPosY    sta BBZ_ErasorTargetPosY          ; for auto move
                        
                        inc [BB_ScoreCharsAmount - $21],x ; subtract "A"
                        lda [BB_ScoreCharsAmount - $21],x ; 
                        
                        cpx #$2e                          ; 
                        bcc .GetCharRowOffsetLe           ; lower
                        
                        adc #$06                          ; higher/equal
                        
.GetCharRowOffsetLe     tay                               ; 
                        lda [TabScoreCharRowsPosX_Le - $01],y ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        clc                               ; 
                        adc #$2e                          ; 
.SetErasorTargetPosX    sta BBZ_ErasorTargetPosX          ; 
                        
.WaitErasorOnCharPos    jsr ScoreEraseWaitCharPosX        ; 
                        
                        lda #$30                          ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
.SetScoreNameChar       txa                               ; 
.RestoreScoreNameChar   jsr PrintTextChar                 ; 
                        
.IniOscCtrlRestore      lda #$8e                          ; 
.IniCharHightRestore    ldx #$06                          ; 
                        
.SaveNextOscCtrlRestore pha                               ; step erasor up to reveal restored char
                        stx .__SaveCharHightRestore       ; 
                        tax                               ; Oscillator Ctrl/SustainRelease
                        lda #$02                          ; Oscillator Offset DataSfxFreq
                        jsr SoundEffectSelOsc_01          ; 
                        
.RestoreOscCtrlRestore  pla                               ; 
                        
.__SaveCharHightRestore equ [* + $01]                     ; 
                        ldx #$00                          ; 
                        
                        sec                               ; 
.IncOscCtrlRestore      sbc #$02                          ; 
                        
                        ldy BBZ_IRQ_GameTimer             ; 
                        iny                               ; 
                        iny                               ; 
                        iny                               ; 
                        jsr TimerWait                     ; 
                        
.StepCharErasorBackward dec BBZ_ErasorTargetPosY          ; 
                        
.DecCharHightRestore    dex                               ; 
.ChkCharHightRestoreMax bne .SaveNextOscCtrlRestore       ; 
                        
                        ldx #$88                          ; Oscillator Ctrl/SustainRelease
                        lda #$06                          ; Oscillator Offset DataSfxFreq
                        jsr SoundEffectSelOsc_01          ; 
                        
                        lda #BBZ_ErasorActionTypeBack     ; move to top left start pos
                        sta BBZ_ErasorActionType          ; 
                        
.MoveErasorBackPosX     lda #$30                          ; for auto move
                        sta BBZ_ErasorTargetPosX          ; 
                        
.MoveErasorBackPosY     lda #$2d                          ; 
                        sta BBZ_ErasorTargetPosY          ; for auto move
                        
.WaitErasorOnStartPos   jsr ScoreEraseWaitCharPosX        ; 
                        
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
ScoreEraseCharX         jmp SoundEffectSelOsc_01          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreEraseWaitCharPosX Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreEraseWaitCharPosX  subroutine                        ; 
.GetNextActualPosX      lda BBZ_ErasorActualPosX          ; 
                        sta BBZ_ErasorEraseCharPosY       ; 
                        
                        cmp BBZ_ErasorTargetPosX          ; 
ScoreEraseWaitCharPosXX bne .GetNextActualPosX            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreEraseWaitCharPosY Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreEraseWaitCharPosY  subroutine                        ; 
.GetNextActualPosY      lda BBZ_ErasorActualPosY          ; 
                        cmp BBZ_ErasorTargetPosY          ; 
                        bne .GetNextActualPosY            ; 
                        
ScoreEraseWaitCharPosYX rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreCharRowsPosY    dc.b $15 ; left half char rows
                        dc.b $1f ; 
                        dc.b $29 ; 
                        dc.b $33 ; 
                        dc.b $3d ; 
                        dc.b $47 ; 
                        dc.b $51 ; 
                        dc.b $5b ; 
                        dc.b $65 ; 
                        dc.b $6f ; 
                        dc.b $79 ; 
                        dc.b $83 ; 
                        dc.b $8d ; 
                        
                        dc.b $15 ; right half char rows
                        dc.b $1f ; 
                        dc.b $29 ; 
                        dc.b $33 ; 
                        dc.b $3d ; 
                        dc.b $47 ; 
                        dc.b $51 ; 
                        dc.b $5b ; 
                        dc.b $65 ; 
                        dc.b $6f ; 
                        dc.b $79 ; 
                        dc.b $83 ; 
                        dc.b $8d ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreCharRowsPosX_Le dc.b $60 ; 
                        dc.b $5a ; 
                        dc.b $54 ; 
                        dc.b $4e ; 
                        dc.b $48 ; 
                        dc.b $42 ; 
                        dc.b $3c ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreCharRowsPosX_Ri dc.b $6c ; 
                        dc.b $72 ; 
                        dc.b $78 ; 
                        dc.b $7e ; 
                        dc.b $84 ; 
                        dc.b $8a ; 
                        dc.b $90 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreSpriteStoreLo   dc.b <BB_SpriteStore0a            ; 
                        dc.b <BB_SpriteStore0b            ; 
                        dc.b <BB_SpriteStore0c            ; 
                        dc.b <BB_SpriteStore0d            ; 
                        dc.b <BB_SpriteStore0e            ; 
                        dc.b <BB_SpriteStoreLo00          ; 
                        dc.b <[BB_SpriteStoreLo02 - $10]  ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreSpriteStoreHi   dc.b >BB_SpriteStore0a            ; 
                        dc.b >BB_SpriteStore0b            ; 
                        dc.b >BB_SpriteStore0c            ; 
                        dc.b >BB_SpriteStore0d            ; 
                        dc.b >BB_SpriteStore0e            ; 
                        dc.b >BB_SpriteStoreLo00          ; 
                        dc.b >[BB_SpriteStoreLo02 - $10]  ; 
; -------------------------------------------------------------------------------------------------------------- ;
Copy_ScoreHandlerExe_X  rend                              ; 
CopyCode_03_X           equ *                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
CopyCode_05             equ *                             ; 
                        rorg  BB_Code_ScoreInput          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreInputHandler     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreInputHandler       subroutine                        ; 
.WaitBeforeNextInput    jsr TimerWaitFull                 ; 
                        jsr ScoreNameHandler              ; 
                        
.ChkScoreTimerUp        lda BBZ_ScoreTimerTime            ; 
.StillScoreTimeLeft     beq .GetJoystickInput             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; .hbu001. Generate and check a code CheckSum - Try to prevent code modifications
; -------------------------------------------------------------------------------------------------------------- ;
.WasScoreTimerUp        ldx #$28                          ; 
                        lda #$00                          ; 
.AddNextCodeByte        clc                               ; 
                        adc [BuildChecksumCode - $28],x   ; 
                        
                        inx                               ; 
.ChkCeckSumCodeLenMax   cpx #[BuildChecksumCodeX - BuildChecksumCode + $28] ; $3a
                        bcc .AddNextCodeByte              ; lower
                        
.ChkCkeckSum            cmp #$a3                          ; 
                        beq .ChksumBuildExit_OK           ; 
                        
.ChksumBuildExit_BAD    lda #$60                          ; rts
                        sta [__BobSetDeath + $01]         ; deactivate sub BobSetDeath
                        
.ChksumBuildExit_OK     jmp ScoreDispatchBirds            ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GetJoystickInput       lda BBZ_JoystickMenu              ; 
                        ora BBZ_JoystickMenuFlip          ; 
                        sta BBZ_JoystickMenuCheck         ; 
                        
                        lda BBZ_JoystickMenu              ; 
.FlipJostickBits        eor #$ff                          ; ########
                        sta BBZ_JoystickMenuFlip          ; 
                        
                        lda BBZ_JoystickMenuCheck         ; 
                        lsr a                             ; up
                        lsr a                             ; down
.Chk_Left               lsr a                             ; left
                        bcs .Chk_Right                    ; 
                        
.Was_Left               ldx BBZ_ScoreActiveColNum         ; 
.Was_LeftMax            beq .CheckLiftMoves               ; BBZ_ScoreActiveColNumTxt
                        
.Mov_Left               dec BBZ_ScoreActiveColNum         ; 
                        
.GoScoreActionBox       jsr TextOutScoreActionBox         ; 
                        jmp .WaitBeforeNextInput          ; 
; -------------------------------------------------------------------------------------------------------------- ;
.Chk_Right              lsr a                             ; right
                        bcs .CheckLiftMoves               ; 
                        
.Was_Right              ldx BBZ_ScoreActiveColNum         ; 
.Chk_RightMax           cpx #BBZ_ScoreActiveColNumBRi     ; Bulldozer right = max
.Was_RightMax           bcs .CheckLiftMoves               ; greater/eqal
                        
.Mov_Right              inc BBZ_ScoreActiveColNum         ; 
                        bcc .GoScoreActionBox             ; lower - always
; -------------------------------------------------------------------------------------------------------------- ;
.CheckLiftMoves         ldx #$00                          ; preset Bulldozer left offset
                        
                        ldy BBZ_ScoreActiveColNum         ; 
.Was_TextBox            beq .CheckTextBoxMoves            ; BBZ_ScoreActiveColNumTxt
                        
                        dey                               ; 
.Was_LiftLeft           beq .ChkLiftOnTargetPos           ; BBZ_ScoreActiveColNumBLe
                        
.Was_LiftRight          ldx #$03                          ; get Bulldozer right offset
                        
.ChkLiftOnTargetPos     lda BBZ_ScoreLiftTargetPos,x      ; 
                        cmp BBZ_ScoreLiftActualPos,x      ; 
.StillMoving            bne .GoWaitBeforeNextInput        ; 
                        
.GetLiftRowNum          ldy BBZ_ScoreLiftRowNum,x         ; 
                        
                        lda BBZ_JoystickMenu              ; BBZ_ScoreActiveColNumTxt = Left Text Pos
.Chk_LiftUp             lsr a                             ; 
                        bcs .Chk_LiftDown                 ; 
                        
.Mov_LiftUp             dey                               ; 
.Chk_LiftUpMax          bmi .GoWaitBeforeNextInput        ; 
                        bpl .SetLiftTargetNew             ; always
; -------------------------------------------------------------------------------------------------------------- ;
.Chk_LiftDown           lsr a                             ; 
                        bcs .GoWaitBeforeNextInput        ; 
                        
.Mov_LiftDown           iny                               ; 
.Chk_LiftDownMax        cpy #$0d                          ; 
                        bcs .GoWaitBeforeNextInput        ; greater/equal
; -------------------------------------------------------------------------------------------------------------- ;
.SetLiftTargetNew       sty BBZ_ScoreLiftRowNum,x         ; lower
                        
                        lda TabScreenRowPosY,y            ; 
                        sec                               ; 
                        sbc #$06                          ; 
                        sta BBZ_ScoreLiftTargetPos,x      ; 
                        
.GoWaitBeforeNextInput  jmp .WaitBeforeNextInput          ; 
; -------------------------------------------------------------------------------------------------------------- ;
.CheckTextBoxMoves      lda BBZ_JoystickMenuCheck         ; 
.Chk_TextBoxUp          lsr a                             ; 
                        bcs .Chk_TextBoxDown              ; 
                        
.Was_TextBoxUp          lda BBZ_ScoreTextBoxRowNum        ; 
.Chk_TextBoxUpMax       beq .TexbBoxBlink                 ; 
                        
                        jsr TextOutScoreActionBox         ; 
                        
.Mov_TextBoxUp          dec BBZ_ScoreTextBoxRowNum        ; 
                        jmp ScoreInputHandlerX            ; 
; -------------------------------------------------------------------------------------------------------------- ;
.Chk_TextBoxDown        lsr a                             ; 
                        bcs .TexbBoxBlink                 ; 
                        
.Was_TextBoxDown        lda BBZ_ScoreTextBoxRowNum        ; 
.Chk_TextBoxDownMax     cmp #$02                          ; 
                        beq .TexbBoxBlink                 ; 
                        
                        jsr TextOutScoreActionBox         ; 
                        
.Mov_TextBoxDown        inc BBZ_ScoreTextBoxRowNum        ; 
                        jmp ScoreInputHandlerX            ; 
; -------------------------------------------------------------------------------------------------------------- ;
.TexbBoxBlink           lda BBZ_IRQ_GameTimer             ; 
                        and #$07                          ; .....###
                        bne ScoreInputHandlerX            ; 
                        
.Text_Off               ldx #[$0f * $04]                  ; ptr -> TabTextColorShape_01/TabTextColorShape_02
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$08                          ; ....#...
                        bne .TextOut                      ; 
                        
.Text_On                ldx #[$0e * $04]                  ; ptr -> TabTextColorShape_01/TabTextColorShape_02
                        
.TextOut                jsr TextOutWaitRaster             ; 
                        
ScoreInputHandlerX      jmp .WaitBeforeNextInput          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreMoveCharsRight   Does    : Moves a Bulldozer selected char one step right
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreMoveCharsRight     subroutine                        ; 
                        jsr ScoreCharHiResPtrSet          ; 
                        
.GetNextMoveStepPos     ldy #[BB_Scrn_ColorRowLen * $02]  ; 
                        
.ShiftHiResDataRight_1  lda (BBZ_CharRowHiResPtr),y       ; 
                        ror a                             ; 
                        ror a                             ; 
                        ror a                             ; 
                        ora #$3f                          ; ..######
                        ldy #[[BB_Scrn_ColorRowLen * $02] + $08] ; 
                        and (BBZ_CharRowHiResPtr),y       ; 
                        
                        jmp .SetNextCharHiResData         ; 
                        
.GetNextCharHiResData   lda (BBZ_CharRowHiResPtr),y       ; 
.SetNextCharSaveDataRi  sta BBZ_ScoreHiresSaveData        ; 

.SetNextHiResPosRight_1 tya                               ; 
                        clc                               ; 
                        adc #$08                          ; 
                        tay                               ; 
                        
.ShiftHiResDataRight_2  lda (BBZ_CharRowHiResPtr),y       ; 
                        lsr BBZ_ScoreHiresSaveData        ; 
                        ror a                             ; 
                        lsr BBZ_ScoreHiresSaveData        ; 
                        ror a                             ; 
                        
.SetNextCharHiResData   sta (BBZ_CharRowHiResPtr),y       ; 
                        
.SetNextHiResPosRight_2 tya                               ; 
                        sec                               ; 
                        sbc #$10                          ; 
                        tay                               ; 
                        bpl .GetNextCharHiResData         ; 
                        
                        lda #$ff                          ; ########
                        
.ChkHiResPosRightMax    cpy #$f8                          ; 
                        beq .SetNextCharSaveDataRi        ; 
                        
.NextScoreHiResPtrStep  jsr ScoreCharHiResPtrInc          ; 
.ChkScoreHiResPtrSteps  bne .GetNextMoveStepPos           ; 
                        
ScoreMoveCharsRightX    rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreCharHiResPtrInc  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreCharHiResPtrInc    subroutine                        ; 
                        inc BBZ_CharRowHiResPtrLo         ; 
                        
                        lda BBZ_CharRowHiResPtrLo         ; 
                        and #$07                          ; .....### 
.ChkAdjustment          beq .Adjust                       ; 
                        
                        dec BBZ_ScoreCharPtrIncSteps      ; 
                        rts                               ; 
                        
.Adjust                 ldy BBZ_CharRowHiResPtrLo         ; 
                        dey                               ; 
                        tya                               ; 
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_CharRowHiResPtrLo         ; 
                        lda BBZ_CharRowHiResPtrHi         ; 
                        adc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_CharRowHiResPtrHi         ; 
                        
                        dec BBZ_ScoreCharPtrIncSteps      ; 
ScoreCharHiResPtrIncX   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreMoveCharsLeft    Does    : Moves Treadmill/Bulldozer selected char one step left
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreMoveCharsLeft      subroutine                        ; 
                        jsr ScoreCharHiResPtrSet          ; 
                        
.GetNextMoveStepPos     ldy #$58                          ; 
                        lda #$ff                          ; ########
                        bne .SetCharHiResByte             ; always
                        
.GetNextCharSaveData    lda BBZ_ScoreHiresSaveData        ; 
.SetCharHiResByte       sta BBZ_ScoreHiresShiftData       ; 
                        
.GetNextCharHiResData   lda (BBZ_CharRowHiResPtr),y       ; 
.SetNextCharSaveDataLe  sta BBZ_ScoreHiresSaveData        ; 
                        
.ShiftHiResDataLeft     asl BBZ_ScoreHiresShiftData       ; 
                        rol a                             ; 
                        asl BBZ_ScoreHiresShiftData       ; 
                        rol a                             ; 
                        
.SetNextCharHiResData   sta (BBZ_CharRowHiResPtr),y       ; 
                        
.SetNextHiResPosLeft    tya                               ; 
                        sec                               ; 
                        sbc #$08                          ; 
                        tay                               ; 
                        bpl .GetNextCharSaveData          ; 
                        
                        ldy #$00                          ; 
                        lda BBZ_ScoreHiresSaveData        ; 
                        ora #$3f                          ; ..######
                        and (BBZ_CharRowHiResPtr),y       ; 
                        sta (BBZ_CharRowHiResPtr),y       ; 
                        
.NextScoreHiResPtrStep  jsr ScoreCharHiResPtrInc          ; 
.ChkScoreHiResPtrSteps  bne .GetNextMoveStepPos           ; 
                        
ScoreMoveCharsLeftX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreGenCharSprites   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreGenCharSprites     subroutine                        ; 
                        ldx BBZ_ScoreNameActualLen        ; 
                        sta BB_ScorerInputBuffer,x        ; 
                        
                        tax                               ; 
                        
                        lda #>[BB_SpriteStoreLo01 + $30]  ; 
                        sta BBZ_BirdsSpriteStorePtrHi     ; 
                        
                        lda #<[BB_SpriteStoreLo01 + $30]  ; 
                        sta BBZ_BirdsSpriteStorePtrLo     ; 
                        
                        lda BB_InfoCharDataPtrLo,x        ; 
                        sta .__GetCharDataAdrLo_Ri        ; 
                        sta .__GetCharDataAdrLo_Le        ; 
                        
                        lda BB_InfoCharDataPtrHi,x        ; 
                        sta .__GetCharDataAdrHi_Ri        ; 
                        sta .__GetCharDataAdrHi_Le        ; 
                        
                        ldy #$0d                          ; 
                        ldx #$09                          ; 
.__GetCharDataAdrLo_Ri  equ [* + $01]                     ; 
.__GetCharDataAdrHi_Ri  equ [* + $02]                     ; 
.GetNextCharDataByteRi  lda BB_PlaceHolder_8000,x         ; 
                        and #$aa                          ; #.#.#.#.
                        sta (BBZ_BirdsSpriteStorePtr),y   ; 
                        
                        dey                               ; 
                        dex                               ; 
                        
.__GetCharDataAdrLo_Le  equ [* + $01]                     ; 
.__GetCharDataAdrHi_Le  equ [* + $02]                     ; 
.GetNextCharDataByteLe  lda BB_PlaceHolder_8000,x         ; 
                        and #$aa                          ; #.#.#.#.
                        sta (BBZ_BirdsSpriteStorePtrLo),y ; 
                        
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl .GetNextCharDataByteRi        ; 
                        
ScoreGenCharSpritesX    rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreSetSpriteStorePtr Does   : 
;                       Expects : 
;                       Returns : yr=0d
; -------------------------------------------------------------------------------------------------------------- ;
ScoreSetSpriteStorePtr  subroutine                        ; 
                        lda TabScoreSpriteStoreLo,x       ; 
                        sta BBZ_ScoreSpriteStorePtrLo     ; 
                        lda TabScoreSpriteStoreHi,x       ; 
                        sta BBZ_ScoreSpriteStorePtrHi     ; 
                        
                        ldy #$0d                          ; 
                        
ScoreSetSpriteStorePtrX rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreCheckNameLenMax  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreCheckNameLenMax    subroutine                        ; 
.GetActualNameLen       lda BBZ_ScoreNameActualLen        ; 
.ChkMaxNameLen          cmp GameOptsScoreNamLen           ; 
.MaxReached_No          bne ScoreCheckNameLenMaxX         ; 
                        
.MaxReached_Yes         lda #BBZ_ScoreTextBoxRowNumEn     ; 
.ActivateEnd            sta BBZ_ScoreTextBoxRowNum        ; 
                        
.ActivateTextBox        lda #BBZ_ScoreActiveColNumTxt     ; 
                        sta BBZ_ScoreActiveColNum         ; 
                        
ScoreCheckNameLenMaxX   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreCharHiResPtrSet  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreCharHiResPtrSet    subroutine                        ; 
                        stx BBZ_ScoreCharPtrIncSteps      ; 
                        
                        tax                               ; 
                        lda BB_TabHiResAdrColLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrRowLo,y         ; 
                        sta BBZ_CharRowHiResPtrLo         ; 
                        lda BB_TabHiResAdrColHi,x         ; 
                        adc BB_TabHiResAdrRowHi,y         ; 
                        sta BBZ_CharRowHiResPtrHi         ; 
                        
                        lda BBZ_ScoreCharPtrIncSteps      ; 
                        cmp #$01                          ; 
                        bne .IniWaitRaster                ; 
                        
                        jmp TimerWaitFull                 ; 
                        
.IniWaitRaster          tya                               ; 
                        clc                               ; 
                        adc #$36                          ; 
.WaitRaster01           cmp RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        bcc .WaitRaster01                 ; lower
                        
.WaitRaster02           cmp RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        bcs .WaitRaster02                 ; higher/equal
                        
ScoreCharHiResPtrSetX   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        rend                              ; 
CopyCode_05_X           equ *                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; EndOfCopies           
; -------------------------------------------------------------------------------------------------------------- ;
; StartOfMainCode       
; -------------------------------------------------------------------------------------------------------------- ;
                        * = BB_Code_Main                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispatchHidden     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DynDispatchHidden       subroutine                        ; 
                        lda R6510                         ; 
.SaveConfig             pha                               ; 
                        
                        and #[KERNAL_OFF & BASIC_OFF]     ; ##### #.. = io=off basic=off kernal=off
                        sta R6510                         ; 
                        
                        stx [.__CallRoutine + $02]        ; 
                        sty [.__CallRoutine + $01]        ; 
.__CallRoutine          jsr BB_PlaceHolder_9800           ; 
                        
.RestoreConfig          pla                               ; 
                        sta R6510                         ; 
                        
DynDispatchHiddenX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScreenRowPosY        dc.b $20 ; options and info
                        dc.b $2a ; 
                        dc.b $34 ; 
                        dc.b $3e ; 
                        dc.b $48 ; 
                        dc.b $52 ; 
                        dc.b $5c ; 
                        dc.b $66 ; 
                        dc.b $70 ; 
                        dc.b $7a ; 
                        dc.b $84 ; 
                        dc.b $8e ; 
                        dc.b $98 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GenBulldozerSprite    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GenBulldozerSprite      subroutine                        ; 
                        ldx #$08                          ; 
.CopyNextData           lda TabBulldozerSpriteRi01,x      ; 
                        sta BB_SpriteStore08,y            ; 
                        
                        lda TabBulldozerSpriteRi02,x      ; 
                        sta BB_SpriteStore09,y            ; 
                        
                        dey                               ; 
                        
                        lda TabBulldozerSpriteLe01,x      ; 
                        sta BB_SpriteStore08,y            ; 
                        
                        lda TabBulldozerSpriteLe02,x      ; 
                        sta BB_SpriteStore09,y            ; 
                        
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl .CopyNextData                 ; 
                        
GenBulldozerSpriteX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBulldozerSpriteLe01  dc.b $30 ; ..##............
                        dc.b $cc ; ##..##..........
                        dc.b $30 ; ..##............
                        dc.b $b2 ; #.##..#.##..#.#.
                        dc.b $be ; #.#####.##..#.#.
                        dc.b $aa ; #.#.#.#.#####.#.
                        dc.b $3f ; ..########....##
                        dc.b $ea ; ###.#.#.##..###.
                        dc.b $3f ; ..######......##
                        
TabBulldozerSpriteRi01  dc.b $00 ; ............##..
                        dc.b $00 ; ..........##..##
                        dc.b $00 ; ............##..
                        dc.b $a3 ; #.#...###...###.
                        dc.b $a3 ; #.#...###.#####.
                        dc.b $af ; #.#.#####.#.#.#.
                        dc.b $db ; ##.##.########..
                        dc.b $b3 ; #.##..###.#.#.##
                        dc.b $c0 ; ##......######..
                        
TabBulldozerSpriteLe02  dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $ca ; ##..#.#.
                        dc.b $ca ; ##..#.#.
                        dc.b $fa ; #####.#.
                        dc.b $c3 ; ##....##
                        dc.b $ce ; ##..###.
                        dc.b $03 ; ......##
                        
TabBulldozerSpriteRi02  dc.b $0c ; ....##..
                        dc.b $33 ; ..##..##
                        dc.b $0c ; ....##..
                        dc.b $8e ; #...###.
                        dc.b $be ; #.#####.
                        dc.b $aa ; #.#.#.#.
                        dc.b $fc ; ######..
                        dc.b $ab ; #.#.#.##
                        dc.b $fc ; ######..
; -------------------------------------------------------------------------------------------------------------- ;
; SetSpritesDecPosX     Does    : 
;                       Expects : ac=Sprite PosX xr=Sprite Num
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetSpritesDecPosX       subroutine                        ; 
                        sec                               ; 
                        sbc #$24                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetSpritesPosX        Does    : 
;                       Expects : ac=Sprite PosX xr=Sprite Num
;                       Returns : ac=MSB PosX
; -------------------------------------------------------------------------------------------------------------- ;
SetSpritesPosX          subroutine                        ; 
                        asl a                             ; *2
                        sta SP0X,x                        ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda TabSpriteMsbPosX_Lo,x         ; 
.SavePosX_MSB           php                               ; 
                        bcc .Flip                         ; 
                        
                        sei                               ; 
                        ora MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        bcs .SetMostSigX                  ; 
                        
.Flip                   eor #$ff                          ; 
                        and MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.SetMostSigX            sta MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.RestorePosX_MSB        plp                               ; 
                        
SetSpritesPosXX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteMsbPosX_Lo     dc.b $01 ; .......#
                        dc.b $01 ; .......#
                        dc.b $02 ; ......#.
                        dc.b $02 ; ......#.
                        dc.b $04 ; .....#..
                        dc.b $04 ; .....#..
                        dc.b $08 ; ....#...
                        dc.b $08 ; ....#...
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteMsbPosX_Hi     dc.b $10 ; ...#....
                        dc.b $10 ; ...#....
                        dc.b $20 ; ..#.....
                        dc.b $20 ; ..#.....
                        dc.b $40 ; .#......
                        dc.b $40 ; .#......
                        dc.b $80 ; #.......
; -------------------------------------------------------------------------------------------------------------- ;
; DrawPole              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPole                subroutine                        ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
DrawPole_SetHight       sty BBZ_PoleDrawHight             ; 
                        
.GetHight               tya                               ; 
                        clc                               ; 
                        adc BBZ_DrawPosY                  ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        
.SaveHight              pha                               ; 
                        
                        and #$07                          ; .....###
                        tay                               ; 
                        
.SetDrawSubroutinePtr   lda TabDrawPoleSubLo,y            ; 
                        sta BBZ_DrawPoleSubPtrLo          ; 
                        lda TabDrawPoleSubHi,y            ; 
                        sta BBZ_DrawPoleSubPtrHi          ; 
                        
.RestoreHight           pla                               ; 
                        
                        tay                               ; 
                        lda BB_TabHiResAdrRowLo,y         ; 
                        sec                               ; 
                        sbc BBZ_PoleDrawHight             ; 
                        sta BBZ_HiResNextPosPtrLo         ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        sbc #$00                          ; 
                        sta BBZ_HiResNextPosPtrHi         ; 
                        
                        lda BBZ_DrawPosX                  ; 
.DrawNextPolePart       clc                               ; 
                        adc BBZ_HiResNextPosPtrLo         ; 
                        sta BBZ_HiResNextPosPtrLo         ; 
                        sta BBZ_HiResRowPtrLo             ; 
                        
                        lda BBZ_HiResNextPosPtrHi         ; 
                        adc #$00                          ; 
                        sta BBZ_HiResNextPosPtrHi         ; 
                        sta BBZ_HiResRowPtrHi             ; 
                        
                        lda BBZ_TabDrawLineColorPtr       ; 
                        ldy BBZ_PoleDrawHight             ; 
.PaintPoleParts         jmp (BBZ_DrawPoleSubPtr)          ; 
                        
.GetNextPolePart        lda #$08                          ; 
                        
                        dex                               ; 
                        bne .DrawNextPolePart             ; 
                        
DrawPoleX               rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawPoleParts         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_01         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_02         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_03         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_04         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_05         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_06         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_07         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_08         sta (BBZ_HiResRowPtr),y           ; 
                        dey                               ; 
                        beq .GetNextPolePart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawPolePart_SetNextRow lda BBZ_HiResRowPtrLo             ; 
                        sec                               ; 
                        sbc #<[BB_Scrn_HiResRowLen - $08] ; 
                        sta BBZ_HiResRowPtrLo             ; 
                        
                        lda BBZ_HiResRowPtrHi             ; 
                        sbc #>[BB_Scrn_HiResRowLen - $08] ; 
                        sta BBZ_HiResRowPtrHi             ; 
                        
                        lda BBZ_TabDrawLineColorPtr       ; 
                        
DrawPolePartsX          jmp DrawPolePart_01               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDrawPoleSubLo        dc.b <DrawPolePart_08 ; 
                        dc.b <DrawPolePart_07 ; 
                        dc.b <DrawPolePart_06 ; 
                        dc.b <DrawPolePart_05 ; 
                        dc.b <DrawPolePart_04 ; 
                        dc.b <DrawPolePart_03 ; 
                        dc.b <DrawPolePart_02 ; 
                        dc.b <DrawPolePart_01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDrawPoleSubHi        dc.b >DrawPolePart_08 ; 
                        dc.b >DrawPolePart_07 ; 
                        dc.b >DrawPolePart_06 ; 
                        dc.b >DrawPolePart_05 ; 
                        dc.b >DrawPolePart_04 ; 
                        dc.b >DrawPolePart_03 ; 
                        dc.b >DrawPolePart_02 ; 
                        dc.b >DrawPolePart_01 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabGameOptsColor        dc.b RED                          ; 
                        dc.b BROWN                        ; 
                        dc.b ORANGE                       ; 
                        dc.b YELLOW                       ; 
                        dc.b LT_GREEN                     ; 
                        dc.b CYAN                         ; 
                        dc.b LT_BLUE                      ; 
                        dc.b LT_GREY                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitAll               Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitAll                 subroutine                        ; 
                        sei                               ; 
                        
                        jsr InitVicSid                    ; 
                        jsr InitHiResTab                  ; 
                        
                        lda #$05                          ; 
                        sta BBZ_CheckFireWaitP1           ; 
                        sta BBZ_CheckFireWaitP2           ; 
                        
                        asl a                             ; $0a = BB_GameOptsTextHeight
                        sta GameTextRowHeight             ; 
                        
                        jsr InitVoice3                    ; 
                        
                        lda #HR_GreenGreen                ; 
                        jsr FillScreenWithAc              ; 
                        
                        lda #GREY                         ; 
InitAllX                jmp FillColorRamWithAc            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MirrorByteCheck       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MirrorByteCheck         subroutine                        ; 
                        ldx #$08                          ; 
                        ldy BBZ_MirrorShiftFlag           ; 
                        bne MirrorByteX                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MirrorByte            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MirrorByte              subroutine                        ; 
                        sta BBZ_MirrorShiftByte           ; 
                        
                        lda #$08                          ; 
                        sta BBZ_MirrorShiftCount          ; 
                        
.Shift                  rol BBZ_MirrorShiftByte           ; 
                        ror a                             ; 
                        
                        dec BBZ_MirrorShiftCount          ; 
                        bne .Shift                        ; 
                        
MirrorByteX             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawScreenObjects     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawScreenObjects       subroutine                        ; 
.GetNextDecoObj         lda TabScreenObjects,y            ; $00 - hight
.Exit                   beq MirrorByteX                   ; 
                        
                        iny                               ; $01 - length
                        
.DrawNextDecoObj        sec                               ; 
.DecHight               sbc #$01                          ; 
                        
.SaveHight              pha                               ; 
                        
                        lda TabScreenObjects,y            ; 
                        sta BBZ_DrawLen                   ; 
                        
                        iny                               ; $02 - PosX
                        lda TabScreenObjects,y            ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        iny                               ; $03 - PosY
                        
                        pla                               ; 
                        pha                               ; 
                        
                        clc                               ; 
                        adc TabScreenObjects,y            ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        iny                               ; $04 - color
                        lda TabScreenObjects,y            ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
.SetNextObjectStart     iny                               ; $05
                        sty BBZ_DrawDecoTabPtr            ; 
                        
.DrawDecoLine           jsr DrawLineHorizontal            ; 
                        
                        ldy BBZ_DrawDecoTabPtr            ; 
                        
.RestoreHight           pla                               ; 
                        beq .GetNextDecoObj               ; 
                        
.ResetToDrawLen         dey                               ; handle next hight row - reset deco pointer to DrawLen
                        dey                               ; 
                        dey                               ; 
                        dey                               ; 
DrawScreenObjectsX      bne .DrawNextDecoObj              ; always - next part
; -------------------------------------------------------------------------------------------------------------- ;
TabScreenObjects        equ  *
TabScreenObjectsScores  equ  [* - TabScreenObjects] ; 
.ErasorLine_Top         dc.b $01 ; hight (thickness)
                        dc.b $a0 ; len
                        dc.b $00 ; PosX
                        dc.b $00 ; PosY
                        dc.b $04 ; color
                        
.ErasorLine_Bottom      dc.b $01 ; hight (thickness)
                        dc.b $a0 ; len
                        dc.b $00 ; PosX
                        dc.b $04 ; PosY
                        dc.b $04 ; color
                        
.ConveyorLine_Top       dc.b $01 ; hight (thickness)
                        dc.b $51 ; len
                        dc.b $3f ; PosX
                        dc.b $a6 ; PosY
                        dc.b $04 ; color
                        
.ConveyorLine_Bottom    dc.b $01 ; hight (thickness)
                        dc.b $51 ; len
                        dc.b $3f ; PosX
                        dc.b $b2 ; PosY
                        dc.b $04 ; color
                        
.TextBoxLine_Top        dc.b $01 ; hight (thickness)
                        dc.b $27 ; len
                        dc.b $00 ; PosX
                        dc.b $72 ; PosY
                        dc.b $04 ; color
                        
.TextBoxLine_Bottom     dc.b $01 ; hight (thickness)
                        dc.b $27 ; len
                        dc.b $00 ; PosX
                        dc.b $8c ; PosY
                        dc.b $04 ; color
                        
.TextBoxLine_Left       dc.b $1a ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $00 ; PosX
                        dc.b $72 ; PosY
                        dc.b $04 ; color
                        
.TextBoxLine_Right      dc.b $1b ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $27 ; PosX
                        dc.b $72 ; PosY
                        dc.b $04 ; color
                        
.LiftsLine_Bottom       dc.b $02 ; hight (thickness)
                        dc.b $6e ; len
                        dc.b $31 ; PosX
                        dc.b $bb ; PosY
                        dc.b $04 ; color
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabScreenObjectsBoard_1 equ  [* - TabScreenObjects] ; 
.BoardTitleStandLeft    dc.b $0a ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $44 ; PosX
                        dc.b $12 ; PosY
                        dc.b $0c ; color
                        
.BoardTitleStandRight   dc.b $0a ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $5c ; PosX
                        dc.b $12 ; PosY
                        dc.b $0c ; color
                        
.BoardFrameLineTop      dc.b $01 ; hight (thickness)
                        dc.b $6a ; len
                        dc.b $1b ; PosX
                        dc.b $1c ; PosY
                        dc.b $0c ; color
                        
.BoardFrameLineBottom   dc.b $01 ; hight (thickness)
                        dc.b $6a ; len
                        dc.b $1b ; PosX
                        dc.b $82 ; PosY
                        dc.b $0c ; color
                        
.BoardFrameLineLeft     dc.b $65 ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $1b ; PosX
                        dc.b $1d ; PosY
                        dc.b $0c ; color
                        
.BoardFrameLineRight    dc.b $65 ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $84 ; PosX
                        dc.b $1d ; PosY
                        dc.b $0c ; color
                        
.BoardTitleFrameTop     dc.b $01 ; hight (thickness)
                        dc.b $94 ; len
                        dc.b $08 ; PosX
                        dc.b $05 ; PosY
                        dc.b $0c ; color
                        
.BoardTitleFrameBottom  dc.b $01 ; hight (thickness)
                        dc.b $94 ; len
                        dc.b $08 ; PosX
                        dc.b $11 ; PosY
                        dc.b $0c ; color
                        
.BoardTitleFrameLeft    dc.b $0d ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $07 ; PosX
                        dc.b $05 ; PosY
                        dc.b $0c ; color
                        
.BoardTitleFrameRight   dc.b $0d ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $9c ; PosX
                        dc.b $05 ; PosY
                        dc.b $0c ; color
                        
.BoardGround            dc.b $01 ; hight (thickness)
                        dc.b $a0 ; len
                        dc.b $00 ; PosX
                        dc.b $be ; PosY
                        dc.b $00 ; color
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabScreenObjectsBoard_2 equ  [* - TabScreenObjects] ; 
.BoardStand             dc.b $01 ; hight (thickness)
                        dc.b $0c ; len
                        dc.b $02 ; PosX
                        dc.b $bd ; PosY
                        dc.b $00 ; color
                        
.BoardConnector         dc.b $10 ; hight (thickness)
                        dc.b $01 ; len
                        dc.b $1a ; PosX
                        dc.b $39 ; PosY
                        dc.b $0c ; color
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabScreenObjectsBoard_3 equ  [* - TabScreenObjects] ; 
.BoardHouseWallLeft     dc.b $0f ; hight (thickness)
                        dc.b $0f ; len
                        dc.b $10 ; PosX
                        dc.b $af ; PosY
                        dc.b $08 ; color
                        
.BoardHouseWallRight    dc.b $0f ; hight (thickness)
                        dc.b $0f ; len
                        dc.b $8d ; PosX
                        dc.b $af ; PosY
                        dc.b $08 ; color
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabScreenObjectsLevel20 equ  [* - TabScreenObjects] ; hide mobile suction tube background
.MobileSuctionTubeBack  dc.b $08 ; hight (thickness)
                        dc.b $0c ; len
                        dc.b $1e ; PosX
                        dc.b $0a ; PosY
                        dc.b $00 ; color
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
GameOptsValues          equ  *   ; 
GameOptsLives           dc.b BB_GameOptsLivesIni      ; $02
GameOptsPlayers         dc.b BB_GameOptsPlayersIni    ; $00
GameOptsSticks          dc.b BB_GameOptsSticksIni     ; $00
GameOptsSecMsg          dc.b BB_GameOptsSecMsgIni     ; $00
GameOptsBonus           dc.b BB_GameOptsBonusIni      ; $02
GameOptsDifficulty      dc.b BB_GameOptsDifficultyIni ; $00
GameOptsPauseKey        dc.b BB_GameOptsPauseKeyIni   ; $01
GameOptsVolume          dc.b BB_GameOptsVolumeIni     ; $05
GameOptsTimeScore       dc.b BB_GameOptsTimeScoreIni  ; $16
GameOptsTimeTitle       dc.b BB_GameOptsTimeTitleIni  ; $23
GameOptsYohanType       dc.b BB_GameOptsYohanTypeIni  ; $00
GameOptsScoreNamLen     dc.b BB_GameOptsScorNamLenIni ; $06
GameOptsCodeLo          dc.b BB_GameOptsCodeLoIni     ; $00
GameOptsCodeHi          dc.b BB_GameOptsCodeHiIni     ; $00
; -------------------------------------------------------------------------------------------------------------- ;
GameOptsMasterFlag      dc.b BB_GameOptsMasterOk      ; $00
GameTextRowHeight       dc.b BB_GameOptsTextHeight    ; $0a
; -------------------------------------------------------------------------------------------------------------- ;
TabKeyMatrixEquiv       equ  *   ; 
TabKeyMatrixRow_00      dc.b $64 ; Crsr_D
                        dc.b $65 ; F5
                        dc.b $66 ; F3
                        dc.b $67 ; F1   
                        dc.b $68 ; F7
                        dc.b $69 ; Crsr_R
                        dc.b $6a ; Return
                        dc.b $6b ; Delete
                        
TabKeyMatrixRow_01      dc.b $80 ; Shft_L
                        dc.b $25 ; E
                        dc.b $33 ; S
                        dc.b $3a ; Z
                        dc.b $14 ; 4
                        dc.b $21 ; A
                        dc.b $37 ; W
                        dc.b $13 ; 3
                        
TabKeyMatrixRow_02      dc.b $38 ; X
                        dc.b $34 ; T
                        dc.b $26 ; F
                        dc.b $23 ; C
                        dc.b $16 ; 6
                        dc.b $24 ; D
                        dc.b $32 ; R
                        dc.b $15 ; 5
                        
TabKeyMatrixRow_03      dc.b $36 ; V
                        dc.b $35 ; U
                        dc.b $28 ; H
                        dc.b $22 ; B
                        dc.b $18 ; 8
                        dc.b $27 ; G
                        dc.b $39 ; Y
                        dc.b $17 ; 7
                        
TabKeyMatrixRow_04      dc.b $2e ; N
                        dc.b $2f ; O
                        dc.b $2b ; K
                        dc.b $2d ; M
                        dc.b $10 ; 0
                        dc.b $2a ; J
                        dc.b $29 ; I
                        dc.b $19 ; 9
                        
TabKeyMatrixRow_05      dc.b $0c ; ,
                        dc.b $20 ; @
                        dc.b $1a ; :
                        dc.b $0e ; .
                        dc.b $0d ; -
                        dc.b $2c ; L
                        dc.b $30 ; P
                        dc.b $0b ; +
                        
TabKeyMatrixRow_06      dc.b $0f ; /
                        dc.b $6c ; ^
                        dc.b $1d ; =
                        dc.b $80 ; Shft_R
                        dc.b $6d ; Home
                        dc.b $1b ; ;
                        dc.b $0a ; *
                        dc.b $6e ; LIRA
                        
TabKeyMatrixRow_07      dc.b $6f ; Stop
                        dc.b $31 ; Q
                        dc.b $70 ; C=
                        dc.b $00 ; Space
                        dc.b $12 ; 2
                        dc.b $c0 ; Ctrl
                        dc.b $71 ; <-
                        dc.b $11 ; 1
; -------------------------------------------------------------------------------------------------------------- ;
TabKeyPressed_01        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabKeyPressed_02        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
                        dc.b $ff ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetKey                Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetKey                  subroutine                        ; 
                        lda #$01                          ; 
                        bne CheckKeyBoard                 ; always
; -------------------------------------------------------------------------------------------------------------- ;
; GetKeyPressed         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetKeyPressed           subroutine                        ; 
                        lda #$00                          ; 
                        jsr CheckKeyBoard                 ; 
                        
                        cmp #BBZ_KeyPressedNone           ; 
                        beq CheckKeyBoardX                ; 
                        
                        sta BBZ_KeyPressed                ; 
                        
GetKeyPressedX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckKeyBoard         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckKeyBoard           subroutine                        ; 
                        sta .__FlagFlip                   ; $00 or $01
                        
.SaveRegs               txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        lda #BBZ_KeyPressedNone           ; init return key value equivalent
                        sta .__ReturnKeyEquiv             ; 
                        
                        lda [CIAPRA + $f0]                ; CIA1(CIAPRA=$DC00) mirror: Data Port Register A
                        and [CIAPRB + $f0]                ; CIA1(CIAPRB=$DC01) mirror: Data Port Register B
                        cmp #$ff                          ; 
                        bne .RestoreRegs                  ; nothing pressed - exit
                        
                        sta [CIDDRA + $f0]                ; CIA1(CIDDRA=$DCF2) mirror: Data Direction Register A
                        
                        ldx #$00                          ; 
.ChkNextMatrixCol       lda TabKeyMatrixCol,x             ; get column bit to check
                        sta [CIAPRA + $f0]                ; CIA1(CIAPRA=$DC00) mirror: Data Port Register A
                        
                        lda [CIAPRB + $f0]                ; CIA1(CIAPRB=$DC01) mirror: Data Port Register B
                        cmp TabKeyPressed_02,x            ; 
                        bne .SetKeyMatrixRow_02           ; 
                        
                        pha                               ; save KeyMatrixRow
                        
.__FlagFlip             equ [* + $01]                     ; 
                        ldy #$00                          ; 
                        beq .FlipBits                     ; 
                        
                        eor #$ff                          ; 
                        jmp .ChkNextMatrixRowIni          ; 
                        
.FlipBits               eor TabKeyPressed_01,x            ; 
                        and TabKeyPressed_01,x            ; 
                        
.ChkNextMatrixRowIni    ldy #$07                          ; 
.ChkNextMatrixRow       lsr a                             ; 
                        bcc .SetNextMatrixRow             ; not pressed
                        
                        sty .__MatrixRowNo                ; 
                        
                        txa                               ; matrix col no
                        asl a                             ; *2
                        asl a                             ; *4
                        asl a                             ; *8
.__MatrixRowNo          equ [* + $01]                     ; 
                        adc #$00                          ; matrix row no
                        tay                               ; 
                        lda TabKeyMatrixEquiv,y           ; 
                        sta .__ReturnKeyEquiv             ; 
                        
                        ldy #$00                          ; key found - prepare exit
                        
.SetNextMatrixRow       dey                               ; 
                        bpl .ChkNextMatrixRow             ; 
                        
                        pla                               ; restore KeyMatrixRow
                        sta TabKeyPressed_01,x            ; 
.SetKeyMatrixRow_02     sta TabKeyPressed_02,x            ; 

.SetNextMatrixCol       inx                               ; 
                        cpx #$08                          ; 
                        bcc .ChkNextMatrixCol             ; lower
                        
                        lda #$00                          ; 
                        sta [CIDDRA + $f0]                ; CIA1(CIDDRA=$DC02) mirror: Data Direction Register A
                        
.RestoreRegs            pla                               ; 
                        tay                               ; 
                        pla                               ; 
                        tax                               ; 
                        
.__ReturnKeyEquiv       equ [* + $01]                     ; 
                        lda #$00                          ; 
                        
CheckKeyBoardX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabKeyMatrixCol         dc.b $fe ; #######. - 1=ignore keyboard matrix col/0=check it
                        dc.b $fd ; ######.#
                        dc.b $fb ; #####.##
                        dc.b $f7 ; ####.###
                        dc.b $ef ; ###.####
                        dc.b $df ; ##.#####
                        dc.b $bf ; #.######
                        dc.b $7f ; .#######
; -------------------------------------------------------------------------------------------------------------- ;
; WaitRaster_0c         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
WaitRaster_0c           subroutine                        ; 
                        lda #$0c                          ; 
                        jsr WaitRaster                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; WaitRaster_0d         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
WaitRaster_0d           subroutine                        ; 
                        lda #$0d                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; WaitRaster            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
WaitRaster              subroutine                        ; 
                        cmp RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        bne WaitRaster                    ; 
                        
                        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScreenToBank_00       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScreenToBank_00         subroutine                        ; 
                        jsr WaitRaster_0d                 ; 
                        
                        lda #CI2_VIC_MemBank_0            ; $0000-$3fff
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        sta C2DDRA                        ; CIA2($DD02) Data Dir A
                        
                        lda #[$00 | VIC_Video_0800 | VIC_CharS_2000] ; 
                        sta VMCSB                         ; VIC($D018) VIC Chip Memory Control
                        
                        lda #[$00 & VIC_On | VIC_MCM_On | VIC_Cols40 & VIC_SoftX_Clear] ; bit4=1 Multi Color Mode   bit3=1 40 columns
                        sta SCROLX                        ; ...##... - VIC($D016) VIC Control Register 2
                        
                        lda #[$00 & VIC_RasterHi_Off & VIC_ECM_Off | VIC_BMM_On | VIC_Screen_On | VIC_Rows25 | VIC_SoftY_03] ;
                        sta SCROLY                        ; ..###.## - VIC($D011) VIC Control Register 1
                        
ScreenToBank_00X        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillStoragePrepare    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillStoragePrepare      subroutine                        ; 
                        stx BBZ_FillStoragePageCount      ; set no of pages  $100-BBZ_10
                        sty __FillStorageWithAc           ; set start address high byte
                        
FillStoragePrepareX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillScreenWithZero    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillScreenWithZero      subroutine                        ; 
                        lda #$00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillScreenWithAc      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillScreenWithAc        subroutine                        ; 
                        ldx #$e0                          ; no of pages $100-$e0=$20
                        ldy #$20                          ; start address high = $2000
                        jsr FillStoragePrepare            ; 
                        
                        ldx #$c0                          ; max fill level last page $100-$40=$c0
                        ldy #$00                          ; start fill level first page
                        
FillScreenWithAcX       jmp FillStorageWithAc             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillSaveColorRamWithAc Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillSaveColorRamWithAc  subroutine                        ; 
                        ldx #$fc                          ; no of pages $100-$e0=$20
                        ldy #$ec                          ; start address high = $ec00
                        jsr FillStoragePrepare            ; 
                        
                        ldy #$00                          ; start fill level first page
                        
FillSaveColorRamWithAcX jmp FillZeroPageWithAc            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillColorRamWithAc    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillColorRamWithAc      subroutine                        ; 
                        ldx #$fc                          ; no of pages $100-$fc=$04
                        ldy #>COLORAM                     ; start address high
                        jsr FillStoragePrepare            ; 
                        
                        ldy #$00                          ; start fill level first page
; -------------------------------------------------------------------------------------------------------------- ;
; FillColorRamWithAc    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillZeroPageWithAc      subroutine                        ; 
                        ldx #$18                          ; max fill level last page $100-$18=$e8
FillColorRamWithAcX     bne FillStorageWithAc             ; always
; -------------------------------------------------------------------------------------------------------------- ;
TabSpritePtrGame        dc.b [BB_SpriteStore00   / VIC_Sprt_BlockLen] ; $00 - $30 ; $0c00
                        dc.b [BB_SpriteStore01   / VIC_Sprt_BlockLen] ; $01 - $31 ; 
                        dc.b [BB_SpriteStore02   / VIC_Sprt_BlockLen] ; $02 - $32 ; 
                        dc.b [BB_SpriteStore02   / VIC_Sprt_BlockLen] ; $03 - $32 ; 
                        dc.b [BB_SpriteStore00   / VIC_Sprt_BlockLen] ; $04 - $30 ; 
                        dc.b [BB_SpriteStore01   / VIC_Sprt_BlockLen] ; $05 - $31 ; 
                        dc.b [BB_SpriteStore02   / VIC_Sprt_BlockLen] ; $06 - $32 ; 
                        dc.b [BB_SpriteStore03   / VIC_Sprt_BlockLen] ; $07 - $33 ; <- name erasor
                        dc.b [BB_SpriteStore04   / VIC_Sprt_BlockLen] ; $08 - $34 ; 
                        dc.b [BB_SpriteStore05   / VIC_Sprt_BlockLen] ; $09 - $35 ; 
                        dc.b [BB_SpriteStore06   / VIC_Sprt_BlockLen] ; $0a - $36 ; 
                        dc.b [BB_SpriteStore07   / VIC_Sprt_BlockLen] ; $0b - $37 ; <- opt frame
                        dc.b [BB_SpriteStore08   / VIC_Sprt_BlockLen] ; $0c - $38 ; 
                        dc.b [BB_SpriteStore09   / VIC_Sprt_BlockLen] ; $0d - $39 ; 
                        dc.b [BB_SpriteStore0a   / VIC_Sprt_BlockLen] ; $0e - $3a ; 
                        dc.b [BB_SpriteStore0b   / VIC_Sprt_BlockLen] ; $0f - $3b ; 
                        dc.b [BB_SpriteStore0c   / VIC_Sprt_BlockLen] ; $10 - $3c ; 
                        dc.b [BB_SpriteStore0d   / VIC_Sprt_BlockLen] ; $11 - $3d ; 
                        dc.b [BB_SpriteStore0e   / VIC_Sprt_BlockLen] ; $12 - $3e ; 
                        dc.b [BB_SpriteStore01   / VIC_Sprt_BlockLen] ; $13 - $31 ; <- yohan
                        dc.b [BB_SpriteStore00   / VIC_Sprt_BlockLen] ; $14 - $30 ; 
                        dc.b [BB_SpriteStore08   / VIC_Sprt_BlockLen] ; $15 - $38 ; 
                        dc.b [BB_SpriteStore09   / VIC_Sprt_BlockLen] ; $16 - $39 ; 
                        dc.b [BB_SpriteStore0d   / VIC_Sprt_BlockLen] ; $17 - $3d ; 
                        dc.b [BB_SpriteStore0e   / VIC_Sprt_BlockLen] ; $18 - $3e ; 
                        dc.b [BB_SpriteStoreLo00 / VIC_Sprt_BlockLen] ; $19 - $0c ; $0300
                        dc.b [BB_SpriteStoreLo01 / VIC_Sprt_BlockLen] ; $1a - $0d ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetSpritePointers     Does    : 
;                       Expects : xr=tab offset
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetSpritePointers       subroutine                        ; 
.SetTabSpritePtrCount   ldy #$07                          ; 
.GetNextSpritePtr       lda TabSpritePtrGame,x            ; 
                        sta BB_SpritePointers,y           ; 
                        
.DecTabSpritePtrOffset  dex                               ; 
.DecTabSpritePtrCount   dey                               ; 
                        bpl .GetNextSpritePtr             ; 
                        
SetSpritePointersX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ClearSpriteStorSetPtr Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ClearSpriteStorSetPtr   subroutine                        ; 
                        jsr SetSpritePointers             ; xr=tab offset
; -------------------------------------------------------------------------------------------------------------- ;
; ClearSpriteStorage    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ClearSpriteStorage      subroutine                        ; 
                        ldx #$fc                          ; no of pages $100-$fc=$04
                        ldy #$0c                          ; start address high = $0c00
                        jsr FillStoragePrepare            ; 
                        
                        ldx #$40                          ; max fill level last page $100-$40=$c0
                        ldy #$00                          ; number of bytes/page 
                        jsr FillStorageWithZero           ; 
                        
                        ldx #$fe                          ; no of pages $100-$fe=$02
                        ldy #$03                          ; start address high = $0300
                        jsr FillStoragePrepare            ; 
                        
                        ldx #$40                          ; max fill level last page $100-$40=$c0
ClearSpriteStorageX     ldy #$00                          ; number of bytes/page 
; -------------------------------------------------------------------------------------------------------------- ;
; FillStorageWithZero   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillStorageWithZero     subroutine                        ; 
                        lda #$00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillStorageWithAc     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillStorageWithAc       subroutine                        ; 
.Fill                   sta BB_PlaceHolder_8000,y         ; 
__FillStorageWithAc     equ [* - $01]                     ; 
.NextByte               iny                               ; inc byte count
                        bne .IncFillLevel                 ; 
                        
                        inc __FillStorageWithAc           ; inc page
                        
.IncFillLevel           inx                               ; 
                        bne .Fill                         ; 
                        
.ChkMax                 inc BBZ_FillStoragePageCount      ; inc page count
                        bne .Fill                         ; 
                        
FillStorageWithAcX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitVicSid            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitVicSid              subroutine                        ; 
                        sei                               ; 
                        
                        lda R6510                         ; 
                        ora #[IO_ON | BASIC_ON]           ; .....#.# - io=on kernal=keep basic=on (if kernal=on)
                        sta R6510                         ; 
                        
                        ldy #$2e                          ; 
                        lda #$00                          ; 
.IniVic                 sta VIC2,y                        ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta BB_SaveSidRegs,y              ; 
                        sta SID,y                         ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        dey                               ; 
                        bpl .IniVic                       ; 
                        
                        ldx #[BB_SaveSidRegsLen + $01]    ; 
                        lda #$00                          ; 
.IniSid                 sta SID,x                         ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        sta BB_SaveSidRegs,x              ; 
                        dex                               ; 
                        bpl .IniSid                       ; 
                        
                        sta WrkSid_01                     ; 
                        sta WrkSid_02                     ; 
                        sta WrkSid_03                     ; 
                        
                        lda #$08                          ; 
                        sta PWHI1                         ; SID($D403) Oscillator 1 Pulse Waveform Width (high nybble)
                        sta PWHI2                         ; SID($D40A) Oscillator 2 Pulse Waveform Width (high nybble)
                        sta PWHI3                         ; SID($D411) Oscillator 3 Pulse Waveform Width (high nybble)
                        
                        lda #$00                          ; 
                        sta PWLO1                         ; SID($D402) Oscillator 1 Pulse Waveform Width (low byte)
                        sta PWLO2                         ; SID($D409) Oscillator 2 Pulse Waveform Width (low byte)
                        sta PWLO3                         ; SID($D410) Oscillator 3 Pulse Waveform Width (low byte)
                        
                        lda #$0f                          ; 
                        sta SIGVOL                        ; SID($D418) Volume/Filter Select
                        
InitVicSidX             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitHiResTab          Does    : Init completely
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitHiResTab            subroutine                        ; 
                        ldx #>BB_Scrn_HiRes               ; start value hi
                        lda #<BB_Scrn_HiRes               ; start value lo
; -------------------------------------------------------------------------------------------------------------- ;
; InitHiResTabGame      Does    : Init but leave out status line
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitHiResTabGame        subroutine                        ; 
                        stx BBZ_HiResAdrRowHi             ; 
                        sta BBZ_HiResAdrRowLo             ; 
                        
                        ldx #$00                          ; 
.GetNextPtr             lda BBZ_HiResAdrRowLo             ; 
                        sta BB_TabHiResAdrRowLo,x         ; 
                        
                        lda BBZ_HiResAdrRowHi             ; 
                        sta BB_TabHiResAdrRowHi,x         ; 
                        
                        inc BBZ_HiResAdrRowLo             ; 
                        bne .SetNextPtrPos                ; 
                        inc BBZ_HiResAdrRowHi             ; 
                        
.SetNextPtrPos          inx                               ; 
                        
                        txa                               ; 
                        and #$07                          ; .....###
                        bne .ChkMax                       ; 
                        
.SetNextRow             lda BBZ_HiResAdrRowLo             ; 
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $08] ; 
                        sta BBZ_HiResAdrRowLo             ; 
                        
                        lda BBZ_HiResAdrRowHi             ; 
                        adc #>[BB_Scrn_HiResRowLen - $08] ; 
                        sta BBZ_HiResAdrRowHi             ; 
                        
.ChkMax                 cpx #$c8                          ; 
                        bcc .GetNextPtr                   ; 
                        
InitHiResTabGameX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawVerticalLine      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawVerticalLine        subroutine                        ; 
                        sta BBZ_DrawVertLineLen           ; 
                        
.SetNextDrawPos         inc BBZ_DrawPosY                  ; 
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        dec BBZ_DrawVertLineLen           ; 
                        bne .SetNextDrawPos               ; 
                        
DrawVerticalLineX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawLine              Does    : 
;                       Expects : xr=PosX yr=PosY ac=length
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawLine                subroutine                        ; 
DrawLineSetLenPosXY     sty BBZ_DrawPosY                  ; 
DrawLineSetLenPosX      stx BBZ_DrawPosX                  ; 
DrawLineSetLen          sta BBZ_DrawLen                   ; 
                        
DrawLineHorizontal      jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        inc BBZ_DrawPosX                  ; 
                        
                        dec BBZ_DrawLen                   ; 
                        bne DrawLineHorizontal            ; 
                        
DrawLineX               rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawLineRoof          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawLineRoof            subroutine                        ; 
                        sta BBZ_DrawPosX                  ; 
                        lda BBZ_DrawRoofCount             ; 
                        
                        jmp DrawLineSetLen                ; ac=len
; -------------------------------------------------------------------------------------------------------------- ;
; DrawLinePart          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawLinePart            subroutine                        ; 
DrawLinePartGetPosXY    ldx BBZ_DrawPosX                  ; 
DrawLinePartGetPosY     ldy BBZ_DrawPosY                  ; 
                        
DrawLinePartWithXY      lda BB_TabHiResAdrRowLo,y         ; xr=PosX / yr=PosY
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta BBZ_HiResRowPtrLo             ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_HiResRowPtrHi             ; 
                        
                        txa                               ; 
                        and #$03                          ; ......## - four different PosX positions
.SetTabDrawPartOffset   tay                               ; 
                        
                        adc BBZ_TabDrawLineColorPtr       ; 
                        tax                               ; 
                        
.GetDrawPartInit        lda TabDrawLineColorClear,y       ; depending on position
                        
                        ldy #$00                          ; 
.ClearOldPart           and (BBZ_HiResRowPtr),y           ; 
.OverlayDrawPart        ora TabDrawLineColor,x            ; 
.SetNewPart             sta (BBZ_HiResRowPtr),y           ; 
                        
DrawLinePartX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDrawLineColor        equ  *   ; 
TabDrawLineColor_00     dc.b $00 ; ........ - $00 - value $00 for PosX = $00 - $03
                        dc.b $00 ; ........ - $01
                        dc.b $00 ; ........ - $02
                        dc.b $00 ; ........ - $03
TabDrawLineColor_01     dc.b $40 ; .#...... - $04 - value $01 for PosX = $00 - $03
                        dc.b $10 ; ...#.... - $05
                        dc.b $04 ; .....#.. - $06
                        dc.b $01 ; .......# - $07
TabDrawLineColor_02     dc.b $80 ; #....... - $08 - value $02 for PosX = $00 - $03
                        dc.b $20 ; ..#..... - $09
                        dc.b $08 ; ....#... - $0a
                        dc.b $02 ; ......#. - $0b
TabDrawLineColor_03     dc.b $c0 ; ##...... - $0c - value $03 for PosX = $00 - $03
                        dc.b $30 ; ..##.... - $0d
                        dc.b $0c ; ....##.. - $0e
                        dc.b $03 ; ......## - $0f
; -------------------------------------------------------------------------------------------------------------- ;
TabDrawLineColorClear   dc.b $3f ; ..###### - $10 - value clear for PosX = $00 - $03
                        dc.b $cf ; ##..####
                        dc.b $f3 ; ####..##
                        dc.b $fc ; ######..
; -------------------------------------------------------------------------------------------------------------- ;
; NMI                   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
NMI                     pha                               ; 
                        
                        lda #BB_IrqSubID_ColdStart        ; 
                        sta  __IrqDispatchSubID           ; 
                        
                        pla                               ; 
NMIX                    rti                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabHiresCharSetsOffLo   dc.b <[BB_Scrn_HiResCharSetLen * 00] ; $00 ; $1450 + $0000
                        dc.b <[BB_Scrn_HiResCharSetLen * 01] ; $4e ; $169e + $024e
                        dc.b <[BB_Scrn_HiResCharSetLen * 02] ; $9c ; $18ec + $049c
                        dc.b <[BB_Scrn_HiResCharSetLen * 03] ; $ea ; $1b3a + $06ea
; -------------------------------------------------------------------------------------------------------------- ;
TabHiresCharSetsOffHi   dc.b >[BB_Scrn_HiResCharSetLen * 00] ; $00 ; 
                        dc.b >[BB_Scrn_HiResCharSetLen * 01] ; $02 ; 
                        dc.b >[BB_Scrn_HiResCharSetLen * 02] ; $04 ; 
                        dc.b >[BB_Scrn_HiResCharSetLen * 03] ; $06 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; PrintTextChar         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
PrintTextChar           subroutine                        ; 
                        tay                               ; 
                        
                        lda BBZ_DrawPosX                  ; 
                        and #$03                          ; ......##
                        tax                               ; 
                        
                        lda BB_InfoCharDataPtrLo,y        ; 
                        clc                               ; 
                        adc TabHiresCharSetsOffLo,x       ; 
                        sta BBZ_PrintTextCharPtrLo        ; 
                        
                        lda BB_InfoCharDataPtrHi,y        ; 
                        adc TabHiresCharSetsOffHi,x       ; 
                        sta BBZ_PrintTextCharPtrHi        ; 
                        
                        lda TabTextIsolate,x              ; 
                        sta BBZ_PrintTxtIsolate_01        ; 
                        
.Flip                   eor #$ff                          ; 
                        pha                               ; 
                        
.Shift_02               lsr a                             ; /2
                        lsr a                             ; /4
                        sta BBZ_PrintTxtIsolate_02        ; 
                        
                        lda BBZ_DrawPosY                  ; 
                        sta BBZ_DrawPosYWork              ; 
                        
                        lda BBZ_TabDrawLineColorPtr       ; 
                        lsr a                             ; /2
                        lsr a                             ; /4
                        tay                               ; 
                        
                        pla                               ; 
                        
                        and TabTextColorShape_01,y        ; 
                        sta BBZ_PrintTxtColorIso01        ; 
                        
                        lda BBZ_PrintTxtIsolate_02        ; 
                        eor #$ff                          ; 
                        and TabTextColorShape_01,y        ; 
                        sta BBZ_PrintTxtColorIso02        ; 
                        
                        lda TabTextColorShape_02,y        ; 
                        sta BBZ_PrintTxtColor02           ; 
                        
                        tya                               ; 
                        lsr a                             ; /2
                        lsr a                             ; /4
                        tay                               ; 
                        
                        lda TabTextColorShape_01,y        ; 
                        sta BBZ_PrintTxtColor01           ; 
                        
                        ldy #$00                          ; 
.GetNextChrPart         lda (BBZ_PrintTextCharPtr),y      ; 
                        eor BBZ_PrintTxtColor01           ; 
                        ora BBZ_PrintTxtColor02           ; 
                        and BBZ_PrintTxtColorIso01        ; 
                        sta BBZ_PrintTxtSet_01            ; 
                        
                        iny                               ; 
                        lda (BBZ_PrintTextCharPtr),y      ; 
                        eor BBZ_PrintTxtColor01           ; 
                        ora BBZ_PrintTxtColor02           ; 
                        and BBZ_PrintTxtColorIso02        ; 
                        sta BBZ_PrintTxtSet_02            ; 
                        
                        iny                               ; 
                        sty BBZ_PrintTextCharOffset       ; 
                        
                        ldy BBZ_DrawPosYWork              ; 
                        ldx BBZ_DrawPosX                  ; 
                        lda BB_TabHiResAdrColLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrRowLo,y         ; 
                        sta BBZ_DrawTextPtrLo             ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_DrawTextPtrHi             ; 
                        
                        ldy #$00                          ; 
                        lda (BBZ_DrawTextPtr),y           ; 
                        and BBZ_PrintTxtIsolate_01        ; 
                        ora BBZ_PrintTxtSet_01            ; 
                        sta (BBZ_DrawTextPtr),y           ; 
                        
                        ldy #$08                          ; 
                        lda (BBZ_DrawTextPtr),y           ; 
                        and BBZ_PrintTxtIsolate_02        ; 
                        ora BBZ_PrintTxtSet_02            ; 
                        sta (BBZ_DrawTextPtr),y           ; 
                        
                        inc BBZ_DrawPosYWork              ; 
                        
                        ldy BBZ_PrintTextCharOffset       ; 
                        cpy #$0a                          ; 
                        bcc .GetNextChrPart               ; lower
                        
                        lda BBZ_DrawPosX                  ; 
                        clc                               ; 
                        adc #$06                          ; 
                        sta BBZ_DrawPosX                  ; 
                        
PrintTextCharX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabTextIsolate          dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
; -------------------------------------------------------------------------------------------------------------- ;
TabTextColorShape_01    dc.b $00 ; $00 - ........ - $00
                        dc.b $55 ; $01 - .#.#.#.# - $04
                        dc.b $aa ; $02 - #.#.#.#. - $08
                        dc.b $ff ; $03 - ######## - $0c
                        dc.b $55 ; $04 - .#.#.#.# - $10
                        dc.b $00 ; $05 - ........ - $14
                        dc.b $ff ; $06 - ######## - $18
                        dc.b $ff ; $07 - ######## - $1c
                        dc.b $aa ; $08 - #.#.#.#. - $20
                        dc.b $ff ; $09 - ######## - $24
                        dc.b $00 ; $0a - ........ - $28
                        dc.b $ff ; $0b - ######## - $2c
                        dc.b $ff ; $0c - ######## - $30
                        dc.b $ff ; $0d - ######## - $34
                        dc.b $ff ; $0e - ######## - $38
                        dc.b $ff ; $0f - ######## - $3c
; -------------------------------------------------------------------------------------------------------------- ;
TabTextColorShape_02    dc.b $00 ; $00 - ........ - $00
                        dc.b $00 ; $01 - ........ - $04
                        dc.b $00 ; $02 - ........ - $08
                        dc.b $00 ; $03 - ........ - $0c
                        dc.b $00 ; $04 - ........ - $10
                        dc.b $55 ; $05 - .#.#.#.# - $14
                        dc.b $00 ; $06 - ........ - $18
                        dc.b $55 ; $07 - .#.#.#.# - $1c
                        dc.b $00 ; $08 - ........ - $20
                        dc.b $00 ; $09 - ........ - $24
                        dc.b $aa ; $0a - #.#.#.#. - $28
                        dc.b $aa ; $0b - #.#.#.#. - $2c
                        dc.b $00 ; $0c - ........ - $30
                        dc.b $55 ; $0d - .#.#.#.# - $34
                        dc.b $aa ; $0e - #.#.#.#. - $38
                        dc.b $ff ; $0f - ######## - $3c
; -------------------------------------------------------------------------------------------------------------- ;
Text_GreatScore         dc.b $27 ; g
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $21 ; a
                        dc.b $34 ; t
                        dc.b $40 ; <newline>
                        dc.b $33 ; s
                        dc.b $23 ; c
                        dc.b $2f ; o
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $30 ; p
                        dc.b $2c ; l
                        dc.b $21 ; a
                        dc.b $39 ; y
                        dc.b $25 ; e
                        dc.b $32 ; r
                        dc.b $40 ; <newline>
                        dc.b $2f ; o
                        dc.b $2e ; n
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $40 ; <newline>
                        dc.b $40 ; <newline>
                        dc.b $30 ; p
                        dc.b $2c ; l
                        dc.b $25 ; e
                        dc.b $21 ; a
                        dc.b $33 ; s
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $34 ; t
                        dc.b $25 ; e
                        dc.b $32 ; r
                        dc.b $40 ; <newline>
                        dc.b $39 ; y
                        dc.b $2f ; o
                        dc.b $35 ; u
                        dc.b $32 ; r
                        dc.b $40 ; <newline>
                        dc.b $2e ; n
                        dc.b $21 ; a
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $1a ; :
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_Space              dc.b $33 ; s
                        dc.b $30 ; p
                        dc.b $21 ; a
                        dc.b $23 ; c
                        dc.b $25 ; e
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_Delete             dc.b $24 ; d
                        dc.b $25 ; e
                        dc.b $2c ; l
                        dc.b $25 ; e
                        dc.b $34 ; t
                        dc.b $25 ; e
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_End                dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $24 ; d
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_Two                dc.b $34 ; t
                        dc.b $37 ; w
                        dc.b $2f ; o
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_NL_1               dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_NL_2               dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_TopAchievers       dc.b $34 ; t
                        dc.b $2f ; o
                        dc.b $30 ; p
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $23 ; c
                        dc.b $28 ; h
                        dc.b $29 ; i
                        dc.b $25 ; e
                        dc.b $36 ; v
                        dc.b $25 ; e
                        dc.b $32 ; r
                        dc.b $33 ; s
                        dc.b $1a ; :
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_BBSB               dc.b $22 ; b
                        dc.b $2f ; o
                        dc.b $35 ; u
                        dc.b $2e ; n
                        dc.b $34 ; t
                        dc.b $39 ; y
                        dc.b $00 ; <space> 
                        dc.b $22 ; b
                        dc.b $2f ; o
                        dc.b $22 ; b
                        dc.b $00 ; <space> 
                        dc.b $33 ; s
                        dc.b $34 ; t
                        dc.b $32 ; r
                        dc.b $29 ; i
                        dc.b $2b ; k
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $00 ; <space> 
                        dc.b $22 ; b
                        dc.b $21 ; a
                        dc.b $23 ; c
                        dc.b $2b ; k
                        dc.b $01 ; !
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_GameAdjustment     dc.b $7f ;  
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $27 ; g
                        dc.b $21 ; a
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $24 ; d
                        dc.b $2a ; j
                        dc.b $35 ; u
                        dc.b $33 ; s
                        dc.b $34 ; t
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $34 ; t
                        dc.b $40 ; <newline>
                        dc.b $40 ; <newline>
                        dc.b $03 ; #
                        dc.b $00 ; <space> 
                        dc.b $2c ; l
                        dc.b $29 ; i
                        dc.b $36 ; v
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $40 ; <newline>
                        dc.b $03 ; #
                        dc.b $00 ; <space> 
                        dc.b $30 ; p
                        dc.b $2c ; l
                        dc.b $21 ; a
                        dc.b $39 ; y
                        dc.b $25 ; e
                        dc.b $32 ; r
                        dc.b $33 ; s
                        dc.b $40 ; <newline>
                        dc.b $03 ; #
                        dc.b $00 ; <space> 
                        dc.b $2a ; j
                        dc.b $2f ; o
                        dc.b $39 ; y
                        dc.b $33 ; s
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $23 ; c
                        dc.b $2b ; k
                        dc.b $33 ; s
                        dc.b $40 ; <newline>
                        dc.b $33 ; s
                        dc.b $25 ; e
                        dc.b $23 ; c
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $34 ; t
                        dc.b $00 ; <space> 
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $33 ; s
                        dc.b $21 ; a
                        dc.b $27 ; g
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $40 ; <newline>
                        dc.b $22 ; b
                        dc.b $2f ; o
                        dc.b $2e ; n
                        dc.b $35 ; u
                        dc.b $33 ; s
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $34 ; t
                        dc.b $40 ; <newline>
                        dc.b $24 ; d
                        dc.b $29 ; i
                        dc.b $26 ; f
                        dc.b $26 ; f
                        dc.b $29 ; i
                        dc.b $23 ; c
                        dc.b $35 ; u
                        dc.b $2c ; l
                        dc.b $34 ; t
                        dc.b $39 ; y
                        dc.b $40 ; <newline>
                        dc.b $30 ; p
                        dc.b $21 ; a
                        dc.b $35 ; u
                        dc.b $33 ; s
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $2b ; k
                        dc.b $25 ; e
                        dc.b $39 ; y
                        dc.b $40 ; <newline>
                        dc.b $2d ; m
                        dc.b $35 ; u
                        dc.b $33 ; s
                        dc.b $29 ; i
                        dc.b $23 ; c
                        dc.b $00 ; <space> 
                        dc.b $36 ; v
                        dc.b $2f ; o
                        dc.b $2c ; l
                        dc.b $35 ; u
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $28 ; h
                        dc.b $29 ; i
                        dc.b $27 ; g
                        dc.b $28 ; h
                        dc.b $00 ; <space> 
                        dc.b $33 ; s
                        dc.b $23 ; c
                        dc.b $2f ; o
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $2d ; m
                        dc.b $21 ; a
                        dc.b $29 ; i
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $34 ; t
                        dc.b $2c ; l
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $39 ; y
                        dc.b $35 ; u
                        dc.b $2b ; k
                        dc.b $2f ; o
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $39 ; y
                        dc.b $2f ; o
                        dc.b $28 ; h
                        dc.b $21 ; a
                        dc.b $2e ; n
                        dc.b $40 ; <newline>
                        dc.b $28 ; h
                        dc.b $33 ; s
                        dc.b $00 ; <space> 
                        dc.b $2e ; n
                        dc.b $21 ; a
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $2c ; l
                        dc.b $25 ; e
                        dc.b $34 ; t
                        dc.b $34 ; t
                        dc.b $25 ; e
                        dc.b $32 ; r
                        dc.b $33 ; s
                        dc.b $40 ; <newline>
                        dc.b $33 ; s
                        dc.b $30 ; p
                        dc.b $25 ; e
                        dc.b $23 ; c
                        dc.b $29 ; i
                        dc.b $21 ; a
                        dc.b $2c ; l
                        dc.b $00 ; <space> 
                        dc.b $23 ; c
                        dc.b $2f ; o
                        dc.b $24 ; d
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $40 ; <newline>
                        dc.b $40 ; <newline>
                        dc.b $35 ; u
                        dc.b $33 ; s
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $2a ; j
                        dc.b $2f ; o
                        dc.b $39 ; y
                        dc.b $33 ; s
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $23 ; c
                        dc.b $2b ; k
                        dc.b $00 ; <space> 
                        dc.b $11 ;  
                        dc.b $00 ; <space> 
                        dc.b $26 ; f
                        dc.b $2f ; o
                        dc.b $32 ; r
                        dc.b $00 ; <space> 
                        dc.b $23 ; c
                        dc.b $28 ; h
                        dc.b $21 ; a
                        dc.b $2e ; n
                        dc.b $27 ; g
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $40 ; <newline>
; -------------------------------------------------------------------------------------------------------------- ;
Text_PressF7            dc.b $00 ; 
                        dc.b $30 ; p
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $33 ; s
                        dc.b $00 ; <space> 
                        dc.b $02 ; "
                        dc.b $26 ; f
                        dc.b $17 ; 7
                        dc.b $02 ; "
                        dc.b $00 ; <space> 
                        dc.b $37 ; w
                        dc.b $28 ; h
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $26 ; f
                        dc.b $29 ; i
                        dc.b $2e ; n
                        dc.b $29 ; i
                        dc.b $33 ; s
                        dc.b $28 ; h
                        dc.b $25 ; e
                        dc.b $24 ; d
                        dc.b $40 ; <newline>
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_NL_03              dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_NL_04              dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_TNT                dc.b $34 ; t
                        dc.b $2e ; n
                        dc.b $34 ; t
                        dc.b $7f ;  
                        dc.b $1d ; =
                        dc.b $7f ;  
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $10 ; 0
                        dc.b $80 ; End Of Text Data
; -------------------------------------------------------------------------------------------------------------- ;
Text_Copyright          dc.b $23 ; c
                        dc.b $2f ; o
                        dc.b $30 ; p
                        dc.b $39 ; y
                        dc.b $32 ; r
                        dc.b $29 ; i
                        dc.b $27 ; g
                        dc.b $28 ; h
                        dc.b $34 ; t
                        dc.b $00 ; <space> 
                        dc.b $08 ; (
                        dc.b $23 ; c
                        dc.b $09 ; )
                        dc.b $00 ; <space> 
                        dc.b $11 ; 1
                        dc.b $19 ; 9
                        dc.b $18 ; 8
                        dc.b $15 ; 5
                        dc.b $00 ; <space> 
                        dc.b $22 ; b
                        dc.b $39 ; y
                        dc.b $40 ; <newline>
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $22 ; b
                        dc.b $29 ; i
                        dc.b $27 ; g
                        dc.b $00 ; <space> 
                        dc.b $26 ; f
                        dc.b $29 ; i
                        dc.b $36 ; v
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $33 ; s
                        dc.b $2f ; o
                        dc.b $26 ; f
                        dc.b $34 ; t
                        dc.b $37 ; w
                        dc.b $21 ; a
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $40 ; <newline>
                        dc.b $36 ; v
                        dc.b $21 ; a
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $2e ; n
                        dc.b $35 ; u
                        dc.b $39 ; y
                        dc.b $33 ; s
                        dc.b $0c ; <komma>
                        dc.b $00 ; <space> 
                        dc.b $23 ; c
                        dc.b $21 ; a
                        dc.b $0e ; ....###.
                        dc.b $00 ; <space> 
                        dc.b $00 ; <space> 
                        dc.b $35 ; u
                        dc.b $0e ; .
                        dc.b $33 ; s
                        dc.b $0e ; 
                        dc.b $21 ; a
                        dc.b $0e ; .
                        dc.b $40 ; <newline>
                        dc.b $2c ; l
                        dc.b $29 ; i
                        dc.b $23 ; c
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $33 ; s
                        dc.b $25 ; e
                        dc.b $24 ; d
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $2f ; o
                        dc.b $00 ; <space> 
                        dc.b $35 ; u
                        dc.b $0e ; .
                        dc.b $33 ; s
                        dc.b $0e ; .
                        dc.b $00 ; <space> 
                        dc.b $27 ; g
                        dc.b $2f ; o
                        dc.b $2c ; l
                        dc.b $24 ; d
                        dc.b $80 ; <newline>
; -------------------------------------------------------------------------------------------------------------- ;
TabPhoneNum             dc.b $18 ; "8"
                        dc.b $11 ; "1"
                        dc.b $18 ; "8"
                        dc.b $17 ; "7"
                        dc.b $18 ; "8"
                        dc.b $12 ; "2"
                        dc.b $16 ; "6"
                        dc.b $18 ; "8"
                        dc.b $16 ; "6"
                        dc.b $11 ; "1"
; -------------------------------------------------------------------------------------------------------------- ;
TabGameTextsPosX        dc.b $02 ; Text_GreatScore     ; $01
                        dc.b $02 ; Text_Space          ; $02
                        dc.b $02 ; Text_Delete         ; $03
                        dc.b $02 ; Text_End            ; $04
                        dc.b $02 ; Text_Two            ; $05
                        dc.b $3b ; Text_NL_1           ; $06
                        dc.b $73 ; Text_NL_2           ; $07
                        dc.b $28 ; Text_TopAchievers   ; $08
                        dc.b $0b ; Text_BBSB           ; $09
                        dc.b $02 ; Text_GameAdjustment ; $0a
                        dc.b $06 ; Text_PressF7        ; $0b
                        dc.b $3a ; Text_NL_03          ; $0c
                        dc.b $35 ; Text_NL_04          ; $0d
                        dc.b $3a ; Text_NL_03          ; $0e
                        dc.b $06 ; Text_TNT            ; $0f
                        dc.b $03 ; Text_PressF7        ; $10
                        dc.b $14 ; Text_Copyright      ; $11
; -------------------------------------------------------------------------------------------------------------- ;
TabGameTextsPosY        dc.b $15 ; Text_GreatScore     ; $01
                        dc.b $75 ; Text_Space          ; $02
                        dc.b $7d ; Text_Delete         ; $03
                        dc.b $85 ; Text_End            ; $04
                        dc.b $2d ; Text_Two            ; $05
                        dc.b $5d ; Text_NL_1           ; $06
                        dc.b $a2 ; Text_NL_2           ; $07
                        dc.b $09 ; Text_TopAchievers   ; $08
                        dc.b $09 ; Text_BBSB           ; $09
                        dc.b $06 ; Text_GameAdjustment ; $0a
                        dc.b $32 ; Text_PressF7        ; $0b
                        dc.b $50 ; Text_NL_03          ; $0c
                        dc.b $4c ; Text_NL_04          ; $0d
                        dc.b $54 ; Text_NL_03          ; $0e
                        dc.b $68 ; Text_TNT            ; $0f
                        dc.b $c0 ; Text_PressF7        ; $10
                        dc.b $8e ; Text_Copyright      ; $11
; -------------------------------------------------------------------------------------------------------------- ;
TabGameTextsLo          dc.b <Text_GreatScore          ; $01
                        dc.b <Text_Space               ; $02
                        dc.b <Text_Delete              ; $03
                        dc.b <Text_End                 ; $04
                        dc.b <Text_Two                 ; $05
                        dc.b <Text_NL_1                ; $06
                        dc.b <Text_NL_2                ; $07
                        dc.b <Text_TopAchievers        ; $08
                        dc.b <Text_BBSB                ; $09
                        dc.b <Text_GameAdjustment      ; $0a
                        dc.b <Text_PressF7             ; $0b
                        dc.b <Text_NL_03               ; $0c
                        dc.b <Text_NL_04               ; $0d
                        dc.b <Text_NL_03               ; $0e
                        dc.b <Text_TNT                 ; $0f
                        dc.b <Text_PressF7             ; $10
                        dc.b <Text_Copyright           ; $11
; -------------------------------------------------------------------------------------------------------------- ;
TabGameTextsHi          dc.b >Text_GreatScore          ; $01
                        dc.b >Text_Space               ; $02
                        dc.b >Text_Delete              ; $03
                        dc.b >Text_End                 ; $04
                        dc.b >Text_Two                 ; $05
                        dc.b >Text_NL_1                ; $06
                        dc.b >Text_NL_2                ; $07
                        dc.b >Text_TopAchievers        ; $08
                        dc.b >Text_BBSB                ; $09
                        dc.b >Text_GameAdjustment      ; $0a
                        dc.b >Text_PressF7             ; $0b
                        dc.b >Text_NL_03               ; $0c
                        dc.b >Text_NL_04               ; $0d
                        dc.b >Text_NL_03               ; $0e
                        dc.b >Text_TNT                 ; $0f
                        dc.b >Text_PressF7             ; $10
                        dc.b >Text_Copyright           ; $11
; -------------------------------------------------------------------------------------------------------------- ;
TabGameTextsColorShape  dc.b [$0e * $04] ; Text_GreatScore     ; $01 = $38 -> TabTextColorShape_01/TabTextColorShape_02
                        dc.b [$0e * $04] ; Text_Space          ; $02 = $38
                        dc.b [$0e * $04] ; Text_Delete         ; $03 = $38
                        dc.b [$0e * $04] ; Text_End            ; $04 = $38
                        dc.b [$0e * $04] ; Text_Two            ; $05 = $38
                        dc.b [$03 * $04] ; Text_NL_1           ; $06 = $0c
                        dc.b [$03 * $04] ; Text_NL_2           ; $07 = $0c
                        dc.b [$08 * $04] ; Text_TopAchievers   ; $08 = $20
                        dc.b [$08 * $04] ; Text_BBSB           ; $09 = $20
                        dc.b [$0c * $04] ; Text_GameAdjustment ; $0a = $30
                        dc.b [$01 * $04] ; Text_PressF7        ; $0b = $04
                        dc.b [$03 * $04] ; Text_NL_03          ; $0c = $0c
                        dc.b [$03 * $04] ; Text_NL_04          ; $0d = $0c
                        dc.b [$03 * $04] ; Text_NL_03          ; $0e = $0c
                        dc.b [$03 * $04] ; Text_TNT            ; $0f = $0c
                        dc.b [$03 * $04] ; Text_PressF7        ; $10 = $0c
                        dc.b [$06 * $04] ; Text_Copyright      ; $11 = $18
; -------------------------------------------------------------------------------------------------------------- ;
; TextOutScoreActionBox Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TextOutScoreActionBox   subroutine                        ; 
                        ldx #[$0e * $04]                  ; ptr -> TabTextColorShape_01/TabTextColorShape_02
; -------------------------------------------------------------------------------------------------------------- ;
; TextOutWaitRaster     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TextOutWaitRaster       subroutine                        ; 
.GetNextRaster          lda RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        cmp #$bd                          ; 
                        bne .GetNextRaster                ; 
                        
                        txa                               ; 
                        
                        ldy BBZ_ScoreTextBoxRowNum        ; 
                        iny                               ; 
                        iny                               ; 
                        bpl TextOutSetPositionPtr         ; always
; -------------------------------------------------------------------------------------------------------------- ;
; TextOut               Does    : 
;                       Expects : xr=color table offset  yr=text number
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TextOut                 subroutine                        ; 
                        lda [TabGameTextsColorShape - $01],y ; 
                        
TextOutSetPositionPtr   sta BBZ_TabDrawLineColorPtr       ; 

                        lda [TabGameTextsPosX - $01],y    ; 
                        sta BBZ_DrawPosX                  ; 
                        sta BBZ_HiResPosX                 ; 
                        
                        lda [TabGameTextsPosY - $01],y    ; 
                        sta BBZ_DrawPosY                  ; 
                        sta BBZ_HiResPosY                 ; 
                        
                        lda [TabGameTextsLo - $01],y      ; 
                        ldx [TabGameTextsHi - $01],y      ; 
                        sta BBZ_GameTextsPtrLo            ; 
                        stx BBZ_GameTextsPtrHi            ; 
                        
.GetNextTextChar        ldy #$00                          ; 
                        lda (BBZ_GameTextsPtr),y          ; 
                        bmi PrintGameTextsX               ; 
                        
                        cmp #$7f                          ; 
                        bne .ChkMaxChrNum                 ; 
                        
                        inc BBZ_DrawPosX                  ; 
                        inc BBZ_DrawPosX                  ; 
                        inc BBZ_DrawPosX                  ; 
                        jmp .SetNextTextChr               ; 
                        
.ChkMaxChrNum           cmp #BB_Scrn_HiResCharCount       ; 
                        bcc .GoPrintTextChar              ; lower
                        
                        lda BBZ_HiResPosX                 ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        lda BBZ_HiResPosY                 ; 
                        clc                               ; 
                        adc GameTextRowHeight             ; 
                        sta BBZ_HiResPosY                 ; 
                        sta BBZ_DrawPosY                  ; 
                        jmp .SetNextTextChr               ; 
                        
.GoPrintTextChar        jsr PrintTextChar                 ; 
                        
.SetNextTextChr         inc BBZ_GameTextsPtrLo            ; 
                        bne .GetNextTextChar              ; 
                        
                        inc BBZ_GameTextsPtrHi            ; 
                        bne .GetNextTextChar              ; 
                        
PrintGameTextsX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameExit            pla                               ; 
                        tay                               ; 
                        pla                               ; 
                        tax                               ; 
                        pla                               ; 
                        
IRQ_GameExitX           rti                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_SetNewRasterIRQ   Does    : Set IRQ Vector and IRQ Raster Line
;                       Expects : xr=ptr_hi yr=ptr_lo ac=raster
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_SetNewRasterIRQ     subroutine                        ; 
                        stx HBRK_HI                       ; Kernel Maskable Interrupt Request and Break Vectors ($FF48)
                        sty VBRK_LO                       ; .hbu001. change to HBRK_LO to make it run (copy prot)
                        
                        ldy #$01                          ; .......# - permit raster interrupts only
.AllowRasterIRQs        sty IRQMASK                       ; VIC($D01A) IRQ Mask Register
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_IniNewRaster      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_IniNewRaster        subroutine                        ; 
.NewRaster              sta RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        
.ClrRasterBit8          lda SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        and #VIC_RasterHi_Off             ; .#######
                        sta SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
.ClrVicIrq              lda VICIRQ                        ; VIC($D019) Interrupt Flags - Latched flags cleared if set to 1
                        sta VICIRQ                        ; VIC($D019) Interrupt Flags - Latched flags cleared if set to 1
                        
.ReallowIRQs            cli                               ; 
                        
IRQ_IniNewRasterX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TimerWaitFull         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TimerWaitFull           subroutine                        ; 
                        ldy BBZ_IRQ_GameTimer             ; 
                        iny                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TimerWait             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TimerWait               subroutine                        ; 
.ChkTimer               cpy BBZ_IRQ_GameTimer             ; 
                        bne .ChkTimer                     ; 
                        
TimerWaitX              rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; JoyStickCheckFireSc   Does    : Check whilest entering scorer name
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
JoyStickCheckFireSc     subroutine                        ; 
                        ldx #$68                          ; 
                        
                        lda BBZ_JoystickMenu              ; 
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        lsr a                             ; right
; -------------------------------------------------------------------------------------------------------------- ;
; JoyStickCheckFire     Does    : 
;                       Expects : xr=offset BBZ_CheckFireWaitP1/BBZ_CheckFireWaitP2
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
JoyStickCheckFire       subroutine                        ; 
                        lsr a                             ; shift out fire bit
                        
                        ldy #$05                          ; init counter
                        
                        lda D6510,x                       ; get player counter
                        bcc .IniPlayerCounter             ; fire was pressed
                        beq JoyStickCheckFireX            ; player counter was zero
                        
                        dec D6510,x                       ; dec player counter
                        
.Exit                   rts                               ; 
                        
.IniPlayerCounter       sty D6510,x                       ; set player counter
                        beq JoyStickCheckFireX            ; 
                        
                        sec                               ; 
                        
JoyStickCheckFireX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SprtGetDataByteIncPtr Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SprtGetDataByteIncPtr   subroutine                        ; 
                        lda #$12                          ; 
                        sta BB_WA_SpritePtrA,x            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetDataByteIncPtr     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetDataByteIncPtr       subroutine                        ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        
.IncPtr                 inc BBZ_GetDataBytePtrLo          ; 
                        bne .Set_RC                       ; 
                        inc BBZ_GetDataBytePtrHi          ; 
                        
.Set_RC                 ora #$00                          ; 
                        
GetDataByteIncPtrX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IniDataBytePtr_Yr     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IniDataBytePtr_Yr       subroutine                        ; with $00/$01 + yr
                        lda BBZ_0000,y                    ; 
                        ldx R6510,y                       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IniDataBytePtr        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IniDataBytePtr          subroutine                        ; 
                        sta BBZ_GetDataBytePtrLo          ; 
                        stx BBZ_GetDataBytePtrHi          ; 
                        
                        ldy #$00                          ; 
                        
IniDataBytePtrX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveCheckTimer     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveCheckTimer       subroutine                        ; 
                        lda BBZ_BobMoveFoodBarTime        ; 
                        bne .ExitCarryClr                 ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
.ExitCarrySet           rts                               ; 
                        
.ExitCarryClr           clc                               ; 
BobMoveCheckTimerX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabLevelNumEquiv        dc.b $00 ; level number equivalents
                        
TabLevelNumEquivStart   dc.b BBZ_LevelNumEquiv_01 ; $01 - AA - Bob's Morning Calisthenics
                        dc.b BBZ_LevelNumEquiv_02 ; $02 - BB - Utility Hoist
                        dc.b BBZ_LevelNumEquiv_03 ; $03 - CC - The Suction Tubes
                        dc.b BBZ_LevelNumEquiv_04 ; $04 - DD - Bob's Playroom
                        dc.b BBZ_LevelNumEquiv_05 ; $05 - EE - Jumping 101
                        dc.b BBZ_LevelNumEquiv_06 ; $06 - FF - The Grain Elevator
                        dc.b BBZ_LevelNumEquiv_07 ; $07 - GG - Yukon's Penthouse
                        dc.b BBZ_LevelNumEquiv_08 ; $08 - HH - Luxury Transporters
                        dc.b BBZ_LevelNumEquiv_09 ; $09 - II - Bonus Level # 1
                        dc.b BBZ_LevelNumEquiv_10 ; $0a - JJ - The Gravity Lift
                        dc.b BBZ_LevelNumEquiv_11 ; $0b - KK - The Super Slippery Slide
                        dc.b BBZ_LevelNumEquiv_12 ; $0c - LL - Acid Rain
                        dc.b BBZ_LevelNumEquiv_13 ; $0d - MM - Rest Stop # 1
                        dc.b BBZ_LevelNumEquiv_14 ; $0e - NN - Hydraulic Lifts
                        dc.b BBZ_LevelNumEquiv_15 ; $0f - OO - Yukon's Revenge
                        dc.b BBZ_LevelNumEquiv_16 ; $10 - PP - The Advanced Suction Tubes
                        dc.b BBZ_LevelNumEquiv_17 ; $11 - QQ - Bonus Level # 2
                        dc.b BBZ_LevelNumEquiv_18 ; $12 - RR - Super Energy Food Bars
                        dc.b BBZ_LevelNumEquiv_19 ; $13 - SS - The Sliding Candelabra
                        dc.b BBZ_LevelNumEquiv_20 ; $14 - TT - Mobile Suction Unit
                        dc.b BBZ_LevelNumEquiv_21 ; $15 - UU - Rest Stop # 2
                        dc.b BBZ_LevelNumEquiv_22 ; $16 - VV - Advanced Cannon
                        dc.b BBZ_LevelNumEquiv_23 ; $17 - WW - Advanced Pulverizors
                        dc.b BBZ_LevelNumEquiv_24 ; $18 - XX - Mutants On The Move
TabLevelNumEquivEnd     dc.b BBZ_LevelNumEquiv_25 ; $19 - YY - The Floating Transporter
                        
                        dc.b BBZ_LevelNumEquivMax ; $1a - ZZ - 26 Congratulations ... 
; -------------------------------------------------------------------------------------------------------------- ;
; FloorTileDataNext     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloorTileDataNext       subroutine                        ; 
                        asl BBZ_FloorTileData             ; 
                        
                        dec BBZ_FloorTileHight            ; 
                        bpl FloorTileDataInitX            ; exit
                        
                        ldx BBZ_FloorTileDataPtr          ; 
FloorTileDataNextX      inx                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FloorTileDataInit     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloorTileDataInit       subroutine                        ; 
                        stx BBZ_FloorTileDataPtr          ; 
                        
                        lda BB_FloorStatusPlay,x          ; 
                        sta BBZ_FloorTileData             ; 
                        
                        lda #$07                          ; 
                        sta BBZ_FloorTileHight            ; 
                        
FloorTileDataInitX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetLadderSlideWA      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetLadderSlideWA        subroutine                        ; 
                        ldy #BBZ_LvlLadderDataPtr         ; 
                        jsr IniDataBytePtr_Yr             ; with $00/$01 + yr 
                        
                        ldx #$00                          ; 
.GetNextLadder          jsr GetDataByteIncPtr             ; 
                        beq .SavLadderCounter             ; end of ladder data
                        
                        sta BB_WA_LadderLen,x             ; 
                        
                        lda #$03                          ; 
                        sec                               ; 
                        sbc (BBZ_GetDataBytePtr),y        ; 
                        sta BB_WA_LadderAddX,x            ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_LadderPosX,x            ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_LadderTopY,x            ; 
                        
                        clc                               ; 
                        adc BB_WA_LadderLen,x             ; 
                        sta BB_WA_LadderBotY,x            ; 
                        
                        inx                               ; 
                        bne .GetNextLadder                ; 
                        
.SavLadderCounter       stx BBZ_CountLadders              ; 
                        
                        ldy #BBZ_LvlSlideDataPtr          ; 
                        jsr IniDataBytePtr_Yr             ; with $00/$01 + yr 
                        
                        ldx #$00                          ; 
.GetNextSlide           jsr GetDataByteIncPtr             ; 
                        beq .SavSlideCounter              ; end of slide data
                        
                        sta BB_WA_SlideLen,x              ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        sta BB_WA_SlideMove,x             ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_SlidePosX,x             ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_SlidePosY,x             ; 
                        
                        inx                               ; 
                        bne .GetNextSlide                 ; 
                        
.SavSlideCounter        stx BBZ_CountSlides               ; 
                        
SetLadderSlideWAX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetLevelFloorWA       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetLevelFloorWA         subroutine                        ; 
                        asl a                             ; 
                        tay                               ; 
                        lda [TabLevelGroundCtrl + $00],y  ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        lda [TabLevelGroundCtrl + $01],y  ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
                        ldy #$00                          ; $00
.GetNextFloor           lda (BBZ_DrawHiResPtr),y          ; 
.Exit                   beq SetLadderSlideWAX             ; end of data
                        
                        iny                               ; $01
                        
                        clc                               ; 
                        adc (BBZ_DrawHiResPtr),y          ; 
                        sta BB_WA_FloorMaxX,x             ; 
                        
                        lda (BBZ_DrawHiResPtr),y          ; 
                        sta BB_WA_FloorMinX,x             ; 
                        
                        iny                               ; $02
                        
                        lda (BBZ_DrawHiResPtr),y          ; 
                        sta BB_WA_FloorPosY,x             ; 
                        
                        lda #$81                          ; thin ground
                        sta BB_WA_FloorTileNum,x          ; 
                        
.SetNextWA              inx                               ; 
                        
.SetNextFloor           iny                               ; $03
SetLevelFloorWAX        bne .GetNextFloor                 ; always (hopefully)
; -------------------------------------------------------------------------------------------------------------- ;
TabLevelGroundCtrl      dc.w TabGroundLineAll ; $00 ----------------- all levels
                        
                        dc.w TabXtraLineNone  ; $01 - level 21 - none Rest Stop # 2
                        dc.w TabXtraLineNone  ; $02 - level 25 - none The Floating Transporter
                        dc.w TabXtraLevel_06  ; $03 - level 06 ------ The Grain Elevator
                        dc.w TabXtraLineNone  ; $04 - level 10 - none The Gravity Lift
                        dc.w TabXtraLineNone  ; $05 - level 03 - none The Suction Tubes
                        dc.w TabXtraLineNone  ; $06 - level 17 - none Bonus Level # 2
                        dc.w TabXtraLineNone  ; $07 - level 18 - none Super Energy Food Bars
                        dc.w TabXtraLevel_14  ; $08 - level 14 ------ Hydraulic Lifts
                        dc.w TabXtraLineNone  ; $09 - level 20 - none Mobile Suction Unit
                        dc.w TabXtraLevel_19  ; $0a - level 19 ------ The Sliding Candelabra
                        dc.w TabXtraLineNone  ; $0b - level 05 - none Jumping 101
                        dc.w TabXtraLevel_02  ; $0c - level 02 ------ Utility Hoist
                        dc.w TabXtraLineNone  ; $0d - level 09 - none Bonus Level # 1
                        dc.w TabXtraLineNone  ; $0e - level 15 - none Yukon's Revenge
                        dc.w TabXtraLineNone  ; $0f - level 08 - none Luxury Transporters
                        dc.w TabXtraLevel_22  ; $10 - level 22 ------ Advanced Cannon
                        dc.w TabXtraLineNone  ; $11 - level 13 - none Rest Stop # 1
                        dc.w TabXtraLineNone  ; $12 - level 01 - none Bob's Morning Calisthenics
                        dc.w TabXtraLineNone  ; $13 - level 11 - none The Super Slippery Slide
                        dc.w TabXtraLineNone  ; $14 - level 12 - none Acid Rain
                        dc.w TabXtraLineNone  ; $15 - level 23 - none Advanced Pulverizors
                        dc.w TabXtraLineNone  ; $16 - level 04 - none Bob's Playroom
                        dc.w TabXtraLineNone  ; $17 - level 07 - none Yukon's Penthouse
                        dc.w TabXtraLineNone  ; $18 - level 16 - none The Advanced Suction Tubes
                        dc.w TabXtraLineNone  ; $19 - level 24 - none Mutants On The Move
                        dc.w TabXtraLineNone  ; $1a - level 26 - none Congratulations ...
; -------------------------------------------------------------------------------------------------------------- ;
TabGroundLineAll        dc.b $a0 ; len
                        dc.b $00 ; PosX
                        dc.b $bf ; PosY
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabXtraLevel_06         dc.b $0c ; 
                        dc.b $0e ; 
                        dc.b $11 ; 
                        
                        dc.b $0c ; 
                        dc.b $0e ; 
                        dc.b $bd ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $1e ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $37 ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $50 ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $69 ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $82 ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $9b ; 
                        
                        dc.b $08 ; 
                        dc.b $10 ; 
                        dc.b $b4 ; 
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabXtraLevel_14         dc.b $0c ; 
                        dc.b $04 ; 
                        dc.b $b2 ; 
                        
                        dc.b $0c ; 
                        dc.b $90 ; 
                        dc.b $b2 ; 
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabXtraLevel_19         dc.b $0c ; 
                        dc.b $92 ; 
                        dc.b $11 ; 
                        
                        dc.b $0c ; 
                        dc.b $92 ; 
                        dc.b $bd ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $1e ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $37 ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $50 ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $69 ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $82 ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $9b ; 
                        
                        dc.b $08 ; 
                        dc.b $94 ; 
                        dc.b $b4 ; 
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabXtraLevel_02         dc.b $0b ; 
                        dc.b $40 ; 
                        dc.b $21 ; 
                        
                        dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
TabXtraLevel_22         dc.b $3c ; 
                        dc.b $00 ; 
                        dc.b $64 ; 
                        
                        dc.b $3a ; 
                        dc.b $3e ; 
                        dc.b $bb ; 
                        
TabXtraLineNone         dc.b $00 ; end of data
; -------------------------------------------------------------------------------------------------------------- ;
; DrawLadderSlide       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawLadderSlide         subroutine                        ; 
                        ldy #$00                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        ora TabLadderSlide_01,x           ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        ldy #$08                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        ora TabLadderSlide_02,x           ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        ldy #$10                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        ora TabLadderSlide_03,x           ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
DrawLadderSlideX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IncDrawHiResPtr       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IncDrawHiResPtr         subroutine                        ; 
                        inc BBZ_DrawHiResPtrLo            ; 
                        
                        lda BBZ_DrawHiResPtrLo            ; 
                        and #$07                          ; 
                        beq .SetNextGfxRow                ; 
                        
                        rts                               ; 
                        
.SetNextGfxRow          dec BBZ_DrawHiResPtrLo            ; 
                        
                        lda BBZ_DrawHiResPtrLo            ; 
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        
                        lda BBZ_DrawHiResPtrHi            ; 
                        adc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
IncDrawHiResPtrX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabFloorTileLe          dc.b $ff ; ########
                        dc.b $3f ; ..######
                        dc.b $0f ; ....####
                        dc.b $03 ; ......##
; -------------------------------------------------------------------------------------------------------------- ;
TabFloorTileRi          dc.b $00 ; ........
                        dc.b $c0 ; ##......
                        dc.b $f0 ; ####....
                        dc.b $fc ; ######..
; -------------------------------------------------------------------------------------------------------------- ;
TabFloorTopTileRi       dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $14 ; ...#.#..
                        
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
                        
                        dc.b $00 ; ........
                        dc.b $40 ; .#......
                        dc.b $50 ; .#.#....
                        dc.b $54 ; .#.#.#..
; -------------------------------------------------------------------------------------------------------------- ;
TabFloorEndTile         dc.b $50 ; .#.#....
                        dc.b $44 ; .#...#..
                        dc.b $10 ; ...#....
                        dc.b $44 ; .#...#..
                        dc.b $10 ; ...#....
                        dc.b $44 ; .#...#..
                        dc.b $10 ; ...#....
                        dc.b $40 ; .#......
; -------------------------------------------------------------------------------------------------------------- ;
TabFloorTopTileLe       dc.b $05 ; .....#.#
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        dc.b $00 ; ........
                        
                        dc.b $55 ; .#.#.#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $05 ; .....#.#
                        dc.b $01 ; .......#
                        
                        dc.b $15 ; ...#.#.#
                        dc.b $05 ; .....#.#
                        dc.b $01 ; .......#
                        dc.b $00 ; ........
                        
                        dc.b $55 ; .#...#..
                        dc.b $15 ; ...#.#.#
                        dc.b $05 ; .....#.#
                        dc.b $01 ; .......#
                        
                        dc.b $55 ; .#.#.#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $05 ; .....#.#
                        dc.b $01 ; .......#
                        
                        dc.b $55 ; .#.#.#.#
                        dc.b $15 ; ...#.#.#
                        dc.b $05 ; .....#.#
                        dc.b $01 ; .......#
; -------------------------------------------------------------------------------------------------------------- ;
TabLadderSlide_01       dc.b $a0 ; #.#.....
                        dc.b $aa ; #.#.#.#.
                        dc.b $28 ; ..#.#...
                        dc.b $2a ; ..#.#.#.
                        
                        dc.b $0a ; ....#.#.
                        dc.b $0a ; ....#.#.
                        dc.b $02 ; ......#.
                        dc.b $02 ; ......#.
; -------------------------------------------------------------------------------------------------------------- ;
TabLadderSlide_02       dc.b $0a ; ....#.#.
                        dc.b $aa ; #.#.#.#.
                        dc.b $02 ; ......#.
                        dc.b $aa ; #.#.#.#.
                        
                        dc.b $00 ; ........
                        dc.b $aa ; #.#.#.#.
                        dc.b $80 ; #.......
                        dc.b $aa ; #.#.#.#.
; -------------------------------------------------------------------------------------------------------------- ;
TabLadderSlide_03       dc.b $00 ; ........
                        dc.b $00 ; ........
                        dc.b $80 ; #.......
                        dc.b $80 ; #.......
                        
                        dc.b $a0 ; #.#.....
                        dc.b $a0 ; #.#.....
                        dc.b $28 ; ..#.#...
                        dc.b $a8 ; #.#.....
; -------------------------------------------------------------------------------------------------------------- ;
; DrawFloorTilePart     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawFloorTilePart       subroutine                        ; 
                        bcs .SetNextRow                   ; 
                        
                        jsr DrawFloorTileRow              ; 
                        
.SetNextRow             jsr IncDrawHiResPtr               ; 
                        jsr DrawFloorTileRow              ; 
                        jsr IncDrawHiResPtr               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawFloorTileRow      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawFloorTileRow        subroutine                        ; 
                        ldy #$00                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        ora TabFloorTileLe,x              ; 
                        and __FloorDrawColor              ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        ldy #$08                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        ora TabFloorTileRi,x              ; 
__FloorDrawColor        equ [* + $01]                     ; 
                        and #$00                          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
DrawFloorTileRowX       jmp IncDrawHiResPtr               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawFloorTop          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawFloorTop            subroutine                        ; 
.NextTopRow             ldy #$00                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        and #$aa                          ; #.#.#.#.
                        sta BBZ_LevelStructCount          ; 
                        
                        lsr a                             ; 
                        ora BBZ_LevelStructCount          ; 
                        eor #$ff                          ; ########
                        and TabFloorTopTileLe,x           ; 
                        ora (BBZ_DrawHiResPtr),y          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        ldy #$08                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        and #$aa                          ; #.#.#.#.
                        sta BBZ_LevelStructCount          ; 
                        
                        lsr a                             ; 
                        ora BBZ_LevelStructCount          ; 
                        eor #$ff                          ; ########
                        and TabFloorTopTileRi,x           ; 
                        ora (BBZ_DrawHiResPtr),y          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        jsr IncDrawHiResPtr               ; 
                        
                        txa                               ; 
                        clc                               ; 
                        adc #$08                          ; 
                        tax                               ; 
                        
                        cmp #$18                          ; 
                        bcc .NextTopRow                   ; lower - two lines only
                        
                        ldx BBZ_DrawLevelStructStartX     ; 
DrawFloorTopX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawFloorEndTile      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawFloorEndTile        subroutine                        ; 
                        ldx #$00                          ; 
.SetNetTileRow          stx BBZ_LevelStructCount          ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_FloorEndTileShift         ; 
                        
                        lda [TabFloorEndTile - $01],x     ; 
                        ldx BBZ_DrawLevelStructStartX     ; 
                        beq .DrawTileRow                  ; 
                        
.ShiftNextTileLeft      lsr a                             ; 
                        ror BBZ_FloorEndTileShift         ; 
                        lsr a                             ; 
                        ror BBZ_FloorEndTileShift         ; 
                        
                        dex                               ; 
                        bne .ShiftNextTileLeft            ; 
                        
.DrawTileRow            sta BBZ_FloorEndTile_01           ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        and #$aa                          ; #.#.#.#.
                        sta BBZ_FloorEndTile_02           ; 
                        
                        lsr a                             ; .#.#.#.#
                        ora BBZ_FloorEndTile_02           ; 
                        eor #$ff                          ; ########
                        and BBZ_FloorEndTile_01           ; 
                        ora (BBZ_DrawHiResPtr),y          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        ldy #$08                          ; 
                        lda (BBZ_DrawHiResPtr),y          ; 
                        and #$aa                          ; #.#.#.#.
                        sta BBZ_FloorEndTile_02           ; 
                        
                        lsr a                             ; .#.#.#.#
                        ora BBZ_FloorEndTile_02           ; 
                        eor #$ff                          ; ########
                        and BBZ_FloorEndTile,x            ; 
                        ora (BBZ_DrawHiResPtr),y          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        jsr IncDrawHiResPtr               ; 
                        
                        ldx BBZ_LevelStructCount          ; 
                        inx                               ; 
                        cpx #$09                          ; 
                        bcc .SetNetTileRow                ; lower
                        
DrawFloorEndTileX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitDrawHiResPtrPosY  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitDrawHiResPtrPosY    subroutine                        ; 
                        sty BBZ_DrawLevelStructTopY       ; 
                        tay                               ; DrawLevelStructPosY
; -------------------------------------------------------------------------------------------------------------- ;
; InitDrawHiResPtrPosX  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitDrawHiResPtrPosX    subroutine                        ; 
                        ldx BBZ_DrawLevelStructPosX       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitDrawHiResPtr      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitDrawHiResPtr        subroutine                        ; 
                        lda BB_TabHiResAdrColLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrRowLo,y         ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
InitDrawHiResPtrX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawItemOrXmit        Does    : 
;                       Expects : xr=ItemBufferPos
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawItemOrXmit          subroutine                        ; 
                        lda BB_WA_ItemNo,x                ; ItemBufferPos
                        sec                               ; 
                        sbc #Item_XmitBoothNum1           ; 
                        bcc DrawItem                      ; lower
                        
.ChkIniXmit             tax                               ; 
                        lda BB_WA_XmitDrawBits,x          ; 
                        bpl DrawItemOrXmitX               ; Go Draw Xmit
                        
.IniDrawXmit            ldy BBZ_LevelStructCount          ; 
                        lda BB_WA_ItemPosX,y              ; 
                        clc                               ; 
                        adc #$0a                          ; preset width
                        sta BB_WA_XmitGamePosX,x          ; 
                        
                        lda BB_WA_ItemPosY,y              ; 
                        sec                               ; 
                        sbc #$1e                          ; 
                        sta BB_WA_XmitGamePosY,x          ; 
                        
                        lda #$00                          ; 
                        sta BB_WA_XmitDrawHeight,x        ; 
                        sta BB_WA_XmitDrawDataPtr,x       ; 
                        
                        lda #$0f                          ; 
                        sta BB_WA_XmitDrawDataByte,x      ; 
                        
                        lda #BB_WA_XmitDrawBitsTop        ; 
                        sta BB_WA_XmitDrawBits,x          ; 
                        
DrawItemOrXmitX         jmp DrawXmit                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DrawItem              Does    : 
;                       Expects : xr=ItemBufferPos
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawItem                lda BB_WA_ItemPosY,x              ; 
                        sec                               ; 
                        sbc #$1e                          ; 
                        tay                               ; 
                        sta BBZ_DrawItemPosY              ; 
                        
                        lda BB_WA_ItemPosX,x              ; 
                        tax                               ; 
                        and #$03                          ; ......##
                        sta BBZ_DrawItemPosX              ; $00-$03 = 4 different positions
                        
                        jsr InitDrawHiResPtr              ; with xr=HiResPtr yr=HiResOff
                        
                        txa                               ; ItemBufferPos
                        lsr a                             ; /2
                        lsr a                             ; /4
                        sta BBZ_ItemBufferPos             ; ItemBufferPos / 4
                        
                        ldx BBZ_LevelStructCount          ; 
                        lda BB_WA_ItemNo,x                ; 
                        cmp #$64                          ; 
                        bcc .SetItemDataPtr               ; lower - can be picked up and scored
                        
                        sbc #$63                          ; higher/equal - unpickable - make normal item
                        
.SetItemDataPtr         tay                               ; BB_WA_ItemNo
                        lda [BB_WA_ItemDataPtrLo - $01],y ; 
                        sta BBZ_ItemDataPtrLo             ;  
                        
                        lda [BB_WA_ItemDataPtrHi - $01],y ; 
                        sta BBZ_ItemDataPtrHi             ; 
                        
                        lda [BB_WA_ItemDataRows - $01],y  ; 
                        sta BBZ_ItemDataRows              ; 
                        
                        clc                               ; 
                        adc BB_WA_ItemPosY,x              ; 
                        sta BB_WA_ItemMaxY,x              ; 
                        
                        lda [BB_WA_ItemDataCols - $01],y  ; 
                        pha                               ; 
                        
                        clc                               ; 
                        adc BB_WA_ItemPosX,x              ; 
                        sta BB_WA_ItemMaxX,x              ; 
                        
                        pla                               ; BB_WA_ItemDataCols
                        sec                               ; 
                        sbc #$01                          ; 
                        lsr a                             ; /2
                        lsr a                             ; /4
                        clc                               ; 
                        adc #$01                          ; 
                        sta BBZ_ItemDataCols              ; 
                        
                        tya                               ; BB_WA_ItemNo
                        asl a                             ; *2
                        tay                               ; 
                        lda TabDrawItemColor1_2,y         ; 
                        tax                               ; 
                        
                        and #$0f                          ; 
                        sta BBZ_ItemColor01               ; 
                        
                        txa                               ; 
                        and #$f0                          ; 
                        sta BBZ_DrawItemColor02           ; 
                        
                        lda TabDrawItemColorRam,y         ; 
                        sta BBZ_DrawItemColorRam          ; 
                        jsr ItemColorBufClear             ; 
                        
                        ldy #$00                          ; 
.SetNextItemDataRow     lda #$00                          ; 
                        sta BBZ_DrawItemHiResOff          ; 
                        sta BBZ_DrawItemColorBufPtr       ; 
                        
                        lda BBZ_ItemDataCols              ; BBZ_ItemDataCols / 4
                        sta BBZ_DrawItemDataColsWrk       ; 
                        
.SetNextItemDataPtr     sty BBZ_DrawItemDataOff           ; 
                        
                        lda #$00                          ; 
                        sta BBZ_DrawItemHiResVal2         ; 
                        
                        lda (BBZ_ItemDataPtr),y           ; 
                        ldx BBZ_DrawItemPosX              ; $00-$03 = 4 different positions
                        beq .GetHiResOff                  ; 
                        
.ShiftPosX              lsr a                             ; 
                        ror BBZ_DrawItemHiResVal2         ; 
                        lsr a                             ; 
                        ror BBZ_DrawItemHiResVal2         ; 
                        
                        dex                               ; 
                        bne .ShiftPosX                    ; 
                        
.GetHiResOff            ldy BBZ_DrawItemHiResOff          ; 
                        tax                               ; 
                        ora (BBZ_DrawHiResPtr),y          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        tya                               ; 
                        clc                               ; 
                        adc #$08                          ; 
                        tay                               ; 
                        sty BBZ_DrawItemHiResOff          ; 
                        
                        lda BBZ_DrawItemHiResVal2         ; 
                        ora (BBZ_DrawHiResPtr),y          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        ldy BBZ_DrawItemColorBufPtr       ; 
                        jsr ItemColorBufFill              ; 
                        
                        iny                               ; 
                        
                        ldx BBZ_DrawItemHiResVal2         ; 
                        jsr ItemColorBufFill              ; 
                        
                        sty BBZ_DrawItemColorBufPtr       ; 
                        
                        ldy BBZ_DrawItemDataOff           ; 
                        iny                               ; 
                        
                        dec BBZ_DrawItemDataColsWrk       ; BBZ_ItemDataCols / 4
                        bne .SetNextItemDataPtr           ; 
                        
                        inc BBZ_DrawItemPosY              ; 
                        lda BBZ_DrawItemPosY              ; 
                        and #$07                          ; .....###
                        bne .GetNextHiResPtr              ; 
                        
                        jsr ItemColorRamFill              ; 
                        
                        ldy BBZ_DrawItemDataOff           ; 
                        iny                               ; 
                        
.GetNextHiResPtr        jsr IncDrawHiResPtr               ; 
                        
                        dec BBZ_ItemDataRows              ; 
                        bne .SetNextItemDataRow           ; 
                        
                        jsr ItemColorRamFill              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckItemPickable     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckItemPickable       subroutine                        ; 
                        ldx BBZ_LevelStructCount          ; 
                        lda BB_WA_ItemNo,x                ; 
                        cmp #$64                          ; 
                        bcc CheckItemPickableX            ; lower - can be picked up and scored
                        
                        lda #$00                          ; higher/equal - mark as unpickable
                        sta BB_WA_ItemNo,x                ; 
                        
CheckItemPickableX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDrawXmitData         equ  *               ; width: $02*$07 bits / height: $0e rows
TabDrawXmitDataTop      equ  *               ; 
TabDrawXmitDataTopData  equ  *               ; 
                        dc.b $0f ; ....####  ; ....#######....
                        dc.b $e0 ; ###.....  ; ...###...###...
                        dc.b $38 ; ..###...  ; ..####...####..
                        dc.b $e0 ; ###.....  ; ..###########..
                        dc.b $f1 ; ####...#  ; .###.......###.
                        dc.b $e1 ; ###....#  ; .###.......###.
                        dc.b $ff ; ########  ; .###.......###.
                        dc.b $c7 ; ##...###  ; .###.......###.
                        dc.b $01 ; .......#  ; ####.......####
                        dc.b $ce ; ##..###.  ; ####.......####
                        dc.b $03 ; ......##  ; ####.......####
                        dc.b $9c ; #..###..  ; ###############
                        dc.b $07 ; .....###  ; ###############
                        dc.b $38 ; ..###...  ; ##...........
                        dc.b $0e ; ....###.  ; 
                        dc.b $f0 ; ####....  ; 
                        dc.b $1f ; ...#####  ; 
                        dc.b $e0 ; ###.....  ; 
                        dc.b $3f ; ..######  ; 
                        dc.b $c0 ; ##......  ; 
                        dc.b $7f ; .#######  ; 
                        dc.b $ff ; ########  ; 
                        dc.b $ff ; ########  ; 
                        dc.b $ff ; ########  ; 
                        dc.b $f8 ; #####...  ; 
TabDrawXmitDataWallOff  equ  [[* - TabDrawXmitDataTop] - $01] ; offset wall data
TabDrawXmitDataTopRows  equ  [[[TabDrawXmitDataWallOff + $01] * $08] / $07] / $02] ; 8bytes of 8bits - 7bits used - 2*7bits in a row
TabDrawXmitDataWallData equ  *   ; 
                        
TabDrawXmitDataWall     equ  *   ;          
TabDrawXmitDataWallRows equ  $0b ; 
                        dc.b $00 ; ........  ; width: $0f bits / height: $0b rows
                        dc.b $c0 ; ##......  ; ##...........##.......
; -------------------------------------------------------------------------------------------------------------- ;
; DrawXmit              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DrawXmitReady           jmp CheckItemPickable             ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawXmit                subroutine                        ; entry point
.ChkDrawXmitReady       ldy BB_WA_XmitDrawHeight,x        ; 
                        cpy #BB_WA_XmitDrawHeightMax      ; 
.Exit                   bcs DrawXmitReady                 ; greater/equal - ready
                        
.IncXmitPosY            tya                               ; 
                        adc BB_WA_XmitGamePosY,x          ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        inc BB_WA_XmitDrawHeight,x        ; 
                        
                        lda BB_WA_XmitGamePosX,x          ; 
                        sec                               ; 
                        sbc #$0a                          ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        lda #BB_WA_XmitDrawBitsTopRow     ; bits used for one row
                        sta BBZ_XmitWidth                 ; 
                        
                        lda #BBZ_TabDrawLineColor_02      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
                        stx BBZ_DrawXmitNum               ; 
                        
.ShiftNextDataBit       asl BB_WA_XmitDrawDataByte,x      ; 
                        dec BB_WA_XmitDrawBits,x          ; 
                        bne .CheckNextDataBit             ; 
                        
                        lda #BB_WA_XmitDrawBitsTop        ; 
                        sta BB_WA_XmitDrawBits,x          ; 
                        
                        inc BB_WA_XmitDrawDataPtr,x       ; 
                        
                        ldy BB_WA_XmitDrawDataPtr,x       ; 
                        lda TabDrawXmitData,y             ; 
                        sta BB_WA_XmitDrawDataByte,x      ; 
                        
.CheckNextDataBit       bcc .IncXmitPosX                  ;  
                        
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        ldx BBZ_DrawXmitNum               ; 
                        
.IncXmitPosX            inc BBZ_DrawPosX                  ; 
                        dec BBZ_XmitWidth                 ; width
                        bne .ShiftNextDataBit             ; 
                        
                        ldy BB_WA_XmitDrawHeight,x        ; 
.ChkDrawXmitTopRdy      cpy #BB_WA_XmitDrawHeightTop      ; 
                        bcc .ChkDrawXmitWallRdy           ; lower - xmit top not completely drawn
                        
.IniXmitWall            lda #TabDrawXmitDataWallOff       ; 
                        sta BB_WA_XmitDrawDataPtr,x       ; 
                        lda #BB_WA_XmitDrawBitsWall       ; bits used for the left wall
                        sta BB_WA_XmitDrawBits,x          ; 
                        lda #$c0                          ; ##......
                        sta BB_WA_XmitDrawDataByte,x      ; 
                        
.ChkDrawXmitWallRdy     cpy #BB_WA_XmitDrawHeightWall     ; 
                        bne .ChkDrawXmitReady             ; xmit wall not completely drawn
                        
.DrawXmitCounter        lda BBZ_DrawPosX                  ; 
                        sec                               ; 
                        sbc #$0a                          ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        lda BBZ_DrawPosY                  ; 
                        sbc #$05                          ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        lda #BBZ_TabDrawLineColor_03      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
                        txa                               ; 
                        adc #$10                          ; "0" - make digit
                        jsr PrintTextChar                 ; 
                        
                        ldx BBZ_DrawXmitNum               ; 
DrawXmitX               jmp .ChkDrawXmitReady             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemColorBufFill      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemColorBufFill        subroutine                        ; 
                        lda BB_ItemRndColors,x            ; 
                        ora BB_ItemDrawColorBuf,y         ; 
                        sta BB_ItemDrawColorBuf,y         ; 
                        
ItemColorBufFillX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemColorRamFill      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemColorRamFill        subroutine                        ; 
                        ldy BBZ_DrawItemPosY              ; 
                        dey                               ; 
                        
                        tya                               ; 
                        lsr a                             ; /2
                        lsr a                             ; /4
                        lsr a                             ; /8
                        tay                               ; 
                        
                        lda BB_TabColorScrnPtrLo,y        ; 
                        clc                               ; 
                        adc BBZ_ItemBufferPos             ; ItemBufferPos / 4
                        sta BBZ_ColorScrnPtrLo            ; 
                        sta BBZ_ColorSavePtrLo            ; 
                        
                        lda BB_TabColorScrnPtrHi,y        ; 
                        adc #$00                          ; 
                        sta BBZ_ColorScrnPtrHi            ; 
                        
                        adc #>[BB_ColorScreenSave - BB_Scrn_Color] ; $e4
                        sta BBZ_ColorSavePtrHi            ; 
                        
                        ldy BBZ_ItemDataCols              ; 
.GetNextColor_01        lda BB_ItemDrawColorBuf,y         ; 
.ChkColor_01            and #$08                          ; ....#...
                        beq .GetNextColor_02              ; 
                        
                        lda BBZ_DrawItemColorRam          ; 
                        beq .GetNextColor_02              ; 
                        
                        sta (BBZ_ColorSavePtr),y          ; 
                        
.GetNextColor_02        lda BB_ItemDrawColorBuf,y         ; 
.ChkColor_02            and #$04                          ; .....#..
                        beq .GetNextColor_03              ; 
                        
                        lda BBZ_ItemColor01               ; 
                        beq .GetNextColor_03              ; 
                        
                        lda (BBZ_ColorScrnPtr),y          ; 
                        and #$f0                          ; 
                        ora BBZ_ItemColor01               ; 
                        sta (BBZ_ColorScrnPtr),y          ; 
                        
.GetNextColor_03        lda BB_ItemDrawColorBuf,y         ; 
.ChkColor_03            and #$02                          ; ......#.
                        beq .SetNextColor                 ; 
                        
                        lda BBZ_DrawItemColor02           ; 
                        beq .SetNextColor                 ; 
                        
                        lda (BBZ_ColorScrnPtr),y          ; 
                        and #$0f                          ; ....####
                        ora BBZ_DrawItemColor02           ; 
                        sta (BBZ_ColorScrnPtr),y          ; 
                        
.SetNextColor           dey                               ; 
ItemColorRamFillX       bpl .GetNextColor_01              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemColorBufClear     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemColorBufClear       subroutine                        ; 
                        ldx BBZ_ItemDataCols              ; 
                        lda #$00                          ; 
.ClrBuffer              sta BB_ItemDrawColorBuf,x         ; 
                        dex                               ; 
                        bpl .ClrBuffer                    ; 
                        
ItemColorBufClearX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDrawItemColor1_2     = [* - $02]                       ; 
TabDrawItemColorRam     = [* - $01]                       ; 
TabDrawItemColor_01     dc.b HR_BlackPurple               ; kneifzange
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_02     dc.b HR_LtRedBlack                ; spitzhacke
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_03     dc.b HR_LtRedLtGrey               ; schippe
                        dc.b CYAN                         ; 
                        
TabDrawItemColor_04     dc.b HR_LtRedBlack                ; hammer
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_05     dc.b HR_BlackBlack                ; trichter
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_06     dc.b HR_BlackPurple               ; teekanne
                        dc.b ORANGE                       ; 
                        
TabDrawItemColor_07     dc.b HR_GreyBlack                 ; dynamit znder
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_08     dc.b HR_BlackBlack                ; amboss
                        dc.b DK_GREY                      ; 
                        
TabDrawItemColor_09     dc.b HR_GreenCyan                 ; bgeleisen
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_0a     dc.b HR_LtGreenLtBlue             ; tasse
                        dc.b YELLOW                       ; 
                        
TabDrawItemColor_0b     dc.b HR_RedLtBlue                 ; torte
                        dc.b YELLOW                       ; 
                        
TabDrawItemColor_0c     dc.b HR_YellowBlack               ; kuchen
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_0d     dc.b HR_WhiteOrange               ; schneeschuh
                        dc.b GREY                         ; 
                        
TabDrawItemColor_0e     dc.b HR_GreenLtBlue               ; blumentopf 01
                        dc.b LT_RED                       ; 
                        
TabDrawItemColor_0f     dc.b HR_GreyRed                   ; fahrrad
                        dc.b BLUE                         ; 
                        
TabDrawItemColor_10     dc.b HR_RedLtGreen                ; atari joystick
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_11     dc.b HR_LtRedYellow               ; kandelaber
                        dc.b GREY                         ; 
                        
TabDrawItemColor_12     dc.b HR_BlackPurple               ; kelch
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_13     dc.b HR_BlackPurple               ; pistole
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_14     dc.b HR_RedBlack                  ; puschen
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_15     dc.b HR_RedBlue                   ; bonsai
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_16     dc.b HR_LtGreenLtBlue             ; -- nix --
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_17     dc.b HR_BrownBlack                ; telefon
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_18     dc.b HR_CyanBlack                 ; handtasche
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_19     dc.b HR_BlackBlack                ; halskette
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_1a     dc.b HR_CyanLtGrey                ; leine
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_1b     dc.b HR_BlueBrown                 ; staubsauger
                        dc.b GREY                         ; 
                        
TabDrawItemColor_1c     dc.b HR_BlackBlack                ; bombe
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_1d     dc.b HR_LtRedBlack                ; maurer hammer
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_1e     dc.b HR_BlackWhite                ; parfm flasche
                        dc.b LT_BLUE                      ; 
                        
TabDrawItemColor_1f     dc.b HR_GreyGreen                 ; blumentopf 2
                        dc.b PURPLE                       ; 
                        
TabDrawItemColor_20     dc.b HR_YellowBlue                ; vogelkfig
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_21     dc.b HR_YellowRed                 ; pmpel
                        dc.b ORANGE                       ; 
                        
TabDrawItemColor_22     dc.b HR_LtGreenLtBlue             ; messer
                        dc.b GREY                         ; 
                        
TabDrawItemColor_23     dc.b HR_OrangeBrown               ; galgen strick
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_24     dc.b HR_LtGreyBlack               ; rasiermesser
                        dc.b GREEN                        ; 
                        
TabDrawItemColor_25     dc.b HR_BlackRed                  ; weihwasser behlter
                        dc.b LT_GREEN                     ; 
                        
TabDrawItemColor_26     dc.b HR_BrownBlack                ; dreizack
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_27     dc.b HR_OrangeLtBlue              ; staubsauger 2
                        dc.b RED                          ; 
                        
TabDrawItemColor_28     dc.b HR_BrownBlue                 ; taschenlampe breit
                        dc.b GREY                         ; 
                        
TabDrawItemColor_29     dc.b HR_GreyLtBlue                ; koffer
                        dc.b RED                          ; 
                        
TabDrawItemColor_2a     dc.b HR_BlackGrey                 ; schloss
                        dc.b ORANGE                       ; 
                        
TabDrawItemColor_2b     dc.b HR_GreenBlack                ; schlssel
                        dc.b BLUE                         ; 
                        
TabDrawItemColor_2c     dc.b HR_LtGreyGreen               ; weihrauch gef
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_2d     dc.b HR_BlueLtGrey                ; giesskanne
                        dc.b GREEN                        ; 
                        
TabDrawItemColor_2e     dc.b HR_BlackRed                  ; kaffee tasse
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_2f     dc.b HR_LtRedBlack                ; robotron fsse
                        dc.b GREY                         ; 
                        
TabDrawItemColor_30     dc.b HR_YellowDkGrey              ; rckleuchte
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_31     dc.b HR_BlackGrey                 ; kreissge hut
                        dc.b WHITE                        ; 
                        
TabDrawItemColor_32     dc.b HR_LtGreyBlack               ; bowler hut
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_33     dc.b HR_LtBlueWhite               ; regenschirm
                        dc.b PURPLE                       ; 
                        
TabDrawItemColor_34     dc.b HR_RedCyan                   ; rollkoffer
                        dc.b WHITE                        ; 
                        
TabDrawItemColor_35     dc.b HR_BrownBlack                ; bratpfanne
                        dc.b GREY                         ; 
                        
TabDrawItemColor_36     dc.b HR_BrownDkGrey               ; feldflasche
                        dc.b GREY                         ; 
                        
TabDrawItemColor_37     dc.b HR_PurpleLtGrey              ; maske
                        dc.b RED                          ; 
                        
TabDrawItemColor_38     dc.b HR_BlackGreen                ; reissnagel
                        dc.b LT_GREY                      ; 
                        
TabDrawItemColor_39     dc.b HR_BlackBlack                ; runen
                        dc.b WHITE                        ; 
                        
TabDrawItemColor_3a     dc.b HR_LtRedBlack                ; -- nix --
                        dc.b GREY                         ; 
                        
TabDrawItemColor_3b     dc.b HR_BlackBlack                ; bombe 2
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_3c     dc.b HR_OrangeWhite               ; apple
                        dc.b LT_GREEN                     ; 
                        
TabDrawItemColor_3d     dc.b HR_BlackBlack                ; lolli
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_3e     dc.b HR_GreyPurple                ; sandkasten eimer
                        dc.b YELLOW                       ; 
                        
TabDrawItemColor_3f     dc.b HR_BlackBlack                ; breiter pinsel
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_40     dc.b HR_LtRedPurple               ; lammfellrolle
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_41     dc.b HR_OrangeGreen               ; dollar beutel
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_42     dc.b HR_LtGreyRed                 ; TNT eins
                        dc.b DK_GREY                      ; 
                        
TabDrawItemColor_43     dc.b HR_GreyCyan                  ; TNT zwei
                        dc.b RED                          ; 
                        
TabDrawItemColor_44     dc.b HR_BrownGrey                 ; TNT drei
                        dc.b DK_GREY                      ; 
                        
TabDrawItemColor_45     dc.b HR_BrownBrown                ; glhende kohlen
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_46     dc.b HR_BrownBrown                ; glhende kohlen 2
                        dc.b BROWN                        ; 
                        
TabDrawItemColor_47     dc.b HR_BlackLtBlue               ; keimling
                        dc.b YELLOW                       ; 
                        
TabDrawItemColor_48     dc.b HR_BlackLtBlue               ; maske 2
                        dc.b CYAN                         ; 
                        
TabDrawItemColor_49     dc.b HR_BlackBlack                ; hundeknochen
                        dc.b PURPLE                       ; 
                        
TabDrawItemColor_4a     dc.b HR_LtRedLtGrey               ; schild
                        dc.b DK_GREY                      ; 
                        
TabDrawItemColor_4b     dc.b HR_BlackBlack                ; strich
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_4c     dc.b HR_BlackBlue                 ; brilliant
                        dc.b CYAN                         ; 
                        
TabDrawItemColor_4d     dc.b HR_BlackBlack                ; regen outlet
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_4e     dc.b HR_BlackBlack                ; regen inlet
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_4f     dc.b HR_LtRedBlack                ; mobiles saugrohr
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_50     dc.b HR_BlackRed                  ; pulverisator
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_51     dc.b HR_BlackBlack                ; lifter
                        dc.b BLACK                        ; 
                        
TabDrawItemColor_52     dc.b HR_LtGreenLtBlue             ; diode
                        dc.b YELLOW                       ; 
                        
TabDrawItemColor_53     dc.b HR_LtGreenLtBlue             ; -- nix --
                        dc.b YELLOW                       ; 
                        
TabDrawItemColor_54     dc.b HR_OrangeGreen               ; kraftpille
                        dc.b BLUE                         ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabRndColorStartVal     dc.b WHITE                        ; 
                        dc.b RED                          ; 
                        dc.b PURPLE                       ; 
                        dc.b ORANGE                       ; 
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispGameSprites    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
DynDispGameSprites      subroutine                        ; 
                        ldx #>SetGameSprites              ; 
                        ldy #<SetGameSprites              ; 
                        
DynDispGameSpritesX     jmp DynDispatchHidden             ; xr=hi_adr_sub yr=lo_adr_sub
; -------------------------------------------------------------------------------------------------------------- ;
; DynDispHidden_01      Does   : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetGameSprites          subroutine                        ; 
                        ldy BBZ_BobSpriteNo               ; 
                        
                        lda BBZ_PlayerStatus              ; 
                        beq .Store                        ; BBZ_PlayerStateAlive
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        and #$03                          ; ......##
                        cmp #$02                          ; 
                        beq SetBobWobbleDead              ; 
                        
.Store                  sta __BobNextPosX                 ; 

.GetSpriteDataPtr       lda TabBobSpriteDataPtrLo,y       ; 
                        ldx TabBobSpriteDataPtrHi,y       ; 
                        
                        ldy #$00                          ; 
.SetSpriteDataPtr       sta .__SpriteDataAdrLo,y          ; 
                        
                        pha                               ; save
                        
                        txa                               ; 
                        sta .__SpriteDataAdrHi,y          ; 
                        
                        tya                               ; 
                        clc                               ; 
                        adc #$06                          ; 
                        tay                               ; 
                        
                        pla                               ; restore
                        adc #$12                          ; 
                        bcc .ChkMax                       ; 
                        
                        inx                               ; 
                        
.ChkMax                 cpy #[$04 * $06]                  ; 
                        bcc .SetSpriteDataPtr             ; 
                        
                        ldy BBZ_BobMoveType               ; 
                        cpy #BBZ_BobMoveTypeSink          ; 
                        bcc .CopyBobDataIni               ; 
                        
                        jmp BobWobbleSink                 ; 
                        
.CopyBobDataIni         ldy #$34                          ; sprite data length
                        ldx #$11                          ; sprite hight
CopyBobDataIni          lda #$00                          ; rightmost byte always $00
                        sta BB_BobSpriteGameBodyLe,y      ; 
                        sta BB_BobSpriteGameBodyRi,y      ; 
                        sta BB_BobSpriteGameArm,y         ; 
                        sta BB_BobSpriteGameLeg,y         ; 
                        
                        dey                               ; 
                        
.__SpriteDataAdrLo      equ [* + $01]                     ; 
.__SpriteDataAdrHi      equ [* + $02]                     ; 
                        lda BB_PlaceHolder_8000,x         ; + $00
                        sta BB_BobSpriteGameBodyLe,y      ; 
                        lda BB_PlaceHolder_8000,x         ; + $12
                        sta BB_BobSpriteGameBodyRi,y      ; 
                        lda BB_PlaceHolder_8000,x         ; + $24
                        sta BB_BobSpriteGameArm,y         ; 
                        lda BB_PlaceHolder_8000,x         ; + $36
                        sta BB_BobSpriteGameLeg,y         ; 
                        
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl CopyBobDataIni                ; 
                        
SetGameSpritesX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetBobWobbleDead      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetBobWobbleDead        subroutine                        ; 
                        sta __BobNextPosX                 ; 
                        
.GetSpriteDataPtr       lda TabWobSpriteDataPtrLo,y       ; 
                        ldx TabWobSpriteDataPtrHi,y       ; 
                        
                        ldy #$00                          ; 
.SetSpriteDataPtr       sta __GetWobbleSpriteDataLo,y     ; 
                        
                        pha                               ; save
                        
                        txa                               ; 
                        sta __GetWobbleSpriteDataHi,y     ; 
                        
                        tya                               ; 
                        clc                               ; 
                        adc #$06                          ; 
                        tay                               ; 
                        
                        pla                               ; restore
                        adc #$12                          ; 
                        bcc .ChkMax                       ; 
                        
                        inx                               ; 
                        
.ChkMax                 cpy #[$08 * $06]                  ; 
                        bcc .SetSpriteDataPtr             ; 
                        
                        ldy BBZ_BobMoveType               ; 
                        cpy #BBZ_BobMoveTypeSink          ; 
                        bcc .CpySpriteDataIni             ; 
                        
                        jmp SetBobWobbleSink              ; 
                        
.CpySpriteDataIni       ldy #$34                          ; 
SetBobWobbleDeadX       ldx #$11                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CopyWobbleSpriteData  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CopyWobbleSpriteData    subroutine                        ; 
__GetWobbleSpriteDataLo equ [* + $01]                     ; 
__GetWobbleSpriteDataHi equ [* + $02]                     ; 
.GetWobbleSpriteData    lda BB_PlaceHolder_8000,x         ; + $00
                        sta [BB_SpriteStore03 - $01],y    ; 
                        lda BB_PlaceHolder_8000,x         ; + $12
                        sta BB_BobSpriteGameBodyLe,y      ; 
                        lda BB_PlaceHolder_8000,x         ; + $24
                        sta [BB_SpriteStore02 - $01],y    ; 
                        lda BB_PlaceHolder_8000,x         ; + $36
                        sta BB_BobSpriteGameBodyRi,y      ; 
                        lda BB_PlaceHolder_8000,x         ; + $48
                        sta [BB_SpriteStore01 - $01],y    ; 
                        lda BB_PlaceHolder_8000,x         ; + $5a
                        sta BB_BobSpriteGameArm,y         ; 
                        lda BB_PlaceHolder_8000,x         ; + $6c
                        sta BB_SpritePointer07,y          ; 
                        lda BB_PlaceHolder_8000,x         ; + $7e
                        sta BB_BobSpriteGameLeg,y         ; 
                        
                        dey                               ; 
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl .GetWobbleSpriteData          ; 
                        
CopyWobbleSpriteDataX   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetBobWobbleSink      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetBobWobbleSink        subroutine                        ; 
                        ldy BBZ_CopyWobTabOff             ; 
                        ldx TabCopyWobFromLen,y           ; 
                        lda TabCopyWobTargLen,y           ; 
                        tay                               ; 
                        jsr CopyWobbleSpriteData          ; 
                        
                        tya                               ; 
.SaveCopyTabOff         pha                               ; 
                        
                        lda #BBZ_CopyWobTabOffMax         ; 
                        sec                               ; 
                        sbc BBZ_CopyWobTabOff             ; 
                        sta BBZ_CopyWobPhase              ; 
                        
                        asl a                             ; *2
                        adc BBZ_CopyWobPhase              ; 
                        cmp #$2a                          ; [BBZ_CopyWobTabOffMax + $01] * $02
                        bcs .RestoreCopyTabOff            ; greater/equal
                        
                        tay                               ; 
                        ldx BBZ_BobSpriteNo               ; 
                        lda TabWobSpriteDataHead_12,x     ; 
                        sta [BB_SpriteStore03 + $12],y    ; 
                        
                        lda #$aa                          ; 
                        sta [BB_SpriteStore02 + $12],y    ; 
                        sta [BB_SpriteStore03 + $13],y    ; 
                        
                        lda #$00                          ; 
                        sta [BB_SpriteStore03 + $15],y    ; 
                        sta [BB_SpriteStore02 + $16],y    ; 
                        
                        lda TabWobSpriteDataHead_15,x     ; 
                        sta [BB_SpriteStore02 + $15],y    ; 
                        
                        lda TabWobSpriteDataHead_13,x     ; 
                        sta [BB_SpriteStore02 + $13],y    ; 
                        
                        lda TODMIN,x                      ; CIA1($DC0A) Time of Day Clock Minutes
                        sta [BB_SpriteStore03 + $16],y    ; 
                        
.RestoreCopyTabOff      pla                               ; 
                        jmp BobWobbleSinkClear            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobWobbleSink         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobWobbleSink           subroutine                        ; 
                        ldy BBZ_CopyWobTabOff             ; 
                        ldx TabCopyWobFromLen,y           ; 
                        lda TabCopyWobTargLen,y           ; 
                        tay                               ; 
                        jsr CopyBobDataIni                ; 
                        
                        tya                               ; 
.SaveCopyTabOff         pha                               ; 
                        
                        lda #BBZ_CopyWobTabOffMax         ; 
                        sec                               ; 
                        sbc BBZ_CopyWobTabOff             ; actual offset
                        sta BBZ_CopyWobPhase              ; 
                        
                        asl a                             ; *2
                        adc BBZ_CopyWobPhase              ; 
                        cmp #$2a                          ; [BBZ_CopyWobTabOffMax + $01] * $02
                        bcs .RestoreCopyTabOff            ; greater/equal
                        
                        tay                               ; 
                        ldx BBZ_BobSpriteNo               ; 
                        
                        lda TabWobSpriteDataSmileLe,x     ; 
                        sta [BB_SpriteStore03 + $12],y    ; 
                        
                        lda TabWobSpriteDataSmileRi,x     ; 
                        sta [BB_SpriteStore02 + $12],y    ; 
                        
                        lda TODMIN,x                      ; CIA1($DC0A) Time of Day Clock Minutes
                        sta [BB_SpriteStore03 + $15],y    ; 
                        
                        lda TabWobSpriteDataHead,x        ; 
                        sta [BB_SpriteStore02 + $15],y    ; 
                        
.RestoreCopyTabOff      pla                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobWobbleSinkClear    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobWobbleSinkClear      subroutine                        ; 
                        tay                               ; 
                        
                        lda #$00                          ; 
                        
                        cpy #$80                          ; 
                        bcs .IniClearNext                 ; greater/equal
                        
                        sta BB_BobSpriteGameLeg,y         ; 
                        sta BB_BobSpriteGameArm,y         ; 
                        sta BB_BobSpriteGameBodyRi,y      ; 
                        sta BB_BobSpriteGameBodyLe,y      ; 
                        sta BB_SpritePointer07,y          ; 
                        sta [BB_SpriteStore01 - $01],y    ; 
                        sta [BB_SpriteStore02 - $01],y    ; 
                        sta [BB_SpriteStore03 - $01],y    ; 
                        
.IniClearNext           ldy #$07                          ; 
.ClearNext              sta [BB_SpriteStore00 + $36],y    ; 
                        sta [BB_SpriteStore01 + $36],y    ; 
                        dey                               ; 
                        bpl .ClearNext                    ; 
                        
                        lda BBZ_CopyWobTabOff             ; 
                        cmp #BBZ_CopyWobTabOffMax         ; 
                        bcs SetBobWobbleSinkX             ; 
                        
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeDead          ; 
                        beq BobWobbleSinkStep_01          ; 
                        
                        lda R6510                         ; 
                        ora #[IO_ON | BASIC_ON]           ; .....#.# - io=on kernal=keep basic=on (if kernal=on)
                        sta R6510                         ; 
                        
.SetRndBobSinkLine      lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore01_01           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore01_02           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore03_01           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore03_02           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore00_01           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore00_02           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore02_01           ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta .__SpriteStore02_02           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobWobbleSinkSteps    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobWobbleSinkStep_01    equ *                    
.__SpriteStore01_01     equ [* + $01]                     ; 
                        lda #$00                          ; 
                        sta [BB_SpriteStore01 + $33]      ; 
.__SpriteStore01_02     equ [* + $01]                     ; 
                        lda #$00                          ; 
                        sta [BB_SpriteStore01 + $34]      ; 
.__SpriteStore03_01     equ [* + $01]                     ; 
                        lda #$00                          ; 
                        sta [BB_SpriteStore03 + $3c]      ; 
.__SpriteStore03_02     equ [* + $01]                     ; 
                        lda #$00                          ; 
                        sta [BB_SpriteStore03 + $3d]      ; 
                        
                        lda __BobNextPosX                 ; 
                        cmp #$02                          ; 
                        bne SetBobWobbleSinkX             ; 
                        
BobWobbleSinkStep_02    equ *                    
.__SpriteStore00_01     equ [* + $01]                     ; 
                        lda #$00                          ; 
                        sta [BB_SpriteStore00 + $33]      ; 
.__SpriteStore00_02     equ * + $01                       ; 
                        lda #$00]                         ; 
                        sta [BB_SpriteStore00 + $34]      ; 
.__SpriteStore02_01     equ [* + $01]                     ; 
                        lda #$00]                         ; 
                        sta [BB_SpriteStore02 + $3c]      ; 
.__SpriteStore02_02     equ [* + $01]                     ; 
                        lda #$00]                         ; 
                        sta [BB_SpriteStore02 + $3d]      ; 
                        
SetBobWobbleSinkX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSprite         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSprite           subroutine                        ; 
                        lda BBZ_BobPosX                   ; 
                        ldy BBZ_BobPosY                   ; 
                        
                        ldx BBZ_XmitFlipFlopPos           ; 
                        cpx #BBZ_XmitFlipFlopPosNew       ; 
                        bne BobMoveSprite_ay              ; 
                        
                        lda BBZ_BobNewX                   ; 
                        ldy BBZ_BobNewY                   ; 
                        
BobMoveSprite_ay        sty .__BobNextPosY                ; 
                        
                        clc                               ; 
                        adc #$10                          ; 
                        tay                               ; 
                        asl a                             ; 
                        sta SP0X                          ; VIC($D000) Sprite 0 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP2X                          ; VIC($D004) Sprite 2 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        ldx #$0f                          ; 
                        bcs .SetXpos                      ; 
                        
                        ldx #$0a                          ; 
                        
.SetXpos                tya                               ; 
                        
__BobNextPosX           equ [* + $01]                     ; 
                        ldy #$00                          ; 
                        clc                               ; 
                        adc TabBobOffXpos,y               ; 
                        asl a                             ; 
                        sta SP1X                          ; VIC($D002) Sprite 1 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        sta SP3X                          ; VIC($D006) Sprite 3 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        txa                               ; 
                        bcs .SetNextPosXmsb               ; 
                        
                        and #$05                          ; 
                        
.SetNextPosXmsb         sta .__BobNextPosXmsb             ; 
                        lda #$f0                          ; 
                        
                        sei                               ; 
                        and MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
.__BobNextPosXmsb       equ [* + $01]                     ; 
                        ora #$00                          ; 
                        sta MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        cli                               ; 
                        
.__BobNextPosY          equ [* + $01]                     ; 
                        lda #$00                          ; 
                        clc                               ; 
                        adc #$3d                          ; 
                        sta SP0Y                          ; VIC($D001) Sprite 0 Y-Pos (Bits 0-7)
                        sta SP1Y                          ; VIC($D003) Sprite 1 Y-Pos (Bits 0-7)
                        
                        sec                               ; 
                        sbc #$03                          ; 
                        sta SP2Y                          ; VIC($D005) Sprite 2 Y-Pos (Bits 0-7)
                        sta SP3Y                          ; VIC($D007) Sprite 3 Y-Pos (Bits 0-7)
                        
                        lda XXPAND                        ; VIC($D01D) Sprite Double Height
                        and #$f0                          ; 
                        ora TabBobExpand,y                ; 
                        sta XXPAND                        ; VIC($D01D) Sprite Double Height
                        
BobMoveSpriteX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobOffXpos           dc.b $fc ; 
                        dc.b $f8 ; 
                        dc.b $f0 ; 
                        dc.b $f8 ; 
                        
TabBobExpand            dc.b $00 ; 
                        dc.b $0f ; 
                        dc.b $0f ; 
                        dc.b $0f ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetLevelNumber        Does    : 
;                       Expects : 
;                       Returns : yr=level number
; -------------------------------------------------------------------------------------------------------------- ;
GetLevelNumber          subroutine                        ; 
                        lda BBZ_LevelNumEquiv             ; 
                        
                        ldy #$ff                          ; prepare
.SetNextLevelNum        iny                               ; 
                        cmp TabLevelNumEquivStart,y       ; 
                        bne .SetNextLevelNum              ; 
                        
GetLevelNumberX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CallGamePlayInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CallGamePlayInit        subroutine                        ; 
                        jsr InitVicSid                    ; 
                        
                        ldx #>GamePlayInit                ; 
                        ldy #<GamePlayInit                ; 
CallGamePlayInitX       jmp DynDispatchHidden             ; xr=hi_adr_sub yr=lo_adr_sub
; -------------------------------------------------------------------------------------------------------------- ;
Text_GameOver           dc.b $40 ; _
                        dc.b $40 ; _
                        dc.b $67 ; G
                        dc.b $61 ; A
                        dc.b $6d ; M
                        dc.b $65 ; E
                        dc.b $40 ; _
                        dc.b $6f ; O
                        dc.b $76 ; V
                        dc.b $65 ; E
                        dc.b $72 ; R
                        dc.b $40 ; _
                        dc.b $40 ; _
                        dc.b $40 ; _
Text_GameOver_Len       equ  [* - Text_GameOver - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
Text_Player             dc.b $40 ; _
                        dc.b $40 ; _
                        dc.b $40 ; _
                        dc.b $70 ; P
                        dc.b $6c ; L
                        dc.b $61 ; A
                        dc.b $79 ; Y
                        dc.b $65 ; E
                        dc.b $72 ; R
                        dc.b $40 ; _
                        dc.b $51 ; 1
                        dc.b $40 ; _
                        dc.b $40 ; _
                        dc.b $40 ; _
Text_Player_Len         equ  [* - Text_Player - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
Text_Level              dc.b $00 ; 
                        dc.b $6c ; L
                        dc.b $65 ; E
                        dc.b $76 ; V
                        dc.b $65 ; E
                        dc.b $2c ; l
Text_Level_Len          equ  [* - Text_Level - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FillScreenTitle       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FillScreenTitle         subroutine                        ; 
                        cmp #$60                          ; 
                        bcc .Fill                         ; 
                        
                        sbc #$20                          ; 
                        
.Fill                   sta BB_Scrn_InfoLevelTitle,x      ; 
                        
FillScreenTitleX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_InfoScreen        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_InfoScreen          subroutine                        ; 
                        pha                               ; 
                        txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        lda R6510                         ; 
.SaveConfig             pha                               ; 
                        ora #[IO_ON | BASIC_ON]           ; .....#.# - io=on kernal=keep basic=on (if kernal=on)
                        sta R6510                         ; 
                        
                        lda #$b4                          ; 
                        cmp RASTER                        ; VIC($D012) Read : Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        bne .IncMoveTimer                 ; 
                        
                        lda BBZ_TimeInfoScreen            ; 
                        beq .SetOff_ECM                   ; 
                        
                        dec BBZ_TimeInfoScreen            ; 
                        
.SetOff_ECM             lda #$03                          ; 
                        ldx #$1b                          ; ...##.##  bit4=1 scrn_enab bit3=1 25_rows
                        bne .SetModeRaster                ; always
                        
.IncMoveTimer           inc BBZ_IRQ_GameTimer             ; 
                        
                        jsr MelodyCtrlRestore             ; 
                        jsr IrqDispatchSub                ; set number in __IrqDispatchSubID
                        
.SetOn_ECM              lda #$b4                          ; 
                        ldx #[$00 & VIC_RasterHi_Off | VIC_ECM_On & VIC_BMM_Off | VIC_Screen_On | VIC_Rows25 | VIC_SoftY_03] ; 
                        
.SetModeRaster          stx SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        jsr IRQ_IniNewRaster              ; ac=raster line
                        
IRQ_InfoScreen_X        jmp IRQ_GameExitPrep              ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabLvlInitTunePtrLo     dc.b <TabInitMelody_04            ; 
                        dc.b <TabInitMelody_03            ; 
                        dc.b <TabInitMelody_02            ; 
                        dc.b <TabInitMelody_01            ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabLvlInitTunePtrHi     dc.b >TabInitMelody_04            ; 
                        dc.b >TabInitMelody_03            ; 
                        dc.b >TabInitMelody_02            ; 
                        dc.b >TabInitMelody_01            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowInfoScreen        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowInfoScreen          subroutine                        ; 
                        sta BBZ_MelodyType                ; 
                        
                        sei                               ; 
                        jsr InitVicSid                    ; 
                        
                        ldy #>TabMelodyGameOver           ; preset
                        lda #<TabMelodyGameOver           ; 
                        
                        ldx BBZ_MelodyType                ; 
.WasGameOver            bne .GoSetMelodies                ; BBZ_MelodyTypeGameOver
                        
.__MelodyNo             equ [* + $01]                     ; 
.WasLeveleStart         ldx #$00                          ; 
                        inx                               ; 
.SetNextMelodyNo        stx .__MelodyNo                   ; 
                        
                        txa                               ; 
                        and #$03                          ; ......## - 4 different melodies
                        tax                               ; 
                        
                        lda TabLvlInitTunePtrLo,x         ; 
                        ldy TabLvlInitTunePtrHi,x         ; 
                        
.GoSetMelodies          jsr SetMelodies                   ; 
                        
                        ldx #$fc                          ; no of pages $100-$fc=$04
                        ldy #>BB_Scrn_Info                ; start address high = $e800
                        jsr FillStoragePrepare            ; 
                        
                        ldx #$18                          ; max fill level last page $100-$18=$e8
                        ldy #$00                          ; number of bytes/page 
                        lda #$00                          ; not necessary
                        jsr FillStorageWithZero           ; 
                        
                        ldx #Text_Player_Len              ; 
.PrintPlayer            lda #$40                          ; 
                        sta [BB_Scrn_InfoBox + BB_Scrn_ColorRowLen * $00],x ; 
                        sta [BB_Scrn_InfoBox + BB_Scrn_ColorRowLen * $01],x ; 
                        sta [BB_Scrn_InfoBox + BB_Scrn_ColorRowLen * $03],x ; 
                        sta [BB_Scrn_InfoBox + BB_Scrn_ColorRowLen * $04],x ; 
                        
                        lda Text_Player,x                 ; 
                        sta BB_Scrn_InfoPlayer,x          ; 
                        
                        dex                               ; 
                        bpl .PrintPlayer                  ; 
                        
                        ldx #$fc                          ; no of pages $100-$fc=$04
                        ldy #>COLORAM                     ; start address high = $d800
                        jsr FillStoragePrepare            ; 
                        
.GetCharColorPlayer1    lda #YELLOW                       ; 
.GetBackColorPlayer1    ldx #BLUE                         ; 
                        
                        ldy BBZ_ActivePlayer              ; 
                        bmi .SetBackColor                 ; player 1
                        
.GetBackColorPlayer2    ldx #RED                          ; 
.GetCharColorPlayer2    lda #WHITE                        ; 
                        inc BB_Scrn_InfoPlayerNum         ; 
                        
.SetBackColor           stx BGCOL1                        ; VIC($D022) Background Color 1
                        
                        ldx #$18                          ; max fill level last page $100-$18=$e8
                        ldy #$00                          ; start fill level first page
                        jsr FillStorageWithAc             ; max fill level last page $100-$18=$e8
                        
                        lda BBZ_MelodyType                ; 
                        beq .GetInfoScreenTime            ; 
                        
                        ldx #Text_GameOver_Len            ; 
.PrintGameOver          lda #$40                          ; 
                        sta BB_Scrn_InfoGameOverBox,x     ; 
                        lda Text_GameOver,x               ; 
                        sta BB_Scrn_InfoGameOverPlr,x     ; 
                        dex                               ; 
                        bpl .PrintGameOver                ; 
                        
.GetInfoScreenTime      lda #BBZ_TimeInfoScreenIni        ; 
                        sta BBZ_TimeInfoScreen            ; 
                        
                        jsr WaitRaster_0d                 ; 
                        
                        lda #CI2_VIC_MemBank_3            ; $00 = $c000-$ffff
                        sta CI2PRA                        ; CIA2($DD00) Data Port A - Bits 0-1 = VIC mem bank
                        
                        sta BGCOL0                        ; VIC($D021) Background Color 0
                        sta SPENA                         ; VIC($D015) Sprite Enable Register
                        
                        lda #$03                          ; 
                        sta C2DDRA                        ; CIA2($DD02) Data Dir A
                        
                        lda #[$00 | VIC_Video_2800 | VIC_CharS_2000] ; 
                        sta VMCSB                         ; VIC($D018) VIC Chip Memory Control
                        
                        lda #[$00 & VIC_On & VIC_MCM_Off | VIC_Cols40 & VIC_SoftX_Clear] ; ....#... bit3=1 40_columns
                        sta SCROLX                        ; ....#... - VIC($D016) VIC Control Register 2 (Horiz Fine Scroll)
                        
                        lda #[$00 & VIC_RasterHi_Off | VIC_ECM_On & VIC_BMM_Off | VIC_Screen_On | VIC_Rows25 | VIC_SoftY_03] ;
                        sta SCROLY                        ; .#.##.## - VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
                        ldy #<IRQ_InfoScreen              ; 
                        ldx #>IRQ_InfoScreen              ; 
                        lda #$b4                          ; 
                        
ShowInfoScreenX         jmp IRQ_SetNewRasterIRQ           ; xr=ptr_hi yr=ptr_lo ac=raster
; -------------------------------------------------------------------------------------------------------------- ;
; ClearKeyPressed       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ClearKeyPressed         subroutine                        ; 
                        ldx #BBZ_KeyPressedNone           ; 
                        stx BBZ_KeyPressed                ; 
                        
ClearKeyPressedX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreBlinkInit        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreBlinkInit          subroutine                        ; 
                        lda #$00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreBlinkSet         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreBlinkSet           subroutine                        ; 
                        sta BBZ_FlagScoreBlink            ; 
                        
                        tax                               ; 
                        lda TabScoreBlinkRate,x           ; 
                        sta BBZ_FlagScoreBlinkRate        ; 
                        
ScoreBlinkSetX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreBlinkRate       dc.b $32 ; Player 1
                        dc.b $14 ; Player 2
; -------------------------------------------------------------------------------------------------------------- ;
; ShowScoreHandler      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowScoreHandler        subroutine                        ; 
                        lda BBZ_ActivePlayer              ; 
                        bpl ScoreHandlerP_02              ; player 2
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreHandlerP_01      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreHandlerP_01        subroutine                        ; 
                        lda BBZ_FlagScoreBlink            ; 
                        lsr a                             ; test blink flag
                        bcc ShowScoreP_01                 ; not set
                        
                        ldx #[BB_Scrn_StatusP_Len - $01]  ; length status info for each player
                        lda #$00                          ; 
.ClearScore_P1          sta BB_Scrn_StatusOffDataP1,x     ; 
                        dex                               ; 
                        bpl .ClearScore_P1                ; 
                        
ScoreHandlerP_01X       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowScoreP_01         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowScoreP_01           subroutine                        ; 
                        ldy #$01                          ; 
                        ldx #$00                          ; 
.Get1stScoreDigit       lda BB_WA_Scores,x                ; 
                        bne .Found                        ; 
                        
                        inx                               ; 
                        cpx #[BB_WA_Scores_P1_Off_10 + $01] ; 
                        bcc .Get1stScoreDigit             ; 
                        
.Found                  jsr StatusScorePlayers            ; 
                        jsr ShowOneBlank                  ; 
                        
                        ldx BB_LivesNo_P1                 ; 
                        
ShowScoreP_01X          jmp ShowLives                     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreHandlerChkP_02   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreHandlerChkP_02     subroutine                        ; 
                        lda GameOptsPlayers               ; 
                        beq StatusScorePlayersX           ; exit - one players game
                        
                        lda BBZ_GameDemoMode              ; 
                        bne StatusScorePlayersX           ; exit - in demo mode
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreHandlerChkP_0    2 Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreHandlerP_02        subroutine                        ; 
                        lda BBZ_FlagScoreBlink            ; 
                        lsr a                             ; test blink flag
                        bcc ShowScoreP_02                 ; not set
                        
                        ldx #[BB_Scrn_StatusP_Len - $01]  ; length status info for each player
                        lda #$00                          ; 
.ClearScore_P2          sta BB_Scrn_StatusOffDataP2,x     ; 
                        dex                               ; 
                        bpl .ClearScore_P2                ; 
                        
ScoreHandlerP_02X       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowScoreP_02         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowScoreP_02           subroutine                        ; 
                        ldy #$01                          ; 
                        lda BB_LivesNo_P2                 ; 
                        eor #$ff                          ; 
                        clc                               ; 
                        adc #$1f                          ; 
                        tay                               ; 
                        
                        ldx #BB_WA_Scores_P1_Len          ; 
.Get1stScoreDigit       lda [BB_WA_Scores_P2 - BB_WA_Scores_P1_Len],x ;
                        bne .Found                        ; 
                        
                        iny                               ; 
                        
                        inx                               ; 
                        cpx #[BB_WA_Scores_P2_Off_10 + $01] ; 
                        bcc .Get1stScoreDigit             ; 
                        
.Found                  txa                               ; 
                        pha                               ; 
                        jsr ShowOneBlank                  ; 
                        
                        lda BB_LivesNo_P2                 ; 
                        tax                               ; 
                        jsr ShowLives                     ; 
                        
                        pla                               ; 
ShowScoreP_02X          tax                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; StatusScorePlayers    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
StatusScorePlayers      subroutine                        ; 
                        lda BB_WA_Scores,x                ; 
                        clc                               ; 
                        adc #$10                          ; make digit
                        stx .__SaveScore                  ; 
                        jsr StatusItemOutPtr              ; in ac
                        
.__SaveScore            equ [* + $01]                     ; 
                        ldx #$00                          ; 
                        iny                               ; 
                        inx                               ; 
                        cpx #BB_WA_Scores_P1_Len          ; score player 1
                        beq StatusScorePlayersX           ; 
                        
                        cpx #BB_WA_Scores_Len             ; score player 2
                        bcc StatusScorePlayers            ; lower
                        
StatusScorePlayersX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowLives             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowLives               subroutine                        ; 
                        lda #$40                          ; 
.NextLive               dex                               ; 
                        bmi ShowOneBlank                  ; 
                        
                        stx .__SaveXR                     ; 
                        
                        ldx #$40                          ; filled "o"
                        jsr StatusItemOut                 ; 
                        
.__SaveXR               equ [* + $01]                     ; 
                        ldx #$00                          ; 
                        iny                               ; 
ShowLivesX              bpl .NextLive                     ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ShowOneBlank          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ShowOneBlank            subroutine                        ; 
                        ldx #$00                          ; " "
                        jsr StatusItemOut                 ; 
                        
                        iny                               ; 
                        
ShowOneBlankX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetColorMasks         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetColorMasks           subroutine                        ; 
                        sta __FloorDrawColor              ; 
                        sta __GravityLiftTileColor        ; 
                        sta __FloorFillColorLe            ; 
                        sta __FloorFillColorRi            ; 
                        
.SavColor               tay                               ; 
                        
                        ldx #$03                          ; max 4 diifferent PosX 
.NextColorPos           and TabColorPosMasks,x            ; 
                        sta WrkColorPosVals,x             ; 
                        
.GetColor               tya                               ; 
                        
                        dex                               ; 
                        bpl .NextColorPos                 ; 
                        
SetColorMasksX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IrqDispatch_S05       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IrqDis_DemoStart        subroutine                        ; 
                        jsr CallGamePlayInit              ; 
                        
                        ldx #$00                          ; 
                        stx BBZ_MelodyType                ; 
                        
                        inx                               ; BBZ_GameDemoModeOn
                        bne IrqDis_SetGameMode            ; always
; -------------------------------------------------------------------------------------------------------------- ;
; IrqDispatch_S07       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IrqDis_GameStart        subroutine                        ; 
                        jsr CallGamePlayInit              ; 
                        
                        ldx #BBZ_GameDemoModeOff          ; 
IrqDis_SetGameMode      stx BBZ_GameDemoMode              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IrqDispatch_S08       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IrqDis_LevelStart       subroutine                        ; 
                        ldx #$00                          ; 
                        stx BBZ_NotUsed_9b                ; 
                        
                        stx BB_LevelStartTuneBuf_1        ; 
                        stx BB_LevelStartTuneBuf_2        ; 
                        stx BB_LevelStartTuneBuf_3        ; 
                        
                        lda #BBZ_MelodyTypeLvlInit        ; 
                        jsr ShowInfoScreen                ; 
                        
                        lda #$8f                          ; 
                        sta SIGVOL                        ; SID($D418) Volume/Filter Select
                        jsr InitVoice3                    ; 
                        
                        ldx #BB_Pulver_Max                ; 
.IniPulverWAs           lda #$00                          ; 
                        sta [BB_WA_PulverMovPos - $01],x  ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta [BB_WA_PulverMovTimer - $01],x; 
                        
                        lda #BB_WA_PulverMovDirDo         ; 
                        sta [BB_WA_PulverMovDir - $01],x  ; 
                        
                        dex                               ; 
                        bne .IniPulverWAs                 ; 
                        
                        stx BBZ_MoveLimitTabPtr           ; $00
                        stx BBZ_CannonPosY                ; 
                        stx BBZ_MobileTubeMove            ; 
                        stx BBZ_JoystickMenuCheck         ; 
                        stx BBZ_NotUsed_27                ; 
                        stx BBZ_HoistSwitchWait           ; 
                        stx BBZ_HoistStatus               ; 
                        stx BB_NumItemJustTaken           ; 
                        stx BBZ_CannonBobFlySound         ; 
                        stx BBZ_CannonStatus              ; 
                        stx BBZ_CannonBobTNTCleared       ; 
                        stx BBZ_AmoutTNT                  ; 
                        stx BBZ_CannonPosX                ; 
                        stx BB_MasterCheatLevelNum        ; 
                        stx BBZ_DrawLoopPosY              ; 
                        stx BBZ_TonePingCount             ; 
                        stx BBZ_NotUsed_de                ; 
                        stx BBZ_TimerLeftBarTime          ; 
                        stx BBZ_CountSuctionTubes         ; 
                        
                        ldx #BB_WA_XmitDrawBitsInit       ; Xmit needs an init first before a draw
                        stx BB_WA_XmitDrawBits_01         ; 
                        stx BB_WA_XmitDrawBits_02         ; 
                        stx BB_WA_XmitDrawBits_03         ; 
                        stx BB_WA_XmitDrawBits_04         ; 
                        stx BB_WA_XmitDrawBits_05         ; 
                        
                        ldx #$03                          ; 
.ResLevelColors         lda BBZ_LevelColor_01,x           ; 
                        and #$0f                          ; ....####
                        sta BBZ_LevelColor_01,x           ; 
                        
                        dex                               ; 
                        bpl .ResLevelColors               ; 
                        
                        lda BBZ_LevelNumEquiv             ; 
.ChkYukonsPenthouse_01  cmp #BBZ_LevelNumEquiv_23         ; Level WW - Advanced Pulverizors
                        bne .IniLevelColorOff             ; 
                        
.RecolorYukonsPH_01     lda #RED                          ; 
                        sta BBZ_LevelColor_02             ; 
                        
.IniLevelColorOff       ldy #$03                          ; 
.IniLevelColorNum       ldx #$03                          ; 
.GetLevelColorsRND      lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$0f                          ; ....#### - isolate color
                        beq .GetLevelColorsRND            ; 
                        
.ChkLevelColors         cmp BBZ_LevelColor_01,x           ; 
                        beq .IniLevelColorNum             ; 
                        
                        dex                               ; 
                        bpl .ChkLevelColors               ; 
                        
.SetLevelColors         sta BBZ_LevelColors,y             ; $97 $98 $99 $9a
                        dey                               ; 
                        bpl .IniLevelColorNum             ; 
                        
                        lda BBZ_LevelNumEquiv             ; 
.ChkYukonsPenthouse_02  cmp #BBZ_LevelNumEquiv_23         ; Level WW - Advanced Pulverizors
                        bne .SetLevelDataPtr              ; 
                        
.RecolorYukonsPH_02     lda BBZ_LevelColor_02             ; 
                        sta __ColorLevel_23               ; 
                        
                        lda #RED                          ; 
                        sta BBZ_LevelColor_02             ; 
                        
.SetLevelDataPtr        lda #<TabLevelData                ; 
                        ldx #>TabLevelData                ; 
                        jsr IniDataBytePtr                ; 
                        
                        lda BBZ_LevelNumEquiv             ; 
                        sta BBZ_LevelNumEquivWork         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetLevelSectionPtrs   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetLevelSectionPtrs     subroutine                        ; 
.SetLevelFloorPtr       lda BBZ_GetDataBytePtrLo          ; Floors
                        sta BBZ_LvlFloorDataPtrLo         ; 
                        lda BBZ_GetDataBytePtrHi          ; 
                        sta BBZ_LvlFloorDataPtrHi         ; 
                        
.Get1stLevelFloorByte   jsr GetDataByteIncPtr             ; 
.ChkEndLevelFloorBlock  beq .SetLevelLadderPtr            ; 
                        
.Get2ndLevelFloorByte   jsr GetDataByteIncPtr             ; 
.Get3rdLevelFloorByte   jsr GetDataByteIncPtr             ; 
                        
                        jmp .Get1stLevelFloorByte         ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetLevelLadderPtr      lda BBZ_GetDataBytePtrLo          ; Ladders
                        sta BBZ_LvlLadderDataPtrLo        ; 
                        lda BBZ_GetDataBytePtrHi          ; 
                        sta BBZ_LvlLadderDataPtrHi        ; 
                        
.Get1stLevelLadderByte  jsr GetDataByteIncPtr             ; 
.ChkEndLevelLadderBlock beq .SetLevelSlidePtr             ; 
                        
.Get2ndLevelLadderByte  jsr GetDataByteIncPtr             ; 
.Get3rdLevelLadderByte  jsr GetDataByteIncPtr             ; 
.Get4thLevelLadderByte  jsr GetDataByteIncPtr             ; 
                        
                        jmp .Get1stLevelLadderByte        ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetLevelSlidePtr       lda BBZ_GetDataBytePtrLo          ; Slides
                        sta BBZ_LvlSlideDataPtrLo         ; 
                        lda BBZ_GetDataBytePtrHi          ; 
                        sta BBZ_LvlSlideDataPtrHi         ; 
                        
.Get1stLevelSlideByte   jsr GetDataByteIncPtr             ; 
.ChkEndLevelSlideBlock  beq .SetLevelTitlePtr             ; 
                        
.Get2ndLevelSlideByte   jsr GetDataByteIncPtr             ; 
.Get3rdLevelSlideByte   jsr GetDataByteIncPtr             ; 
.Get4thLevelSlideByte   jsr GetDataByteIncPtr             ; 
                        
                        jmp .Get1stLevelSlideByte         ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetLevelTitlePtr       sty BBZ_TabDrawLineColorPtr       ; Title
                        
                        lda BBZ_GetDataBytePtrLo          ; 
                        sta BBZ_LvlTitleDataPtrLo         ; 
                        lda BBZ_GetDataBytePtrHi          ; 
                        sta BBZ_LvlTitleDataPtrHi         ; 
                        
.Get1stLevelTitleByte   jsr GetDataByteIncPtr             ; 
.ChkEndLevelTitleBlock  cmp #$10                          ; 
                        beq .GetLevelBobsStartPosX        ; 
                        
.ChkEndLevelTitleToken  cmp #$16                          ; The_
                        bne .IncLevelTitleLen             ; 
                        
                        inc BBZ_LvlTitleDataLen           ; 
                        inc BBZ_LvlTitleDataLen           ; 
                        inc BBZ_LvlTitleDataLen           ; 
                        
.IncLevelTitleLen       inc BBZ_LvlTitleDataLen           ; 
                        bne .Get1stLevelTitleByte         ; always (hopefully)
; -------------------------------------------------------------------------------------------------------------- ;
.GetLevelBobsStartPosX  jsr GetDataByteIncPtr             ; Bobs Start Position
                        sta BBZ_BobPosX                   ; 
                        sta BBZ_BobPosXStart              ; 
                        
.GetLevelBobsStartPosY  jsr GetDataByteIncPtr             ; 
                        sta BBZ_BobPosY                   ; 
                        sta BBZ_BobPosYStart              ; 
; -------------------------------------------------------------------------------------------------------------- ;
.IniLevelSpriteCount    ldx #$00                          ; Sprites
                        stx BB_CountEnemySprites          ; 
                        
.SetLevelSpriteCount    stx BBZ_CountSprites              ; 

.Get1stLevelSpriteByte  jsr GetDataByteIncPtr             ; 
.ChkEndLevelSpriteBlk_1 bne .Chk1stLevelSpriteRstr        ; 
                        
.GoIniLevelItemCount    jmp .IniLevelItemCount            ; 
                        
.GoSetLevelSpriteColor  jmp .SetLevelSpriteColor          ; 
                        
.Chk1stLevelSpriteRstr  cmp #$04                          ; 
                        bcs .Add1stLevelSpriteRstr        ; greater/equal
                        
                        lda #$ff                          ; -1
                        
.Add1stLevelSpriteRstr  adc #$35                          ; 
                        sta BB_WA_SpriteRaster,x          ; plus $35 (1st plus $34)
                        
.SetLevelSpriteOffWA_2  txa                               ; 1st sprite entry has part 2 only
                        clc                               ; 
                        adc #$10                          ; set WA offset block 2
                        
.GetLevelSpriteOffWA    tax                               ; next sprite entries have 2 parts
                        
.GetLevelSpritePosX     jsr SprtGetDataByteIncPtr         ; 
                        sta BB_WA_SpritePosX,x            ; 
                        beq .GoSetLevelSpriteColor        ; 
                        
                        inc BB_CountEnemySprites          ; 
                        
.GetLevelSpritePosY     jsr GetDataByteIncPtr             ; 
                        clc                               ; 
                        adc #$3b                          ; 
                        sta BB_WA_SpritePosY,x            ; 
                        
.GetLevelSpriteMinX     jsr GetDataByteIncPtr             ; 
                        clc                               ; 
                        adc #$01                          ; 
                        sta BB_WA_SpriteMinX,x            ; 
                        
.GetLevelSpriteMaxX     jsr GetDataByteIncPtr             ; 
                        sta BB_WA_SpriteMaxX,x            ; 
                        
.GetLevelSpriteID       jsr GetDataByteIncPtr             ; 
                        sta BB_WA_SpriteID,x              ; 
                        
.GetLevelSpriteDirSpeed jsr GetDataByteIncPtr             ; 
                        pha                               ; DR.SSSS. - save SpeedDir
                        
.GetLevelSpriteSpeed    and #$1f                          ; ...SSSS.
                        
                        ldy GameOptsDifficulty            ; 
                        beq .SetLevelSpriteSpeed          ; BB_GameOptsDifficultyEasy
                        
                        ldy BBZ_GameDemoMode              ; 
                        bne .SetLevelSpriteSpeed          ; BBZ_GameDemoModeOn
                        
.DecLevelSpriteSpeed    lsr a                             ; ....SSSS
                        
.SetLevelSpriteSpeed    sta BB_WA_SpriteSpeedA,x          ; 
                        sta BB_WA_SpriteSpeedB,x          ; 
                        
                        pla                               ; DR.SSSS. - restore SpeedDir
                        
.GetLevelSpriteDirFlag  rol a                             ; R.SSSS.. D->C
                        rol a                             ; .SSSS..D R->C
                        bcc .ChkLevelSpriteDir            ; 
                        
                        lda BBZ_GameDemoMode              ; 
                        bne .ChkLevelSpriteDir            ; BBZ_GameDemoModeOn
                        
.GetLevelSpriteDirRND   lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        
.ChkLevelSpriteDir      and #$01                          ; .......D
                        bne .SetLevelSpriteDir            ; +1
                        
                        lda #$ff                          ; -1
                        
.SetLevelSpriteDir      sta BB_WA_SpriteDir,x             ; 
                        
.GetLevelSpriteNumIni_1 lda #$80                          ; #.......
                        
.ChkLevelSpritePart     cpx #$10                          ; 
                        bcc .GetLevelSpriteDir            ; lower
                        
.GetLevelSpriteNumIni_2 lda #$84                          ; #....#..
                        
.GetLevelSpriteDir      ldy BB_WA_SpriteDir,x             ; 
                        bmi .SetLevelSpriteNum            ; 
                        
                        ora #$02                          ; ......#.
                        
.SetLevelSpriteNum      sta BB_WA_SpriteNumberA,x         ; 
                        sta BB_WA_SpriteNumberB,x         ; 
                        
.GetLevelSpriteColor    lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$0f                          ; ....####
                        beq .GetLevelSpriteColor          ; 
                        
                        ldy #$02                          ; 
                        
.ChkLevelSpriteColor    cmp BBZ_LevelColors,y             ; 
                        beq .GetLevelSpriteColor          ; 
                        
                        dey                               ; 
                        bpl .ChkLevelSpriteColor          ; 
                        
                        ldy BB_SpriteStatusPlay,x         ; 
                        bne .SetLevelSpriteColor          ; 
                        
                        tya                               ; 
                        sta BB_WA_SpritePosX,x            ; 
                        
                        dec BB_CountEnemySprites          ; 
                        
                        lda #BLUE                         ; 
                        
.SetLevelSpriteColor    sta BB_WA_SpriteColor,x           ; 
                        
                        ldy #$00                          ; 
                        
.SetLevelSpriteOffWA_1  txa                               ; 
                        sec                               ; 
                        sbc #$10                          ; 
                        bcc .GetLevelSpriteCount          ; 
                        
                        jmp .GetLevelSpriteOffWA          ; 
                        
.GetLevelSpriteCount    ldx BBZ_CountSprites              ; 
.IncLevelSpriteCount    inx                               ; 
                        jmp .SetLevelSpriteCount          ; 
; -------------------------------------------------------------------------------------------------------------- ;
.IniLevelItemCount      ldx #$00                          ; Items
                        
.Get1stLevelItemByte    jsr GetDataByteIncPtr             ; 
.ChkEndLevelItemBlock   beq .SetLevelItemCount            ; 
.SetLevelItemNum        sta BB_WA_ItemNo,x                ; 
                        
.GetLevelItemPosX       jsr GetDataByteIncPtr             ; 
.SetLevelItemPosX       sta BB_WA_ItemPosX,x              ; 

.GetLevelItemPosY       jsr GetDataByteIncPtr             ; 
                        clc                               ; 
                        adc #$1e                          ; 
.SetLevelItemPosY       sta BB_WA_ItemPosY,x              ; 
                        
                        inx                               ; 
                        bpl .Get1stLevelItemByte          ; always (hopefully)
                        
.SetLevelItemCount      stx BBZ_CountItems                ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetLevelFloatPtr       lda BBZ_GetDataBytePtrLo          ; Floating Platforms
                        sta BBZ_LvlFloatDataPtrLo         ; 
                        lda BBZ_GetDataBytePtrHi          ; 
                        sta BBZ_LvlFloatDataPtrHi         ; 
                        
.Get1stLevelFloatByte   jsr GetDataByteIncPtr             ; 
.ChkEndLevelFloatBlock  beq .SetNextLevelData             ; 
                        
.IniLevelFloatBlockLen  ldx #$05                          ; 
.GetNextLevelFloatByte  jsr GetDataByteIncPtr             ; 
                        
.DecLevelFloatBlockLen  dex                               ; 
                        bne .GetNextLevelFloatByte        ; 
                        beq .Get1stLevelFloatByte         ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetNextLevelData       dec BBZ_LevelNumEquivWork         ; 
                        beq OutLevelName                  ; 
                        
SetLevelSectionPtrsX    jmp SetLevelSectionPtrs           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; OutLevelName          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
OutLevelName            subroutine                        ; 
                        jsr WaitRaster_0d                 ; 
                        
                        jsr GetLevelNumber                ; yr=level number
                        iny                               ; level no + $01
                        sty BBZ_OutLevelNum               ; 
                        
                        lda #BB_Scrn_ColorRowLen          ; max length
                        sec                               ; 
                        sbc BBZ_LvlTitleDataLen           ; level name length
                        
                        pha                               ; save length without level name
                        
                        lda #$09                          ; still single digit
                        cmp BBZ_OutLevelNum               ; set carry
                        
                        pla                               ; restore length without level name
                        
                        sbc #$0c                          ; subtract header
                        lsr a                             ; /2 = print out text in middle of the screen
                        tax                               ; 
                        
.GetTxtLevelLen         ldy #Text_Level_Len               ; 
.GetTxtLevel            lda Text_Level,y                  ; "LEVEL"
                        jsr FillScreenTitle               ; 
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        
.DecTxtLevelLen         dey                               ; 
.ChkTxtLevelLen         bpl .GetTxtLevel                  ; 
                        
                        lda BBZ_OutLevelNum               ; 
                        
                        sty BBZ_OutLevelNum               ; $ff -> -1
                        
                        cmp #$0a                          ; 10
                        bcc .OutLevel_1s                  ; lower
                        
                        ldy #$10                          ; greater/equal - preset "0"
                        
.CountLevel_10s         iny                               ; 
                        sbc #$0a                          ; 10
                        cmp #$0a                          ; 10
                        bcs .CountLevel_10s               ; greater/equal
                        
.SavLevel1              pha                               ; save level number
                        
                        tya                               ; 
.OutLevel_10s           jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        
.GetLevel1              pla                               ; restore level number
                        
.OutLevel_1s            clc                               ; 
                        adc #$10                          ; make char digit
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos - one space
                        inx                               ; set next out pos
                        
                        lda #$0d                          ; "-"
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos - one space
                        inx                               ; 
                        
.OutLevelTitleStrtQuote lda #$02                          ; """
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        
                        txa                               ; 
.SavOutPos              pha                               ; save screen pos
                        
                        ldy #BBZ_LvlTitleDataPtr          ; 
                        jsr IniDataBytePtr_Yr             ; with $00/$01 + yr 
                        
.GetOutPos              pla                               ; restore screen pos
                        tax                               ; 
                        
.GetNextLevelTitleChar  jsr GetDataByteIncPtr             ; get next title chr
                        
.ChkEndOfLevelTitleData cmp #$10                          ; Level_nn_Title_EOD
                        beq .OutLevelTitleEndQuote        ; end of data
                        
                        cmp #$16                          ; Token: The_
                        bne .OutLevelDataChar             ; 
                        
                        lda #$34                          ; "T"
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        lda #$68                          ; "h"
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        lda #$65                          ; "e"
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        lda #$0c                          ; prepare " "
                        
.OutLevelDataChar       sec                               ; 
                        sbc #$0c                          ; make printable
                        jsr FillScreenTitle               ; 
                        
                        inx                               ; set next out pos
                        bne .GetNextLevelTitleChar        ; always (hopefully)
                        
.OutLevelTitleEndQuote  lda #$02                          ; """
                        jsr FillScreenTitle               ; 
                        
                        jsr FillScreenWithZero            ; 
                        
                        lda BBZ_LevelNumEquiv             ; 
.ChkLastLevel           cmp #BBZ_LevelNumEquivMax         ; Level ZZ - Congratulations ... 
                        bne NextLevelPrepare              ; 
                        
OutLevelNameX           jmp Congratulations               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; NextLevelPrepare      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
NextLevelPrepare        subroutine                        ; 
                        jsr ClearSpriteStorage            ; 
                        
                        ldx #>SetEnemySpriteData          ; 
                        ldy #<SetEnemySpriteData          ; 
                        jsr DynDispatchHidden             ; 
                        
                        ldx #$fc                          ; no of pages $100-$fc=$04
                        ldy #>BB_Scrn_Color               ; start address high = $0800
                        jsr FillStoragePrepare            ; 
                        
                        lda BBZ_LevelColor_01             ; 
                        asl a                             ; 
                        asl a                             ; 
                        asl a                             ; 
                        asl a                             ; 
                        ora BBZ_LevelColor_02             ; 
                        ldx #$40                          ; max fill level last page $100-$40=$c0
                        ldy #$28                          ; start fill level first page
                        jsr FillStorageWithAc             ; 
                        
                        lda BBZ_LevelColor_03             ; 
                        jsr FillSaveColorRamWithAc        ; 
                        
                        ldx #[BB_Scrn_ColorRowLen - $01]  ; 
                        lda #HR_WhiteBlack                ; 
.InitScreenRow_01       sta BB_Scrn_ColorStat,x           ; 
                        dex                               ; 
                        bpl .InitScreenRow_01             ; 
                        
.InitLevelFloors        ldx #$00                          ; 
                        stx BBZ_CountFlowTiles            ; 
                        stx BBZ_CountFloorTilesToFlip     ; 
                        
                        txa                               ; $00
.BaseLineWA             jsr SetLevelFloorWA               ; for all levels on pos one
                        
                        lda BBZ_LevelNumEquiv             ; 
                        jsr SetLevelFloorWA               ; 
                        
                        stx BBZ_NextFreePosInWA           ; next free wa pos
                        
.LevelFloors            ldy #BBZ_LvlFloorDataPtr          ; 
                        jsr IniDataBytePtr_Yr             ; with $00/$01 + yr 
                        
                        ldx BBZ_NextFreePosInWA           ; next free wa pos
.GetNextFloorDataByte   jsr GetDataByteIncPtr             ; 
                        beq .SavFloorWaMax                ; end of data
                        
                        pha                               ; save LevelFloorLen
                        
                        clc                               ; 
.AddFloorLength         adc BBZ_CountFloorTilesToFlip     ; 
                        sta BBZ_CountFloorTilesToFlip     ; 
                        
                        pla                               ; restore LevelFloorLen
                        
                        asl a                             ; *2
                        asl a                             ; *4 - floor tile width
                        
                        clc                               ; 
                        adc (BBZ_GetDataBytePtr),y        ; LevelFloorPosX
                        sta BB_WA_FloorMaxX,x             ; 
                        
                        jsr GetDataByteIncPtr             ; LevelFloorPosX
                        sta BB_WA_FloorMinX,x             ; 
                        
                        jsr GetDataByteIncPtr             ; LevelFloorPosY
                        sta BB_WA_FloorPosY,x             ; 
                        
                        lda #$00                          ; 
                        sta BB_WA_FloorTileNum,x          ; 
                        
                        inx                               ; 
                        bne .GetNextFloorDataByte         ; 
                        
.SavFloorWaMax          stx BBZ_NextFreePosInWA           ; next free wa pos
                        stx BBZ_CountFloorsFlows          ; floors and flow tiles
                        
.GetLevelFloatDataPtr   ldy #BBZ_LvlFloatDataPtr          ; 
                        jsr IniDataBytePtr_Yr             ; with $00/$01 + yr
                        
.GetNextFloatDataByte   jsr GetDataByteIncPtr             ; 
                        beq .GoSetLadderSlideWA           ; end of data
                        
.SavLevelFloatLen       pha                               ; length
                        
                        jsr GetDataByteIncPtr             ; 
                        ldx BBZ_CountFloorsFlows          ; next free wa pos - floors and flow tiles
                        sta BB_WA_FloorMinX,x             ; 
                        
                        jsr GetDataByteIncPtr             ; 
                        sta BB_WA_FloorPosY,x             ; 
                        
.GetLevelFloatLen       pla                               ; length
.SavLevelFloatLenAgain  pha                               ; length
                        
                        clc                               ; 
                        adc BB_WA_FloorMinX,x             ; 
                        sta BB_WA_FloorMaxX,x             ; 
                        
                        lda #$81                          ; thin ground
                        sta BB_WA_FloorTileNum,x          ; 
                        
                        ldx BBZ_CountFlowTiles            ; 
                        
.GetLevelFloatLenAgain  pla                               ; 
                        sta BB_WA_FloatTileLen,x          ; 
                        
                        lda #$00                          ; 
                        sta BB_WA_FloatMoveHeight,x       ; 
                        
                        jsr GetDataByteIncPtr             ; MinX
                        sta BB_WA_FloatMoveMinX,x         ; 
                        
                        jsr GetDataByteIncPtr             ; MaxX
                        sta BB_WA_FloatMoveMaxX,x         ; 
                        
                        jsr GetDataByteIncPtr             ; Move
                        sta BB_WA_FloatType,x             ; 
                        
.SavLevelFloatMove      pha                               ; Move
                        
                        and #BB_LevelFloatMaskMoveSpeed   ; .....###
                        sta BB_WA_FloatMoveSpeed,x        ; 
                        sta BB_WA_FloatMoveSpeedDec,x     ; 
                        
.GetLevelFloatMove      pla                               ; Move
.SavLevelFloatMoveAgain pha                               ; Move - GG.RDSSS

.GetLevelFloatDirFlag   asl a                             ; G.RDSSS.
                        asl a                             ; .RDSSS..
                        asl a                             ; RDSSS...
                        asl a                             ; DSSS.... R->C
                        bcc .ChkLevelFloatMoveDir         ; bit4=1 - get a random move dir
                        
.GetLevelFloatDirRND    lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        
.ChkLevelFloatMoveDir   asl a                             ; SSS..... D->C
                        
                        lda #$ff                          ; -1 - preset move left
                        bcc .SetLevelFloatMoveDir         ; 
                        
                        lda #$01                          ; +1 - set move right
                        
.SetLevelFloatMoveDir   sta BB_WA_FloatMoveDir,x          ; 
                        
.GetLevelFloatMoveAgain pla                               ; Move - GG.RDSSS
                        
.IsoLevelFloatGrLift    and #BB_LevelFloatMaskGraLi       ; check if Gravity Lift
.ChkLevelFloatGrLift    cmp #BB_LevelFloatMaskGraLi       ; 
                        bne .IncLevelFloatCount           ; 
                        
                        ldx BBZ_CountFloorsFlows          ; next free wa pos - floors and flow tiles
                        lda BB_WA_FloorPosY,x             ; 
                        
                        ldx BBZ_CountFlowTiles            ; 
                        sta BB_WA_FloatMoveMinX,x         ; 
                        
.IncLevelFloatCount     inc BBZ_CountFlowTiles            ; 
                        inc BBZ_CountFloorsFlows          ; floors and flow tiles
                        
.GoGetNextFloatByte     jmp .GetNextFloatDataByte         ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GoSetLadderSlideWA     jsr SetLadderSlideWA              ; 
                        
                        lda #$ff                          ; ######## - color $03
                        
                        ldx BBZ_LevelNumEquiv             ; 
                        cpx #BBZ_LevelNumEquiv_23         ; Level WW - Advanced Pulverizors
                        bne .GoSetColorMasks              ; 
                        
                        lda #$55                          ; .#.#.#.# - color $01
                        
.GoSetColorMasks        jsr SetColorMasks                 ; 
                        
.PaintLadderI           ldy #$00                          ; 
.ChkLadderCountMax      cpy BBZ_CountLadders              ; 
                        beq .PaintSlideI                  ; all ladders painted
                        
                        lda BB_WA_LadderLen,y             ; 
                        sta BBZ_DrawLevelStructLen        ; 
                        
                        lda BB_WA_LadderAddX,y            ; 
                        sta BBZ_DrawLevelStructAddX       ; 
                        
                        lda BB_WA_LadderPosX,y            ; 
                        sta BBZ_DrawLevelStructPosX       ; 
                        
                        lda BB_WA_LadderTopY,y            ; 
                        jsr InitDrawHiResPtrPosY          ; 
                        
                        lda BBZ_DrawLevelStructPosX       ; 
                        and #$03                          ; ......##
                        asl a                             ; .....##. - *2
                        sta BBZ_DrawLevelStructPosX       ; 
                        
.GetLevelLadderPosX     ldx BBZ_DrawLevelStructPosX       ; 
                        dec BBZ_DrawLevelStructAddX       ; 
                        bpl .DrawLevelLadderPart          ; 
                        
                        lda #$03                          ; 
                        sta BBZ_DrawLevelStructAddX       ; 
                        
                        inx                               ; 
                        
.DrawLevelLadderPart    jsr DrawLadderSlide               ; 
                        jsr IncDrawHiResPtr               ; 
                        
.DecLevelLadderLen      dec BBZ_DrawLevelStructLen        ; 
                        bne .GetLevelLadderPosX           ; 
                        
                        ldy BBZ_DrawLevelStructTopY       ; 
                        iny                               ; 
                        bne .ChkLadderCountMax            ; always
; -------------------------------------------------------------------------------------------------------------- ;
.PaintSlideI            ldy #$00                          ; 
.ChkSlideCountMax       cpy BBZ_CountSlides               ; 
                        beq .ChkDifficultyFlipCount       ; all slides painted
                        
                        lda BB_WA_SlideLen,y              ; 
                        sta BBZ_DrawLevelStructLen        ; 
                        
                        lda BB_WA_SlideMove,y             ; 
                        sta BBZ_DrawLevelStructAddX       ; 
                        
                        lda BB_WA_SlidePosX,y             ; 
                        sta BBZ_DrawLevelStructPosX       ; 
                        
                        lda BB_WA_SlidePosY,y             ; 
                        sta BBZ_DrawLevelStructPosY       ; 
                        
                        sty BBZ_CountSlidesWork           ; 
                        
.GetLevelSlidePosY      ldy BBZ_DrawLevelStructPosY       ; 
                        jsr InitDrawHiResPtrPosX          ; 
                        
                        lda BBZ_DrawLevelStructPosX       ; 
                        and #$03                          ; ......##
                        asl a                             ; .....##. - *2
                        tax                               ; 
                        inx                               ; 
                        jsr DrawLadderSlide               ; 
                        
                        lda BBZ_DrawLevelStructPosX       ; 
                        clc                               ; 
                        adc BBZ_DrawLevelStructAddX       ; 
                        sta BBZ_DrawLevelStructPosX       ; 

                        inc BBZ_DrawLevelStructPosY       ; 

                        dec BBZ_DrawLevelStructLen        ; 
                        bne .GetLevelSlidePosY            ; 
                        
                        ldy BBZ_CountSlidesWork           ; 
                        iny                               ; 
                        bne .ChkSlideCountMax             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.ChkDifficultyFlipCount ldx #$00                          ; 
                        lda GameOptsDifficulty            ; 
                        cmp #BB_GameOptsDifficultyHard    ; 
                        bcc .InitFloorTileData            ; lower
                        
.ResetFlipCount         stx BBZ_FloorPiecesFlipped        ; reset flip count for HARD/C'MON
                        
.InitFloorTileData      jsr FloorTileDataInit             ; 
                        
                        ldy #$ff                          ; -1
                        
.SetNextFloorTileCount  iny                               ; 
                        cpy BBZ_CountFloorsFlows          ; floors and flow tiles
                        bne .GetLevelFloorMaxX            ; 
                        
                        jmp .ChkLevel_UtilityHoist        ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GetLevelFloorMaxX      lda BB_WA_FloorMaxX,y             ; 
                        sec                               ; 
                        sbc BB_WA_FloorMinX,y             ; 
                        
                        lsr a                             ; /2
                        lsr a                             ; /4 - floor tile width
                        sta BBZ_DrawLevelStructLen        ; 
                        
                        lda BB_WA_FloorTileNum,y          ; 
                        bmi .SetNextFloorTileCount        ; handle next floor wa entry
                        
.SetLevelFloorStartPos  lda BB_WA_FloorMinX,y             ; 
                        sta BBZ_DrawLevelStructPosX       ; 
                        
                        lda BB_WA_FloorPosY,y             ; 
                        sec                               ; 
                        sbc #$03                          ; 
                        jsr InitDrawHiResPtrPosY          ; 
                        
                        lda BBZ_DrawLevelStructPosX       ; 
                        and #$03                          ; ......##
                        sta BBZ_DrawLevelStructStartX     ; 
                        
                        tax                               ; 
                        
                        clc                               ; 
.AddLevelFloorTileWidth adc #$04                          ; 
                        sta BBZ_DrawLevelStructEndX       ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_DrawFloorTileCount        ; 
                        
.SavNextFloorHiResPtr   lda BBZ_DrawHiResPtrHi            ; 
                        pha                               ; 
                        lda BBZ_DrawHiResPtrLo            ; 
                        pha                               ; 
                        jsr DrawFloorTop                  ; 
                        
                        ldy BBZ_DrawFloorTileCount        ; 
                        lda BBZ_FloorPiecesFlipped        ; 
                        beq .DrawFloorUnfilled            ; 
                        
                        jsr FloorTileDataNext             ; 
                        
                        ldx BBZ_DrawLevelStructStartX     ; 
                        bcc .DrawFloorUnfilled            ; 
                        
.GetLevelFloorHeight    lda #$06                          ; 
.SetLevelFloorHeight    sta BBZ_DrawLevelTileHeight       ; 
                        
.DrawFloorFilled        jsr DrawFloorTileRow              ; 
                        
                        dec BBZ_DrawLevelTileHeight       ; 
                        bne .DrawFloorFilled              ; 
                        beq .SetNextFloorHiResPtr         ; always
                        
.DrawFloorUnfilled      jsr DrawFloorTileRow              ; 
                        
                        lda BBZ_DrawFloorTileCount        ; 
                        lsr a                             ; /2 = mark every 2nd tile
                        jsr DrawFloorTilePart             ; 
                        
.SetNextFloorHiResPtr   pla                               ; 
                        clc                               ; 
                        adc #$08                          ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        pla                               ; 
                        adc #$00                          ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
                        ldx BBZ_DrawLevelStructEndX       ; 
                        
                        inc BBZ_DrawFloorTileCount        ; 
                        ldy BBZ_DrawFloorTileCount        ; 
                        cpy BBZ_DrawLevelStructLen        ; 
                        bne .SavNextFloorHiResPtr         ; 
                        
                        jsr DrawFloorEndTile              ; 
                        
                        ldy BBZ_DrawLevelStructTopY       ; 
                        jmp .SetNextFloorTileCount        ; 
; -------------------------------------------------------------------------------------------------------------- ;
.ChkLevel_UtilityHoist  ldx BBZ_LevelNumEquiv             ; 
                        cpx #BBZ_LevelNumEquiv_12         ; Level LL - Acid Rain
                        bne .GetLevelFloatTileColor       ; 
                        
.GetColor_UtilityHoist  lda #$55                          ; .#.#.#.# - color $01
                        jsr SetColorMasks                 ; 
                        
.GetLevelFloatTileColor lda __GravityLiftTileColor        ; 
                        and #BBZ_TabDrawLineColor_03      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
                        ldx BBZ_CountFlowTiles            ; 
                        ldy BBZ_CountFloorsFlows          ; next free wa pos - floors and flow tiles
.SetNextFloatTile       dey                               ; 
                        
                        dex                               ; 
                        bmi .DrawLevelThinBotLine         ; all flow tiles painted
                        
.GetNextFloatTileHight  lda BB_WA_FloatMoveHeight,x       ; 
                        cmp #$03                          ; 
                        bcs .SetNextFloatTile             ; greater/equal
                        
                        adc BB_WA_FloorPosY,y             ; 
                        
                        inc BB_WA_FloatMoveHeight,x       ; 
                        
                        sta BBZ_DrawPosY                  ; 
                        
                        lda BB_WA_FloorMinX,y             ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        lda BB_WA_FloatTileLen,x          ; 
                        
                        stx BBZ_CountFlowTilesSav         ; 
                        sty BBZ_CountFloorsFlowsSav       ; 
                        
                        jsr DrawLineSetLen                ; 
                        
                        ldy BBZ_CountFloorsFlowsSav       ; 
                        ldx BBZ_CountFlowTilesSav         ; 
                        bpl .GetNextFloatTileHight        ; 
; -------------------------------------------------------------------------------------------------------------- ;
.DrawLevelThinBotLine   ldx #$00                          ; 
                        ldy #$bf                          ; 
                        lda #[BB_Scrn_ColorRowLen * $04]  ; 
                        jsr DrawLineSetLenPosXY           ; xr=PosX yr=PosY ac=length
                        
                        ldx #$00                          ; 
.ChkItemCountMax        cpx BBZ_CountItems                ; 
                        beq .GoSetLevelHandlers           ; 
                        
                        stx BBZ_LevelStructCount          ; 
                        
                        jsr DrawItemOrXmit                ; 
                        
                        ldx BBZ_LevelStructCount          ; 
                        inx                               ; 
                        bne .ChkItemCountMax              ; 
                        
.GoSetLevelHandlers     jsr SetLevelHandlers              ; 
                        jsr ClearKeyPressed               ; and Xr
                        
                        stx __IRQKeyPressed               ; $ff
                        stx __NumberKeyPressed            ; 
                        
                        stx BBZ_MasterLevelNo             ; init level no for master cheat
                        stx BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        jsr ScoreBlinkInit                ; 
                        
                        lda #BBZ_TimeScoreTimeIni         ; 
                        sta BBZ_TimeScoreTime             ; 
                        
                        asl a                             ; BBZ_TimeScoreTimeIni * 2
                        sta BBZ_BobDeadWobbleTime         ; 
                        
                        ldx #$07                          ; 
                        stx TabChkSolvedWait              ; 
                        stx BBZ_TimeLowBeepLen            ; 
                        stx BBZ_BobMoveNoJumpTimer        ; 
                        
                        ldx #BBZ_TimeLowBeepSpeedInit     ; 
                        stx BBZ_TimeLowBeepSpeed          ; 
                        
                        ldx #$60                          ; rts
                        stx __BobSetDeath                 ; deactivate sub BobSetDeath
                        
                        ldx #$00                          ; 
                        stx BBZ_SpriteNoToHandle          ; 
                        stx BBZ_PlayerStatus              ; BBZ_PlayerStateAlive
                        
                        ldx BBZ_LevelNumEquiv             ; 
                        lda TabLevelTime,x                ; 
                        
                        ldx GameOptsDifficulty            ; 
                        cpx #$03                          ; 
                        bcc .SavLevelTime                 ; 
                        
                        ldx BBZ_GameDemoMode              ; 
                        bne .SavLevelTime                 ; BBZ_GameDemoModeOn
                        
.DecLevelTime           sbc #$10                          ; 
                        
.SavLevelTime           pha                               ; 
                        
                        and #$0f                          ; isolate right halfbyte
                        clc                               ; 
                        adc #$10                          ; "0" - make digit
                        sta BB_WA_LevelTimesLo_100        ; 
                        sta BB_WA_LevelTimesHi_100        ; 
                        
.GetLevelTime           pla                               ; 
                        
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; isolate left halfbyte
                        clc                               ; 
                        adc #$10                          ; "0" - make digit
                        sta BB_WA_LevelTimesLo_1000       ; 
                        sta BB_WA_LevelTimesHi_1000       ; 
                        
                        lda #$10                          ; "0"
                        sta BB_WA_LevelTimesLo_10         ; 
                        sta BB_WA_LevelTimesHi_10         ; 
                        
                        sta BB_ScoreTimeLeft_1000         ; 
                        sta BB_ScoreTimeLeft_100          ; 
                        sta BB_ScoreTimeLeft_10           ; 
                        jsr StatusShowTime                ; 
                        
                        ldx #$10                          ; 
                        ldy #$15                          ; 
                        jsr StatusItemOut                 ; 
                        
                        ldx #$00                          ; 
                        stx BBZ_TimeChrPos                ; 
                        
                        ldx #BBZ_TimeTicsInit             ; do not start count down immediately after level start
                        stx BBZ_TimeTics                  ; 
                        
                        ldy BBZ_MoveLimitTabPtr           ; 
                        
                        lda #$ff                          ; 
                        sta BB_WA_MoveLimitMinX,y         ; min PosX
                        lda #$a0                          ; 
                        sta BB_WA_MoveLimitMaxX,y         ; max PosX
                        
                        lda #$3c                          ; 
                        sta BB_WA_MoveLimitMinY0,y        ; min PosY
                        sta BB_WA_MoveLimitMinY1,y        ; 
                        
                        lda #$fb                          ; 
                        sta BB_WA_MoveLimitMaxY0,y        ; max PosY
                        sta BB_WA_MoveLimitMaxY1,y        ; 
                        
                        iny                               ; 
                        iny                               ; 
                        sty BBZ_MoveLimitTabPtr           ; 
                        
                        jsr SetLadderSlideWA              ; 
                        jsr ScoreHandlerP_01              ; 
                        jsr ScoreHandlerChkP_02           ; 
                        
                        ldx #$00                          ; 
                        stx BBZ_SprtSprtCollision         ; 
                        stx BBZ_MoveSpriteNum             ; 
                        stx BBZ_ScoreCharActualPos        ; 
                        stx BBZ_IRQ_GameTimer             ; 
                        stx BBZ_BobDemoMoveMove           ; 
                        
                        inx                               ; $01
                        stx BBZ_BobDemoMoveTime           ; 
                        
                        lda #<TabBobDemoMoveData          ; 
                        sta BBZ_BobDemoMovesPtrLo         ; 
                        lda #>TabBobDemoMoveData          ; 
                        sta BBZ_BobDemoMovesPtrHi         ; 
                        
                        jsr WaitTunesEnd                  ; 
                        
                        sei                               ; 
                        
.InitSCROLY             sta SCROLY                        ; VIC($D011) VIC Control Register 1 (Vert Fine Scroll)
                        
                        lda #>BB_ColorScreenSave          ; 
                        sta .__FromHi                     ; 
                        lda #>COLORAM                     ; 
                        sta .__TargetHi                   ; 
                        
                        ldx #$00                          ; 
                        ldy #$04                          ; 
                        
.__FromHi               equ [* + $02]                     ; 
.GetNextColor           lda BB_ColorScreenSave,x          ; 
.__TargetHi             equ [* + $02]                     ; 
                        sta COLORAM,x                     ; 
                        inx                               ; 
                        bne .GetNextColor                 ; 
                        
                        inc .__FromHi                     ; 
                        inc .__TargetHi                   ; 
                        dey                               ; 
                        bne .GetNextColor                 ; 
                        
                        tya                               ; 
                        tax                               ; 
.ZeroZeroPageEntries    ldy TabLevelZeroPageIni,x         ; zero to selected zero page addresses
                        beq .GoScreenToBank_00            ; 
                        
                        sta BBZ_0000,y                    ; 
                        inx                               ; 
                        bne .ZeroZeroPageEntries          ; 
                        
.GoScreenToBank_00      jsr ScreenToBank_00               ; 
                        
                        lda #$ff                          ; 
                        sta SPENA                         ; VIC($D015) Sprite Enable Register
                        
                        lda #$f0                          ; 
                        sta XXPAND                        ; VIC($D01D) Sprite Double Height
                        
                        lda #$0f                          ; 
                        sta SPMC                          ; VIC($D01C) Sprite Multicolor
                        
                        lda #LT_BLUE                      ; 
                        sta SPMC0                         ; VIC($D025) Sprite Multicolor Register 0
                        
                        lda #GREEN                        ; 
                        sta SPMC1                         ; VIC($D026) Sprite Multicolor Register 1
                        
                        lda #ORANGE                       ; 
                        sta SP3COL                        ; VIC($D02A) Color Sprite 3
                        sta SP2COL                        ; VIC($D029) Color Sprite 2
                        
                        lda #WHITE                        ; 
                        sta SP0COL                        ; VIC($D027) Color Sprite 0
                        sta SP1COL                        ; VIC($D028) Color Sprite 1
                        
                        ldx #[BB_SpriteStore / VIC_Sprt_BlockLen] ; sprite pointer
                        stx BB_SpritePointer00            ; $30 - BB_BobSpriteGameLeg
                        inx                               ; 
                        stx BB_SpritePointer01            ; $31 - BB_BobSpriteGameArm
                        inx                               ; 
                        stx BB_SpritePointer02            ; $32 - BB_BobSpriteGameBodyRi
                        inx                               ; 
                        stx BB_SpritePointer03            ; $33 - BB_BobSpriteGameBodyLe
                        
                        ldy #<IRQ_GameStart               ; 
                        ldx #>IRQ_GameStart               ; 
                        lda #$fb                          ; raster line 251
                        jsr IRQ_SetNewRasterIRQ           ; 
                        
.FreezeOff              inc BBZ_GamePause                 ; BBZ_GamePauseOff
; -------------------------------------------------------------------------------------------------------------- ;
; MainLoop              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MainLoop                subroutine                        ; 
                        lda BBZ_TimeScoreTime             ; 
                        ora BBZ_TonePingCount             ; 
                        beq MainLoopGoBobSolved           ; 
                        
                        lda BBZ_BobDeadWobbleTime         ; 
                        ora BBZ_TonePingCount             ; 
                        beq MainLoopGoBobKilled           ; 
                        
                        jsr CheckColorLevel_12            ; Level LL - Acid Rain
                        
                        lda BBZ_GameDemoMode              ; 
                        bne MainLoop                      ; 
                        
                        lda GameOptsPauseKey              ; 
                        bne .ChkMasterLevelNum            ; 
                        
                        lda BBZ_KeyPressed                ; 
                        cmp #$71                          ; "<-"
                        bne .ChkMasterLevelNum            ; 
                        
                        jsr ClearKeyPressed               ; and xr
                        
.GamePause              lda #BBZ_GamePauseOn              ; 
                        sta BBZ_GamePause                 ; 
                        
                        sta SUREL1                        ; SID($D406) Oscillator 1 Sustain/Release
                        sta SUREL2                        ; SID($D40D) Oscillator 2 Sustain/Release
                        
                        sta BB_SaveSid_SUREL1             ; 
                        sta BB_SaveSid_SUREL2             ; 
                        
.WaitPauseEnd           lda BBZ_KeyPressed                ; 
                        cmp #$71                          ; "<-"
                        bne .WaitPauseEnd                 ;  
                        
                        jsr ClearKeyPressed               ; and xr
                        
                        inc BBZ_GamePause                 ; BBZ_GamePauseOff
                        
.ChkMasterLevelNum      ldx BB_MasterCheatLevelNum        ; 
                        bne MainLoopLevelStart            ; 
                        
                        jsr MasterCheatCheck              ; 
                        bne MainLoop                      ; not found
                        
                        lda BBZ_KeyPressed                ; 
                        bne .ChkMasterKeyDigit            ; 
                        
                        jsr ClearKeyPressed               ; and xr
                        
                        jmp .IniMasterLevelNo             ; 
                        
.ChkMasterKeyDigit      sec                               ; 
                        sbc #$10                          ; "0"
                        bcc .GetMasterKey                 ; lower
                        
                        cmp #$0a                          ; "9" + $01
                        bcs .GetMasterKey                 ; greater/equal
                        
                        jsr ClearKeyPressed               ; 
                        
                        ldx BBZ_MasterLevelNo             ; 
                        bmi .MultMasterLevelNo            ; fresh - multiply 1st digit by $0a
                        
.SetMasterLevelNo1      adc BBZ_MasterLevelNo             ; 
                        beq .IniMasterLevelNo             ; 
                        
                        cmp #BBZ_LevelNumEquivMax         ; Level ZZ - Congratulations ... 
                        bcs .IniMasterLevelNo             ; greater/equal max level no
                        
                        tay                               ; 
                        ldx TabLevelNumEquiv,y            ; 
                        bne MainLoopLevelStart            ; 
                        
.IniMasterLevelNo       lda #$ff                          ; 
                        bmi .SetMasterLevelNo10           ; 
; -------------------------------------------------------------------------------------------------------------- ;
MainLoopGoBobKilled     beq MainLoopBobKilled             ; 
MainLoopGoBobSolved     beq MainLoopBobSolved             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.MultMasterLevelNo      asl a                             ; ......#. - $01 was start value
                        sta BBZ_MasterLevelNo             ; 
                        
                        asl a                             ; .....#..
                        asl a                             ; ....#...
                        adc BBZ_MasterLevelNo             ; ....#.#.
                        
.SetMasterLevelNo10     sta BBZ_MasterLevelNo             ; ....#.#. - $0a is end value
                        
.GetMasterKey           lda BBZ_KeyPressed                ; 
.ChkMaster_A            cmp #$21                          ; "a" - previous level
                        bne .ChkMaster_Q                  ; 
                        
                        jsr GetLevelNumber                ; yr=level number
                        ldx TabLevelNumEquiv,y            ; 
                        bne MainLoopLevelStart            ; 
                        
                        ldx TabLevelNumEquivEnd           ; last entry
                        bne MainLoopLevelStart            ; 
                        
.ChkMaster_Q            cmp #$31                          ; "q" - next level
                        beq MainLoopBobSolved             ; 
                        
.ChkMaster_Z            cmp #$3a                          ; "z" - restart level
                        bne GoMainLoop                    ; 
                        
                        jsr InitLevelRestart              ; 
                        
                        ldx #BB_IrqSubID_LevelStart       ; 
                        jmp SetIrqDispatchSubID           ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoMainLoop              jmp MainLoop                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MainLoopBobSolved     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MainLoopBobSolved       subroutine                        ; 
                        jsr CheckShowScores               ; 
                        jsr GetLevelNumber                ; yr=level number
                        
                        ldx [TabLevelNumEquiv + $02],y    ; 
                        cpx #BBZ_LevelNumEquivMax         ; Level ZZ - Congratulations ... 
                        bne MainLoopLevelStart            ; last level still not solved
                        
                        jsr CheckLevelSelect              ; 
                        bne MainLoopLevelStart            ; code '7/7' not found
                        
MainLoopBobSolvedX      ldx TabLevelNumEquivStart         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MainLoopLevelStart    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MainLoopLevelStart      subroutine                        ; 
                        lda #BBZ_GamePauseOn              ; 
                        sta BBZ_GamePause                 ; 
                        sta BBZ_FloorPiecesFlipped        ; 
                        stx BBZ_LevelNumEquiv             ; 
                        
                        ldy #BB_SpriteStatusPlayLen       ; 
                        tya                               ; 
.ClrDataStore_P2        sta [BB_SpriteStatusPlay - $01],y ; $20
                        dey                               ; 
                        bne .ClrDataStore_P2              ; 
                        
                        ldx #BB_IrqSubID_LevelStart       ; 
MainLoopLevelStartX     jmp SetIrqDispatchSubID           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MainLoopBobKilled     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MainLoopBobKilled       subroutine                        ; 
                        jsr CheckShowScores               ; 
                        jsr InitLevelRestart              ; 
                        jsr GetActPlayerLives             ; 
                        beq MainLoopGameOver              ; all lives used up
                        
.ChkPlayers             lda GameOptsPlayers               ; 
                        beq .LevelRestart                 ; 
                        
                        lda BB_LivesNo_P1                 ; 
                        
                        ldx BBZ_ActivePlayer              ; 
                        bpl .ChkLives                     ; player 2
                        
                        lda BB_LivesNo_P2                 ; 
                        
.ChkLives               tax                               ; 
                        beq .LevelRestart                 ; 
                        
                        jsr SwapPlayerGameData            ; 
                        
.LevelRestart           lda #BBZ_PlayerLooseLifeYes       ; flag loose 1 live if killed
                        sta BBZ_PlayerLooseLife           ; 
                        
                        ldx #BB_IrqSubID_LevelStart       ; 
                        jmp SetIrqDispatchSubID           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MainLoopGameOver      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MainLoopGameOver        subroutine                        ; 
                        ldx #BB_IrqSubID_GameOver         ; 
                        stx __IrqDispatchSubID            ; 
                        
MainLoopWaitGameOver    bne MainLoopWaitGameOver          ; wait to be dispatched
; -------------------------------------------------------------------------------------------------------------- ;
; IrqDispatch_S09       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IrqDis_GameOver         subroutine                        ; 
                        lda #BBZ_MelodyTypeGameOver       ; 
                        jsr ShowInfoScreen                ; 
                        jsr WaitTunesEnd                  ; 
                        
.SetLooseLife           sta BBZ_PlayerLooseLife           ; BBZ_PlayerLooseLifeYes
                        
                        jsr SecretMsg                     ; 
                        
                        ldx #$00                          ; 
                        
                        lda #>BB_WA_Scores                ; 
.SetScorePtrHi          sta BBZ_PlayerScorePtrHi          ; 
                        
                        lda #<BB_WA_Scores_P1             ; preset
                        
                        ldy BBZ_ActivePlayer              ; 
                        bmi .SetScorePtrLo                ; player 1
                        
                        lda #<BB_WA_Scores_P2             ; 
                        
.SetScorePtrLo          sta BBZ_PlayerScorePtrLo          ; 
                        
.IniScoreEntryOff       ldy #$00                          ; 
                        stx BBZ_ScorerTableOff            ; 
                        
.GetNextScoreByte       lda [BB_WA_Score + BB_WA_ScoreNameLen],x ; score behind name
                        beq .ChkScores                    ; 
                        
                        sec                               ; 
                        sbc #$10                          ; 
                        
.ChkScores              cmp (BBZ_PlayerScorePtr),y        ; 
                        bcc .CopyScorerNameIni            ; 
                        bne .SetNextEntry                 ; 
                        
                        inx                               ; 
                        
                        iny                               ; 
                        cpy #$07                          ; 
                        bcc .GetNextScoreByte             ; 
                        
.SetNextEntry           lda BBZ_ScorerTableOff            ; 
                        clc                               ; 
                        adc #BB_WA_ScoreEntryLen          ; 
                        tax                               ; 
                        cpx #BB_WA_Score_Len              ; 
                        bcc .IniScoreEntryOff             ; lower
                        bcs SetNextPlayer                 ; higher/equal - end of table reached
                        
.CopyScorerNameIni      ldx #Text_IntroBoardLen           ; 
.CopyScorerName         lda [BB_WA_ScoreName - $01],x     ; 
                        sta [BB_IntroBoardTxtRnd - $01],x ; 
                        dex                               ; 
                        bne .CopyScorerName               ; 
                        
                        lda #BB_WA_Score_Len              ; 
                        sec                               ; 
                        sbc BBZ_ScorerTableOff            ; 
                        tax                               ; 
                        
                        ldy #[BB_WA_Score_Len - $01]      ; 10 entries of $0e bytes
.MoveEntriesDown        lda BB_WA_Score,y                 ; 
                        sta [BB_WA_Score + BB_WA_ScoreEntryLen],y ; 
                        dey                               ; 
                        dex                               ; 
                        bne .MoveEntriesDown              ; 
                        
                        txa                               ; 
                        sta BBZ_ScorerTableOffWrk         ; 
                        
                        ldx BBZ_ScorerTableOff            ; 
                        tay                               ; 
                        
.ClrOldSetNewEntry      lda #$00                          ; 
                        sta BB_WA_Score,x                 ; 
                        sta BB_IntroBoardBirdName,y       ; 
                        
                        lda (BBZ_PlayerScorePtr),y        ; 
                        bne .SetNextEntryData             ; 
                        
                        cmp BBZ_ScorerTableOffWrk         ; 
                        beq .SetNewScore                  ; 
                        
.SetNextEntryData       inc BBZ_ScorerTableOffWrk         ; 
                        
                        clc                               ; 
                        adc #$10                          ; "0" - make digit
                        
.SetNewScore            sta [BB_WA_Score + BB_WA_ScoreNameLen],x ; score behind name
                        sta BB_IntroBoardBirdScore,y      ; 
                        
                        inx                               ; 
                        iny                               ; 
                        cpy #BB_WA_ScoreNameLen           ; 
                        bcc .ClrOldSetNewEntry            ; lower
                        
                        ldx #$02                          ; leave out D6510 and R6510
.SaveZeroPage           lda D6510,x                       ; 
                        sta BB_SaveZeroPageGame,x         ; 
                        inx                               ; 
                        bne .SaveZeroPage                 ; 
                        
                        ldx #BB_IrqSubID_EnterScorer      ; 
SetIrqDispatchSubID     stx __IrqDispatchSubID            ; 
                        
IrqDis_GameOverX        jmp IrqDis_GameOverX              ; wait to be dispatched
; -------------------------------------------------------------------------------------------------------------- ;
; IrqDispatch_S03       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IrqDis_SwapPlayers      subroutine                        ; 
                        jsr InitVicSid                    ; 
                        
                        ldx #>[BB_Scrn_HiRes + BB_Scrn_HiResRowLen] ; start value hi - leave out status row
                        lda #<[BB_Scrn_HiRes + BB_Scrn_HiResRowLen] ; start value lo
                        jsr InitHiResTabGame              ; 
                        
                        ldx #$02                          ; leave out D6510 and R6510
.RestoreZeroPage        lda BB_SaveZeroPageGame,x         ; 
                        sta D6510,x                       ; 
                        inx                               ; 
                        bne .RestoreZeroPage              ; 
                        
                        ldx #BBZ_PlayerGameDataP2         ; 
                        stx BBZ_PlayerGameDataPtr         ; 
                        jsr SwapPlayerGameData            ; 
                        
                        ldx #$08                          ; 
IrqDis_SwapPlayersX     jmp IrqDis_LevelStart             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetNextPlayer         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetNextPlayer           subroutine                        ; 
                        lda GameOptsPlayers               ; 
                        beq GetIrqNoShowScores            ; one playes game
                        
                        jsr SwapPlayerGameData            ; 
                        jsr GetActPlayerLives             ; 
                        beq GetIrqNoShowScores            ; dead
                        
                        ldx #BB_IrqSubID_LevelStart       ; 
GetIrqNoShowScoresX     jmp SetIrqDispatchSubID           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetIrqNoShowScores    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetIrqNoShowScores      subroutine                        ; 
                        ldx #BB_IrqSubID_ShowScores       ; 
                        jmp SetIrqDispatchSubID           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; WaitTunesEnd          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
WaitTunesEnd            subroutine                        ; 
.WaitRaster             jsr WaitRaster_0c                 ; 
                        
                        lda BB_LevelStartTuneBuf_1        ; 
                        bne .WaitRaster                   ; 
                        
                        lda BBZ_TimeInfoScreen            ; 
                        bne .WaitRaster                   ; 
                        
                        ldx #$18                          ; 
                        lda #$00                          ; 
.InitSID                sta SID,x                         ; SID($D400) Oscillator 1 Freq Ctrl (low byte)
                        sta BB_SaveSidRegs,x              ; 
                        
                        dex                               ; 
                        bpl .InitSID                      ; 
                        
                        jsr InitVoice3                    ; 
                        
                        lda #$8f                          ; 
                        sta SIGVOL                        ; SID($D418) Volume/Filter Select
                        
.InitSCROLY             lda #[$00 & VIC_RasterHi_Off & VIC_ECM_Off & VIC_BMM_Off & VIC_Screen_Off & VIC_Rows24 & VIC_SoftY_Clear] ; 
                        
WaitTunesEndX           rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetActPlayerLives     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetActPlayerLives       subroutine                        ; 
                        ldx BBZ_ActivePlayer              ; 
                        bmi .GetLivesP1                   ; player 1
                        
.GetLivesP2             lda BB_LivesNo_P2                 ; 
                        
.Exit                   rts                               ; 
                        
.GetLivesP1             lda BB_LivesNo_P1                 ; 
                        
GetActPlayerLivesX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabLevelZeroPageIni     dc.b BBZ_CheatKeyValue            ; 
                        dc.b BBZ_ToneTypeHight            ; 
                        dc.b BBZ_SfxSusRel                ; 
                        dc.b BBZ_SpecialSfxTime           ; 
                        dc.b BBZ_TubeStatus               ; 
                        dc.b BBZ_BobOnFloorNo             ; 
                        dc.b BBZ_BobMoveFoodBarTime       ; 
                        dc.b BBZ_XmitFlipFlopPos          ; 
                        dc.b BBZ_BobXmitTime              ; 
                        dc.b BBZ_GamePause                ; 
                        dc.b BBZ_EnemyFlipFlag            ; 
                        dc.b BBZ_EnemyGoodTimeBlink       ; 
                        dc.b BBZ_EnemyGoodTime            ; 
                        dc.b BBZ_NotUsed_f5               ; 
                        dc.b BBZ_ScoreToAddItem           ; 
                        dc.b BBZ_ScoreToAddEnemyAc        ; 
                        dc.b BBZ_ScoreToAddEnemy          ; 
                        dc.b BBZ_ScoreToAddFloor          ; 
                        dc.b BBZ_EnemyState               ; 
                        dc.b BBZ_BobMoveType              ; 
                        dc.b BBZ_TonePingSusRel           ; 
                        dc.b BBZ_BobSpriteNo              ; 
                        dc.b BBZ_XmitActive               ; 
                        
TabLevelZeroPageIniX    dc.b $00 ; end of BBZ_Data
; -------------------------------------------------------------------------------------------------------------- ;
TabMasterCheat          dc.b $28 ; h
                        dc.b $2c ; l
                        dc.b $2c ; l
                        dc.b $29 ; i
                        dc.b $22 ; b
; -------------------------------------------------------------------------------------------------------------- ;
; SwapPlayerGameData    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SwapPlayerGameData      subroutine                        ; 
                        lda #BBZ_GamePauseOn              ; 
                        sta BBZ_GamePause                 ; 
                        
                        lda BBZ_LevelNumEquiv             ; 
                        ldx BB_LevelNumEquiv              ; 
                        stx BBZ_LevelNumEquiv             ; 
                        sta BB_LevelNumEquiv              ; 
                        
                        lda BBZ_FloorPiecesFlipped        ; 
                        ldx BB_FloorPiecesFlipped         ; 
                        stx BBZ_FloorPiecesFlipped        ; 
                        sta BB_FloorPiecesFlipped         ; 
                        
                        ldy #BB_FloorStatusPlayLen        ; 
.SwapArea01             lda [BB_FloorStatusPlay - $01],y  ; 
                        ldx [BB_FloorStatusSwap - $01],y  ; 
                        sta [BB_FloorStatusSwap - $01],y  ; 
                        txa                               ; 
                        sta [BB_FloorStatusPlay - $01],y  ; 
                        
                        dey                               ; 
                        bne .SwapArea01                   ; 
                        
                        ldy #BB_SpriteStatusPlayLen       ; 
.SwapArea02             lda [BB_SpriteStatusPlay - $01],y ; 
                        ldx [BB_SpriteStatusSwap - $01],y ; 
                        sta [BB_SpriteStatusSwap - $01],y ; 
                        txa                               ; 
                        sta [BB_SpriteStatusPlay - $01],y ; 
                        
                        dey                               ; 
                        bne .SwapArea02                   ; 
                        
                        lda BBZ_ActivePlayer              ; 
                        eor #BBZ_ActivePlayer_01          ; flip players
                        sta BBZ_ActivePlayer              ; 
                        
SwapPlayerGameDataX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckShowScores       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckShowScores         subroutine                        ; 
                        lda BBZ_GameDemoMode              ; 
                        beq SwapPlayerGameDataX           ; BBZ_GameDemoModeOff
                        
CheckShowScoresX        jmp GetIrqNoShowScores            ; show scores at end of demo
; -------------------------------------------------------------------------------------------------------------- ;
TabLevelTime            equ [* - 1] ; 
                        dc.b $25 ; $01 - level 21 - 2500 Rest Stop # 2
                        dc.b $95 ; $02 - level 25 - 9500 The Floating Transporter
                        dc.b $85 ; $03 - level 06 - 8500 The Grain Elevator
                        dc.b $85 ; $04 - level 10 - 8500 The Gravity Lift
                        dc.b $50 ; $05 - level 03 - 5000 The Suction Tubes
                        dc.b $30 ; $06 - level 17 - 3000 Bonus Level # 2
                        dc.b $50 ; $07 - level 18 - 5000 Super Energy Food Bars
                        dc.b $85 ; $08 - level 14 - 8500 Hydraulic Lifts
                        dc.b $70 ; $09 - level 20 - 7000 Mobile Suction Unit
                        dc.b $82 ; $0a - level 19 - 8200 The Sliding Candelabra
                        dc.b $50 ; $0b - level 05 - 5000 Jumping 101
                        dc.b $50 ; $0c - level 02 - 5000 Utility Hoist
                        dc.b $30 ; $0d - level 09 - 3000 Bonus Level # 1
                        dc.b $55 ; $0e - level 15 - 5500 Yukon's Revenge
                        dc.b $88 ; $0f - level 08 - 8800 Luxury Transporters
                        dc.b $80 ; $10 - level 22 - 8000 Advanced Cannon
                        dc.b $36 ; $11 - level 13 - 3600 Rest Stop # 1
                        dc.b $25 ; $12 - level 01 - 2500 Bob's Morning Calisthenics
                        dc.b $70 ; $13 - level 11 - 7000 The Super Slippery Slide
                        dc.b $60 ; $14 - level 12 - 6000 Acid Rain
                        dc.b $50 ; $15 - level 23 - 5000 Advanced Pulverizors
                        dc.b $40 ; $16 - level 04 - 4000 Bob's Playroom
                        dc.b $40 ; $17 - level 07 - 4000 Yukon's Penthouse
                        dc.b $60 ; $18 - level 16 - 6000 The Advanced Suction Tubes
                        dc.b $75 ; $19 - level 24 - 7500 Mutants On The Move
; -------------------------------------------------------------------------------------------------------------- ;
; InitLevelRestart      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitLevelRestart        subroutine                        ; 
                        ldx #BBZ_GamePauseOn              ; 
                        stx BBZ_GamePause                 ; 
                        jsr FloorTileDataInit             ; 
                        
.ChkFloorsCount         cpx BBZ_CountFloorsFlows          ; floors and flow tiles
                        beq .DrawLastLine                 ; 
                        
                        inx                               ; 
                        lda [BB_WA_FloorTileNum - $01],x  ; 
                        bmi .ChkFloorsCount               ; 
                        
                        lda [BB_WA_FloorMinX - $01],x     ; 
                        sta BBZ_DrawFloorMinX             ; 
                        
                        lda [BB_WA_FloorMaxX - $01],x     ; 
                        sec                               ; 
                        sbc BBZ_DrawFloorMinX             ; 
                        lsr a                             ; /2
                        lsr a                             ; /4 - tile width
                        sta BBZ_DrawFloorLen              ; 
                        
                        stx BBZ_DrawFloorWAOff            ; 
                        
.NextFloorTile          lda BBZ_DrawFloorMinX             ; 
                        jsr BobMoveFillFloorIni           ; 
                        
.SetFilled              sec                               ; preset
                        
                        beq .GoGetNextFloorPart           ; 
                        
.SetUnFilled            clc                               ; 
                        
.GoGetNextFloorPart     jsr GetNextFloorPart              ; 
                        
.SetNextFloorTile       lda BBZ_DrawFloorMinX             ; 
                        clc                               ; 
                        adc #$04                          ; 
                        sta BBZ_DrawFloorMinX             ; 
                        
                        ldx BBZ_DrawFloorWAOff            ; 
                        
                        dec BBZ_DrawFloorLen              ; 
                        bne .NextFloorTile                ; 
                        beq .ChkFloorsCount               ; 
                        
.GoGetLastFloorPart     jsr GetNextFloorPart              ; 
                        
.DrawLastLine           lda BBZ_FloorTileHight            ; 
                        cmp #$07                          ; 
                        bcc .GoGetLastFloorPart           ; lower
                        
                        ldy GameOptsDifficulty            ; 
                        cpy #$02                          ; 
                        bcs .GetNextSpriteIni             ; greater/equal
                        
                        ldy #$00                          ; 
                        
.GetNextSpriteIni       ldx #[BB_WA_Sprite_Max * $02]     ; both areas
.GetNextSprite          lda [BB_WA_SpriteNumberA - $01],x ; 
                        cmp #$10                          ; 
                        tya                               ; 
                        bcs .MarkPlayerData               ; greater/equal
                        
                        ora [BB_WA_SpritePosX - $01],x    ; 
                        
.MarkPlayerData         sta [BB_SpriteStatusPlay - $01],x ; 
                        dex                               ; 
                        bne .GetNextSprite                ; 
                        
InitLevelRestartX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetNextFloorPart      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetNextFloorPart        subroutine                        ; 
                        ldx BBZ_FloorTileDataPtr          ; 
                        rol BB_FloorStatusPlay,x          ; 
                        dec BBZ_FloorTileHight            ; 
                        bpl GetNextFloorPartX             ; 
                        
.SetNextFloorTile       inc BBZ_FloorTileDataPtr          ; 
                        
                        lda #$07                          ; 
                        sta BBZ_FloorTileHight            ; 
                        
GetNextFloorPartX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SecretMsg             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SecretMsg               subroutine                        ; 
                        jsr CheckLevelSelect              ; 
                        beq .ExitSecretMsgNone            ; code '7/7' found - no messages anymore
                        
                        jsr GetLevelNumber                ; yr=level number
                        
.GetSecMsgLevelCount    ldx #TabSecMsgLevelActionLen      ; max no of secret messages
                        tya                               ; 
.ChkNextSecMsgLevelNum  cmp TabSecMsgLevelSolvedNum,x     ; the level number which has to be reached for a secret message
                        bcs .GetActivePlayer              ; 
                        
.DecSecMsgLevelCount    dex                               ; 
                        bne .ChkNextSecMsgLevelNum        ; 
                        
.ExitSecretMsgNone      rts                               ; 
                        
.GetActivePlayer        lda BBZ_ActivePlayer              ; 
                        bpl .ChkSecretMsg_P2              ; player 2
                        
.ChkSecretMsg_P1        cpx BB_SecMsgLevelMax_P1          ; player 1
                        jmp .ExitSecretMsg_Same           ; 
                        
.ChkSecretMsg_P2        cpx BB_SecMsgLevelMax_P2          ; 
.ExitSecretMsg_Same     beq .ExitSecretMsgNone            ; 
.ExitSecretMsg_Lower    bcc .ExitSecretMsgNone            ; lower
                        
.WasSecretMsg_Higher    lda GameOptsSecMsg                ; greater than the last secret message 
                        bne .ExitSecretMsgNone            ; 
                        
                        jsr ResetKeyPressed               ; $05 -> $17 $18
                        
                        lda TabSecMsgLevelActionNum,x     ; the level number where the action takes place
                        sta BBZ_SecMsgLevelAction         ; 
                        lda TabSecMsgLevelSolvedNum,x     ; the level number which has to be reached for a secret message
                        sta BBZ_SecMsgLevelSolved         ; 
                        
.DecSecMsgNum           dex                               ; msg number
                        txa                               ; 
.IncSecMsgNum           inx                               ; 
                        
                        lsr a                             ; shift out rightmost msg num bit
                        tay                               ; 
                        lda TabSecMsgTextVarNum,y         ; 
                        bcs .GetVarNumPart_Left           ; 
                        
.GetVarNumPart_Right    lsr a                             ; .oooo...
                        lsr a                             ; ..oooo..
                        lsr a                             ; ...oooo.
                        lsr a                             ; ....oooo
                        
.GetVarNumPart_Left     and #$0f                          ; ....####
                        clc                               ; 
                        adc #$11                          ; "1"
                        sta BBZ_SecMsgNumChar             ; 
                        stx BBZ_SecMsgNumBin              ; 
                        
.IniSecMsgText_Header   lda #<BB_Scrn_InfoSecMsgHeader    ; 
                        sta BBZ_DrawPosY                  ; 
                        lda #>BB_Scrn_InfoSecMsgHeader    ; 
                        sta BBZ_DrawPosX                  ; 
                        lda #$00                          ; 
                        sta BBZ_SecMsgCharCount           ; 
                        
                        lda #<SecMsg_4TheAdvanced         ; 
                        ldx #>SecMsg_4TheAdvanced         ; 
                        jsr SecretTextFix                 ; secret message - header
                        
.IniSecMsgText_Message  lda #<BB_Scrn_InfoSecMsgText      ; 
                        sta BBZ_DrawPosY                  ; 
                        lda #>BB_Scrn_InfoSecMsgText      ; 
                        sta BBZ_DrawPosX                  ; 
                        lda #$00                          ; 
                        sta BBZ_SecMsgCharCount           ; 
                        
                        lda #<SecMsg_InLevel              ; 
                        ldx #>SecMsg_InLevel              ; 
                        jsr SecretTextFix                 ; "in level 1,"
                        
                        lda BBZ_SecMsgNumBin              ; 
                        clc                               ; 
                        adc #$05                          ; 
                        jsr SecretTextVar                 ; 
                        
                        lda #<SecMsg_AfterGetItem         ; 
                        ldx #>SecMsg_AfterGetItem         ; 
                        jsr SecretTextFix                 ; "immmediately after picking <nl> up the
                        
                        ldx BBZ_SecMsgNumBin              ; 
                        dex                               ; 
                        txa                               ; 
                        jsr SecretTextVar                 ; "flower pot,"
                        
                        lda #<SecMsg_TypeNoAndF7          ; 
                        ldx #>SecMsg_TypeNoAndF7          ; 
                        jsr SecretTextFix                 ; "type the number 1 <nl> on the keyboard ..."
                        
                        ldy #$32                          ; 
                        sty BBZ_SecMsgNumChar             ; 
                        
.GoWaitBeam             jsr WaitRaster_0c                 ; 
                        jsr GetKeyPressed                 ; in BBZ_KeyPressed
                        
                        dec BBZ_SecMsgNumBin              ; 
                        bne .GoChkJoystick                ; 
                        
                        lda #$32                          ; 
                        sta BBZ_SecMsgNumBin              ; 
                        
                        dec BBZ_SecMsgNumChar             ; 
                        beq SecretMsgPrepExit             ; 
                        
.GoChkJoystick          jsr CheckJoystick                 ; 
                        bcs .GoWaitBeam                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SecretMsgPrepExit     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SecretMsgPrepExit       subroutine                        ; 
                        lda #$00                          ; 
                        sta BBZ_LevelColor_01             ; 
                        
SecretMsgX              rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckLevelSelect      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckLevelSelect        subroutine                        ; 
                        lda BB_LevelSelectCode_01         ; 
                        cmp #$37                          ; '7'
                        bne CheckLevelSelectX             ; 
                        
                        cmp BB_LevelSelectCode_03         ; '7'
                        bne CheckLevelSelectX             ; 
                        
                        lda BB_LevelSelectCode_02         ; '/'
                        sbc #$2f                          ; 
                        
CheckLevelSelectX       rts                               ; $00 if tests were successful
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveHandler        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveHandler          subroutine                        ; 
                        lda BBZ_BobMoveFoodBarTime        ; 
                        beq .GetMove                      ; 
                        
                        dec BBZ_BobMoveFoodBarTime        ; 
                        
.GetMove                ldx BBZ_BobMoveType               ; 
                        
                        lda TabBobMoveSubPtrLo,x          ; 
                        sta BBZ_BobMoveSubPtrLo           ; 
                        
                        lda TabBobMoveSubPtrHi,x          ; 
                        sta BBZ_BobMoveSubPtrHi           ; 
                        
BobMoveHandlerX         jmp (BBZ_BobMoveSubPtr)           ; 
; -------------------------------------------------------------------------------------------------------------- ;
WrkMelodyCtrlWait       dc.b $02 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyCtrlWait        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyCtrlWait          subroutine                        ; 
                        dec WrkMelodyCtrlWait             ; 
                        bne MelodyCtrlRestoreX            ; rts
                        
.__GetWaitValue         equ [* + $01]                     ; 
                        lda #$01                          ; 
                        eor #$03                          ; 
                        sta .__GetWaitValue               ; 
MelodyCtrlWaitX         sta WrkMelodyCtrlWait             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyCtrlRestore     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyCtrlRestore       subroutine                        ; 
                        ldx #$02                          ; 
                        stx BBZ_MelodyVoiceNo             ; 
                        
.IniStartTune           jsr GetLvlStartTuneBufOff         ; 
                        
.CtrlDataRestore        lda BB_LevelStartTuneBuf,y        ; 
                        sta BBZ_Melody,x                  ; 
                        dey                               ; 
                        dex                               ; 
                        bpl .CtrlDataRestore              ; 
                        
                        jsr MelodyCheckEOD                ; 
                        jsr MelodyCtrlSave                ; 
                        
                        dec BBZ_MelodyVoiceNo             ; 
                        bpl .IniStartTune                 ; 
                        
MelodyCtrlRestoreX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSidOscOff            dc.b <FRELO1 ; Registers Oscillator 1
                        dc.b <FRELO2 ; Registers Oscillator 2
                        dc.b <FRELO3 ; Registers Oscillator 3
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyCheckEOD        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyCheckEOD          subroutine                        ; 
                        lda BBZ_MelodyVocDataEOD          ; 
                        bne .MelodyDecWait                ; 
                        
.Exit                   rts                               ; 
                        
.MelodyDecWait          dec BBZ_MelodyVocWait             ; 
                        beq MelodyCopy                    ; 
                        
MelodyCheckEODX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyCopy            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyCopy              subroutine                        ; 
.GetNextVoiceNo         ldy BBZ_MelodyVoiceNo             ; 
                        ldx TabSidOscOff,y                ; Registers Oscillator 1-3
                        
                        ldy BBZ_MelodyCtrlOff             ; 
                        lda (BBZ_MelodyCtrlPtr),y         ; 
                        cmp #$ff                          ; $FF = EOD_01
                        bne MelodyPlayNext                ; 
                        
                        iny                               ; 
                        cmp (BBZ_MelodyCtrlPtr),y         ; $FF = EOD_02
                        bne MelodyPlayNext                ; 
                        
                        lda BBZ_MelodyVocTime             ; 
                        beq .SetNext                      ; 
                        
                        dec BBZ_MelodyVocTime             ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_MelodyCtrlOff             ; 
                        
                        jmp .GetNextVoiceNo               ; 
                        
.SetNext                ldy BBZ_MelodyVocDataOff          ; 
                        iny                               ; 
                        iny                               ; 
                        iny                               ; 
                        sty BBZ_MelodyVocDataOff          ; 
                        
                        lda (BBZ_MelodyVocDataPtr),y      ; 
                        cmp #$ff                          ; 
                        bne MelodyPlay                    ; 
                        
                        iny                               ; 
                        cmp (BBZ_MelodyVocDataPtr),y      ; 
                        bne MelodyPlayIni                 ; 
                        
                        lda #$00                          ; 
                        sta BBZ_MelodyVocDataEOD          ; 
                        
                        ldy BBZ_MelodyVoiceNo             ; 
                        cmp WrkSids,y                     ; 
                        beq MelodyCopyX                   ; 
                        
                        sta WrkSids,y                     ; 
                        sta SUREL1,x                      ; SID($D406) Oscillator 1 Sustain/Release
                        sta BB_SaveSid_SUREL1,x           ; 
                        
MelodyCopyX             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyPlay            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyPlayIni           subroutine                        ; 
                        dey                               ; 
MelodyPlay              sta BBZ_MelodyCtrlPtrLo           ; 
                        
                        iny                               ; 
                        lda (BBZ_MelodyVocDataPtr),y      ; 
                        sta BBZ_MelodyCtrlPtrHi           ; 
                        
                        iny                               ; 
                        lda (BBZ_MelodyVocDataPtr),y      ; 
                        sta BBZ_MelodyVocTime             ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_MelodyCtrlOff             ; 
                        
                        iny                               ; 
                        sty BBZ_MelodyVocWait             ; 
                        
MelodyPlayX             jmp MelodyCheckEOD                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyPlayNext        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyPlayNext          subroutine                        ; 
                        ldy BBZ_MelodyCtrlOff             ; 
                        lda (BBZ_MelodyCtrlPtr),y         ; 
                        sta BBZ_MelodyVocWait             ; 
                        
                        iny                               ; 
                        lda (BBZ_MelodyCtrlPtr),y         ; 
                        bne .PresetVoiceVal               ; 
                        
                        sta SUREL1,x                      ; $00 - SID($D406) Oscillator 1 Sustain/Release
                        sta BB_SaveSid_SUREL1,x           ; 
                        beq .SetNextPair                  ; always
                        
.PresetVoiceVal         ldx #$4f                          ; 
                        
                        ldy BBZ_MelodyVoiceNo             ; 
                        cpy #$02                          ; 
                        bne .SaveXR                       ; 
                        
                        ldx #$8f                          ; 
                        lda #$40                          ; 
                        
.SaveXR                 stx .__SaveXR                     ; 
                        
                        ldx BBZ_MelodyVoiceNo             ; 
                        
                        pha                               ; 
                        lda #$01                          ; 
                        sta WrkSids,x                     ; 
                        pla                               ; Oscillator Frequency Tab Offset
                        
                        ldy TabSidOscOff,x                ; Oscillator SID Offset
.__SaveXR               equ [* + $01]                     ; 
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffectsPlay              ; 
                        
.SetNextPair            inc BBZ_MelodyCtrlOff             ; 
                        inc BBZ_MelodyCtrlOff             ; 
                        
MelodyPlayNextX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
WrkSids                 equ  *
WrkSid_01               dc.b $00 ; 
WrkSid_02               dc.b $00 ; 
WrkSid_03               dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetMelodies           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetMelodies             subroutine                        ; 
                        sta BBZ_MelodyDataPtrLo           ; 
                        sty BBZ_MelodyDataPtrHi           ; 
                        
                        lda GameOptsVolume                ; 
                        sta SIGVOL                        ; SID($D418) Volume/Filter Select
                        beq MelodyPlayNextX               ; rts
                        
                        ldx #$02                          ; 
                        stx BBZ_MelodyVoiceNo             ; 
                        
.SetAmount              lda #$fd                          ; 
                        sta BBZ_MelodyVocDataOff          ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_MelodyCtrlOff             ; 
                        sty BBZ_MelodyVocTime             ; 
                        
                        iny                               ; $01
                        sty BBZ_MelodyVocDataEOD          ; 
                        sty BBZ_MelodyVocWait             ; 
                        
                        lda #<[TabMelodyCtrl - $02]       ; $7d
                        sta BBZ_MelodyCtrlPtrLo           ; 
                        lda #>[TabMelodyCtrl - $02]       ; $5d
                        sta BBZ_MelodyCtrlPtrHi           ; 
                        
                        lda BBZ_MelodyVoiceNo             ; 
                        asl a                             ; 
                        tay                               ; 
                        lda (BBZ_MelodyDataPtr),y         ; 
                        sta BBZ_MelodyVocDataPtrLo        ; 
                        
                        iny                               ; 
                        lda (BBZ_MelodyDataPtr),y         ; 
                        sta BBZ_MelodyVocDataPtrHi        ; 
                        
                        jsr MelodyCtrlSave                ; 
                        
                        dec BBZ_MelodyVoiceNo             ; 
                        bpl .SetAmount                    ; 
                        
SetMelodiesX            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GetLvlStartTuneBufOff Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetLvlStartTuneBufOff   subroutine                        ; 
                        ldx BBZ_MelodyVoiceNo             ; 
                        ldy TabLvlStrtTunBufOff,x         ; 
                        ldx #[BB_LevelStartTuneBufLen - $01] ; 
                        
                        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabLvlStrtTunBufOff     dc.b [BB_LevelStartTuneBufLen * $01 - $01] ; $08
                        dc.b [BB_LevelStartTuneBufLen * $02 - $01] ; $11
                        dc.b [BB_LevelStartTuneBufLen * $03 - $01] ; $1a
; -------------------------------------------------------------------------------------------------------------- ;
; MelodyCtrlSave        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
MelodyCtrlSave          subroutine                        ; 
                        jsr GetLvlStartTuneBufOff         ; 
                        
.CtrlDataSave           lda BBZ_Melody,x                  ; 
                        sta BB_LevelStartTuneBuf,y        ; 
                        dey                               ; 
                        dex                               ; 
                        bpl .CtrlDataSave                 ; 
                        
MelodyCtrlSaveX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabInitMelody_01        dc.w TabInitMelodyPtr_01    ; 
                        dc.w TabInitMelody_EoD      ; 
                        dc.w TabInitMelody_EoD      ; 
                        
TabInitMelodyPtr_01     dc.w TabInitMelody_01_Data  ; 
                        dc.b $00                    ; 
                        
                        dc.w $ffff                  ; End of Data
                        
TabInitMelody_01_Data   dc.b $0b ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $60 ; 
                        dc.b $10 ; 
                        dc.b $51 ; 
                        dc.b $10 ; 
                        dc.b $3c ; 
                        dc.b $0b ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $60 ; 
                        dc.b $10 ; 
                        dc.b $51 ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
TabInitMelody_02        dc.w TabInitMelodyPtr_02    ; 
                        dc.w TabInitMelody_EoD      ; 
                        dc.w TabInitMelody_EoD      ; 
                        
TabInitMelodyPtr_02     dc.w TabInitMelody_02_Data  ; 
                        dc.b $00                    ; 
                        
                        dc.w $ffff                  ; End of Data
                        
TabInitMelody_02_Data   dc.b $0b ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $79 ; 
                        dc.b $08 ; 
                        dc.b $51 ; 
                        dc.b $08 ; 
                        dc.b $60 ; 
                        dc.b $08 ; 
                        dc.b $51 ; 
                        dc.b $08 ; 
                        dc.b $3c ; 
                        dc.b $10 ; 
                        dc.b $51 ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
TabInitMelody_03        dc.w TabInitMelodyPtr_03    ; 
                        dc.w TabInitMelody_EoD      ; 
                        dc.w TabInitMelody_EoD      ; 
                        
TabInitMelodyPtr_03     dc.w TabInitMelody_03_Data  ; 
                        dc.b $00                    ; 
                        
                        dc.w $ffff                  ; End of Data
                        
TabInitMelody_03_Data   dc.b $0b ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $79 ; 
                        dc.b $08 ; 
                        dc.b $51 ; 
                        dc.b $08 ; 
                        dc.b $5b ; 
                        dc.b $08 ; 
                        dc.b $60 ; 
                        dc.b $08 ; 
                        dc.b $6c ; 
                        dc.b $10 ; 
                        dc.b $3c ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
TabInitMelody_04        dc.w TabInitMelodyPtr_04    ; 
                        dc.w TabInitMelody_EoD      ; 
                        dc.w TabInitMelody_EoD      ; 
                        
TabInitMelodyPtr_04     dc.w TabInitMelody_04_Data  ; 
                        dc.b $00                    ; 
                        
                        dc.w $ffff                  ; End of Data
                        
TabInitMelody_04_Data   dc.b $0b ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $79 ; 
                        dc.b $04 ; 
                        dc.b $51 ; 
                        dc.b $04 ; 
                        dc.b $60 ; 
                        dc.b $04 ; 
                        dc.b $51 ; 
                        dc.b $04 ; 
                        dc.b $60 ; 
                        dc.b $20 ; 
                        dc.b $3c ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
TabMelodyGameOver       dc.w TabMelodyGameOverPtr_1  ; 
                        dc.w TabMelodyGameOverPtr_2  ; 
                        dc.w TabMelodyGameOverPtr_3  ; 
                        
TabMelodyGameOverPtr_3  dc.w TabMelodyGameOverDat_01 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $14                     ; 
                        dc.w TabMelodyGameOverDat_01 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $14                     ; 
                        dc.w TabMelodyGameOverDat_01 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $14                     ; 
                        dc.w TabMelodyGameOverDat_01 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $14                     ; 
                        
                        dc.w $ffff                   ; End of Data
                        
TabMelodyGameOverDat_01 dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $04 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $04 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff                   ; End of Data
                        
TabMelodyGameOverPtr_2  dc.w TabMelodyGameOverDat_02 ; 
                        dc.b $03                     ; 
                        
                        dc.w $ffff                   ; End of Data
                        
TabMelodyGameOverDat_02 dc.b $0c ; 
                        dc.b $f3 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $10 ; 
                        dc.b $a2 ; 
                        dc.b $10 ; 
                        dc.b $b6 ; 
                        dc.b $0b ; 
                        dc.b $a2 ; 
                        
                        dc.w $ffff                   ; End of Data
                        
TabMelodyGameOverPtr_1  dc.w TabMelodyGameOverDat_03 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_04 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_03 ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_05 ; 
                        dc.b $00                     ; 
                        
                        dc.w $ffff                   ; End of Data
                        
TabMelodyGameOverDat_03 dc.b $0a ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $29 ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyGameOverDat_04 dc.b $04 ; 
                        dc.b $4c ; 
                        dc.b $04 ; 
                        dc.b $51 ; 
                        dc.b $04 ; 
                        dc.b $4c ; 
                        dc.b $2c ; 
                        dc.b $51 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyGameOverDat_05 dc.b $04 ; 
                        dc.b $4c ; 
                        dc.b $04 ; 
                        dc.b $51 ; 
                        dc.b $04 ; 
                        dc.b $4c ; 
                        dc.b $2c ; 
                        dc.b $79 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyGameOverDat_06 dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
TabMelodyScore          dc.w TabMelodyScore_Ptr_1  ; 
                        dc.w TabMelodyScore_Ptr_2  ; 
                        dc.w TabMelodyScore_Ptr_3  ; 
                        
TabMelodyScore_Ptr_1    dc.w TabMelodyScoreData_11 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_12 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_13 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_12 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_14 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_12 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_13 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_15 ; 
                        dc.b $00                   ; 
                        
                        dc.w $ffff                 ; End of Data
                        
TabMelodyCtrl           equ  *                     ; 
TabMelodyScore_Ptr_2    dc.w TabMelodyScoreData_11 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_21 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_22 ; 
                        dc.b $01                   ; 
                        dc.w TabMelodyScoreData_21 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_21 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_23 ; 
                        dc.b $01                   ; 
                        dc.w TabMelodyScoreData_21 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_22 ; 
                        dc.b $01                   ; 
                        dc.w TabMelodyScoreData_21 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_21 ; 
                        dc.b $03                   ; 
                        dc.w TabMelodyScoreData_24 ; 
                        dc.b $00                   ; 
                        
                        dc.w $ffff                 ; End of Data
                        
TabMelodyScoreData_11   dc.b $20 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_12   dc.b $0f ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $07 ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $0f ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $10 ; 
                        dc.b $79 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_13   dc.b $10 ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $51 ; 
                        dc.b $04 ; 
                        dc.b $5b ; 
                        dc.b $1f ; 
                        dc.b $51 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_14   dc.b $10 ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $60 ; 
                        dc.b $04 ; 
                        dc.b $79 ; 
                        dc.b $20 ; 
                        dc.b $6c ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_15   dc.b $20 ; 
                        dc.b $51 ; 
                        dc.b $10 ; 
                        dc.b $79 ; 
                        dc.b $08 ; 
                        dc.b $5b ; 
                        dc.b $08 ; 
                        dc.b $60 ; 
                        dc.b $18 ; 
                        dc.b $6c ; 
                        dc.b $04 ; 
                        dc.b $79 ; 
                        dc.b $04 ; 
                        dc.b $00 ; 
                        dc.b $40 ; 
                        dc.b $79 ; 
                        
                        dc.w $ffff ; End of Data
                         
TabMelodyScoreData_21   dc.b $04 ; 
                        dc.b $3c ; 
                        dc.b $04 ; 
                        dc.b $28 ; 
                        dc.b $04 ; 
                        dc.b $2f ; 
                        dc.b $04 ; 
                        dc.b $28 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_22   dc.b $04 ; 
                        dc.b $3c ; 
                        dc.b $04 ; 
                        dc.b $23 ; 
                        dc.b $04 ; 
                        dc.b $2d ; 
                        dc.b $04 ; 
                        dc.b $23 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_23   dc.b $04 ; 
                        dc.b $3c ; 
                        dc.b $04 ; 
                        dc.b $28 ; 
                        dc.b $04 ; 
                        dc.b $2f ; 
                        dc.b $04 ; 
                        dc.b $35 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_24   dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $79 ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $79 ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $20 ; 
                        dc.b $f3 ; 
                        
TabInitMelody_EoD       dc.w $ffff ; End of Data
                        dc.w $ffff ; End of Data
                        dc.w $ffff ; End of Data
                        
TabMelodyScore_Ptr_3    dc.w TabMelodyScoreData_31 ; 
                        dc.b $01                   ; 
                        dc.w TabMelodyScoreData_33 ; 
                        dc.b $01                   ; 
                        dc.w TabMelodyScoreData_31 ; 
                        dc.b $00                   ; 
                        dc.w TabMelodyScoreData_34 ; 
                        dc.b $07                   ; 
                        
                        dc.w $ffff                 ; End of Data
                        
                        dc.w TabMelodyScoreData_32 ; 
                        dc.b $ff                   ; 
                        dc.w TabMelodyScoreData_32 ; 
                        dc.b $ff                   ; 
                        dc.w TabMelodyScoreData_32 ; 
                        dc.b $ff                   ; 
                        
                        dc.w $ffff                 ; End of Data
                        
TabMelodyScoreData_31   dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $10 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_32   dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $3c ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_33   dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabMelodyScoreData_34   dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $07 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
TabMelodyIntro          dc.w TabIntroScorePtr_3 ; 
                        dc.w TabIntroScorePtr_2 ; 
                        dc.w TabIntroScorePtr_1 ; 
                        
TabIntroScorePtr_1      dc.w TabIntroScoreData_14    ; 
                        dc.b $02                     ; 
                        dc.w TabIntroScoreData_13    ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $10                     ; 
                        dc.w TabIntroScoreData_14    ; 
                        dc.b $02                     ; 
                        dc.w TabIntroScoreData_13    ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $10                     ; 
                        dc.w TabIntroScoreData_12    ; 
                        dc.b $03                     ; 
                        dc.w TabIntroScoreData_11    ; 
                        dc.b $00                     ; 
                        dc.w TabIntroScoreData_14    ; 
                        dc.b $02                     ; 
                        dc.w TabIntroScoreData_13    ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $10                     ; 
                        dc.w TabIntroScoreData_14    ; 
                        dc.b $02                     ; 
                        dc.w TabIntroScoreData_13    ; 
                        dc.b $00                     ; 
                        dc.w TabMelodyGameOverDat_06 ; 
                        dc.b $10                     ; 
                        
                        dc.w $ffff                   ; End of Data
                        
TabIntroScoreData_11    dc.b $04 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_12    dc.b $04 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        
TabIntroScoreData_13    dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_14    dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $03 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        dc.b $01 ; 
                        dc.b $20 ; 
                        dc.b $0b ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScorePtr_2      dc.w TabIntroScoreData_24 ; 
                        dc.b $01                  ; 
                        dc.w TabIntroScoreData_22 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_24 ; 
                        dc.b $01                  ; 
                        dc.w TabIntroScoreData_23 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_21 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_24 ; 
                        dc.b $01                  ; 
                        dc.w TabIntroScoreData_22 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_24 ; 
                        dc.b $01                  ; 
                        dc.w TabIntroScoreData_23 ; 
                        dc.b $00                  ; 
                        
                        dc.w $ffff                ; End of Data
                        
TabIntroScoreData_21    dc.b $0c ; 
                        dc.b $79 ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $51 ; 
                        dc.b $18 ; 
                        dc.b $60 ; 
                        dc.b $0c ; 
                        dc.b $79 ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $24 ; 
                        dc.b $51 ; 
                        dc.b $0c ; 
                        dc.b $79 ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $51 ; 
                        dc.b $18 ; 
                        dc.b $60 ; 
                        dc.b $0c ; 
                        dc.b $79 ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $24 ; 
                        dc.b $51 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_22    dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $0c ; 
                        dc.b $b6 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $0c ; 
                        dc.b $c1 ; 
                        dc.b $07 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_23    dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $0c ; 
                        dc.b $b6 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $0c ; 
                        dc.b $c1 ; 
                        dc.b $07 ; 
                        dc.b $d9 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $08 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $f3 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_24    dc.b $18 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $a2 ; 
                        dc.b $09 ; 
                        dc.b $00 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScorePtr_3      dc.w TabIntroScoreData_31 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_32 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_33 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_31 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_32 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_34 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_35 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_36 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_35 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_37 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_31 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_32 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_33 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_31 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_32 ; 
                        dc.b $00                  ; 
                        dc.w TabIntroScoreData_34 ; 
                        dc.b $00                  ; 
                        
                        dc.w $ffff                ; End of Data
                        
TabIntroScoreData_31    dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $24 ; 
                        dc.b $51 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_32    dc.b $03 ; 
                        dc.b $48 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $48 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $5b ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $24 ; 
                        dc.b $51 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_33    dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $0c ; 
                        dc.b $51 ; 
                        dc.b $0c ; 
                        dc.b $5b ; 
                        dc.b $0c ; 
                        dc.b $60 ; 
                        dc.b $07 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $79 ; 
                        dc.b $24 ; 
                        dc.b $6c ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_34    dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $03 ; 
                        dc.b $79 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $0c ; 
                        dc.b $51 ; 
                        dc.b $0c ; 
                        dc.b $4c ; 
                        dc.b $0c ; 
                        dc.b $48 ; 
                        dc.b $07 ; 
                        dc.b $40 ; 
                        dc.b $01 ; 
                        dc.b $00 ; 
                        dc.b $04 ; 
                        dc.b $40 ; 
                        dc.b $24 ; 
                        dc.b $3c ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_35    dc.b $0c ; 
                        dc.b $f3 ; 
                        dc.b $0c ; 
                        dc.b $d9 ; 
                        dc.b $0c ; 
                        dc.b $90 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $0c ; 
                        dc.b $b6 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $18 ; 
                        dc.b $c1 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_36    dc.b $0c ; 
                        dc.b $f3 ; 
                        dc.b $0c ; 
                        dc.b $d9 ; 
                        dc.b $0c ; 
                        dc.b $90 ; 
                        dc.b $0c ; 
                        dc.b $a2 ; 
                        dc.b $0c ; 
                        dc.b $b6 ; 
                        dc.b $24 ; 
                        dc.b $79 ; 
                        
                        dc.w $ffff ; End of Data
                        
TabIntroScoreData_37    dc.b $0c ; 
                        dc.b $f3 ; 
                        dc.b $0c ; 
                        dc.b $90 ; 
                        dc.b $0c ; 
                        dc.b $b6 ; 
                        dc.b $0c ; 
                        dc.b $90 ; 
                        dc.b $0c ; 
                        dc.b $b6 ; 
                        dc.b $24 ; 
                        dc.b $a2 ; 
                        
                        dc.w $ffff ; End of Data
; -------------------------------------------------------------------------------------------------------------- ;
; LevelWarpHandler      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LevelWarpHandler        subroutine                        ; 
                        ldx #TabSecMsgLevelActionLen      ; max message/level numbers
.GetNextSecMsgLvlNum    ldy TabSecMsgLevelActionNum,x     ; the level number where the action takes place
                        lda TabLevelNumEquiv,y            ; 
                        cmp BBZ_LevelNumEquiv             ; correct level - now check correct action
                        beq .GetSecMsgItemNum             ; 
                        
.SetNextSecMsgLvlNum    dex                               ; 
                        bne .GetNextSecMsgLvlNum          ; 
                        
.ExitWrongLevel         rts                               ; 
                        
.GetSecMsgItemNum       lda TabSecMsgActionItemNum,x      ; 
                        cmp BB_NumItemJustTaken           ; 
                        bne .SetNextSecMsgLvlNum          ; 
                        
__NumberKeyPressed      equ [* + $01]                     ; 
                        lda #$00                          ; get number key pressed - $11-$19
                        sec                               ; 
                        sbc #$11                          ; 
                        sta BBZ_WarpLevelKeyNum           ; 
                        
.DecSecMsgNum           dex                               ; 
                        txa                               ; 
.IncSecMsgNum           inx                               ; 
                        
                        lsr a                             ; /2
                        tay                               ; 
                        lda TabSecMsgTextVarNum,y         ; 
                        bcs .ChkRightHalf                 ; 
                        
                        lsr a                             ; .oooo...
                        lsr a                             ; ..oooo..
                        lsr a                             ; ...oooo.
                        lsr a                             ; ....oooo - isolate left halfbyte
                        
.ChkRightHalf           and #$0f                          ; ....####
                        cmp BBZ_WarpLevelKeyNum           ; 
                        bne .SetNextSecMsgLvlNum          ; 
                        
                        cpx #$05                          ; 
                        bcc .Chk_f7                       ; 
                        beq .ChkTubeSwitchDir             ; 
                        
                        lda BB_CountEnemySprites          ; 
                        jmp .ChkSpriteCounter             ; 
                        
.ChkTubeSwitchDir       lda BB_WA_TubeSwitchDir           ; 
                        cmp #$a0                          ; 
.ChkSpriteCounter       bne .SetNextSecMsgLvlNum          ; 
                        
.Chk_f7                 lda BBZ_KeyPressed                ; 
                        cmp #$68                          ; "f7"
                        bne .SetNextSecMsgLvlNum          ; 
                        
                        lda #BBZ_KeyPressedNone           ; 
                        sta BBZ_KeyPressed                ; 
                        
                        ldy TabSecMsgLevelSolvedNum,x     ; the level number which has to be reached for a secret message
                        lda TabLevelNumEquiv,y            ; 
.SetCheatLevelNum       sta BB_MasterCheatLevelNum        ; will be dispatched if greater $00
                        
                        lda BBZ_ActivePlayer              ; 
                        bmi .SetSecMsgLvl_P1              ; player 1
                        
.SetSecMsgLvl_P2        stx BB_SecMsgLevelMax_P2          ; 
                        rts                               ; 
                        
.SetSecMsgLvl_P1        stx BB_SecMsgLevelMax_P1          ; 
LevelWarpHandlerX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSecMsgActionItemNum  equ [* - $01] ; 
                        dc.b $0e ; flower pot
                        dc.b $2d ; coffee pot
                        dc.b $26 ; pitch fork
                        dc.b $12 ; coffee pot
                        dc.b $0c ; pie
                        dc.b $40 ; paint roller
; -------------------------------------------------------------------------------------------------------------- ;
; SoundMobileTube       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SoundMobileTube         subroutine                        ; 
                        txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        ldy #$02                          ; Time
                        lda #$10                          ; Oscillator Offset DataSfxFreq
                        ldx #$84                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundLevelSpecial             ; 
                        
                        pla                               ; 
                        tay                               ; 
                        pla                               ; 
                        tax                               ; 
                        
SoundMobileTubeX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_06    Does    : The Grain Elevator
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_06      subroutine                        ; The Grain Elevator
                        lda #$10                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveElevator      Does    : The Grain Elevator
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveElevator        subroutine                        ; 
                        sta BBZ_ElevatorMinPosX           ; elevator PosX
                        
                        clc                               ; 
                        adc #$08                          ; platform len
                        sta BBZ_ElevatorMaxPosX           ; 
                        jsr BobMoveAdjustPosX             ; 
                        
                        ldx #BBZ_BobLiftStatusIni         ; preset
                        
                        lda BBZ_BobPosY                   ; 
                        cmp #$fc                          ; top of elevator
                        beq .SetLiftStart                 ; 
                        
.ChkBobMinX             lda BBZ_BobChkMaxPos              ; 
                        cmp BBZ_ElevatorMinPosX           ; 
                        bcc .ChkBobMaxX                   ; lower
                        
                        cmp BBZ_ElevatorMaxPosX           ; 
                        bcc .SetLiftContinue              ; lower
                        
.ChkBobMaxX             lda BBZ_BobChkMinPos              ; 
                        cmp BBZ_ElevatorMinPosX           ; 
                        bcc .SetLiftStart                 ; lower - don't move
                        
                        cmp BBZ_ElevatorMaxPosX           ; 
                        bcs .SetLiftStart                 ; lower - don't move
                        
.SetLiftContinue        dex                               ; $01
                        
.SetLiftStart           stx BBZ_BobLiftStatus             ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$15                          ; 
                        sta BBZ_FootPosY                  ; 
                        
                        ldy #[BBZ_ElevPlatFormMax - $01]  ; 
.SetNextPlattform       sty BBZ_ElevPlatForm              ; 
                        
.GetNextPlattform       lda [BB_WA_FloorPosY + $03],y     ; 
                        cmp BBZ_FootPosY                  ; 
                        bne .SetPlatFormDown              ; 
                        
                        dec BBZ_BobLiftStatus             ; 
                        bne .SetPlatFormDown              ; 
                        
.BobLiftContinue        jsr BobMoveLiftUp                 ; don't move the 1st time - gives a quick 1st fall beeb
                        
.SetPlatFormDown        tax                               ; 
                        inx                               ; down
                        inx                               ; down
                        
.ClrOld                 ldy #$00                          ; clear ...
                        jsr LifterDrawPlatform            ; ... old platform
                        
                        dex                               ; up
                        dex                               ; up
                        dex                               ; up new
                        cpx #$10                          ; up max
                        bne .DrawNew                      ; 
                        
.IniNewPlatForm         ldx #$bc                          ; start PosY
                        
.DrawNew                ldy #$ff                          ; draw ...
                        jsr LifterDrawPlatform            ; ... new platform
                        
                        ldy BBZ_ElevPlatForm              ; 
                        txa                               ; 
                        sta [BB_WA_FloorPosY + $03],y     ; 
                        cmp BBZ_FootPosY                  ; 
                        bne .SetNextPlatForm              ; 
                        
                        dec BBZ_BobLiftStatus             ; 
                        bne .SetNextPlatForm              ; 
                        
.BobLiftStart           jsr BobMoveLiftUp                 ; care for a quick fall beep the 1st time
                        
.SetNextPlatForm        dey                               ; 
                        bpl .SetNextPlattform             ; 
                        
IRQ_MoveElevatorX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveLiftUp         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLiftUp           subroutine                        ; 
.SaveFloorPosY          pha                               ; FloorPosY
                        
                        dec BBZ_BobPosY                   ; 
                        
                        lda BBZ_BobMoveType               ; 
                        sec                               ; 
                        sbc #BBZ_BobMoveTypeJump          ; 
                        cmp #BBZ_BobMoveTypeSlide         ; 
                        bcs .RestoreFloorPosY             ; greater/equal = sink and death
                        
                        ldx BBZ_BobFallHeight             ; 
                        cpx #$db                          ; 
                        bcc .RestoreFloorPosY             ; lower
                        
                        jsr BobMoveSetWalkIni             ; set type walk and init sprite no
                        
.RestoreFloorPosY       pla                               ; 
                        
BobMoveLiftUpX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LifterDrawPlatform    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LifterDrawPlatform      subroutine                        ; 
                        cpx #$13                          ; FloorPosY
                        bcc LifterDrawPlatformXit         ; lower
                        
                        cpx #$bd                          ; FloorPosY
                        bcs LifterDrawPlatformXit         ; greater/equal
                        
                        sty .__FillValue                  ; 
                        
                        ldy BBZ_ElevatorMinPosX           ; 
                        lda BB_TabHiResAdrRowLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,y         ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        
                        lda BB_TabHiResAdrRowHi,x         ; 
                        adc BB_TabHiResAdrColHi,y         ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
.__FillValue            equ [* + $01]                     ; 
                        lda #$00                          ; $00 or $ff - clear or fill
                        ldy #$00                          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        ldy #$08                          ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
LifterDrawPlatformX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_14    Does    : Hydraulic Lifts
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_14      subroutine                        ; Hydraulic Lifts
                        jsr IRQ_MoveSuctTube              ; 
                        
                        ldx #$03                          ; amount + $01
GetNextLifter           ldy [BB_WA_FloorPosY - $01],x     ; 
                        cpx BBZ_BobOnFloorNo              ; 
                        beq LifterMove                    ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        bcs SetNextLifter                 ; 
                        
                        cpy #Lvl_14_LiftBotPosY           ; 
                        bcs SetNextLifter                 ; greater/equal
.AutoMoveDown           bcc MoveLiftDown                  ; lower - auto move lift back down
; -------------------------------------------------------------------------------------------------------------- ;
LifterDrawPlatformXit   rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LifterMove            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LifterMove              subroutine                        ; 
                        lda #BBZ_SpecialSfxTimeOff        ; volume off
                        sta BBZ_SpecialSfxTime            ; 
                        
                        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
.ChkUp                  lsr a                             ; 
                        bcs .ChkDown                      ; 
                        
                        lda #BBZ_SpecialSfxTimeLiftUp     ; 
                        sta BBZ_SpecialSfxTime            ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        bcs SetNextLifter                 ; 
                        
                        cpy #Lvl_14_LiftTopPosY           ; 
                        
                        lda #BBZ_SpecialSfxTimeOff        ; 
                        bcc .SetLiftSound                 ; 
                        
.MoveBobUp              dec BBZ_BobPosY                   ; 
.MoveLiftUp             dey                               ; FloorPosY
                        bcs .SetLiftGfxPtr                ; 
                        
.ChkDown                lsr a                             ; 
                        bcs SetNextLifter                 ; 
                        
                        cpy #Lvl_14_LiftBotPosY           ; 
                        bcs SetNextLifter                 ; greater/equal
                        
.MoveBobDown            inc BBZ_BobPosY                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
MoveLiftDown            iny                               ; FloorPosY
                        
                        lda #BBZ_SpecialSfxTimeLiftDo     ; 
.SetLiftSound           sta BBZ_SpecialSfxTime            ; 
                        
.SetLiftGfxPtr          tya                               ; FloorPosY
                        sta [BB_WA_FloorPosY - $01],x     ; 
                        stx .__SaveLifterNo               ; 
                        
                        lda TabLvl14LiftPosX,x            ; 
                        tax                               ; 
                        
                        lda [BB_TabHiResAdrRowLo - $01],y ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta BBZ_LiftGfxPtrLo              ; 
                        
                        lda [BB_TabHiResAdrRowHi - $01],y ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_LiftGfxPtrHi              ; 
                        
.ClrPoleOnTop           lda #$00                          ; 
                        jsr LifterDrawNextPart            ; 
                        
.DrawPlatformTop        lda #$ff                          ; 
                        jsr LifterDrawNextPart            ; 
                        
.DrawPlatformBot        lda #$ff                          ; 
                        jsr LifterDrawNextPart            ; 
                        
                        lda #$00                          ; 
                        tay                               ; 
.ClrPlatformBot         sta (BBZ_LiftGfxPtr),y            ; ........
                        
                        ldy #$10                          ; 
.ClrPlatformTop         sta (BBZ_LiftGfxPtr),y            ; ........
                        
                        ldy #$08                          ; 
                        lda #$28                          ; ..#.#...
.DrawPoleBelow          sta (BBZ_LiftGfxPtr),y            ; 
                        
.__SaveLifterNo         equ [* + $01]                     ; 
                        ldx #$00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
SetNextLifter           dex                               ; 
                        cpx #$02                          ; 
                        bcc .ChkNoiseUpDo                 ; lower
                        
                        jmp GetNextLifter                 ; 
                        
.ChkNoiseUpDo           lda BBZ_SpecialSfxTime            ; 
                        cmp #$03                          ; 
                        bcc LifterMoveX                   ; 
                        
                        ldx #$87                          ; Oscillator Ctrl/SustainRelease
                        ldy #$02                          ; Time
                        jsr SoundLevelSpecial             ; 
                        
LifterMoveX             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; LifterDrawNextPart    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
LifterDrawNextPart      subroutine                        ; 
                        ldy #$00                          ; 
                        sta (BBZ_LiftGfxPtr),y            ; 
                        ldy #$08                          ; 
                        sta (BBZ_LiftGfxPtr),y            ; 
                        ldy #$10                          ; 
                        sta (BBZ_LiftGfxPtr),y            ; 
                        
                        inc BBZ_LiftGfxPtrLo              ; 
                        
                        lda BBZ_LiftGfxPtrLo              ; 
                        and #$07                          ; .....###
                        bne LifterDrawNextPartX           ; 
                        
                        ldy BBZ_LiftGfxPtrLo              ; 
                        dey                               ; 
                        tya                               ; 
                        
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_LiftGfxPtrLo              ; 
                        
                        lda BBZ_LiftGfxPtrHi              ; 
                        adc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_LiftGfxPtrHi              ; 
                        
LifterDrawNextPartX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabLvl14LiftPosX        equ [* - $02] ; 
                        dc.b $04 ; 
                        dc.b $90 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; HoistCheckTurnOff     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
HoistCheckTurnOff       subroutine                        ; 
                        lda BBZ_JoystickMovesGame         ; 
                        bmi HoistCheckTurnOffSpace        ; 
                        
                        lda #$05                          ; 
                        sta BBZ_BobMoveNoJumpTimer        ; 
                        bne .WasJoyFire                   ; always
; -------------------------------------------------------------------------------------------------------------- ;
HoistCheckTurnOffSpace  lda BBZ_KeyPressed                ; turn off with <SPACE>
                        beq .WasKeySpace                  ; 
                        
                        lda BBZ_HoistSwitchWait           ; 
                        beq .ExitStillOn                  ; 
                        
                        dec BBZ_HoistSwitchWait           ; 
                        
.ExitStillOn            lda #$01                          ; 
                        
                        rts                               ; 
                        
.WasKeySpace            jsr ClearKeyPressed               ; and xr
                        
.WasJoyFire             ldx #$0a                          ; 
                        lda BBZ_HoistSwitchWait           ; 
                        stx BBZ_HoistSwitchWait           ; block switch on again before leaving
                        
HoistCheckTurnOffX      rts                               ; exit switch hoist off
; -------------------------------------------------------------------------------------------------------------- ;
GoMoveHoistTurnOff      jmp MoveHoistTurnOff              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_02    Does    : Utility Hoist
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_02      subroutine                        ; Utility Hoist
                        lda BBZ_PlayerStatus              ; 
                        bne GoMoveHoistTurnOff            ; BBZ_PlayerStateDead
                        
                        lda BBZ_FloorPiecesFlipped        ; 
                        cmp BBZ_CountFloorTilesToFlip     ; 
                        beq GoMoveHoistTurnOff            ; 
                        
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs GoMoveHoistTurnOff            ; greater/equal = sink and death
                        
                        lda BBZ_HoistStatus               ; 
                        bne .ChkHoistSwitchOff            ; BBZ_HoistStatusOn
                        
                        lda BBZ_BobOnFloorNo              ; 
                        cmp #BBZ_BobOnFloorNoHoist        ; 
                        bne GoMoveHoistTurnOff            ; 
                        
                        ldx BBZ_HoistFromFloorNo          ; 
                        cpx #BBZ_BobOnFloorNoHoist        ; 
                        bne .SetHoistWaitTime             ; 
                        
                        jsr HoistCheckTurnOffSpace        ; turn off with <SPACE>
                        bne MoveHoistGetPosY              ; still switched on
                        
.SetHoistWaitTime       stx BBZ_HoistSwitchWait           ; 
                        inc BBZ_HoistStatus               ; BBZ_HoistStatusOn
                        
.ChkHoistSwitchOff      jsr HoistCheckTurnOff             ; 
                        beq .TuneHoistOff                 ; 
                        
                        ldx #$50                          ; 
                        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        ldy [BB_WA_FloorPosY + $01]       ; 
                        
.ChkUp                  lsr a                             ; 
                        bcs .ChkDown                      ; 
                        
                        cpy #$21                          ; 
                        beq .ChkDown                      ; 
                        
                        ldx #$23                          ; 
                        jsr IRQ_HoistChkTimer             ; 
                        bcs .ChkDown                      ; 
                        
.MoveDown               dey                               ; 
                        dec BBZ_BobPosY                   ; 
                        
.ChkDown                lsr a                             ; 
                        bcs .SetNewFloorY                 ; 
                        
                        cpy #$96                          ; 
                        beq .SetNewFloorY                 ; 
                        
                        ldx #$14                          ; 
.MoveUp                 iny                               ; 
                        inc BBZ_BobPosY                   ; 
                        
.SetNewFloorY           sty [BB_WA_FloorPosY + $01]       ; 
                        ldy [BB_WA_FloorMinX + $01]       ; 
                        
.ChkLeft                lsr a                             ; 
                        bcs .ChkRight                     ; 
                        
                        cpy #$36                          ; 
                        beq .ChkRight                     ; 
                        
                        ldx #$32                          ; 
                        jsr IRQ_HoistChkTimer             ; 
                        bcc .ChkRight                     ; 
                        
                        dey                               ; 
.MoveLeft               dec BBZ_BobPosX                   ; 
                        
.ChkRight               lsr a                             ; 
                        bcs .SetNewFloorX                 ; 
                        
                        cpy #$5f                          ; 
                        beq .SetNewFloorX                 ; 
                        
                        ldx #$32                          ; 
                        jsr IRQ_HoistChkTimer             ; 
                        bcs .SetNewFloorX                 ; 
                        
.MoveRight              inc BBZ_BobPosX                   ; 
                        iny                               ; 
.SetNewFloorX           tya                               ; 
                        sta [BB_WA_FloorMinX + $01]       ; 
                        clc                               ; 
                        adc #$0b                          ; hoist width
                        sta [BB_WA_FloorMaxX + $01]       ; 
                        
                        ldy #$8c                          ; 
                        jsr BobSoundHandler               ; Utility Hoist
                        jmp IRQ_HoistSprites              ; 
                        
.TuneHoistOff           ldy #$00                          ; 
                        jsr BobSoundHandler               ; 
; -------------------------------------------------------------------------------------------------------------- ;
MoveHoistTurnOff        ldy #BBZ_HoistStatusOff           ; 
                        sty BBZ_HoistStatus               ; 
; -------------------------------------------------------------------------------------------------------------- ;
MoveHoistGetPosY        lda [BB_WA_FloorPosY + $01]       ; 
                        sec                               ; 
                        sbc #$15                          ; 
                        pha                               ; 
                        jsr GetXtraSprtStorPtr            ; 
                        
                        ldx #$07                          ; 
.DrawHoistCageTop       lda TabSpriteHoistCageTop,x       ; top of cage
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        dey                               ; 
                        dex                               ; 
                        
                        lda TabSpriteHoistCageTop,x       ; top of cage
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        dey                               ; 
                        dey                               ; 
                        bpl .DecCountTop                  ; 
                        
                        ldy #$3d                          ; 
                        
                        lda BBZ_DrawHiResPtrLo            ; 
                        sec                               ; 
                        sbc #VIC_Sprt_BlockLen            ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        bcs .ChkMaxTop                    ; 
                        dec BBZ_DrawHiResPtrHi            ; 
                        
.ChkMaxTop              lda BBZ_DrawHiResPtrHi            ; 
                        cmp #>[BB_SpriteStoreLo - $01]    ; $02
                        bne .DecCountTop                  ; 
                        
                        lda #<BB_SpriteStore0e            ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        lda #>BB_SpriteStore0e            ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
.DecCountTop            dex                               ; 
                        bpl .DrawHoistCageTop             ; 
                        
                        pla                               ; 
                        clc                               ; 
                        adc #$17                          ; 
                        jsr GetXtraSprtStorPtr            ; 
                        
                        ldx #$07                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
DrawHoistCageBot        lda TabSpriteHoistCageBot,x       ; bottom of cage
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        dey                               ; 
                        dex                               ; 
                        
                        lda TabSpriteHoistCageBot,x       ; bottom of cage
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        dey                               ; 
                        dey                               ; 
                        bpl .DecCountBot                  ; 
                        
                        ldy #$3d                          ; 
                        
                        lda BBZ_DrawHiResPtrLo            ; 
                        sec                               ; 
                        sbc #VIC_Sprt_BlockLen            ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        bcs .ChkMaxBot                    ; 
                        dec BBZ_DrawHiResPtrHi            ; 
                        
.ChkMaxBot              lda BBZ_DrawHiResPtrHi            ; 
                        cmp #>[BB_SpriteStoreLo - $01]    ; $02
                        bne .DecCountBot                  ; 
                        
                        lda #<BB_SpriteStore0e            ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        lda #>BB_SpriteStore0e            ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
.DecCountBot            dex                               ; 
                        bpl DrawHoistCageBot              ; 
                        
                        lda [BB_WA_FloorMinX + $01]       ; 
                        clc                               ; 
                        adc #$0c                          ; 
                        pha                               ; 
                        
                        ldx #$08                          ; 
                        jsr SetSpritesPosX                ; ac=Sprite PosX / xr=Sprite Num
                        
                        pla                               ; 
                        ldx #$0a                          ; 
                        jsr SetSpritesPosX                ; ac=Sprite PosX / xr=Sprite Num
                        
                        lda BBZ_BobOnFloorNo              ; 
                        beq IRQ_MoveXtraLvl_02X           ; BBZ_BobOnFloorNoNone
                        
                        sta BBZ_HoistFromFloorNo          ; 
                        
IRQ_MoveXtraLvl_02X     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_19    Does    : The Sliding Candelabra
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_19      subroutine                        ; The Sliding Candelabra
                        jsr IRQ_MoveSuctTube              ; 
                        
                        lda #$94                          ; elevator PosX
                        jmp IRQ_MoveElevator              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_HoistChkTimer     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_HoistChkTimer       subroutine                        ; 
                        pha                               ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        
                        pla                               ; 
                        
IRQ_HoistChkTimerX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_HoistSprites      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_HoistSprites        subroutine                        ; 
                        jsr DynDispGameSprites            ; 
                        
IRQ_HoistSpritesX       jmp MoveHoistGetPosY              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_22    Does    : Advanced Cannon
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_22      subroutine                        ; Advanced Cannon
                        lda BBZ_CannonBobShootHight       ; Oscillator Offset DataSfxFreq
                        cmp #$1e                          ; 
                        bcs .GetBobMoveType               ; greater/equal
                        
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
                        
                        inc BBZ_CannonBobShootHight       ; 
                        cmp #$1d                          ; 
                        bcs .SetSound                     ; greater/equal
                        
                        ldx #$8f                          ; Oscillator Ctrl/SustainRelease
                        
.SetSound               ldy #$02                          ; Time
                        jsr SoundLevelSpecial             ; 
                        
.GetBobMoveType         lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeJump          ; 
                        bne CannonStatusChecks            ; 
                        
.ChkBoxWallRight        lda BBZ_BobPosX                   ; 
                        cmp #[Lvl_22_BoxWallRiPosX + $01] ; 
                        bcs CannonStatusChecks            ; greater/equal
                        
                        ldy BBZ_BobPosY                   ; 
.ChkBoxCeiling          cpy #[Lvl_22_BoxCeilPosY + $01]   ; 
                        beq .BounceBack                   ; equal
                        bcc CannonStatusChecks            ; lower
                        
                        sbc #[Lvl_22_BoxWallRiPosX - $07] ; bob's hat width - $01
                        bcc CannonStatusChecks            ; 
                        
                        tax                               ; $00-$07
                        tya                               ; BBZ_BobPosY
                        cmp TabDoorBobHatPosY,x           ; 
                        bcs CannonStatusChecks            ; greater/equal
                        
.BounceBack             inc BBZ_BobMoveType               ; BBZ_BobMoveTypeFall
                        
                        lda #$00                          ; 
                        sta BBZ_BobFlyHatDirTime          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonStatusChecks    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonStatusChecks      subroutine                        ; 
                        ldx BBZ_CannonStatus              ; 
                        cpx #BBZ_CannonStatusFly          ; 
                        bcs CannonStatCheckTube           ; greater/equal - fly or gone
                        
                        jsr IRQ_MoveSuctTube              ; 
                        
                        ldx BBZ_CannonStatus              ; 
                        bne CannonStatCheckTube           ; not BBZ_CannonStatusEmpty
                        
                        jmp IRQ_CannonCheckIni            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonStatCheckTube   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonStatCheckTube     subroutine                        ; 
                        dex                               ; 
                        beq CannonCheckTube               ; 
                        
CannonStatCheckTubeX    jmp CannonStatCheckLoad           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonCheckTube       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonCheckTube         subroutine                        ; 
                        lda BBZ_TubeStatus                ; 
                        bne CannonMove                    ; 
                        
                        jsr BobMoveSetWalkIni             ; 
                        
                        ldy #$00                          ; 
.SoundOff               jsr BobSoundHandler               ; 
                        
.MarkBobInCannon        inc BBZ_CannonStatus              ; BBZ_CannonStatusLoaded
; -------------------------------------------------------------------------------------------------------------- ;
; CannonMove            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonMove              subroutine                        ; 
CannonSetSprtPosX       lda BBZ_BobPosX                   ; move cannon according to bobs moves
                        sec                               ; 
                        sbc #$03                          ; 
                        sta BBZ_CannonPosX                ; 
                        jsr CannonMoveLeRi                ; 
                        
CannonIniSprtPosY       lda #Lvl_22_CannonBotPosY         ; 
CannonSetSprtPosY       sta BBZ_CannonPosY                ; 
                        
.SetCannonSprtTop       sta SP4Y                          ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        clc                               ; 
                        adc #$15                          ; 
.SetCannonSprtBot       sta SP5Y                          ; VIC($D00B) Sprite 5 Y-Pos (Bits 0-7)
                        
                        lda BBZ_BobPosY                   ; 
                        sec                               ; 
                        sbc #[Lvl_22_CannonTopPosY + $03] ; 
                        cmp #$12                          ; 
                        bcs .ChkBobInCannonArms           ; greater/equal
                        
                        tax                               ; 
                        ldy #$34                          ; $11*$03 rows
                        lda #$00                          ; 
.ClrBobInCannonBody     sta BB_BobSpriteGameBodyRi,y      ; 
                        sta BB_BobSpriteGameBodyLe,y      ; 
                        sta [BB_SpriteStore02 - $01],y    ; 
                        sta [BB_SpriteStore03 - $01],y    ; 
                        
                        dey                               ; 
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl .ClrBobInCannonBody           ; 
                        
.ChkBobInCannonArms     lda BBZ_BobPosY                   ; 
                        sec                               ; 
                        sbc #Lvl_22_CannonTopPosY         ; 
                        cmp #$12                          ; 
                        bcc .IniBobInCannonArms           ; 
                        
                        cmp #$16                          ; 
                        bcs CannonMoveX                   ; greater/equal
                        
                        lda #$11                          ; 
                        
.IniBobInCannonArms     tax                               ; 
                        ldy #$34                          ; $11*$03 rows
                        lda #$00                          ; 
.ClrBobInCannonArms     sta BB_BobSpriteGameLeg,y         ; 
                        sta BB_BobSpriteGameArm,y         ; 
                        sta BB_SpritePointer07,y          ; 
                        sta [BB_SpriteStore01 - $01],y    ; 
                        
                        dey                               ; 
                        dey                               ; 
                        dey                               ; 
                        
                        dex                               ; 
                        bpl .ClrBobInCannonArms           ; 
                        
CannonMoveX             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonStatCheckLoad   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonStatCheckLoad     subroutine                        ; 
                        dex                               ; 
                        bne CannonStatCheckFire           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonCheckJoyst      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonCheckJoyst        subroutine                        ; was BBZ_CannonStatusFire
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        bcs .IniBobCannonPosY             ; 
                        
                        lda BBZ_PlayerStatus              ; 
                        bne .SetCannonStatFire            ; BBZ_PlayerStateDead
                        
.ChkFire                lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        bmi .ChkMoves                     ; 
                        
.SetCannonStatFire      inc BBZ_CannonStatus              ; BBZ_CannonStatusFire
                        
                        lda #$00                          ; 
                        sta BBZ_CannonBobShootHight       ; 
                        
.ChkMoves               lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        ldy BBZ_BobSpriteNo               ; 
                        ldx BBZ_BobPosX                   ; 
                        
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        bcs .ChkJoystRight                ; 
                        
.ChkMaxLeft             cpx #[Lvl_22_TrailMinPosX + $02]  ; 
                        bcc .ChkJoystRight                ; 
                        
                        jsr SoundMoveCannon               ; 
                        
.MoveLeft               dex                               ; 
                        ldy #NumSpriteBobLeft_01          ; 
                        
.ChkJoystRight          lsr a                             ; right
                        bcs .SetBobNewPosX                ; 
                        
.ChkMaxight             cpx #Lvl_22_TubeVertLePosX        ; 
                        bcs .SetBobNewPosX                ; 
                        
                        jsr SoundMoveCannon               ; 
                        
.MoveRight              inx                               ; 
                        ldy #NumSpriteBobRight_01         ; 
                        
.SetBobNewPosX          stx BBZ_BobPosX                   ; 
                        sty BBZ_BobSpriteNo               ; 
                        
.IniBobCannonPosY       lda #[Lvl_22_CannonTopPosY + $08] ; 
                        sta BBZ_BobPosY                   ; 
                        jsr DynDispGameSprites            ; 
                        
CannonCheckJoystX       jmp CannonMove                    ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_CannonCheckIni    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_CannonCheckIni      subroutine                        ; 
                        lda BBZ_CannonPosX                ; 
                        bne CannonMoveBack                ; 
                        
                        lda BBZ_AmoutTNT                  ; 
                        beq IRQ_CannonCheckIniX           ; 
                        
                        lda BBZ_TubeStatus                ; 
                        cmp #$0a                          ; 
                        bcc IRQ_CannonCheckIniX           ; lower
                        
                        lda BB_WA_TubeSwitchDir           ; 
                        asl a                             ; 
.WasSwitchDirRight      bmi IRQ_CannonCheckIniX           ; 
                        
.WasSwitchDirLeft       inc BBZ_CannonStatus              ; 
                        
IRQ_CannonCheckIniX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonStatCheckFire   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonStatCheckFire     subroutine                        ; 
                        dex                               ; 
CannonStatCheckFireX    bne CannonStatCheckGone           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonBobFlight       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonBobFlight         subroutine                        ; 
                        ldx BBZ_AmoutTNT                  ; was BBZ_CannonStatusFly
                        cpx #$04                          ; 
                        bcs CannonOverLoad                ; greater/equal - overload
                        
.ShootBobUp             lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        sbc BBZ_AmoutTNT                  ; speed depends on TNT amount
                        sta BBZ_BobPosY                   ; 
                        
                        clc                               ; 
                        adc #$13                          ; 
                        tax                               ; 
                        
.SaveToneHeight         pha                               ; 
                        
                        ldy #$ac                          ; 
                        jsr BobSoundHandler               ; 
                        
.RestoreToneHeight      pla                               ; 
                        
                        ldx BBZ_AmoutTNT                  ; 
                        cmp TabBobFlyHeightMax,x          ; 
                        bcs .DrawSprites                  ; greater/equal
                        
.SetBobFallBack         lda #BBZ_BobMoveTypeFall          ; with standard fall down speed
                        sta BBZ_BobMoveType               ; 
                        
                        lda #$00                          ; 
                        sta BBZ_AmoutTNT                  ; 
                        sta BBZ_GameSoundTime             ; 
                        sta BBZ_BobFallHeight             ; 
                        
                        inc BBZ_CannonBobFlySound         ; BBZ_CannonBobFlySoundDown
                        
                        lda #$1d                          ; 
                        sta BBZ_BobJumpTone               ; 
                        
.DrawSprites            jsr DynDispGameSprites            ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$13                          ; hidden  sprite rows + $01
                        cmp #[Lvl_22_CannonTopPosY + $0f] ; visible sprite rows 
                        bcc CannonMoveBack                ; lower - move cannon if bob has left it completely
                        
                        jmp CannonIniSprtPosY             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonMoveBack        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonMoveBack          subroutine                        ; 
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        bcc IRQ_CannonCheckIniX           ; 
                        
                        ldx BBZ_CannonPosX                ; 
                        beq IRQ_CannonCheckIniX           ; 
                        
                        inx                               ; 
                        cpx #[Lvl_22_TubeVertLePosX - $02]; 
                        bcc CannonMoveNextRi              ; lower
                        
                        ldx #$00                          ; 
                        stx BBZ_CannonPosX                ; 
                        
CannonMoveBackX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonMoveNextRi      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonMoveNextRi        subroutine                        ; 
                        stx BBZ_CannonPosX                ; 
                        txa                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonMoveLeRi        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonMoveLeRi          subroutine                        ; 
                        ldx #$08                          ; 
                        clc                               ; 
                        adc #$0b                          ; 
                        
.MoveCannonTop          pha                               ; 
                        
                        jsr SetSpritesPosX                ; ac=Sprite PosX / xr=Sprite Num
                        
.MoveCannonBot          pla                               ; 
                        
                        ldx #$0a                          ; 
                        
CannonMoveLeRiX         jmp SetSpritesPosX                ; ac=Sprite PosX / xr=Sprite Num
; -------------------------------------------------------------------------------------------------------------- ;
; CannonOverLoad        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonOverLoad          subroutine                        ; 
                        lda BBZ_BobPosY                   ; 
.ChkSuckInMaxY          cmp #$99                          ; 
                        bcc CannonSuckBobIn               ; lower
                        
                        inc BBZ_CannonStatus              ; BBZ_CannonStatusFly
                        
CannonOverLoadX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonSuckBobIn       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonSuckBobIn         subroutine                        ; 
                        inc BBZ_BobPosY                   ; 
                        jsr DynDispGameSprites            ; 
                        
CannonSuckBobInX        jmp CannonIniSprtPosY             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonStatCheckGone   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonStatCheckGone     subroutine                        ; 
                        dex                               ; 
CannonStatCheckGoneX    bne CannonReturnBobHat            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonFlight          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonFlight            subroutine                        ; was BBZ_CannonStatusGone
.IniTNT                 stx BBZ_AmoutTNT                  ; $00
                        
                        ldy #$ac                          ; 
                        ldx BBZ_CannonPosY                ; 
                        lda BBZ_CannonPosY                ; 
                        cmp #$0a                          ; 
                        bcs .FlySound                     ; greater/equal
                        
.FlySoundOff            ldy #$00                          ; 
                        
.FlySound               jsr BobSoundHandler               ; 
                        
                        lda BBZ_CannonPosY                ; 
                        cmp #$0a                          ; 
                        bcc CannonFlightEnd               ; 
                        
.CannonFlyUp            sbc #$04                          ; 
CannonFlightX           jmp CannonSetSprtPosY             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonFlightEnd       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonFlightEnd         subroutine                        ; 
                        ldx #$00                          ; 
                        stx BBZ_CannonPosX                ; 
                        stx BBZ_BobFlyHatDirX             ; 
                        
                        inc BBZ_CannonStatus              ; BBZ_CannonStatusGone
                        
                        ldx #$14                          ; 
                        stx BBZ_BobFlyHatDirTime          ; 
                        
                        ldx #$ec                          ; 
                        stx BBZ_BobPosY                   ; 
                        
CannonFlightEndX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonReturnBobHat    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonReturnBobHat      subroutine                        ; 
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$1e                          ; Oscillator Offset DataSfxFreq
                        ldx #$48                          ; Oscillator Ctrl/SustainRelease
                        ldy #$02                          ; Time
                        jsr SoundLevelSpecial             ; 
                        
                        ldx BBZ_BobPosY                   ; 
                        cpx #$bb                          ; ground level
.ChkHatOnGround         beq CannonLandBobHat              ; 
                        
                        jsr DynDispGameSprites            ; 
                        
                        ldy #$34                          ; 
                        lda #$00                          ; 
.ClrBobButHat           sta BB_BobSpriteGameLeg,y         ; 
                        sta BB_BobSpriteGameArm,y         ; 
                        sta [BB_SpriteStore02 + $09],y    ; 
                        sta [BB_SpriteStore03 + $09],y    ; 
                        dey                               ; 
                        bpl .ClrBobButHat                 ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
                        bcs .CtrlFlyPosX                  ; 
                        
.MoveHatDown            inc BBZ_BobPosY                   ; 
                        
.CtrlFlyPosX            lda BBZ_BobFlyHatDirX             ; 
                        clc                               ; 
                        adc BBZ_BobPosX                   ; 
                        cmp #$99                          ; MaxPosX of screen
                        bcs .DecFlyTime                   ; greater/equal
                        
                        sta BBZ_BobPosX                   ; 
                        
.DecFlyTime             dec BBZ_BobFlyHatDirTime          ; 
                        bne CannonReturnBobHatX           ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$03                          ; ......##
                        tax                               ; 
                        lda TabBobFlyHatDir,x             ; 
                        sta BBZ_BobFlyHatDirX             ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$0f                          ; ....####
                        adc #$02                          ; 
                        sta BBZ_BobFlyHatDirTime          ; 
                        
CannonReturnBobHatX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CannonLandBobHat      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CannonLandBobHat        subroutine                        ; 
                        lda #BBZ_CannonStatusEmpty        ; $00
                        sta BBZ_CannonStatus              ; 
                        
                        ldx #$10                          ; 
.ClrBobWobbleSink       sta BobWobbleSinkStep_01,x        ; clear bob sprite randon line again
                        sta BobWobbleSinkStep_02,x        ; 
                        
                        dex                               ; 
                        dex                               ; 
                        dex                               ; 
                        dex                               ; 
                        dex                               ; 
                        bpl .ClrBobWobbleSink             ; 
                        
                        ldx #$07                          ; 
.ClrBobBody             sta BB_BobSpriteGameBodyRi,x      ; 
                        sta BB_BobSpriteGameBodyLe,x      ; 
                        dex                               ; 
                        bpl .ClrBobBody                   ; 
                        
                        lda #BBZ_BobMoveTypeDead          ; 
                        sta BBZ_BobMoveType               ; 
                        
                        lda #$ab                          ; 
                        sta BBZ_BobPosY                   ; 
                        
                        lda #$03                          ; 
                        sta BBZ_CopyWobTabOff             ; wobble data ptr
                        
                        lda #$8f                          ; 
                        sta BBZ_GameSoundTime             ; 
                        
                        jsr DynDispGameSprites            ; 
                        
CannonLandBobHatX       jmp BobMoveSinkLooseLife          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SoundMoveCannon       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SoundMoveCannon         subroutine                        ; 
                        pha                               ; 
                        txa                               ; 
                        pha                               ; 
                        
                        lda #$32                          ; Oscillator Offset DataSfxFreq
                        ldx #$8c                          ; Oscillator Ctrl/SustainRelease
                        ldy #$02                          ; Time
                        jsr SoundLevelSpecial             ; 
                        
                        pla                               ; 
                        tax                               ; 
                        pla                               ; 
                        
SoundMoveCannonX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobFlyHeightMax      equ  [* - $01]                    ; 
                        
                        dc.b [Lvl_22_LowFloorPosY - $0b]  ; ($45)
                        dc.b [Lvl_22_MidFloorPosY - $0b]  ; ($24)
                        dc.b [Lvl_22_TopFloorPosY - $0b]  ; ($05)
; -------------------------------------------------------------------------------------------------------------- ;
TabDoorBobHatPosY       dc.b [Lvl_22_BoxDoorRiPosY - $01] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY - $01] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY + $00] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY + $01] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY + $01] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY + $00] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY - $01] ; 
                        dc.b [Lvl_22_BoxDoorRiPosY - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabDropFloorPosYPtr     dc.b $ff ; -> $00 - will be incremented 1st
                        dc.b $03 ; -> $04
                        dc.b $08 ; -> $09
                        dc.b $0b ; -> $0c
; -------------------------------------------------------------------------------------------------------------- ;
TabDropFloorPosY        dc.b $a5 ; $00
                        dc.b $8d ; 
                        dc.b $6d ; 
                        dc.b $00 ; <End Of Data>
                        
                        dc.b $a5 ; $04
                        dc.b $8d ; 
                        dc.b $55 ; 
                        dc.b $35 ; 
                        dc.b $00 ; <End Of Data>
                        
                        dc.b $35 ; $09
                        dc.b $15 ; 
                        dc.b $00 ; <End Of Data>
                        
                        dc.b $7d ; $0c
                        dc.b $00 ; <End Of Data>
; -------------------------------------------------------------------------------------------------------------- ;
TabAcidRainPosX         dc.b $1d ; 
                        dc.b $3b ; 
                        dc.b $59 ; 
                        dc.b $77 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckColorLevel_12    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckColorLevel_12      subroutine                        ; 
                        lda BBZ_LevelNumEquiv             ; 
                        cmp #BBZ_LevelNumEquiv_12         ; Level LL - Acid Rain
                        bne CheckColorLevel_12X           ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$03                          ; ......##
                        bne CheckColorLevel_12X           ; 
                        
                        jsr TimerWaitFull                 ; 
                        
.GetRandomColor         lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$0f                          ; ....####
                        beq .GetRandomColor               ; must be between $01-$0f - not BLACK
                        
.SetRandomColor         sta .__GetLevelColor              ; 
                        
                        lda #<[COLORAM + BB_Scrn_ColorRowLen] ; start with 2nd row - leave out 1st status row
                        sta BBZ_ColorRomPtrLo             ; 
                        lda #>[COLORAM + BB_Scrn_ColorRowLen] ; start with 2nd row - leave out 1st status row
                        sta BBZ_ColorRomPtrHi             ; 
                        
                        ldx #BB_Scrn_ColorRows            ; 
.__GetLevelColor        equ [* + $01]                     ; 
.GetNextAcidRainColor   lda #RED                          ; 
                        ldy #[[$01 * $07] + $00]          ; acid column 1
                        sta (BBZ_ColorRomPtr),y           ; 
                        ldy #[[$02 * $07] + $00]          ; acid column 2
                        sta (BBZ_ColorRomPtr),y           ; 
                        ldy #[[$03 * $07] + $01]          ; acid column 3
                        sta (BBZ_ColorRomPtr),y           ; 
                        ldy #[[$04 * $07] + $01]          ; acid column 4
                        sta (BBZ_ColorRomPtr),y           ; 
                        
.SetNextScreenColorRow  lda BBZ_ColorRomPtrLo             ; 
                        clc                               ; 
                        adc #BB_Scrn_ColorRowLen          ; 
                        sta BBZ_ColorRomPtrLo             ; 
                        bcc .DecScreenColorRow            ; 
                        inc BBZ_ColorRomPtrHi             ; 
                        
.DecScreenColorRow      dex                               ; 
                        bne .GetNextAcidRainColor         ; 
                        
CheckColorLevel_12X     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_12    Does    : Acid Rain
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_12      subroutine                        ; Acid Rain
                        jsr BobMoveCheckAcid              ; 
                        
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs CheckColorLevel_12X           ; greater/equal - sink/dead
                        
                        lda BBZ_IRQ_GameTimer             ; 
.SetRain2ndTurn         lsr a                             ; 
.ChkRain2ndTurn         bcs CheckColorLevel_12X           ; 
                        
.SetRainRight           ldx #[BB_WA_Acid_Len - $01]       ; handle the two right ones any 2nd turn
                        ldy #[BB_WA_Acid_Max * $00]       ; 
                        
.GetDropsCountMax       lda #BB_WA_Acid_Max               ; 
                        sta BBZ_AcidDrops                 ; 
                        
                        lda TabAcidRainPosX,x             ; 
                        sta BBZ_DrawPosX                  ; 
                        
.GetNextAcidPosY        lda BB_WA_AcidDropHeadPosY,y      ; 
                        bne .MoveAcidDrop                 ; 
                        
                        lda BBZ_AcidDropGapLen,x          ; 
                        beq .IniRainDrop                  ; 
                        
                        jmp .GetNextAcidDrop              ; 
                        
.IniRainDrop            sta BB_WA_AcidDropHeadCover,y     ; $00
                        sta BB_WA_AcidDropTailCover,y     ; $00
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$0f                          ; ....####
                        adc #$0a                          ; minimum = $0a - 10
                        sta BBZ_AcidRainNum               ; 
                        
                        eor #$ff                          ; 
                        sta BB_WA_AcidDropTailPosY,y      ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$1f                          ; ...#####
                        adc BBZ_AcidRainNum               ; 
                        adc #$24                          ; maximum = $0f + $0a + $1f + $24 = $5c - 92
                        sta BBZ_AcidDropGapLen,x          ; 
                        
                        lda #[BB_WA_AcidDropPosYMin - $01]; outlet height
                        
.MoveAcidDrop           stx BBZ_AcidRainNum               ; 
                        sty BBZ_AcidDropNum               ; 
                        
.IncAcidDropHead        clc                               ; 
                        adc #$01                          ; 
                        cmp #BB_WA_AcidDropPosYMax        ; 
                        bcs .IncAcidDropTail              ; greater/equal
                        
.SetAcidPosY            sta BB_WA_AcidDropHeadPosY,y      ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        ldy TabDropFloorPosYPtr,x         ; get pointer to floors to pass by acid rains
.SetNextFloorHead       iny                               ; 
.ChkNextFloorHead       cmp TabDropFloorPosY,y            ; 
                        beq .IniCoverFloorHead            ; 
                        bcc .SetNextFloorHead             ; lower
                        
                        ldy BBZ_AcidDropNum               ; greater
                        lda BB_WA_AcidDropHeadCover,y     ; 
                        bne .DecCoverFloorHead            ; hide drop behind floor
                        
.DrawAcidDrop           lda #BBZ_TabDrawLineColor_03      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        ldy BBZ_AcidDropNum               ; 
                        ldx BBZ_AcidRainNum               ; 
                        jmp .IncAcidDropTail              ; 
                        
.IniCoverFloorHead      ldy BBZ_AcidDropNum               ; 
                        lda #$09                          ; 
                        
.DecCoverFloorHead      sec                               ; 
                        sbc #$01                          ; 
                        sta BB_WA_AcidDropHeadCover,y     ; 
                        
.IncAcidDropTail        lda BB_WA_AcidDropTailPosY,y      ; 
                        clc                               ; 
                        adc #$01                          ; 
                        sta BB_WA_AcidDropTailPosY,y      ; 
                        
                        cmp #BB_WA_AcidDropPosYMin        ; 
                        bcc .GetNextAcidDrop              ; lower
                        
                        cmp #BB_WA_AcidDropPosYMax        ; 
                        bne .ChkGreater                   ; 
                        
.ClearDrop              lda #$00                          ; equal
                        sta BB_WA_AcidDropHeadPosY,y      ; 
                        jmp .GetNextAcidDrop              ; 
                        
.ChkGreater             bcs .GetNextAcidDrop              ; 
                        
                        cmp #$01                          ; 
                        bcc .GetNextAcidDrop              ; 
                        
                        sta BBZ_DrawPosY                  ; 
                        
                        ldy TabDropFloorPosYPtr,x         ; get pointer to floors to pass by rain beam
.ChkNextFloorTail       iny                               ; 
                        cmp TabDropFloorPosY,y            ; 
                        beq .IniCoverFloorTail            ; 
                        bcc .ChkNextFloorTail             ; 
                        
                        ldy BBZ_AcidDropNum               ; 
                        lda BB_WA_AcidDropTailCover,y     ; 
                        bne .DecCoverFloorTail            ; 
                        
                        sta BBZ_TabDrawLineColorPtr       ; 
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        ldy BBZ_AcidDropNum               ; 
                        ldx BBZ_AcidRainNum               ; 
                        jmp .GetNextAcidDrop              ; 
                        
.IniCoverFloorTail      ldy BBZ_AcidDropNum               ; 
                        lda #$09                          ; 
                        
.DecCoverFloorTail      sec                               ; 
                        sbc #$01                          ; 
                        sta BB_WA_AcidDropTailCover,y     ; 
                        
.GetNextAcidDrop        iny                               ; 
                        
                        dec BBZ_AcidDrops                 ; 
                        beq .ChkNextAcidRain              ; 
                        
                        jmp .GetNextAcidPosY              ; 
                        
.ChkNextAcidRain        lda BBZ_AcidDropGapLen,x          ; 
                        beq .GetNextAcidRain              ; 
                        
                        dec BBZ_AcidDropGapLen,x          ; 
                        
.GetNextAcidRain        dex                               ; 
.XitWasMaxRainLeft      bmi BobMoveCheckAcidX             ; rts
                        
IRQ_MoveXtraLvl_12X     jmp .GetDropsCountMax             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveCheckAcid      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveCheckAcid        subroutine                        ; 
                        lda SPBGCL                        ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        and #$0f                          ; ....####
                        beq BobMoveCheckAcidX             ; 
                        
                        ldx #$03                          ; 
.GetNextTabAcidPosX     lda TabAcidRainPosX,x             ; 
                        sec                               ; 
                        sbc BBZ_BobPosX                   ; 
                        beq BobMoveHurtBadly              ; 
                        
                        cmp #$08                          ; 
                        bcc BobMoveHurtBadly              ; lower
                        
                        dex                               ; 
                        bpl .GetNextTabAcidPosX           ; 
                        
BobMoveCheckAcidX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveHurtBadly      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveHurtBadly        subroutine                        ; 
                        lda BBZ_CountFloorTilesToFlip     ; 
                        cmp BBZ_FloorPiecesFlipped        ; 
                        beq BobMoveHurtBadlyX             ; 
                        
                        lda BBZ_PlayerStatus              ; 
                        bne BobMoveHurtBadlyX             ; BBZ_PlayerStateDead
                        
                        inc BBZ_PlayerStatus              ; BBZ_PlayerStateDead
                        
                        lda BBZ_BobMoveType               ; 
                        sbc #BBZ_BobMoveTypeJump          ; 
                        cmp #BBZ_BobMoveTypeSlide         ; 
                        bcs BobMoveHurtBadlyX             ; greater/equal = sink or death
                        
                        lda #BBZ_BobMoveTypeFall          ; 
                        sta BBZ_BobMoveType               ; 
                        
                        lda #$00                          ; 
                        sta BBZ_BobFallHeight             ; 
                        sta BBZ_GameSoundTime             ; 
                        
BobMoveHurtBadlyX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_23    Does    : Advanced Pulverizors
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_23      subroutine                        ; Advanced Pulverizors
                        lda SPBGCL                        ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
                        and #$0f                          ; ....####
                        sta .__SprtBkgrColl               ; 
                        
                        ldx #[BB_Pulver_Max - $01]        ; num pulverizors
.__SprtBkgrColl         equ [* + $01]                     ; 
.ChkCollision           lda #$00                          ; 
                        beq .GetPulverTimer               ; 
                        
                        lda TabPulverizorPosY,x           ; 
                        sec                               ; 
                        sbc #$15                          ; sprite hight
                        cmp BBZ_BobPosY                   ; 
                        bcs .GetPulverTimer               ; greater/equal
                        
                        adc #$3c                          ; 
                        cmp BBZ_BobPosY                   ; 
                        bcc .GetPulverTimer               ; lower
                        
                        lda TabPulverizorPosX,x           ; 
                        sec                               ; 
                        sbc #$08                          ; 
                        cmp BBZ_BobPosX                   ; 
                        bcs .GetPulverTimer               ; 
                        
                        adc #$13                          ; 
                        cmp BBZ_BobPosX                   ; 
                        bcc .GetPulverTimer               ; 
                        
                        jsr BobMoveHurtBadly              ; 
                        
.GetPulverTimer         lda BB_WA_PulverMovTimer,x        ; 
                        beq .SavPulverPtr                 ; 
                        
                        sec                               ; 
                        sbc #$01                          ; 
                        sta BB_WA_PulverMovTimer,x        ; 
                        
.SetNextPulver          dex                               ; 
                        bpl .ChkCollision                 ; 
                        
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs BobMoveHurtBadlyX             ; greater/equal = sink or death
                        
                        jmp IRQ_MoveSuctTube              ; 
                        
.SavPulverPtr           stx BBZ_SavePulverPtr             ; 
                        
                        lda BB_WA_PulverMovDir,x          ; 
                        clc                               ; 
                        adc BB_WA_PulverMovPos,x          ; 
                        sta BB_WA_PulverMovPos,x          ; 
                        
                        tay                               ; 
                        bne .ChkPulverMovMax              ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        cmp #BB_WA_PulverMovTimerIni      ; 
                        bcs .SetPulverTimer               ; greater/equal
                        
                        lda #BB_WA_PulverMovTimerIni      ; 
.SetPulverTimer         sta BB_WA_PulverMovTimer,x        ; 
                        
                        lda #BB_WA_PulverMovDirDo         ; 
                        bne .SetMoveDir                   ; always
                        
.ChkPulverMovMax        cmp TabPulverMoveMaxY,x           ; 
                        bcc .DrawPulverizorIni            ; lower
                        
                        lda #BB_WA_PulverMovDirUp         ; 
                        
.SetMoveDir             sta BB_WA_PulverMovDir,x          ; 
                        
.DrawPulverizorIni      tya                               ; 
                        clc                               ; 
                        adc TabPulverizorPosY,x           ; 
                        tay                               ; 
                        
                        lda TabPulverizorPosX,x           ; 
                        tax                               ; 
                        
                        lda [BB_TabHiResAdrRowLo + $02],y ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        
                        lda [BB_TabHiResAdrRowHi + $02],y ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
                        ldx #$06                          ; 
.DrawPulverizor         ldy #$00                          ; 
                        lda TabPulverImage,x              ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        inx                               ; 
                        ldy #$08                          ; 
                        lda TabPulverImage,x              ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        
                        inx                               ; 
                        ldy #$10                          ; 
                        lda TabPulverImage,x              ; 
                        sta (BBZ_DrawHiResPtr),y          ; 
                        jsr IncDrawHiResPtr               ; 
                        
                        inx                               ; 
                        cpx #$12                          ; 
                        bcc .DrawPulverizor               ; 
                        
                        ldx BBZ_SavePulverPtr             ; 
                        jmp .SetNextPulver                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_18    Does   : Super Energy Food Bars
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_18      subroutine                        ; Super Energy Food Bars
                        lda BB_WA_ItemNo                  ; 
                        ldx #$ff                          ; 
                        cmp #$45                          ; coals 1
                        beq .SetSpriteID                  ; 
                        
                        cmp #$c8                          ; 
                        bne IRQ_MoveSuctTube              ; 
                        
                        ldx #$02                          ; 
                        
.SetSpriteID            stx [BB_WA_SpriteID_P1 + $05]     ; bad surprise
                        
                        jmp IRQ_MoveSuctTube              ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoMoveBobSuckIn         jmp IRQ_MoveTubeSuckIn            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_03     Does   : The Suction Tubes
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_03      subroutine                        ; The Suction Tubes
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_16    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_16      subroutine                        ; The Advanced Suction Tubes
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveSuctTube      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveSuctTube        subroutine                        ; 
                        lda BBZ_TubeStatus                ; 
                        bne GoMoveBobSuckIn               ; BBZ_TubeStatusLoaded
                        
.WasEmpty               jsr SuctSwitchHandler             ; 
                        
                        lda BBZ_PlayerStatus              ; 
                        bne IRQ_MoveSuctTubeX             ; BBZ_PlayerStateDead
                        
                        ldx BBZ_CountSuctionTubes         ; 
.SetNextSuctTube        dex                               ; 
                        bmi IRQ_MoveSuctTubeX             ; 
                        
                        lda BB_WA_TubeSwitchDir,x         ; 
                        bpl .SetNextSuctTube              ; BB_WA_TubeSwitchDirOff
                        
                        asl a                             ; carry=BB_WA_TubeSwitchDirLe
                        asl a                             ; carry=BB_WA_TubeSwitchDirRi
                        
                        lda BB_WA_TubeLeftPosY,x          ; 
                        bcs .WasSwitchDirRight            ; 
                        
.WasSwitchDirLeft       adc BB_WA_TubeRightLen,x          ; 
                        ldy BB_WA_TubeRightPosX,x         ; 
                        bcc .SetActivePos                 ; 
                        
.WasSwitchDirRight      clc                               ; 
                        adc BB_WA_TubeLeftLen,x           ; 
                        ldy BB_WA_TubeLeftPosX,x          ; 
                        
.SetActivePos           sta BBZ_TubeActivePosY            ; 
                        sty BBZ_TubeActivePosX            ; 
                        
                        lda BBZ_BobPosY                   ; 
                        sec                               ; 
                        sbc BBZ_TubeActivePosY            ; 
.ChkSuctDistMinY        cmp #$04                          ; 
                        bcs .SetNextSuctTube              ; greater/equal
                        
                        sta BBZ_BobTubeMinDistY           ; 
                        
                        tya                               ; BBZ_TubeActivePosX
                        adc #$05                          ; 
                        adc BBZ_BobTubeMinDistY           ; 
                        cmp BBZ_BobPosX                   ; 
                        bcc .SetNextSuctTube              ; lower
                        
                        tya                               ; BBZ_TubeActivePosX
                        sbc #$06                          ; 
                        bcc .CalcTargetPos                ; lower
                        
                        sbc BBZ_BobTubeMinDistY           ; 
                        bcc .CalcTargetPos                ; lower
                        
                        cmp BBZ_BobPosX                   ; 
                        bcs .SetNextSuctTube              ; greater/equal
                        
.CalcTargetPos          lda #$15                          ; 
                        clc                               ; 
                        adc BBZ_BobTubeMinDistY           ; 
                        sta BBZ_TubeBobPosY               ; 
                        
                        lda #$80                          ; 
                        sta BBZ_TubeSoundSuckIn           ; 
                        
                        lda BB_WA_TubeSwitchDir,x         ; 
                        asl a                             ; BB_WA_TubeSwitchDirLe
                        asl a                             ; BB_WA_TubeSwitchDirRi
                        
                        lda BB_WA_TubeLeftPosY,x          ; 
                        bcs .WasDirRight                  ; 
                        
.WasDirLeft             ldy BB_WA_TubeLeftPosX,x          ; 
                        adc BB_WA_TubeLeftLen,x           ; 
                        bcc .SubBobHeight                 ; 
                        
.WasDirRight            clc                               ; 
                        ldy BB_WA_TubeRightPosX,x         ; 
                        adc BB_WA_TubeRightLen,x          ; 
                        
.SubBobHeight           sbc #$14                          ; 
                        sta BBZ_BobNewY                   ; 
                        sty BBZ_BobNewX                   ; 
                        
                        inc BBZ_TubeStatus                ; BBZ_TubeStatusLoaded
                        
                        lda #$00                          ; 
                        sta BBZ_BobOnFloorNo              ; 
                        
IRQ_MoveSuctTubeX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoMoveBobSpitOut        jmp IRQ_MoveTubeSpitOut           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveTubeSuckIn    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveTubeSuckIn      subroutine                        ; 
                        ldy BBZ_TubeStatus                ; 
                        cpy #BBZ_TubeStatusInEnd          ; 
                        bcs GoMoveBobSpitOut              ; greater/equal
                        
                        cpy #BBZ_TubeStatusInStart        ; 
                        bcs .SuckIn                       ; greater/equal
                        
.ChkTubeInPosY          lda BBZ_TubeBobPosY               ; initially step bob to mid of entrance tube
                        beq .ChkTubeInPosX                ; 
                        
                        dec BBZ_BobFallHeight             ; 
                        dec BBZ_BobPosY                   ; 
                        
.ChkTubeInPosX          lda BBZ_TubeActivePosX            ; 
                        cmp BBZ_BobPosX                   ; 
                        beq .SetNextStep                  ; 
                        
                        inc BBZ_BobPosX                   ; 
                        bcs .SetNextStep                  ; 
                        
                        dec BBZ_BobPosX                   ; 
                        dec BBZ_BobPosX                   ; 
                        
.SetNextStep            dey                               ; 
                        bpl .ChkTubeInPosY                ; 
                        
.SuckIn                 ldx #BBZ_TubeStatusInStart        ; 

                        ldy BBZ_TubeSoundSuckIn           ; 
                        jsr BobSoundHandler               ; 
                        
                        iny                               ; 
                        cpy #$90                          ; 
                        bcc .SetSound                     ; 
                        
.StepIn                 inc BBZ_TubeStatus                ; 
                        dey                               ; 
                        
.SetSound               sty BBZ_TubeSoundSuckIn           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveTubeSprite    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveTubeSprite      subroutine                        ; 
                        jsr DynDispGameSprites            ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$1e                          ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        
                        lda BBZ_TubeActivePosY            ; 
                        clc                               ; 
                        adc #$1e                          ; 
                        sec                               ; 
                        sbc BBZ_DrawHiResPtrLo            ; 
                        bcc .ChkTubePosY                  ; lower
                        beq .ChkTubePosY                  ; equal
                        
.ChkMovMax              cmp #$13                          ; greater
                        bcc .SetMovAmount                 ; lower
                        
.GetMovMax              lda #$12                          ; 
                        
.SetMovAmount           sta .__MovAmount                  ; 
                        asl a                             ; *2
.__MovAmount            equ [* + $01]                     ; 
                        adc #$00                          ; 
                        tay                               ; 
                        
                        lda #$00                          ; 
.BobMoveIn              sta [BB_SpriteStore01 + $3f],y    ; clear bob sprite rows
                        sta [BB_SpriteStore02 + $3f],y    ; 
                        dey                               ; 
                        bne .BobMoveIn                    ; 
                        
.ChkTubePosY            lda BBZ_TubeActivePosY            ; 
                        clc                               ; 
                        adc #$1b                          ; 
                        sec                               ; 
                        sbc BBZ_DrawHiResPtrLo            ; 
                        bcc IRQ_MoveTubeSuckInX           ; lower
                        beq IRQ_MoveTubeSuckInX           ; equal
                        
.ChkClrMax              cmp #$13                          ; greater
                        bcc .SetClrAmount                 ; lower
                        
                        lda #$12                          ; 
                        
.SetClrAmount           sta .__ClrAmount                  ; 
                        asl a                             ; *2
.__ClrAmount            equ [* + $01]                     ; 
                        adc #$00                          ; 
                        tay                               ; 
                        
                        lda #$00                          ; 
.BobMoveInReady         sta BB_SpritePointer07,y          ; 
                        sta [BB_SpriteStore00 + $3f],y    ; 
                        dey                               ; 
                        bne .BobMoveInReady               ; 
                        
IRQ_MoveTubeSuckInX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveTubeSpitOut   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveTubeSpitOut     subroutine                        ; 
                        lda BBZ_BobNewX                   ; 
                        cmp BBZ_BobPosX                   ; 
                        beq .DecOutTimer                  ; 
                        
.SetNewBobPos           sta BBZ_BobPosX                   ; 
                        lda BBZ_BobNewY                   ; 
                        sta BBZ_BobPosY                   ; 
                        
.SetNewTubePosY         clc                               ; 
                        adc #$15                          ; 
                        sta BBZ_TubeActivePosY            ; 
                        
                        lda #BBZ_TubeOutTimerIni          ; care for bit7 
                        sta BBZ_TubeOutTimer              ; 
                        
.DecOutTimer            dec BBZ_TubeOutTimer              ; 
                        ldy BBZ_TubeOutTimer              ; 
                        bmi .SetSound                     ; 
                        
                        inc BBZ_BobPosY                   ; 
                        
                        ldy #BBZ_TubeStatusEmpty          ; 
                        sty BBZ_TubeStatus                ; 
.ExitComplete           jmp BobMoveFallDownIni            ; 
                        
.SetSound               ldx #$02                          ; 
                        jsr BobSoundHandler               ; 
                        
.SpitBobOut             inc BBZ_BobPosY                   ; 
                        inc BBZ_BobPosY                   ; 
                        
IRQ_MoveTubeSpitOutX    jmp IRQ_MoveTubeSprite            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SuctSwitchHandler     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SuctSwitchHandler       subroutine                        ; 
                        ldy BBZ_CountSuctionTubes         ; 
                        ldx BBZ_SuctSwitchNo              ; 
                        
.SetNextSwitchNo        inx                               ; 
                        cpx BBZ_CountSuctionTubes         ; 
                        bcc .DecSuctTubeCount             ; lower
                        
                        ldx #$00                          ; 
                        
.DecSuctTubeCount       dey                               ; 
                        bpl .GetSwitchDir                 ; 
                        
                        stx BBZ_SuctSwitchNo              ; $00
                        
.Exit                   rts                               ; 
                        
.GetSwitchDir           lda BB_WA_TubeSwitchDir,x         ; 
                        lsr a                             ; 
                        bcc .GetMaskUseableFull           ; 
                        
                        lsr a                             ; 
                        bcc .SetNextSwitchDir             ; 
                        
.GetMaskUseablePrep     lda #$fe                          ; #######.
                        bne .PrepareUsage                 ; always
                        
.GetMaskUseableFull     lda #$fc                          ; ######..
                        
.PrepareUsage           and BB_WA_TubeSwitchDir,x         ; 
                        sta BB_WA_TubeSwitchDir,x         ; 
                        jmp .SetNextSwitchNo              ; 
                        
.SetNextSwitchDir       lda BB_WA_TubeSwitchDir,x         ; 
                        adc #BB_WA_TubeSwitchVal          ; 
                        bcc .MarkUnusable                 ; 
                        
.IniSwitchDir           adc #[BB_WA_TubeSwitchDirOff - $01] ; 
                        
.MarkUnusable           eor #$03                          ; ......##
                        
                        sta BB_WA_TubeSwitchDir,x         ; 
                        
                        stx BBZ_SuctSwitchNo              ; 
                        
.SaveDir                tay                               ; 
                        
.CalcTubeMidPos         lda BB_WA_TubeRightPosX,x         ; 
                        clc                               ; 
                        adc #$08                          ; 
                        sec                               ; 
                        sbc BB_WA_TubeLeftPosX,x          ; 
                        lsr a                             ; /2
                        clc                               ; 
                        adc #$02                          ; 
                        adc BB_WA_TubeLeftPosX,x          ; 
                        sta BBZ_DrawPosX                  ; 
                        
                        lda BB_WA_TubeLeftPosY,x          ; 
                        adc #$02                          ; 
                        sta BBZ_DrawPosY                  ; 
                        
                        ldx #BBZ_TabDrawLineColor_Clr     ; 
                        stx BBZ_TabDrawLineColorPtr       ; 
                        
                        dex                               ; 
                        stx BBZ_ToneTypeHight             ; 
                        
.RestoreDir             tya                               ; 
                        
SuctSwitchHandlerX      jmp SuctTubeDrawDirChr            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveXtraLvl_24    Does   : Mutants On The Move
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_24      subroutine                        ; Mutants On The Move
                        lda #$02                          ; 
                        
.SetNextSpriteToHandle  tax                               ; 
                        
                        dec BB_WA_SpriteTrip,x            ; $f190
                        bne .GetSpriteMoveType            ; 
                        
.GetSpriteNewMoveType   lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$80                          ; #....... - Ground Left or Right
                        sta BB_WA_SpriteMoveType,x        ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$3f                          ; ..######
                        adc #$28                          ; min=28 max=67
.GetSpriteNewMoveTrip   sta BB_WA_SpriteTrip,x            ; 
                        
                        jmp .SetNextSpriteToMove          ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GetSpriteMoveType      lda BB_WA_SpriteMoveType,x        ; 
.ChkSlide               lsr a                             ; 
.WasSlide               bcs .Sprite_Trip_Slide            ; 
                        
.ChkLadder              lsr a                             ; 
.WasLadder              bcs .GoSprite_Trip_Ladder         ; 
                        
.WasGround              jmp .Sprite_Trip_Ground           ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GoSprite_Trip_Ladder   jmp .Sprite_Trip_Ladder           ; 
; -------------------------------------------------------------------------------------------------------------- ;
.Sprite_Trip_Slide      lda BB_WA_SpriteTrip,x            ; 
                        lsr a                             ; 
                        bcs .GoSetNextSpriteToMove        ; 
                        
                        lda BB_WA_SpriteMoveType,x        ; 
.ChkSlideUp             asl a                             ; 
.WasSlideUp             bmi .SetSpriteSlide_Up            ; bit6=1 -> BB_WA_SpriteMoveTypeSlNW / BB_WA_SpriteMoveTypeSlNE
                        
.SetSpriteSlide_Do      inc BB_WA_SpritePosY,x            ; bit6=0 -> BB_WA_SpriteMoveTypeSlSW / BB_WA_SpriteMoveTypeSlSE
                        jmp .MoveSprite_Le_Ri             ; 
                        
.SetSpriteSlide_Up      dec BB_WA_SpritePosY,x            ; 
                        jmp .MoveSprite_Le_Ri             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.Sprite_Trip_Ladder     lda BB_WA_SpriteTrip,x            ; 
                        and #$03                          ; ......##
                        bne .GoSetNextSpriteToMove        ; 
                        
                        lda BB_WA_SpriteMoveType,x        ; 
                        asl a                             ; 
                        bmi .SetSpriteLadder_Up           ; 
                        
.SetSpriteLadder_Do     inc BB_WA_SpritePosY,x            ; 
                        jmp .SetNextSpriteToMove          ; 
                        
.SetSpriteLadder_Up     dec BB_WA_SpritePosY,x            ; 
                        jmp .SetNextSpriteToMove          ; obsolete
                        
.GoSetNextSpriteToMove  jmp .SetNextSpriteToMove          ; 
; -------------------------------------------------------------------------------------------------------------- ;
.Sprite_Trip_Ground     lda BBZ_IRQ_GameTimer             ; 
                        lsr a                             ; 
.AnyFirstTime           bcs .ChkSpriteSide_Ri             ; 
                        
.ChkSpriteSide_Le       cpx #$10                          ; 
                        bcc .GoSetNextSpriteToMove        ; lower - left side sprites
                        bcs .MoveSprites                  ; always - higher/equal
                        
.ChkSpriteSide_Ri       cpx #$10                          ; 
                        bcs .GoSetNextSpriteToMove        ; higher/equal - right side sprites
; -------------------------------------------------------------------------------------------------------------- ;
.MoveSprites            lda BB_WA_SpritePosX,x            ; 
                        sec                               ; 
                        sbc #$2f                          ; 
                        sta BBZ_BobChkMaxPos              ; 
                        
                        lda BB_WA_SpritePosY,x            ; 
                        sbc #$30                          ; 
                        sta BBZ_BobChkMinPos              ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$03                          ; ......##
                        tay                               ; 
                        beq .CheckSlides_Up               ; $00
                        
                        dey                               ; 
                        beq .GoCheckLadders_Top           ; $01
                        
                        dey                               ; $02
                        beq .CheckLadders_Bot             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.CheckSlides_Down       ldy BBZ_CountSlides               ; $03
                        
                        lda BBZ_BobChkMinPos              ; 
.ChkNextSlide_DownY     cmp [BB_WA_SlidePosY - $01],y     ; 
                        bne .DecCountSlides_Down          ; 
                        
                        lda BBZ_BobChkMaxPos              ; 
.ChkNextSlide_DownX     cmp [BB_WA_SlidePosX - $01],y     ; 
                        beq .SetMoveSlide_Down            ; 
                        
                        lda BBZ_BobChkMinPos              ; 
                        
.DecCountSlides_Down    dey                               ; 
                        bne .ChkNextSlide_DownY           ; 
                        beq .GoCheckEndOfGround           ; always
; -------------------------------------------------------------------------------------------------------------- ;
.GoCheckLadders_Top     jmp .CheckLadders_Top             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.CheckLadders_Bot       ldy BBZ_CountLadders              ; 
                        
                        lda BBZ_BobChkMinPos              ; 
                        
                        dec BBZ_BobChkMaxPos              ; 
.ChkNextLadder_BotY     cmp [BB_WA_LadderBotY - $01],y    ; 
                        bne .DecCountLadders              ; 
                        
                        lda BBZ_BobChkMaxPos              ; 
.ChkNextLadder_BotX     cmp [BB_WA_LadderPosX - $01],y    ; 
                        beq .GetMoveLadders_Up            ; 
                        
                        lda BBZ_BobChkMinPos              ; 
                        
.DecCountLadders        dey                               ; 
                        bne .ChkNextLadder_BotY           ; 
                        beq .CheckEndOfGround             ; always
; -------------------------------------------------------------------------------------------------------------- ;
.SetMoveSlide_Down      lda [BB_WA_SlideMove - $01],y     ; 
                        and #$80                          ; #.......
                        eor #$81                          ; #......#
                        sta BB_WA_SpriteMoveType,x        ; 
                        
                        lda [BB_WA_SlideLen - $01],y      ; 
                        jmp .SetSpriteTrip                ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GetMoveLadders_Up      lda #$42                          ; .#....#. - set Up/Ladder
                        
.SetMoveLadders         sta BB_WA_SpriteMoveType,x        ; 
                        
.GetLadderLen           lda [BB_WA_LadderLen - $01],y     ; 
                        clc                               ; 
.AddGroundThickness_Bot adc #$05                          ; 
                        asl a                             ; 
                        jmp .SetSpriteTrip                ; 
                        
.GetMoveLadders_Do      lda #$02                          ; ......#. - set Down/Ladder
                        bne .SetMoveLadders               ; always
; -------------------------------------------------------------------------------------------------------------- ;
.CheckSlides_Up         ldy BBZ_CountSlides               ; 
                        
                        lda BBZ_BobChkMinPos              ; 
.ChkNextSlide_UpY       cmp [BB_WA_SlidePosY + $18],y     ; 
                        bne .DecCountSlides_Up            ; 
                        
                        lda BBZ_BobChkMaxPos              ; 
.ChkNextSlide_UpX       cmp [BB_WA_SlidePosX + $18],y     ; 
                        beq .SetMoveSlide_Up              ; 
                        
                        lda BBZ_BobChkMinPos              ; 
                        
.DecCountSlides_Up      dey                               ; 
                        bne .ChkNextSlide_UpY             ; 
.GoCheckEndOfGround     beq .CheckEndOfGround             ; always
; -------------------------------------------------------------------------------------------------------------- ;
.SetMoveSlide_Up        lda [BB_WA_SlideMove - $01],y     ; 
                        and #$80                          ; #....... - keep Left/Right
                        ora #$41                          ; .#.....# - set  North/Slide
                        sta BB_WA_SpriteMoveType,x        ; 
                        
                        lda [BB_WA_SlideLen - $01],y      ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetSpriteTrip          asl a                             ; 
                        clc                               ; 
                        adc #$01                          ; 
                        sta BB_WA_SpriteTrip,x            ; 
                        
                        jmp .SetNextSpriteToMove          ; 
; -------------------------------------------------------------------------------------------------------------- ;
.CheckLadders_Top       ldy BBZ_CountLadders              ; 
                        
                        dec BBZ_BobChkMaxPos              ; 
                        
                        lda BBZ_BobChkMinPos              ; 
                        clc                               ; 
.AddGroundThickness_Top adc #$05                          ; 
                        sta BBZ_BobChkMinPos              ; 
                        
.ChkNextLadder_TopY     cmp [BB_WA_LadderTopY - $01],y    ; 
                        bne .SetNextLadderPos             ; 
                        
                        lda BBZ_BobChkMaxPos              ; 
.ChkNextLadder_TopX     cmp [BB_WA_LadderPosX - $01],y    ; 
                        beq .GetMoveLadders_Do            ; 
                        
                        lda BBZ_BobChkMinPos              ; 
                        
.SetNextLadderPos       dey                               ; 
                        bne .ChkNextLadder_TopY           ; 
; -------------------------------------------------------------------------------------------------------------- ;
.CheckEndOfGround       lda BB_WA_SpritePosX,x            ; 
                        sec                               ; 
                        sbc #$28                          ; 
                        bcc .ChangeMoveDir                ; 
                        
                        ldy BB_WA_SpriteMoveType,x        ; 
                        bmi .SaveSpriteWAPtr              ; 
                        
                        sbc #$08                          ; 
                        bcc .ChangeMoveDir                ; 
                        
.SaveSpriteWAPtr        stx BBZ_Lvl24SpriteWAPtr          ; 
                        
                        ldy BB_WA_SpritePosY,x            ; 
                        
.SetOffsetPosX          tax                               ; 
                        
                        lda [BB_TabHiResAdrRowHi - $f8],y ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta .__GetDataPosY_Lo             ; 
                        
                        lda [BB_TabHiResAdrRowLo + $98],y ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta .__GetDataPosY_Hi             ; 
                        
.GetOffsetPosX          txa                               ; 
                        and #$03                          ; ......## - limit to $04 TabPlatformColorClear positions
.SetOffsetTabColor      tax                               ; 
                        
.__GetDataPosY_Lo       equ [* + $01]                     ; 
.__GetDataPosY_Hi       equ [* + $02]                     ; 
                        lda BB_PlaceHolder_8000           ; 
                        ora TabPlatformColorClear,x       ; 
                        
.RestoreSpriteWAPtr     ldx BBZ_Lvl24SpriteWAPtr          ; 
                        
.ChkEndOfPlatform       cmp #$ff                          ; ########
; -------------------------------------------------------------------------------------------------------------- ;
.ChangeMoveDir          lda BB_WA_SpriteMoveType,x        ; at end of ground
                        bcs .SetFlagMoveDir               ; higher/equal
                        
.FlipMoveDir            eor #$80                          ; #.......
                        sta BB_WA_SpriteMoveType,x        ; 
                        
.SetFlagMoveDir         asl a                             ; 
; -------------------------------------------------------------------------------------------------------------- ;
.MoveSprite_Le_Ri       lda BB_WA_SpriteNumberA,x         ; 
.WasRi                  bcs .SetSpriteNext_Ri             ; 
                        
.SetSpriteNext_Le       dec BB_WA_SpritePosX,x            ; 
                        
.SetSpriteLook_Le       and #$fd                          ; ######.#
                        bcc .SetSpriteLook                ; always
                        
.SetSpriteNext_Ri       inc BB_WA_SpritePosX,x            ; 
                        
.SetSpriteLook_Ri       ora #$02                          ; ......#.
                        
.SetSpriteLook          sta BB_WA_SpriteNumberA,x         ; 
; -------------------------------------------------------------------------------------------------------------- ;
.SetNextSpriteToMove    cpx #$10                          ; sprites: $00 $01 $02 -> right / $10 $11 $12 -> left
                        
                        txa                               ; 
                        bcc .SetSpriteSide_Ri             ; lower
                        
.SetSpriteSide_Le       sbc #$11                          ; $03 sprites on the left screen half
                        bpl .GoNextSpriteToHandle         ; 
                        
.Exit                   rts                               ; all 6 sprites handled
                        
.SetSpriteSide_Ri       adc #$10                          ; $03 sprites on the right screen half
.GoNextSpriteToHandle   jmp .SetNextSpriteToHandle        ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobMoveSubPtrLo      dc.b <BobMoveFloor                ; 
                        dc.b <BobMoveLadder               ; 
                        dc.b <BobMoveSlide                ; 
                        dc.b <BobMoveJump                 ; 
                        dc.b <BobMoveFall                 ; 
                        dc.b <BobMoveSink                 ; 
                        dc.b <BobMoveDead                 ; 
                        
TabBobMoveSubPtrHi      dc.b >BobMoveFloor                ; 
                        dc.b >BobMoveLadder               ; 
                        dc.b >BobMoveSlide                ; 
                        dc.b >BobMoveJump                 ; 
                        dc.b >BobMoveFall                 ; 
                        dc.b >BobMoveSink                 ; 
                        dc.b >BobMoveDead                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveLimitCheck     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLimitCheck       subroutine                        ; 
                        ldy BBZ_BobPosY                   ; 
                        
                        txa                               ; PosX
                        clc                               ; 
                        adc #$07                          ; 
                        sta BBZ_BobPosXCheck              ; PosX + $07
                        
                        tya                               ; 
                        clc                               ; 
                        adc #$3c                          ; 
                        sta BBZ_BobChkMinPos              ; PosY + $3c
                        
                        adc #$14                          ; 
                        sta BBZ_BobChkMaxPos              ; PosY + $14
                        
                        ldy BBZ_MoveLimitTabPtr           ; 
                        iny                               ; 
.GetNextLimitEntry      dey                               ; 
.NoLimit                beq .ContinueMoveX                ; 
                        
                        txa                               ; PosX
                        cmp [BB_WA_MoveLimitMinX - $01],y ; 
                        bne .ChkPosX                      ; 
                        
                        cpx BBZ_BobPosX                   ; 
                        bcc .ChkPosYHi                    ; 
                        
                        cpx #$ff                          ; 
                        beq .ChkPosYHi                    ; 
                        
.ChkPosX                lda BBZ_BobPosXCheck              ; PosX + $07
                        cmp [BB_WA_MoveLimitMinX - $01],y ; 
                        bne .GetNextLimitEntry            ; 
                        
                        cpx BBZ_BobPosX                   ; 
                        bcc .GetNextLimitEntry            ; lower
                        
.ChkPosYHi              lda BBZ_BobChkMinPos              ; PosY + $3c
                        cmp [BB_WA_MoveLimitMaxY0 - $01],y; 
                        bcs .GetNextLimitEntry            ; greater/equal
                        
.ChkPosYLo              lda BBZ_BobChkMaxPos              ; PosY + $14
                        cmp [BB_WA_MoveLimitMinY0 - $01],y; 
                        bcc .GetNextLimitEntry            ; lower
                        
                        lda BBZ_BobMoveType               ; 
                        sec                               ; 
                        sbc #BBZ_BobMoveTypeJump          ; 
                        cmp #BBZ_BobMoveTypeSlide         ; 
                        bcs .Exit                         ; greater/equal = sink or death 
                        
                        lda #$00                          ; 
                        sta BBZ_GameSoundTime             ; 
                        
.Exit                   rts                               ; 
                        
.ContinueMoveX          stx BBZ_BobPosX                   ; 
                        
BobMoveLimitCheckX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveLimitWait      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLimitWait        subroutine                        ; 
                        jsr BobMoveCheckTimer             ; 
                        bcs BobMoveLimitWaitX             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveLimitInit      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLimitInit        subroutine                        ; 
                        lda BBZ_BobPosX                   ; 
                        clc                               ; 
                        adc BBZ_BobLadderPosTop           ; 
                        tax                               ; 
                        jmp BobMoveLimitCheck             ; 
                        
BobMoveLimitWaitX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSetWalkIni     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSetWalkIni       subroutine                        ; 
                        lda #BBZ_BobMoveTypeWalk          ; 
                        sta BBZ_BobMoveType               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSpriteNoIni    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSpriteNoIni      subroutine                        ; 
                        ldx BBZ_BobSpriteNo               ; get actual sprite number
                        lda TabBobSpriteNumInit,x         ; 
                        sta BBZ_BobSpriteNo               ; new sprite start value
                        
BobMoveSpriteNoIniX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveLaCoWrkPos     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLaCoWrkPos       subroutine                        ; 
                        ldy BBZ_CountLadders              ; 
                        iny                               ; 
                        
                        sta BBZ_BobChkMaxPos              ; 
                        
                        ldx BBZ_BobPosX                   ; 
                        inx                               ; 
                        inx                               ; 
                        txa                               ; 
                        sec                               ; 
                        sbc #$04                          ; 
                        sta BBZ_BobChkMinPos              ; 
                        
BobMoveLaCoWrkPosX      rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteNumSlide    dc.b NumSpriteBobSlideLe ; -1 LevelSlideMoveDoLe
                        dc.b NumSpriteBobSlideRi ;  0 LevelSlideMoveDo
                        dc.b NumSpriteBobSlideRi ; +1 LevelSlideMoveDoRi
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveXmit           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveXmit             subroutine                        ; 
                        lda BBZ_BobPosX                   ; 
                        clc                               ; 
                        adc #$04                          ; 
                        sta BBZ_BobChkMinPos              ; 
                        
                        adc #$04                          ; 
                        sta BBZ_BobChkMaxPos              ; 
                        
                        lda BBZ_BobPosY                   ; 
                        sec                               ; 
                        sbc #$0e                          ; 
                        tay                               ; 
                        
.GetXmitNumMax          ldx #[BB_WA_Xmit_Max + $01]       ; 
                        
.GetNextBobPosY         tya                               ; find actual xmit booth number
.SetNextXmitNum         dex                               ; count down xmit booth number
.ExitNoBooth            beq BobMoveLaCoWrkPosX            ; no booth found
                        
                        cmp [BB_WA_XmitGamePosY - $01],x  ; 
                        bne .SetNextXmitNum               ; 
                        
                        lda [BB_WA_XmitDrawBits - $01],x  ; 
                        bmi .GetNextBobPosY               ; 
                        
                        lda BBZ_BobChkMaxPos              ; 
                        cmp [BB_WA_XmitGamePosX - $01],x  ; 
                        bcc .GetNextBobPosY               ; lower
                        
                        lda BBZ_BobChkMinPos              ; 
                        cmp [BB_WA_XmitGamePosX - $01],x  ; 
                        bcs .GetNextBobPosY               ; higher/equal
                        
.SavXmitNum             stx BBZ_XmitBoothNum              ; 
                        
                        ldy BBZ_XmitActive                ; 
.ChkXmitActive          bmi .GetXmitMove                  ; BBZ_XmitActiveYes
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$37                          ; ..##.###
                        bne .ChkXmitBoothNumMax           ; 
                        
.IncXmitBoothNum        iny                               ; 
                        
.ChkXmitBoothNumMax     cpy #BB_WA_Xmit_Max               ; 
                        bcc .GetXmitDrawBitsPtrVal        ; lower
                        
.GetXmitBoothNumMin     ldy #$00                          ; 
                        
.GetXmitDrawBitsPtrVal  lda BB_WA_XmitDrawBits,y          ; 
                        bmi .GetXmitBoothNumMin           ; 
                        
                        iny                               ; 
                        cpy BBZ_XmitBoothNum              ; 
                        beq .ChkXmitBoothNumMax           ; 
                        
.DecXmitBoothNum        dey                               ; 
.SavXmitBoothNum        sty BBZ_XmitActive                ; 
                        
                        lda BB_WA_XmitGamePosY,y          ; 
                        clc                               ; 
                        adc #$01                          ; 
                        sta __XmitGamePosY                ; 
                        
                        lda BB_WA_XmitGamePosX,y          ; 
                        sec                               ; 
                        sbc #$04                          ; 
                        sta __XmitGamePosX                ; 
                        
.SetXmitActive          asl BBZ_XmitActive                ; set Bit7 - keep Xmit Booth Number
                        sec                               ; 
                        ror BBZ_XmitActive                ; 
                        
.GetXmitMove            lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        and #CIA_Joy_Mask_Move            ; ....####
.ChkXmitMove_Do         cmp #CIA_JoyWas_Do                ; ....##.#
                        beq .WasXmitMove                  ; 
                        
.ChkXmitMove_Up         cmp #CIA_JoyWas_Up                ; 
                        bne .GetXmitKey                   ; 
                        
.WasXmitMove            lda BBZ_XmitActive                ; 
                        and #$07                          ; .....###
                        clc                               ; 
                        adc #$01                          ; Booth_1 - Booth_6
                        bpl .ChkXmitBoothSame             ; always
                        
.GetXmitKey             lda BBZ_KeyPressed                ; 
                        sec                               ; 
                        sbc #$10                          ; "0"
                        beq BobMoveXmitX                  ; $00 - wrong number - no action
                        
.GetXmitKeyMax          cmp #[BB_WA_Xmit_Max + $01]       ; 
.ChkXmitKeyMax          bcs BobMoveXmitX                  ; greater/equal - wrong number - no action
                        
.ChkXmitBoothSame       cmp BBZ_XmitBoothNum              ; 
.WasXmitBoothSame       beq BobMoveXmitX                  ; no action
                        
.GetXmitBoothNum        tay                               ; 
                        lda [BB_WA_XmitDrawBits - $01],y  ; 
.ChkXmitBoothAvailable  bmi BobMoveXmitX                  ; not available - no action
                        
                        lda #BBZ_KeyPressedNone           ; 
                        sta BBZ_KeyPressed                ; 
                        
.IniXmitBob             lda BBZ_BobPosX                   ; 
                        sta BBZ_BobNewX                   ; 
                        lda BBZ_BobPosY                   ; 
                        sta BBZ_BobNewY                   ; 
                        
                        lda [BB_WA_XmitGamePosX - $01],y  ; 
                        sec                               ; 
                        sbc [BB_WA_XmitGamePosX - $01],x  ; 
                        clc                               ; 
                        adc BBZ_BobPosX                   ; 
                        sta BBZ_BobPosX                   ; 
                        
                        lda [BB_WA_XmitGamePosY - $01],y  ; 
                        clc                               ; 
                        adc #$0e                          ; 
                        sta BBZ_BobPosY                   ; 
                        
.GetXmitFlipFlopNew     ldx #BBZ_XmitFlipFlopPosNew       ; 
                        
                        cmp BBZ_BobNewY                   ; 
                        bcs .SetXmitFlipFlop              ; greater/equal
                        
.GetXmitFlipFlopOld     inx                               ; BBZ_XmitFlipFlopPosOld
                        
.SetXmitFlipFlop        stx BBZ_XmitFlipFlopPos           ; 
                        
                        ldx #BBZ_BobXmitTimeIni           ; 
                        stx BBZ_BobXmitTime               ; 
                        
                        pla                               ; 
                        pla                               ; remove BobMoveHandler return address
                        
BobMoveXmitX            rts                               ; return to .GoBobMoveHandler
; -------------------------------------------------------------------------------------------------------------- ;
GoBobMoveSetSink        jmp BobMoveSetSink                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveFloor          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFloor            subroutine                        ; 
                        lda BBZ_PlayerStatus              ; 
                        bne GoBobMoveSetSink              ; BBZ_PlayerStateDead
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$15                          ; 
                        tax                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; 1st: Check Slides / 2nd: Check Ladders / 3rd: Check Xmit Booth
; -------------------------------------------------------------------------------------------------------------- ;
.ChkForSlides_1st       ldy BBZ_CountSlides               ; 
                        iny                               ; 
                        
.GetBobPosX             lda BBZ_BobPosX                   ; 
.ChkNextSlide           dey                               ; 
                        beq .GetJoystickMoves             ; no slide left
                        
.ChkBobOnSlideX         cmp [BB_WA_SlidePosX - $01],y     ; 
                        bne .ChkNextSlide                 ; 
                        
.GetBobPosY             txa                               ; 
                        
.ChkBobOnSlideY         cmp [BB_WA_SlidePosY - $01],y     ; 
                        bne .GetBobPosX                   ; 
                        
.Slide                  inc BBZ_BobPosY                   ;  
                        ldx [BB_WA_SlideMove - $01],y     ; 
                        stx BBZ_GameSoundTime             ; 
                        
                        inx                               ; 
                        lda TabBobSpriteNumSlide,x        ; 
                        sta BBZ_BobSpriteNo               ; 
                        
                        lda #BBZ_BobMoveTypeSlide         ; 
                        sta BBZ_BobMoveType               ; 
                        
.GetSlideLen            lda [BB_WA_SlideLen - $01],y      ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        jmp BobMoveFallDown               ; 
                        
.GetJoystickMoves       lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        bmi .DecNoJumpTimer               ; no fire 
                        
                        lda #$02                          ; 
                        ldx BBZ_BobMoveNoJumpTimer        ; 
                        sta BBZ_BobMoveNoJumpTimer        ; 
                        bne .ChkJoystickUpDo              ; 
                        
                        jmp BobMoveJumpInit               ; 
                        
.DecNoJumpTimer         lda BBZ_BobMoveNoJumpTimer        ; 
                        beq .ChkJoystickUpDo              ; 
                        
                        dec BBZ_BobMoveNoJumpTimer        ; 
                        
.ChkJoystickUpDo        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        lsr a                             ; 
                        bcc .ChkLadderUp                  ; up
                        
                        lsr a                             ; down
                        bcc .ChkLadderDo                  ; 
                        
                        jmp .ChkJoystickLeRi              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; 1st: Check Slides / 2nd: Check Ladders / 3rd: Check Xmit Booth
; -------------------------------------------------------------------------------------------------------------- ;
.ChkForLadders_2nd      equ *                             ; 
.ChkLadderDo            lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$1a                          ; 
                        jsr BobMoveLaCoWrkPos             ; yr=BBZ_CountLadders + $01
                        
.GetBobWrkDoPosX        lda BBZ_BobWrkPosX                ; 
.ChkNextLadderDo        dey                               ; 
                        beq .ChkJoystickLeRi              ; 
                        
                        cmp [BB_WA_LadderTopY - $01],y    ; 
                        bne .ChkNextLadderDo              ; 
                        
                        txa                               ; 
                        cmp [BB_WA_Ladder - $01],y        ; 
                        bcc .GetBobWrkDoPosX              ; 
                        
                        lda [BB_WA_Ladder - $01],y        ; 
                        cmp BBZ_BobWrkPosY                ; 
                        bcc .GetBobWrkDoPosX              ; 
                        
.ClimbDown              sta BBZ_BobPosX                   ; 
                        
                        lda #NumSpriteBobLadderTop_02     ; 
                        sta BBZ_BobSpriteNo               ; 
                        
                        inc BBZ_BobPosY                   ; 
                        
                        lda [BB_WA_LadderLen - $01],y     ; 
                        clc                               ; 
                        adc #$05                          ; 
                        sta BBZ_BobLadderPosBot           ; 
                        dec BBZ_BobLadderPosBot           ; <-.hbu.can be $04
                        
                        ldx #$01                          ; 
                        stx BBZ_BobLadderPosTop           ; 
                        bne .ClimbReady                   ; always
                        
.ChkLadderUp            lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$15                          ; 
                        jsr BobMoveLaCoWrkPos             ; yr=BBZ_CountLadders + $01
                        
.GetBobWrkUpPosX        lda BBZ_BobWrkPosX                ; 
.ChkNextLadderUp        dey                               ; 
                        beq .ChkJoystickLeRi              ; 
                        
                        cmp [BB_WA_LadderBotY - $01],y    ; 
                        bne .ChkNextLadderUp              ; 
                        
                        txa                               ; 
                        cmp [BB_WA_Ladder - $01],y        ; 
                        bcc .GetBobWrkUpPosX              ; 
                        
                        lda [BB_WA_Ladder - $01],y        ; 
                        cmp BBZ_BobWrkPosY                ; 
                        bcc .GetBobWrkUpPosX              ; 
                        
.ClimbUp                sta BBZ_BobPosX                   ; 
                        
                        lda #NumSpriteBobLadder_01        ; 
                        sta BBZ_BobSpriteNo               ; 
                        
                        dec BBZ_BobPosY                   ; 
                        
                        lda [BB_WA_LadderLen - $01],y     ; 
                        clc                               ; 
                        adc #$04                          ; 
                        sta BBZ_BobLadderPosTop           ; 
                        
                        ldx #$01                          ; 
                        stx BBZ_BobLadderPosBot           ; 
                        
.ClimbReady             ldy #$00                          ; 
                        jsr BobSoundHandler               ; 
                        
                        inc BBZ_BobMoveType               ; BBZ_BobMoveTypeClimb
                        
                        jmp DynDispGameSprites            ; 
                        
.ChkJoystickLeRi        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        lsr a                             ; up   - ignore
                        lsr a                             ; down - ignore
                        
                        lsr a                             ; left
.ChkJoystickLe          bcc .ChkFloorLe                   ; was left
                        
                        lsr a                             ; right
.ChkJoystickRi          bcc .ChkFloorRi                   ; was right
                        
.IniXmit                jsr BobMoveSpriteNoIni            ; was up/down
                        jsr BobMoveXmit                   ; 
                        
                        jmp .SetStepSound_03              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; 1st: Check Slides / 2nd: Check Ladders / 3rd: Check Xmit Booth
; -------------------------------------------------------------------------------------------------------------- ;
.ChkForFloor_3rd        equ *                             ; 
.ChkFloorLe             jsr BobMoveCheckTimer             ; 
                        bcs .NextBobSpriteNoLe            ; any second tic
                        
                        ldx BBZ_BobPosX                   ; 
                        dex                               ; 
                        jsr BobMoveLimitCheck             ; 
                        
.NextBobSpriteNoLe      ldx BBZ_BobSpriteNo               ; 
                        dex                               ; 
                        cpx #NumSpriteBobLeft_Min         ; 
                        bcc .MaxBobSpriteNoLe             ; lower
                        
                        cpx #[NumSpriteBobLeft_Max + $01] ; 
                        bcc .SetBobSpriteNoLe             ; lower
                        
.MaxBobSpriteNoLe       ldx #NumSpriteBobLeft_Max         ; 
.SetBobSpriteNoLe       stx BBZ_BobSpriteNo               ; 
                        jmp .GetNextStepSound             ; 
                        
.ChkFloorRi             jsr BobMoveCheckTimer             ; 
                        bcs .NextBobSpriteNoRi            ; any second tic
                        
                        ldx BBZ_BobPosX                   ; 
                        inx                               ; 
                        jsr BobMoveLimitCheck             ; 
                        
.NextBobSpriteNoRi      ldx BBZ_BobSpriteNo               ; 
                        inx                               ; 
                        cpx #[NumSpriteBobRight_Max + $01]; 
                        bcc .SetBobSpriteNoRi             ; 
                        
                        ldx #NumSpriteBobRight_Min        ; 
.SetBobSpriteNoRi       stx BBZ_BobSpriteNo               ; 
                        jmp .GetNextStepSound             ; 
                        
.SetStepSound_03        ldx #$03                          ; 
                        bne .GetStepSoundValue            ; always
                        
.GetNextStepSound       ldx BBZ_BobMoveStepCount          ; 
                        inx                               ; 
                        cpx #[BBZ_BobMoveStepCountMax + $01] ; 
                        bcc .SetNextStepSound             ; lower
                        
                        ldx #BBZ_BobMoveStepCountMin      ; 
                        
.SetNextStepSound       stx BBZ_BobMoveStepCount          ; 
                        
.GetStepSoundValue      ldy TabBobMoveSound_02,x          ; 
                        lda TabBobMoveSound_01,x          ; 
                        tax                               ; 
                        jsr BobSoundHandler               ; 
                        
                        jsr BobMoveCheckFall              ; 
                        bne BobMoveFloorX                 ; BBZ_BobFallYes
                        
                        jsr BobMoveSpriteNoIni            ; BBZ_BobFallNo
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFallDownIni      lda #BBZ_BobMoveTypeFall          ; 
                        sta BBZ_BobMoveType               ; 
                        
                        lda #$00                          ; 
                        sta BBZ_GameSoundTime             ; 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFallDown         sta BBZ_BobSlideLen               ; 
                        
                        ldx #$1d                          ; 
                        stx BBZ_BobJumpTone               ; 
                        
                        ldy #$aa                          ; 
                        jsr BobSoundHandler               ; 
                        
BobMoveFloorX           jmp DynDispGameSprites            ; 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLadderXit        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobMoveSound_01      dc.b $fa ; 
                        dc.b $fa ; 
                        dc.b $fa ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        
TabBobMoveSound_02      dc.b $8a ; 
                        dc.b $8a ; 
                        dc.b $8a ; 
                        dc.b $00 ; 
                        
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $8a ; 
                        dc.b $8a ; 
                        dc.b $8a ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveLadder         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveLadder           subroutine                        ; 
                        lda BBZ_PlayerStatus              ; 
                        beq .GoChkMoveTimer               ; BBZ_PlayerStateAlive
                        
.CaughtOnLadder         lda #BBZ_BobMoveTypeFall          ; let bob fall down ...
                        sta BBZ_BobMoveType               ; 
                        
                        lda #$00                          ; 
                        sta BBZ_GameSoundTime             ; 
                        
                        lda #BBZ_BobFallHeightMax         ; and sink into next ground
                        bne BobMoveFallDown               ; always
                        
.GoChkMoveTimer         jsr BobMoveCheckTimer             ; 
                        bcs BobMoveLadderXit              ; 
                        
                        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        lsr a                             ; 
                        bcc .ClimbUp                      ; 
                        
                        lsr a                             ; 
                        bcs BobMoveLadderXit              ; 
                        
.ClimbDown              inc BBZ_BobPosY                   ; 
                        inc BBZ_BobLadderPosTop           ; 
                        dec BBZ_BobLadderPosBot           ; 
                        bne .ChkMoveTimer                 ; 
                        
.SetBobWalk             dec BBZ_BobMoveType               ; 
                        
                        lda #NumSpriteBobRight_Min        ; $00
                        beq .SetBobSpriteNo               ; always
                        
.ClimbUp                inc BBZ_BobLadderPosBot           ; 
                        dec BBZ_BobPosY                   ; 
                        dec BBZ_BobLadderPosTop           ; 
                        beq .SetBobWalk                   ; 
                        
.ChkMoveTimer           lda BBZ_IRQ_GameTimer             ; 
                        and #$03                          ; ......##
                        bne BobMoveLadderX                ; 
                        
.ClimbSprtFlipFlop      lda BBZ_BobSpriteNo               ; 
                        and #$01                          ; .......# - isolate
                        eor #$01                          ; ........ - reverse
                        ora #NumSpriteBobLadder_01        ; .....##. - NumSpriteBobLadder_01 or NumSpriteBobLadder_02
                        
                        ldx BBZ_BobLadderPosTop           ; 
                        cpx #$06                          ; 
                        bcs .SetBobSpriteNo               ; greater/equal
                        
                        adc #$02                          ; NumSpriteBobLadderTop_01 or NumSpriteBobLadderTop_02
                        
.SetBobSpriteNo         sta BBZ_BobSpriteNo               ; 
                        
BobMoveLadderX          jmp DynDispGameSprites            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSlide          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSlide            subroutine                        ; 
                        inc BBZ_BobPosY                   ; 
                        jsr BobMoveLimitInit              ; 
                        
                        dec BBZ_BobSlideLen               ; 
                        bne BobMoveSlideX                 ; 
                        
                        lda #$00                          ; 
                        sta BBZ_GameSoundTime             ; 
                        
                        lda #$04                          ; 
                        sta BBZ_BobMoveType               ; BBZ_BobMoveTypeFall
                        sta BBZ_BobSlideLen               ; 
                        
BobMoveSlideX           jmp BobMoveGoCheckFall            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveJumpInit       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveJumpInit         subroutine                        ; 
                        lda #BBZ_BobMoveTypeJump          ; 
                        sta BBZ_BobMoveType               ; 
                        
                        lda #$00                          ; 
                        sta BBZ_GameSoundTime             ; 
                        sta BBZ_JumpDirChange             ; 
                        
                        lda #BBZ_BobJumpDirTabPtrIni      ; 
                        sta BBZ_BobJumpDirTabPtr          ; 
                        
                        lda #$5d                          ; 
                        sta BBZ_BobJumpTone               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveJump           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveJump             subroutine                        ; 
                        lda BBZ_JumpDirChange             ; 
                        bne .NextJumpStep                 ; BBZ_JumpDirChangeNo
                        
                        lda BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
.SetJumpLeft            ldx #NumSpriteBobJumpLe           ; 
.SetMoveLeft            ldy #$ff                          ; -1
                        
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        
                        inc BBZ_JumpDirChange             ; BBZ_JumpDirChangeNo - no dir change during jump
                        
.JumpToTheLeft          bcc .SetJumpSprtNo                ; 
                        
.SetJumpRight           dex                               ; NumSpriteBobJumpRi
.SetMoveRight           ldy #$01                          ; +1
                        
                        lsr a                             ; 
.JumpToTheRight         bcc .SetJumpSprtNo                ; 
                        
.ResetDirChange         dec BBZ_JumpDirChange             ; BBZ_JumpDirChangeYes
                        
                        dey                               ; $00
                        
                        lda BBZ_BobSpriteNo               ; 
                        cmp #NumSpriteBobJumpRi           ; 
                        bcs .NextJumpStep                 ; greater/equal
                        
                        cmp #[NumSpriteBobRight_Max + $01]; 
                        bcc .SetJumpSprtNo                ; lower
                        
                        inx                               ; 
                        
.SetJumpSprtNo          stx BBZ_BobSpriteNo               ; 
                        sty BBZ_GameSoundTime             ; 
                        
.NextJumpStep           ldx BBZ_BobJumpDirTabPtr          ; 
                        lda [TabBobJumpDir - BBZ_BobJumpDirTabPtrIni],x ; 
                        clc                               ; 
                        adc BBZ_BobPosY                   ; 
                        sta BBZ_BobPosY                   ; 
                        jsr BobMoveLimitWait              ; 
                        
                        lda BBZ_BobJumpDirTabPtr          ; 
                        inc BBZ_BobJumpDirTabPtr          ; 
                        cmp #[BBZ_BobJumpDirTabPtrIni + BBZ_BobJumpDirTabPtrLen / $02 + $01] ; 
                        bcc BobMovDecJumpTone             ; lower - still jumping up
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveGoCheckFall      jsr BobMoveCheckFall              ; greater/equal - falling back down
                        beq BobMoveFallInit               ; BBZ_BobFallYes
                        bpl BobMoveFallEnd                ; BBZ_BobFallNo
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSetSink        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSetSink          subroutine                        ; 
                        lda #BBZ_BobMoveTypeSink          ; 
                        sta BBZ_BobMoveType               ; 
                        
                        lda #BBZ_CopyWobTabOffMax         ; 
                        sta BBZ_CopyWobTabOff             ; 
                        jsr DynDispGameSprites            ; 
                        
                        ldx #$96                          ; 
                        ldy #$8f                          ; 
                        sty BBZ_GameSoundTime             ; 
                        
BobMoveSetSinkX         jmp BobSoundHandler               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveFallEnd        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFallEnd          subroutine                        ;  
                        jsr BobMoveSetWalkIni             ; set type walk and init sprite no
                        
BobMoveFallEndX         jmp GoDispGameSprites             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMovDecJumpTone     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMovDecJumpTone       subroutine                        ; 
                        ldx BBZ_BobJumpTone               ; 
                        dex                               ; 
                        dex                               ; 
                        dex                               ; 
                        
BobMovDecJumpToneX      jmp BobMovSetJumpTone             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveFallInit       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFallInit         subroutine                        ; 
                        ldx BBZ_BobJumpTone               ; 
                        cpx #$ff                          ; 
                        beq BobMovSetJumpTone             ; 
                        
                        inx                               ; 
                        
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeFall          ; 
                        beq BobMovSetJumpTone             ; 
                        
                        cmp #BBZ_BobMoveTypeSlide         ; 
                        beq BobMovSetJumpTone             ; 
                        
                        cpx #$fe                          ; 
                        bcc .IncBobJumpTone               ; lower
                        
                        ldx #$fd                          ; 
                        
.IncBobJumpTone         inx                               ; 
BobMoveFallInitX        inx                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMovSetJumpTone     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMovSetJumpTone       subroutine                        ; 
                        stx BBZ_BobJumpTone               ; 
                        
                        ldy #$aa                          ; 
                        jsr BobSoundHandler               ; 
                        
                        ldx BBZ_BobFallHeight             ; 
                        bne GoDispGameSprites             ; 
                        
                        inc BBZ_BobMoveType               ; 
                        
                        lda #$10                          ; 
                        sta BBZ_BobFallHeight             ; 
                        
GoDispGameSprites       jmp DynDispGameSprites            ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobSpriteNumInit     dc.b NumSpriteBobRight_01         ; NumSpriteBobRight_01
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobRight_02
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobRight_03
                        dc.b NumSpriteBobLeft_01          ; NumSpriteBobLeft_01
                        dc.b NumSpriteBobLeft_01          ; NumSpriteBobLeft_02
                        dc.b NumSpriteBobLeft_01          ; NumSpriteBobLeft_03
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobLadder_01
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobLadder_02
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobLadderTop_01
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobLadderTop_02
                        dc.b NumSpriteBobRight_01         ; NumSpriteBobJumpRi
                        dc.b NumSpriteBobLeft_01          ; NumSpriteBobJumpLe
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveFall           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFall             subroutine                        ; 
                        inc BBZ_BobPosY                   ; 
                        inc BBZ_BobFallHeight             ; 
                        jsr BobMoveLimitWait              ; 
                        
                        jmp BobMoveGoCheckFall            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSink           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSink             subroutine                        ; 
                        dec BBZ_CopyWobTabOff             ; 
                        
                        ldx #$03                          ; 
                        
                        lda BBZ_BobSpriteNo               ; 
                        sec                               ; 
                        sbc #$08                          ; 
                        cmp #$02                          ; 
                        bcs .ChkSinkSpriteNo              ; greater/equal
                        
                        ldx #$05                          ; 
                        
.ChkSinkSpriteNo        cpx BBZ_CopyWobTabOff             ; 
                        bcc BobMoveDead                   ; lower
                        
                        inc BBZ_BobMoveType               ; BBZ_BobMoveTypeDead
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveSinkLooseLife  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveSinkLooseLife    subroutine                        ; 
.ChkPlayerLooseLive     lda BBZ_PlayerLooseLife           ; 
                        bne BobMoveDead                   ; lost a live already
                        
.SetLooseLivesNoMore    inc BBZ_PlayerLooseLife           ; BBZ_PlayerLooseLifeNo
                        
                        jsr ScoreBlinkInit                ; 
                        
                        asl BBZ_FlagScoreBlinkRate        ; 
                        
.LooseOneLivePlayer1    lda BBZ_ActivePlayer              ; 
                        bmi BobMoveSinkLooseLifeX         ; player 1
                        
.LooseOneLivePlayer2    dec BB_LivesNo_P2                 ; player 2
                        jmp BobMoveDead                   ; 
                        
BobMoveSinkLooseLifeX   dec BB_LivesNo_P1                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveDead           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveDead             subroutine                        ; 
                        jsr DynDispGameSprites            ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$03                          ; 
                        bne BobMoveDeadX                  ; 
                        
                        ldy BBZ_GameSoundTime             ; 
                        dey                               ; 
                        bpl BobMoveDeadX                  ; 
                        
                        sty BBZ_GameSoundTime             ; 
                        
                        ldx #$96                          ; 
                        jmp BobSoundHandler               ; 
                        
BobMoveDeadX            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobDemoMove           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobDemoMove             subroutine                        ; 
                        dec BBZ_BobDemoMoveTime           ; 
                        bne .SetDemoMove                  ; old move still ongoing
                        
.GetNextMovePair        ldy #$00                          ; 
                        lda (BBZ_BobDemoMovesPtr),y       ; 
                        sta BBZ_BobDemoMoveMove           ; 
                        
                        iny                               ; 
                        lda (BBZ_BobDemoMovesPtr),y       ; 
                        sta BBZ_BobDemoMoveTime           ; 
                        
.IncMovePointer         lda BBZ_BobDemoMovesPtrLo         ; 
                        clc                               ; 
                        adc #$02                          ; 
                        sta BBZ_BobDemoMovesPtrLo         ; 
                        bcc .SetDemoMove                  ; 
                        inc BBZ_BobDemoMovesPtrHi         ; 
                        
.SetDemoMove            lda BBZ_BobDemoMoveMove           ; 
                        sta BBZ_JoystickMovesGame         ; $9f if nothing pressed (fire in bit7 too)
                        
                        lsr a                             ; .#######
                        lsr a                             ; ..######
                        lsr a                             ; ...#####
                        lsr a                             ; ....####
                        
                        and #$07                          ; .....###
                        tax                               ; 
                        lda TabBobDemoRetVals,x           ; 
                        bne BobDemoMoveX                  ; always $07
                        
                        sta BBZ_KeyPressed                ; 
                        
BobDemoMoveX            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobDemoRetVals       dc.b $00 ; ........
                        dc.b $11 ; ...#...#
                        dc.b $12 ; ...#..#.
                        dc.b $13 ; ...#..##
                        dc.b $14 ; ...#.#..
                        dc.b $15 ; ...#.#.#
                        dc.b $1f ; ...#####
                        dc.b $ff ; ########
; -------------------------------------------------------------------------------------------------------------- ;
; SoundLevelSpecial     Does    : Sound for: Gravity Lift/Mobile Suction Tubes/Cannon
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SoundLevelSpecial       subroutine                        ; 
                        sta .__SpecialSfxFreq             ; 
                        
.ChkLevelBeep           lda BB_WA_LevelTimesLo_1000       ; 
                        bne .SetSpecialTime               ; 
                        
                        lda BB_WA_LevelTimesLo_100        ; 
                        ora BB_WA_LevelTimesLo_10         ; 
                        beq .ChkDeath                     ; 
                        
.ExitNoSound            rts                               ; 
                        
.ChkDeath               lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs .ExitNoSound                  ; greater/equal = sink or death
                        
.SetSpecialTime         sty BBZ_SpecialSfxTime            ; 
                        
.__SpecialSfxFreq       equ [* + $01]                     ; 
                        lda #$00                          ; Oscillator Offset DataSfxFreq
                        ldy #$07                          ; Oscillator SID Offset
SoundLevelSpecialX      jmp SoundEffects                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
; OffVoice_02           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
OffVoice_02             lda #$00                          ; 
                        sta SUREL2                        ; SID($D40D) Oscillator 2 Sustain/Release
                        sta BB_SaveSid_SUREL2             ; 
                        
OffVoice_02X            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SoundTimeHandler      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SoundTimeHandler        subroutine                        ; 
                        lda BBZ_XmitActive                ; 
                        bpl .ChkBobDeath                  ; 
                        
                        lda BBZ_IRQ_GameTimer             ; 
                        and #BBZ_TabDrawLineColor_02      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        bne .GetXmitGamePosY              ; 
                        
.SetXmitInactive        asl BBZ_XmitActive                ; clear Bit7 - keep Xmit Booth Number
                        clc                               ; 
                        ror BBZ_XmitActive                ; 
                        
__XmitGamePosY          equ [* + $01]                     ; 
.GetXmitGamePosY        lda #$00                          ; 
                        sta BBZ_DrawPosY                  ; 
                        
__XmitGamePosX          equ [* + $01]                     ; 
.GetXmitGamePosX        lda #$00                          ; 
                        sta BBZ_DrawPosX                  ; 
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        inc BBZ_DrawPosX                  ; 
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        inc BBZ_DrawPosX                  ; 
                        jsr DrawLinePartGetPosXY          ; from BBZ_DrawPosX / BBZ_DrawPosY
                        
                        lda BBZ_DrawPosY                  ; 
                        inc BBZ_DrawPosY                  ; 
                        cmp __XmitGamePosY                ; 
                        beq .GetXmitGamePosX              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Check Death / Level Complete
; -------------------------------------------------------------------------------------------------------------- ;
.ChkBobDeath            lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs OffVoice_02                   ; greater/equal = Sink/Death
                        
.ChkLevelComplete       lda BBZ_FloorPiecesFlipped        ; lower = Walk/Climb/Slide/Jump/Fall
                        cmp BBZ_CountFloorTilesToFlip     ; 
                        beq OffVoice_02                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Check Beep Time / Intervalls
; -------------------------------------------------------------------------------------------------------------- ;
.ChkTimeLowBeeps        ldx BB_WA_LevelTimesLo_1000       ; no sounds if time low beeps
                        bne SoundHitHandler               ; 
                        
                        lda BB_WA_LevelTimesLo_100        ; 
                        ora BB_WA_LevelTimesLo_10         ; 
.ChkTimeUp              bne .StillAlive                   ; 
                        
.WasTime_Up             dec BBZ_TimeLowBeepLen            ; 
                        bne OffVoice_02                   ; 
                        
                        inc BBZ_TimeLowBeepLen            ; 
                        jmp SoundHitHandler               ; 
                        
.StillAlive             lda #$00                          ; 
                        sta BBZ_ToneTypeHight             ; 
                        sta BBZ_SfxSusRel                 ; 
                        
                        dec BBZ_TimeLowBeepLen            ; 
                        bne .DecBeepSpeedSimple           ; 
                        
                        jsr OffVoice_02                   ; 
                        
.DecBeepSpeedSimple     dec BBZ_TimeLowBeepSpeed          ; stress
                        bne SoundTimeHandlerX             ; 
                        
                        lda #$78                          ; Oscillator Offset DataSfxFreq
                        ldy #$07                          ; Oscillator SID Offset
                        ldx #$46                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffects                  ; alarm time low
                        
                        lda BB_WA_LevelTimesLo_100        ; 
                        sec                               ; 
.CkkTimeRest100         beq .DecBeepSpeedMax              ; 
                        
                        sbc #$10                          ; 
                        asl a                             ; 
                        asl a                             ; 
                        
.DecBeepSpeedMax        adc #BBZ_TimeLowBeepSpeedDecMax   ; stress stress
                        sta BBZ_TimeLowBeepSpeed          ; 
                        
                        lda #BBZ_TimeLowBeepLenInit       ; 
                        sta BBZ_TimeLowBeepLen            ; 
                        
SoundTimeHandlerX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SoundHitHandler       Does    : Score Sounds Items/Enemies/Suct Tube Switch
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SoundHitHandler         subroutine                        ; 
                        lda BBZ_ToneTypeHight             ; 
                        beq .ChkSusRel                    ; 
                        bpl .ChkBobMoveTimer              ; 
                        
                        lda #$0f                          ; ....####
                        sta BBZ_ToneTypeHight             ; 
                        
.ChkBobMoveTimer        lda BBZ_IRQ_GameTimer             ; 
                        and #$03                          ; 
                        bne SoundTimeHandlerX             ; 
                        
                        dec BBZ_ToneTypeHight             ; 
                        
                        lda BBZ_SpecialSfxTime            ; 
                        bne .ChkSusRel                    ; 
                        
                        lda BBZ_ToneTypeHight             ; 
                        ora #$40                          ; .#......
                        tax                               ; Oscillator Ctrl/SustainRelease
                        
.VaryToneHight          lda #$14                          ; 
                        sec                               ; 
                        sbc BBZ_ToneTypeHight             ; 
                        
                        asl a                             ; 
                        asl a                             ; 
                        asl a                             ; 
                        sta .__Hight                      ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$07                          ; .....###
.__Hight                equ [* + $01]                     ; 
                        adc #$00                          ; Oscillator Offset DataSfxFreq
                        ldy #$07                          ; Oscillator SID Offset
                        jsr SoundEffects                  ; sound pick item
                        
.ChkSusRel              lda BBZ_SfxSusRel                 ; 
                        beq SoundTimeHandlerX             ; 
                        bpl .DecTime_01                   ; 
                        
.Reinit                 lda #$0e                          ; 
                        sta BBZ_SfxSusRel                 ; 
                        
                        lda #$12                          ; 
                        sta BBZ_SfxTime_02                ; 
                        sta BBZ_SfxTime_01                ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$7f                          ; .#######
                        adc #$14                          ; 
                        sta BBZ_SfxFreq                   ; 
                        
.DecTime_01             dec BBZ_SfxTime_01                ; 
                        bne .GetToneHight                 ; 
                        
                        dec BBZ_SfxSusRel                 ; 
                        dec BBZ_SfxSusRel                 ; 
                        
                        dec BBZ_SfxTime_02                ; 
                        
                        lda BBZ_SfxTime_02                ; 
                        sta BBZ_SfxTime_01                ; 
                        
.GetToneHight           lda BBZ_ToneTypeHight             ; 
                        ora BBZ_SpecialSfxTime            ; 
                        bne SoundTimeHandlerX             ; 
                        
                        lda BBZ_SfxSusRel                 ; 
                        lsr a                             ; 
                        and #$0f                          ; ....####
                        ora #$40                          ; .#......
                        tax                               ; Oscillator Ctrl/SustainRelease
                        
                        lda #$0f                          ; 
                        sec                               ; 
                        sbc BBZ_SfxSusRel                 ; 
                        asl a                             ; 
                        adc #$04                          ; 
                        sta BBZ_SfxSusRelCheck            ; 
                        
.GetRnd                 lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$1f                          ; ...#####
                        cmp BBZ_SfxSusRelCheck            ; 
                        bcs .GetRnd                       ; greater/equal
                        
                        adc BBZ_SfxFreq                   ; Oscillator Offset DataSfxFreq
                        
                        ldy #$07                          ; Oscillator SID Offset
SoundHitHandlerX        jmp SoundEffects                  ; sound kill enemy
; -------------------------------------------------------------------------------------------------------------- ;
TabSecretMsgLo          dc.b <SecMsg_FlowerPot            ; 
                        dc.b <SecMsg_CoffeePot            ; 
                        dc.b <SecMsg_Fork                 ; 
                        dc.b <SecMsg_Gobelet              ; 
                        dc.b <SecMsg_Pie                  ; 
                        dc.b <SecMsg_PaintRoller          ; 
                        dc.b <SecMsg_NewLine              ; 
                        dc.b <SecMsg_NewLine              ; 
                        dc.b <SecMsg_NewLine              ; 
                        dc.b <SecMsg_NewLine              ; 
                        dc.b <SecMsg_SetTube01            ; 
                        dc.b <SecMsg_KillAliens           ; 
                        
TabSecretMsgHi          dc.b >SecMsg_FlowerPot            ; 
                        dc.b >SecMsg_CoffeePot            ; 
                        dc.b >SecMsg_Fork                 ; 
                        dc.b >SecMsg_Gobelet              ; 
                        dc.b >SecMsg_Pie                  ; 
                        dc.b >SecMsg_PaintRoller          ; 
                        dc.b >SecMsg_NewLine              ; 
                        dc.b >SecMsg_NewLine              ; 
                        dc.b >SecMsg_NewLine              ; 
                        dc.b >SecMsg_NewLine              ; 
                        dc.b >SecMsg_SetTube01            ; 
                        dc.b >SecMsg_KillAliens           ; 
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_4TheAdvanced     dc.b $76 ; A
                        dc.b $55 ; <space>
                        dc.b $88 ; S
                        dc.b $7a ; E
                        dc.b $78 ; C
                        dc.b $87 ; R
                        dc.b $7a ; E
                        dc.b $89 ; T
                        dc.b $55 ; <space>
                        dc.b $82 ; M
                        dc.b $7a ; E
                        dc.b $88 ; S
                        dc.b $88 ; S
                        dc.b $76 ; A
                        dc.b $7c ; G
                        dc.b $7a ; E
                        dc.b $55 ; <space>
                        dc.b $7b ; F
                        dc.b $84 ; O
                        dc.b $87 ; R
                        dc.b $55 ; <space>
                        dc.b $76 ; A
                        dc.b $79 ; D
                        dc.b $8b ; V
                        dc.b $76 ; A
                        dc.b $83 ; N
                        dc.b $78 ; C
                        dc.b $7a ; E
                        dc.b $79 ; D
                        dc.b $55 ; <space>
                        dc.b $85 ; P
                        dc.b $81 ; L
                        dc.b $76 ; A
                        dc.b $8e ; Y
                        dc.b $7a ; E
                        dc.b $87 ; R
                        dc.b $88 ; S
                        dc.b $6f ; :
                        
SecMsg_NewLine          dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_SetTube01        dc.b $15 ; <space>
                        dc.b $48 ; S
                        dc.b $3a ; E
                        dc.b $49 ; T
                        dc.b $15 ; <space>
                        dc.b $48 ; S
                        dc.b $4a ; U
                        dc.b $38 ; C
                        dc.b $49 ; T
                        dc.b $3e ; I
                        dc.b $44 ; O
                        dc.b $43 ; N
                        dc.b $15 ; <space>
                        dc.b $49 ; T
                        dc.b $4a ; U
                        dc.b $37 ; B
                        dc.b $3a ; E
                        dc.b $15 ; <space>
                        dc.b $44 ; O
                        dc.b $43 ; N
                        dc.b $3a ; E
                        dc.b $15 ; <space>
                        dc.b $49 ; T
                        dc.b $44 ; O
                        dc.b $15 ; <space>
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $15 ; <space>
                        dc.b $41 ; L
                        dc.b $3a ; E
                        dc.b $3b ; F
                        dc.b $49 ; T
                        dc.b $15 ; <space>
                        dc.b $36 ; A
                        dc.b $43 ; N
                        dc.b $39 ; D
                        dc.b $15 ; <space>
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $43 ; N
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_KillAliens       dc.b $15 ; <space>
                        dc.b $3b ; F
                        dc.b $3e ; I
                        dc.b $47 ; R
                        dc.b $48 ; S
                        dc.b $49 ; T
                        dc.b $15 ; <space>
                        dc.b $40 ; K
                        dc.b $3e ; I
                        dc.b $41 ; L
                        dc.b $41 ; L
                        dc.b $15 ; <space>
                        dc.b $36 ; A
                        dc.b $41 ; L
                        dc.b $41 ; L
                        dc.b $15 ; <space>
                        dc.b $36 ; A
                        dc.b $41 ; L
                        dc.b $3e ; I
                        dc.b $3a ; E
                        dc.b $43 ; N
                        dc.b $48 ; S
                        dc.b $15 ; <space>
                        dc.b $36 ; A
                        dc.b $43 ; N
                        dc.b $39 ; D
                        dc.b $15 ; <space>
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $43 ; N
                        dc.b $15 ; <space>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_FlowerPot        dc.b $3b ; F
                        dc.b $41 ; L
                        dc.b $44 ; O
                        dc.b $4c ; W
                        dc.b $3a ; E
                        dc.b $47 ; R
                        dc.b $15 ; <space>
                        dc.b $45 ; P
                        dc.b $44 ; O
                        dc.b $49 ; T
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_CoffeePot        dc.b $38 ; C
                        dc.b $44 ; O
                        dc.b $3b ; F
                        dc.b $3b ; F
                        dc.b $3a ; E
                        dc.b $3a ; E
                        dc.b $15 ; <space> 
                        dc.b $45 ; P
                        dc.b $44 ; O
                        dc.b $49 ; T
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_Fork             dc.b $45 ; P
                        dc.b $3e ; I
                        dc.b $49 ; T
                        dc.b $38 ; C
                        dc.b $3d ; H
                        dc.b $3b ; F
                        dc.b $44 ; O
                        dc.b $47 ; R
                        dc.b $40 ; K
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_Gobelet          dc.b $3c ; G
                        dc.b $44 ; O
                        dc.b $37 ; B
                        dc.b $41 ; L
                        dc.b $3a ; E
                        dc.b $49 ; T
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_Pie              dc.b $45 ; P
                        dc.b $3e ; I
                        dc.b $3a ; E
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_PaintRoller      dc.b $45 ; P
                        dc.b $36 ; A
                        dc.b $3e ; I
                        dc.b $43 ; N
                        dc.b $49 ; T
                        dc.b $15 ; <space>  
                        dc.b $47 ; R
                        dc.b $44 ; O
                        dc.b $41 ; L
                        dc.b $41 ; L
                        dc.b $3a ; E
                        dc.b $47 ; R
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_InLevel          dc.b $3e ; I
                        dc.b $43 ; N
                        dc.b $15 ; <space>  
                        dc.b $41 ; L
                        dc.b $3a ; E
                        dc.b $4b ; V
                        dc.b $3a ; E
                        dc.b $41 ; L
                        dc.b $15 ; <space> 
                        dc.b $35 ; <dots>
                        dc.b $21 ; <komma>
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_AfterGetItem     dc.b $15 ; <space> 
                        dc.b $3e ; I
                        dc.b $42 ; M
                        dc.b $42 ; M
                        dc.b $42 ; M
                        dc.b $3a ; E
                        dc.b $39 ; D
                        dc.b $3e ; I
                        dc.b $36 ; A
                        dc.b $49 ; T
                        dc.b $3a ; E
                        dc.b $41 ; L
                        dc.b $4e ; y
                        dc.b $15 ; <space>  
                        dc.b $36 ; A
                        dc.b $3b ; F
                        dc.b $49 ; T
                        dc.b $3a ; E
                        dc.b $47 ; R
                        dc.b $15 ; <space>  
                        dc.b $45 ; P
                        dc.b $3e ; I
                        dc.b $38 ; C
                        dc.b $40 ; K
                        dc.b $3e ; I
                        dc.b $43 ; N
                        dc.b $3c ; G
                        dc.b $15 ; <space>  
                        dc.b $4a ; U
                        dc.b $45 ; P
                        dc.b $15 ; <space>  
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $15 ; <space> 
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
SecMsg_TypeNoAndF7      dc.b $15 ; <space> 
                        dc.b $49 ; T
                        dc.b $4e ; y
                        dc.b $45 ; P
                        dc.b $3a ; E
                        dc.b $15 ; <space>  
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $15 ; <space>  
                        dc.b $43 ; N
                        dc.b $4a ; U
                        dc.b $42 ; M
                        dc.b $37 ; B
                        dc.b $3a ; E
                        dc.b $47 ; R
                        dc.b $15 ; <space>  
                        dc.b $18 ; 8
                        dc.b $15 ; <space>  
                        dc.b $44 ; O
                        dc.b $43 ; N
                        dc.b $15 ; <space>  
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $15 ; <space>  
                        dc.b $40 ; K
                        dc.b $3a ; E
                        dc.b $4e ; y
                        dc.b $37 ; B
                        dc.b $44 ; O
                        dc.b $36 ; A
                        dc.b $47 ; R
                        dc.b $39 ; D
                        dc.b $15 ; <space>  
                        dc.b $36 ; A
                        dc.b $43 ; N
                        dc.b $39 ; D
                        dc.b $15 ; <space>  
                        dc.b $49 ; T
                        dc.b $3d ; H
                        dc.b $3a ; E
                        dc.b $43 ; N
                        dc.b $15 ; <space>  
                        dc.b $45 ; P
                        dc.b $47 ; R
                        dc.b $3a ; E
                        dc.b $48 ; S
                        dc.b $48 ; S
                        dc.b $15 ; <space>  
                        dc.b $3b ; F
                        dc.b $2c ; 7
                        dc.b $15 ; <space>  
                        dc.b $49 ; T
                        dc.b $44 ; O
                        dc.b $15 ; <space>  
                        dc.b $4c ; W
                        dc.b $36 ; A
                        dc.b $47 ; R
                        dc.b $45 ; P
                        dc.b $15 ; <space>  
                        dc.b $49 ; T
                        dc.b $44 ; O
                        dc.b $15 ; <space>  
                        dc.b $41 ; L
                        dc.b $3a ; E
                        dc.b $4b ; V
                        dc.b $3a ; E
                        dc.b $41 ; L
                        dc.b $15 ; <space>  
                        dc.b $19 ; 9
                        dc.b $23 ; .
                        
                        dc.b $1a ; End Of Secret Message
; -------------------------------------------------------------------------------------------------------------- ;
TabSecMsgLevelActionNum equ [* - $01] ; 
                        dc.b $01 ; 01 - the level number where the action takes place
                        dc.b $05 ; 05
                        dc.b $0a ; 10
                        dc.b $03 ; 03
                        dc.b $10 ; 16
                        dc.b $02 ; 02
TabSecMsgLevelActionLen equ  [* - TabSecMsgLevelActionNum - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSecMsgLevelSolvedNum equ  [* - $01] ;  
                        dc.b $04 ; 03 - the level number which has to be reached for a secret message
                        dc.b $08 ; 08
                        dc.b $0e ; 14
                        dc.b $0f ; 15
                        dc.b $13 ; 19
                        dc.b $16 ; 22
TabSecMsgLevelSolvedLen equ  [* - TabSecMsgLevelSolvedNum - $01] ; 
; -------------------------------------------------------------------------------------------------------------- ;
SecretTextX             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SecretTextVar         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SecretTextVar           subroutine                        ; 
                        tay                               ; 
                        lda TabSecretMsgLo,y              ; 
                        ldx TabSecretMsgHi,y              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SecretTextFix         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SecretTextFix           subroutine                        ; 
                        sta BBZ_SecMsgTextPtrLo           ; 
                        stx BBZ_SecMsgTextPtrHi           ; 
                        
.IniNextSecMsgCharCount ldy #$00                          ; 
                        ldx BBZ_SecMsgCharCount           ; 
                        
.GetNextSecMsgChar      lda (BBZ_SecMsgTextPtr),y         ; 
                        sec                               ; 
.MakeNextSecMsgChar     sbc #$15                          ; remove obfuscation
.GotSecMsgChar_Space    beq .ChkEndOfRow                  ; 
                        
                        cmp #$05                          ; 
.GotSecMsgChar_EoMsg    beq .ChkEndOfRow                  ; 
                        
.SetNextSecMsgChar      iny                               ; 
                        
.SetSecMsgCharCount     inx                               ; 
.SetSecMsgCharCountMax  cpx #BB_Scrn_InfoRowLen           ; 
                        bcc .GetNextSecMsgChar            ; lower
.Was_EndOfRow           bcs .SetSecMsgOutPtr              ; always - higher/equal
; -------------------------------------------------------------------------------------------------------------- ;
.ChkEndOfRow            cpx #[BB_Scrn_InfoRowLen - $01]   ; 
                        bcc .GetNextSecMsgCharOut         ; lower
                        
.SetSecMsgOutPtr        lda #BB_Scrn_InfoRowLen           ; 
                        sec                               ; 
                        sbc BBZ_SecMsgCharCount           ; 
                        clc                               ; 
                        adc BBZ_SecMsgOutPtrLo            ; 
                        sta BBZ_SecMsgOutPtrLo            ; 
                        
                        lda #$00                          ; 
                        sta BBZ_SecMsgCharCount           ; 
                        
                        adc BBZ_SecMsgOutPtrHi            ; 
                        sta BBZ_SecMsgOutPtrHi            ; 
; -------------------------------------------------------------------------------------------------------------- ;
.GetNextSecMsgCharOut   ldy #$00                          ; 
                        lda (BBZ_SecMsgTextPtr),y         ; 
                        sec                               ; 
.MakeSecMsgCharOut      sbc #$15                          ; remove obfuscation
.Chk_EoMsg              cmp #$05                          ; 
.Was_EoMsg              beq SecretTextX                   ; 
                        
.Chk_Dots               cmp #$20                          ; dots of SecMsg_InLevel
.Was_Dots               beq .SecMsgChar_Dots              ; 
                        
.Chk_Hash               cmp #$03                          ; "#"
.Was_Hash               beq .SecMsgChar_Hash              ; 
                        
.Chk_Arrow              cmp #$04                          ; "->"
                        bne .SecMsgChar_Char              ; 
                        
.SecMsgChar_Arrow       lda BBZ_SecMsgLevelSolved         ; 
                        bpl .CalcLevelNum                 ; always
                        
.SecMsgChar_Hash        lda BBZ_SecMsgNumChar             ; 
                        bpl .SecMsgChar_Char              ; 
                        
.SecMsgChar_Dots        lda BBZ_SecMsgLevelAction         ; 
                        
.CalcLevelNum           cmp #$0a                          ; 
                        bcc .MakeCharIni                  ; lower
                        
                        ldx #$11                          ; 
                        
.Sub10_1st              sbc #$0a                          ; 
.Chk10_1st              cmp #$0a                          ; 
                        bcc .SavelevelNum                 ; lower
                        
.Sub10_2nd              sbc #$0a                          ; 
                        
                        inx                               ; 
                        
.SavelevelNum           pha                               ; 
                        
                        txa                               ; 
                        jsr SecretMsgOut                  ; 
                        
.RestorelevelNum        pla                               ; 
                        
.MakeCharIni            clc                               ; 
.MakeChar               adc #$10                          ; "0"
                        
.SecMsgChar_Char        pha                               ; 
                        jsr SecretMsgOut                  ; 
                        
.IncSecMsgCharPtr       inc BBZ_SecMsgTextPtrLo           ; 
                        bne .GoCheckJoystick              ; 
                        inc BBZ_SecMsgTextPtrHi           ; 
                        
.GoCheckJoystick        jsr CheckJoystick                 ; 
                        bcs .RestoreSecMsgChar            ; 
                        
.RemoveSecMsgChar       pla                               ; 
.RemoveReturnAddress    pla                               ; do not return to SecretMsg
                        pla                               ; 
                        jmp SecretMsgPrepExit             ; 
                        
.RestoreSecMsgChar      pla                               ; 
.WasSpace               beq .IniNextSecMsgCharCount       ; 
                        bne .GetNextSecMsgCharOut         ; always
; -------------------------------------------------------------------------------------------------------------- ;
; SecretMsgOut          Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SecretMsgOut            subroutine                        ; 
                        pha                               ; 
                        
                        ldy #$00                          ; 
.OutSecMsgChar          sta (BBZ_SecMsgOutPtr),y          ; 
                        
.IncSecMsgCharPtr       inc BBZ_SecMsgOutPtrLo            ; 
                        bne .IncSecMsgCharCount           ; 
                        inc BBZ_SecMsgOutPtrHi            ; 
                        
.IncSecMsgCharCount     inc BBZ_SecMsgCharCount           ; 
                        
                        jsr GetKeyPressed                 ; 
                        
SecretMsgOutX           jmp BeepWait                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
;TabBobJumpDir           equ  * - $d5
TabBobJumpDir           dc.b $ff ; $d5 -> -1=up
                        dc.b $ff ; $d6 -> -1=up
                        dc.b $ff ; $d7 -> -1=up
                        dc.b $ff ; $d8 -> -1=up
                        dc.b $ff ; $d9 -> -1=up
                        dc.b $ff ; $da -> -1=up
                        dc.b $ff ; $db -> -1=up
                        dc.b $ff ; $dc -> -1=up
                        dc.b $ff ; $dd -> -1=up
                        dc.b $ff ; $de -> -1=up
                        dc.b $ff ; $df -> -1=up
                        dc.b $00 ; $e0 -> 
                        dc.b $00 ; $e1 -> 
                        dc.b $ff ; $e2 -> -1=up
                        dc.b $ff ; $e3 -> -1=up
                        dc.b $ff ; $e4 -> -1=up
                        dc.b $00 ; $e5 -> 
                        dc.b $00 ; $e6 -> 
                        dc.b $ff ; $e7 -> -1=up
                        dc.b $ff ; $e8 -> -1=up
                        dc.b $00 ; $e9 -> 
                        dc.b $00 ; $ea -> 
                        dc.b $00 ; $eb -> 
                        dc.b $01 ; $ec ->  1=down
                        dc.b $01 ; $ed ->  1=down
                        dc.b $00 ; $ee -> 
                        dc.b $00 ; $ef -> 
                        dc.b $01 ; $f0 ->  1=down
                        dc.b $01 ; $f1 ->  1=down
                        dc.b $01 ; $f2 ->  1=down
                        dc.b $00 ; $f3 -> 
                        dc.b $00 ; $f4 -> 
                        dc.b $01 ; $f5 ->  1=down
                        dc.b $01 ; $f6 ->  1=down
                        dc.b $01 ; $f7 ->  1=down
                        dc.b $01 ; $f8 ->  1=down
                        dc.b $01 ; $f9 ->  1=down
                        dc.b $01 ; $fa ->  1=down
                        dc.b $01 ; $fb ->  1=down
                        dc.b $01 ; $fc ->  1=down
                        dc.b $01 ; $fd ->  1=down
                        dc.b $01 ; $fe ->  1=down
                        dc.b $01 ; $ff ->  1=down
TabBobJumpDirX          equ  *   ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabEnemySpritePtr       dc.b [BB_SpriteStore04 / VIC_Sprt_BlockLen] ; 1st half: enemy normal left  1 - $00
                        dc.b [BB_SpriteStore05 / VIC_Sprt_BlockLen] ; 1st half: enemy normal left  1 - $01
                        dc.b [BB_SpriteStore06 / VIC_Sprt_BlockLen] ; 1st half: enemy normal right 1 - $02
                        dc.b [BB_SpriteStore07 / VIC_Sprt_BlockLen] ; 1st half: enemy normal right 2 - $03
                        
                        dc.b [BB_SpriteStore04 / VIC_Sprt_BlockLen] ; 2nd half: enemy normal left  1 - $04
                        dc.b [BB_SpriteStore05 / VIC_Sprt_BlockLen] ; 2nd half: enemy normal left  1 - $05
                        dc.b [BB_SpriteStore06 / VIC_Sprt_BlockLen] ; 2nd half: enemy normal right 1 - $06
                        dc.b [BB_SpriteStore07 / VIC_Sprt_BlockLen] ; 2nd half: enemy normal right 2 - $07
                        
                        dc.b [BB_SpriteStore08 / VIC_Sprt_BlockLen] ; 1st half: enemy smile  left  1 - $08
                        dc.b [BB_SpriteStore09 / VIC_Sprt_BlockLen] ; 1st half: enemy smile  left  1 - $09
                        dc.b [BB_SpriteStore08 / VIC_Sprt_BlockLen] ; 1st half: enemy smile  right 1 - $0a
                        dc.b [BB_SpriteStore09 / VIC_Sprt_BlockLen] ; 1st half: enemy smile  right 2 - $0b
                        
                        dc.b [BB_SpriteStore08 / VIC_Sprt_BlockLen] ; 2nd half: enemy smile  left  1 - $0c
                        dc.b [BB_SpriteStore09 / VIC_Sprt_BlockLen] ; 2nd half: enemy smile  left  1 - $0d
                        dc.b [BB_SpriteStore08 / VIC_Sprt_BlockLen] ; 2nd half: enemy smile  right 1 - $0e
                        dc.b [BB_SpriteStore09 / VIC_Sprt_BlockLen] ; 2nd half: enemy smile  right 2 - $0f
                        
                        dc.b [BB_SpriteStore0a / VIC_Sprt_BlockLen] ; enemy score 80                 - $10
                        dc.b [BB_SpriteStore0b / VIC_Sprt_BlockLen] ; enemy score 90                 - $11
; -------------------------------------------------------------------------------------------------------------- ;
; BobSetDeath           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobSetDeath             subroutine                        ; 
__BobSetDeath           equ *                             ; (de)activate routine
                        nop                               ; 
                        nop                               ; 
                        
                        lda BBZ_CannonStatus              ; 
                        cmp #BBZ_CannonStatusFly          ; 
.NotIf_CannonFly        beq BobSetDeathX                  ; 
                        
                        lda BBZ_CountFloorTilesToFlip     ; 
                        cmp BBZ_FloorPiecesFlipped        ; 
.NotIf_LevelSolved      beq BobSetDeathX                  ; 
                        
.Sucide                 lda #BBZ_PlayerStatusDead         ; 
                        sta BBZ_PlayerStatus              ; 
                        
BobSetDeathX            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoIrqGameCheckInput     jmp IRQ_GameCheckInput            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameStart         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameStart           subroutine                        ; 
                        pha                               ; 
                        txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        lda R6510                         ; 
.SaveConfig             pha                               ; 
                        ora #[IO_ON | BASIC_ON]           ; .....#.# - io=on kernal=keep basic=on (if kernal=on)
                        sta R6510                         ; 
                        
                        lda RASTER                        ; VIC($D012) Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        cmp #$fb                          ; 251 - $02 lines off the visible screen
.AllSpritesDone         beq GoIrqGameCheckInput           ; or 1st time
                        
                        ldx BBZ_SpriteNoToHandle          ; 
                        
                        inc BBZ_BobXmitSpriteCount        ; 
                        
.ChkSpritePart1         lda [BB_WA_SpriteColor_P1 - $01],x; 
                        beq .ChkSpritePart2               ; this sprite is killed
                        
__GetXmitSpriteColor_P1 equ [* + $01]                     ; WA block offset for sprite to handle
                        ldy #$00                          ; 
                        sta SP4COL,y                      ; VIC($D02B) Color Sprite 4
                        
                        lda [BB_WA_SpritePtrA - $01],x    ; 
                        sta BB_SpritePointer04,y          ; 
                        
                        tya                               ; 
                        asl a                             ; 
                        tay                               ; 
                        
                        lda [BB_WA_SpritePosY_P1 - $01],x ; 
                        sta SP4Y,y                        ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda [BB_WA_SpritePosX_P1 - $01],x ; 
                        sec                               ; 
                        sbc #$24                          ; 
                        asl a                             ; 
                        sta SP4X,y                        ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda TabSpriteMsbPosX_Hi,y         ; 
                        bcc .FlipPosX_P1                  ; 
                        
                        ora MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        bcs .SetPosX_P1                   ; 
                        
.FlipPosX_P1            eor #$ff                          ; 
                        and MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
.SetPosX_P1             sta MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.ChkSpritePart2         lda [BB_WA_SpriteColor_P2 - $01],x; 
                        beq .ChkNumSpriteToHandle         ; 
                        
__GetXmitSpriteColor_P2 equ [* + $01]                     ; 
                        ldy #$02                          ; 
                        sta SP4COL,y                      ; VIC($D02B) Color Sprite 4
                        
                        lda [BB_WA_SpritePtrB - $01],x    ; 
                        sta BB_SpritePointer04,y          ; 
                        
                        tya                               ; 
                        asl a                             ; 
                        tay                               ; 
                        
                        lda [BB_WA_SpritePosY_P2 - $01],x ; 
                        sta SP4Y,y                        ; VIC($D009) Sprite 4 Y-Pos (Bits 0-7)
                        
                        lda [BB_WA_SpritePosX_P2 - $01],x ; 
                        sec                               ; 
                        sbc #$24                          ; 
                        asl a                             ; 
                        sta SP4X,y                        ; VIC($D008) Sprite 4 X-Pos (Bits 0-7 - Bit 8 in MSIGX = $D010)
                        
                        lda TabSpriteMsbPosX_Hi,y         ; 
                        bcc .FlipPosX_P2                  ; 
                        
                        ora MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        bcs .SetPosX_P2                   ; 
                        
.FlipPosX_P2            eor #$ff                          ; 
                        and MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
.SetPosX_P2             sta MSIGX                         ; VIC($D010) MSB X-Pos Sprites 0-7
                        
.ChkNumSpriteToHandle   cpx #$01                          ; BBZ_SpriteNoToHandle
                        bne GoIrqGameMoveSprite           ; 
                        
                        jsr IRQ_StatusLine                ; 
                        
                        nop                               ; 2 cycles = 8
                        nop                               ; 
                        nop                               ; 
                        nop                               ; 
                        
                        lda SPBGCL                        ; VIC($D01F) Sprite-Foreground Collision - Cleared on read
; -------------------------------------------------------------------------------------------------------------- ;
__IrqGameMovSprtLo      equ [* + $01]                     ; 
__IrqGameMovSprtHi      equ [* + $02]                     ; 
GoIrqGameMoveSprite     jmp BB_PlaceHolder_8000           ; dispatch TabAutoMoveSprites routines IRQ_MoveSprites(Xtra)
; -------------------------------------------------------------------------------------------------------------- ;
GoIrqGameXmitHandler    jmp IRQ_GameXmitHandler           ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoIrqNextSprtBlock      jmp IRQ_GameNextSprtBlock         ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoIrqGameNextSprtID     jmp IRQ_GameNextSprtID            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveSpritesPrep   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveSpritesPrep     subroutine                        ; 
                        inc BBZ_SpriteNoToHandle          ; 
                        
                        lda BB_WA_SpriteRaster,x          ; plus $35 (1st plus $34)
                        
                        cpx BBZ_CountSprites              ; 
                        bcc .SetRasterNext                ; lower
                        
.SetRasterInit          lda #$fb                          ; 
                        
.SetRasterNext          sta RASTER                        ; VIC($D012) Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        
                        lda #$ff                          ; 
.ClrVicIrq              sta VICIRQ                        ; VIC($D019) IRQ - Latched flags cleared if set to 1
                        
                        cli                               ; 
                        
                        lda BBZ_GamePause                 ; 
                        beq GoIrqGameXmitHandler          ; BBZ_GamePauseOn
                        
                        dex                               ; 
                        bne .SetNextSprite                ; 
                        
                        ldx BBZ_CountSprites              ; 
                        
.SetNextSprite          dex                               ; 
                        lda SPSPCL                        ; VIC($D01E) Sprite-Sprite Collision - Cleared on read
                        sta BBZ_SprtSprtCollision         ; 
                        
__GetSpriteMove_B1      equ [* + $01]                     ; 
                        lda #$00                          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_MoveSprites       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveSprites         sta BBZ_MoveSpriteNum             ; 
                        
                        lda BB_WA_SpritePosX,x            ; 
                        beq GoIrqNextSprtBlock            ; 
                        
                        ldy BB_WA_SpriteNumberA,x         ; 
                        bmi GoIrqGameNextSprtID           ; 
                        
                        cpy #$10                          ; 
                        bcs .IniKillEnemy                 ; greater/equal - score
                        
                        lda BBZ_SprtSprtCollision         ; 
                        and BBZ_MoveSpriteNum             ; 
                        beq .GetSpeed_B                   ; 
                        
                        lda BBZ_SprtSprtCollision         ; 
                        and #$0f                          ; ....####
                        beq .GetSpeed_B                   ; no collision
                        
                        cpy #$08                          ; ....#...
                        bcc .SetSprtSprtColl              ; lower
                        
                        dec BB_CountEnemySprites          ; 
                        
                        ldy #$10                          ; 
                        lda #$60                          ; .##..... - $60
                        sta BB_WA_SpriteID,x              ; 
                        
                        asl a                             ; ##...... - $c0
                        sta BBZ_SfxSusRel                 ; 
                        jmp IRQ_GameNextSpriteNum         ; set sprite num and init
; -------------------------------------------------------------------------------------------------------------- ;
.IniKillEnemy           lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta BB_WA_SpriteColor,x           ; 
                        
                        dec BB_WA_SpriteID,x              ; 
                        bne .GoIrqNextSprtBlock           ; 
                        
                        lda #$00                          ; 
                        sta BB_WA_SpritePosX,x            ; 
                        
.GoIrqNextSprtBlock     jmp IRQ_GameNextSprtBlock         ; 
                        
.SetSprtSprtColl        sta __IRQSetDispatchSub           ; set bob - sprite collision rountine
                        
.GetSpeed_B             lda BB_WA_SpriteSpeedB,x          ; 
                        sec                               ; 
__MoveSpritesSpeed      equ [* + $01]                     ; 
                        sbc #$00                          ; 
                        bcs .SetMoveSpeedB                ; 
                        
                        lda BB_WA_SpriteDir,x             ; 
                        bpl .NextStepRight                ; 
                        
.NextStepLeft           adc BB_WA_SpritePosX,x            ; 
                        sta BB_WA_SpritePosX,x            ; 
.ChkStepLeftMax         cmp BB_WA_SpriteMinX,x            ; 
                        bcs .GetMoveSpeedA                ; greater/equal
                        
.TurnRight              tya                               ; 
                        ora #$02                          ; ......#.
                        tay                               ; 
.GetMoveDirRight        lda #$01                          ; +1
                        jmp .SetMoveDir                   ; 
                        
.NextStepRight          clc                               ; 
                        adc BB_WA_SpritePosX,x            ; 
                        sta BB_WA_SpritePosX,x            ; 
.ChkStepRightMax        cmp BB_WA_SpriteMaxX,x            ; 
                        bcc .GetMoveSpeedA                ; lower
                        
.TurnLeft               tya                               ; 
                        and #$0d                          ; ....##.#
                        tay                               ; 
                        
.GetMoveDirLeft         lda #$ff                          ; -1
                        
.SetMoveDir             sta BB_WA_SpriteDir,x             ; 
                        
.GetMoveSpeedA          lda BB_WA_SpriteSpeedA,x          ; 
.SetMoveSpeedB          sta BB_WA_SpriteSpeedB,x          ; 
                        
                        lda BBZ_EnemyGoodTimeBlink        ; 
                        beq .ChkEnemySpriteMax            ; 
                        
                        cpy #$08                          ; 
                        bcs .GetEnemySpriteColor          ; greater/equal
                        
                        lda BBZ_EnemyState                ; 
                        beq IRQ_GameNextSprtID            ; 
                        
                        tya                               ; 
                        ora #$08                          ; ....#...
                        tay                               ; 
                        
                        lda BB_WA_SpriteColor,x           ; 
                        sta BB_WA_SpriteColorSave,x       ; 
                        
.GetEnemySpriteColor    lda BBZ_EnemyGoodFlipColor        ; 
                        sta BB_WA_SpriteColor,x           ; 
                        jmp IRQ_GameNextSprtID            ; 
                        
.ChkEnemySpriteMax      cpy #$08                          ; ....#...
                        bcc IRQ_GameNextSprtID            ; lower
                        
                        tya                               ; 
                        and #$07                          ; .....###
                        tay                               ; 
                        
                        lda BB_WA_SpriteColorSave,x       ; 
IRQ_MoveSpritesX        sta BB_WA_SpriteColor,x           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameNextSprtID    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameNextSprtID      subroutine                        ; 
                        lda BB_WA_SpriteID,x              ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        bcs IRQ_GameNextSprtIDX           ; 
                        
                        tya                               ; 
                        and #$0f                          ; ....####
                        eor #$01                          ; .......#
                        tay                               ; 
                        
                        lda #$0a                          ; 
IRQ_GameNextSprtIDX     sta BB_WA_SpriteID,x              ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameNextSpriteNum Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameNextSpriteNum   subroutine                        ; 
                        tya                               ; 
                        sta BB_WA_SpriteNumberA,x         ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameNextSprtBlock Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameNextSprtBlock   subroutine                        ; 
                        cpx #$10                          ; 
                        bcs IRQ_GameXmitHandler           ; greater/equal
                        
                        txa                               ; 
                        adc #$10                          ; 
                        tax                               ; 
                        
__GetSpriteMove_B2      equ [* + $01]                     ; 
                        lda #$00                          ; 
IRQ_GameNextSprtBlockX  jmp IRQ_MoveSprites               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GameXmitHandler   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GameXmitHandler     subroutine                        ; 
                        lda __GetXmitSpriteColor_P1       ; 
__SetSpriteXmitColor_P1 equ [* + $01]                     ; 
                        eor #$01                          ; .......# - flip
                        sta __GetXmitSpriteColor_P1       ; 
                        
__SetSpriteXmitColor_P2 equ [* + $01]                     ; 
                        ora #$02                          ; ......#. - set
                        sta __GetXmitSpriteColor_P2       ; 

.IrqGameXmit            ldy BBZ_XmitFlipFlopPos           ; handle xmit flip flop between two positions
                        bne .GetXmitSpriteCount           ; 
                        
.DecXmitSpriteCount     dec BBZ_BobXmitSpriteCount        ; was BBZ_XmitFlipFlopPosNone
                        jmp IRQ_GameExitPrep              ; 
                        
.GetXmitSpriteCount     ldx BBZ_BobXmitSpriteCount        ; 
                        dex                               ; 
                        bne .DecXmitSpriteCount           ; 
                        
.WasNewPos              lda BBZ_BobNewY                   ; 
.GetOldPos              ldx #BBZ_BobOldPos                ; zero page offset
                        
                        dey                               ; 
                        beq .ChkRaster                    ; BBZ_XmitFlipFlopPosNew if zero
                        
.WasOldPos              lda BBZ_BobPosY                   ; 
.GetNewPos              ldx #BBZ_BobNewPos                ; zero page offset
                        
.ChkRaster              clc                               ; 
                        adc #$4e                          ; 
                        cmp RASTER                        ; VIC($D012) Current Raster Scan Line (Bit 8 in SCROLY = $D011)
                        bcs .DecXmitSpriteCount           ; greater/equal
                        
.SetSelPos              lda D6510,x                       ; BBZ_BobNewX/BBZ_BobPosX
                        ldy R6510,x                       ; BBZ_BobNewY/BBZ_BobPosY
                        jsr BobMoveSprite_ay              ; 
                        
IRQ_GameXmitHandlerX    jmp IRQ_GameExitPrep              ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobTimeFlicker       dc.b BROWN  ; 
                        dc.b ORANGE ; 
; -------------------------------------------------------------------------------------------------------------- ;
; InitVoice3            Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
InitVoice3              subroutine                        ; 
                        lda #$08                          ; 
                        sta VCREG3                        ; SID($D412) Oscillator 3 Control
                        
                        lda #$00                          ; 
                        sta ATDCY3                        ; SID($D413) Oscillator 3 Attack/Decay
                        sta SUREL3                        ; SID($D414) Oscillator 3 Sustain/Release
                        
                        lda #$81                          ; 
                        sta VCREG3                        ; SID($D412) Oscillator 3 Control
                        
                        lda #$ff                          ; 
                        sta FRELO3                        ; SID($D40E) Oscillator 3 Freq Ctrl (low byte)
                        sta FREHI3                        ; SID($D40F) Oscillator 3 Freq Ctrl (high byte)
                        
InitVoice3X             rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFillFloorXit     jmp BobMoveAdjustPosXX            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveFillFloor      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFillFloor        subroutine                        ; 
                        cmp [BB_WA_FloorMaxX - $01],x     ; 
                        bcs .GetFloorMaxX                 ; greater/equal
                        
                        sec                               ; lower
                        sbc [BB_WA_FloorMinX - $01],x     ; 
                        bcc .GetFloorMinX                 ; 
                        
                        and #$fc                          ; ######..
                        clc                               ; 
                        adc [BB_WA_FloorMinX - $01],x     ; 
                        bcc .SetFloorMinX                 ; 
                        
.GetFloorMaxX           lda [BB_WA_FloorMaxX - $01],x     ; 
                        sbc #$04                          ; 
                        bcs .SetFloorMinX                 ; 
                        
.GetFloorMinX           lda [BB_WA_FloorMinX - $01],x     ; 
                        
.SetFloorMinX           sta BBZ_DrawFloorMinX             ; 
                        jsr BobMoveFillFloorIni           ; 
                        beq BobMoveFillFloorXit           ; 
                        
.FillNextFloorPiecePart ldy #$00                          ; 
                        lda (BBZ_MoveFloorPtr),y          ; 
                        ora TabFloorTileLe,x              ; 
__FloorFillColorLe      equ [* + $01]                     ; 
                        and #$00                          ; 
                        sta (BBZ_MoveFloorPtr),y          ; 
                        
                        ldy #$08                          ; 
                        lda (BBZ_MoveFloorPtr),y          ; 
                        ora TabFloorTileRi,x              ; 
__FloorFillColorRi      equ [* + $01]                     ; 
                        and #$00                          ; 
                        sta (BBZ_MoveFloorPtr),y          ; 
                        
                        lda BBZ_MoveFloorPtrLo            ; 
                        clc                               ; 
                        adc #$02                          ; 
                        sta BBZ_MoveFloorPtrLo            ; 
                        
                        and #$07                          ; .....###
                        cmp #$02                          ; 
                        bcs .DecFloorPieceHight           ; greater/equal
                        
.Correction             lda BBZ_MoveFloorPtrLo            ; otherwise floor fill part is too high
                        sec                               ; 
                        sbc #$02                          ; 
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $06] ; 
                        sta BBZ_MoveFloorPtrLo            ; 
                        
                        lda BBZ_MoveFloorPtrHi            ; 
                        adc #>[BB_Scrn_HiResRowLen - $06] ; 
                        sta BBZ_MoveFloorPtrHi            ; 
                        
.DecFloorPieceHight     dec BBZ_FloorPieceHight           ; 
                        bne .FillNextFloorPiecePart       ; 
                        
                        inc BBZ_ScoreToAddFloor           ; 
                        inc BBZ_FloorPiecesFlipped        ; 
                        
                        lda BBZ_FloorPiecesFlipped        ; 
                        cmp BBZ_CountFloorTilesToFlip     ; 
                        bne BobMoveFillFloorIniX          ; 
                        
                        ldy #$00                          ; 
BobMoveFillFloorX       jmp BobSoundHandler               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobMoveFillFloorIni   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobMoveFillFloorIni     subroutine                        ; 
                        ldy [BB_WA_FloorPosY - $01],x     ; 
                        iny                               ; 
                        
                        tax                               ; 
                        
                        lda BB_TabHiResAdrColLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrRowLo,y         ; 
                        sta BBZ_MoveFloorPtrLo            ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_MoveFloorPtrHi            ; 
                        
                        lda BBZ_DrawFloorMinX             ; 
                        and #$03                          ; 
                        tax                               ; 
                        
                        lda #$03                          ; 
                        sta BBZ_FloorPieceHight           ; 
                        
                        ldy #$00                          ; 
                        lda (BBZ_MoveFloorPtr),y          ; 
                        and TabColorPosMasks,x            ; 
                        cmp WrkColorPosVals,x             ; 
                        bne BobMoveFillFloorIniX          ; 
                        
                        inc BBZ_MoveFloorPtrLo            ; 
                        
                        lda BBZ_MoveFloorPtrLo            ; 
                        and #$07                          ; .....###
                        bne .GetVal                       ; 
                        
                        lda BBZ_MoveFloorPtrLo            ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        clc                               ; 
                        adc #$39                          ; 
                        sta BBZ_MoveFloorPtrLo            ; 
                        
                        lda BBZ_MoveFloorPtrHi            ; 
                        adc #$01                          ; 
                        sta BBZ_MoveFloorPtrHi            ; 
                        
.GetVal                 lda (BBZ_MoveFloorPtr),y          ; 
                        and TabColorPosMasks,x            ; 
                        cmp WrkColorPosVals,x             ; 
                        beq BobMoveFillFloorIniX          ; 
                        
                        dec BBZ_FloorPieceHight           ; 
                        
BobMoveFillFloorIniX    rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabColorPosMasks        dc.b $c0 ; ##......
                        dc.b $30 ; ..##....
                        dc.b $0c ; ....##..
                        dc.b $03 ; ......##
                        
WrkColorPosVals         dc.b $c0 ; ##......
                        dc.b $30 ; ..##....
                        dc.b $0c ; ....##..
                        dc.b $03 ; ......##
; -------------------------------------------------------------------------------------------------------------- ;
; BobSoundHandler       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobSoundHandler         subroutine                        ; 
                        lda BBZ_PlayerStatus              ; 
                        bne SoundBobActionX               ; BBZ_PlayerStateDead - exit
; -------------------------------------------------------------------------------------------------------------- ;
; SoundBobAction        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SoundBobAction          subroutine                        ; 
                        lda BBZ_TonePingCount             ; 
                        bne SoundBobActionX               ; 
                        
                        stx .__SaveXR                     ; 
                        sty .__SaveYR                     ; 
                        
                        tya                               ; 
                        and #$0f                          ; 
                        pha                               ; 
                        
                        tya                               ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        tay                               ; 
                        
                        pla                               ; 
                        ora TabSoundBobAction,y           ; 
                        tax                               ; Oscillator Ctrl/SustainRelease
                        lda .__SaveXR                     ; Oscillator Offset DataSfxFreq
                        ldy #$00                          ; Oscillator SID Offset
                        jsr SoundEffects                  ; bob steps and jumps/Utility Hoist/xmit
                        
.__SaveXR               equ [* + $01]                     ;                     
                        ldx #$00                          ; 
.__SaveYR               equ [* + $01]                     ;                     
                        ldy #$00                          ; 
                        
SoundBobActionX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSoundBobAction       dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $40 ; 
                        dc.b $00 ; 
                        dc.b $80 ; 
                        dc.b $00 ; 
                        dc.b $80 ; 
                        dc.b $00 ; 
                        dc.b $40 ; 
                        dc.b $00 ; 
                        dc.b $80 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BobXmitSpriteGfx      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BobXmitSpriteGfx        subroutine                        ; 
                        ldx #$33                          ; 
.SetRandomGFX           lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and BB_BobSpriteGameLeg,x         ; 
                        sta BB_BobSpriteGameLeg,x         ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and [BB_BobSpriteGameLeg + $01],x ; 
                        sta [BB_BobSpriteGameLeg + $01],x ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and BB_BobSpriteGameArm,x         ; 
                        sta BB_BobSpriteGameArm,x         ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and [BB_BobSpriteGameArm + $01],x ; 
                        sta [BB_BobSpriteGameArm + $01],x ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and BB_BobSpriteGameBodyRi,x      ; 
                        sta BB_BobSpriteGameBodyRi,x      ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and [BB_BobSpriteGameBodyRi + $01],x ; 
                        sta [BB_BobSpriteGameBodyRi + $01],x ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and BB_BobSpriteGameBodyLe,x      ; 
                        sta BB_BobSpriteGameBodyLe,x      ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and [BB_BobSpriteGameBodyLe + $01],x ; 
                        sta [BB_BobSpriteGameBodyLe + $01],x ; 
                        
                        dex                               ; 
                        dex                               ; 
                        dex                               ; 
                        bpl .SetRandomGFX                 ; 
                        
BobXmitSpriteGfxX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GravityLiftSound      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GravityLiftSound        subroutine                        ; 
                        sta .__OscSfxFreq                 ; 
                        
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        txa                               ; 
                        pha                               ; 
                        
.__OscSfxFreq           equ [* + $01]                     ;                     
                        lda #$00                          ; Oscillator Offset DataSfxFreq
                        ldx #$44                          ; Oscillator Ctrl/SustainRelease
                        ldy #$07                          ; Time
                        jsr SoundLevelSpecial             ; 
                        
                        pla                               ; 
                        tax                               ; 
                        pla                               ; 
                        tay                               ; 
                        pla                               ; 
                        
GravityLiftSoundX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GravityLiftDrawTile   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GravityLiftDrawTile     subroutine                        ; 
__GravityLiftTileColor  equ [* + $01]                     ; 
                        lda #$00                          ; 
                        sta BBZ_LiftTileColor             ; 
                        
                        lda BBZ_LiftWipeOutValRight       ; 
                        eor #$ff                          ; ########
                        and BBZ_LiftTileColor             ; 
                        sta BBZ_LiftTileValRight          ; 
                        
                        lda BBZ_LiftWipeOutValLeft        ; 
                        eor #$ff                          ; ########
                        and BBZ_LiftTileColor             ; 
                        sta BBZ_LiftTileValLeft           ; 
                        
.DrawLiftTile_Left      ldy #$00                          ; 
                        lda (BBZ_ItemHiResPtr),y          ; 
                        and BBZ_LiftWipeOutValLeft        ; 
                        ora BBZ_LiftTileValLeft           ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        ldy #$08                          ; 
                        ldx BBZ_LiftTileWidth             ; 
                        beq .DrawLiftTile_Right           ; 
                        
                        clc                               ; 
.DrawLiftTile_Mid       lda BBZ_LiftTileColor             ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        tya                               ; 
                        adc #$08                          ; 
                        tay                               ; 
                        
.DecLiftTileWidth       dex                               ; 
                        bne .DrawLiftTile_Mid             ; 
                        
.DrawLiftTile_Right     lda (BBZ_ItemHiResPtr),y          ; 
                        and BBZ_LiftWipeOutValRight       ; 
                        ora BBZ_LiftTileValRight          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
GravityLiftDrawTileX    rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GravityLiftStepUp     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GravityLiftStepUp       subroutine                        ; 
                        lda BBZ_IRQ_GameTimer             ; 
                        and #$03                          ; ......##
                        bne GravityLiftStepUpX            ; goto FloatTileMoveStepIni
                        
                        lda BBZ_BobChkMaxPos              ; 
                        beq .GetFloatTileLen              ; 
                        
                        lda BBZ_XmitFlipFlopPos           ; 
                        bne .GetFloatTileLen              ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$16                          ; 
                        cmp BB_WA_FloorPosY,y             ; 
                        beq GravityLiftStepUpX            ; goto FloatTileMoveStepIni
                        
.GetFloatTileLen        ldx BBZ_FloatTileWAOffLen         ; 
                        lda BB_WA_FloatTileLen,x          ; 
                        sta BBZ_LiftTileCols              ; 
                        
                        lda BB_WA_FloorPosY,y             ; 
                        cmp BB_WA_FloatMoveMinX,x         ; 
                        beq GravityLiftStepUpX            ; goto FloatTileMoveStepIni
                        
                        sec                               ; 
                        sbc #$01                          ; 
                        sta BB_WA_FloorPosY,y             ; 
                        
                        jsr GravityLiftSound              ; 
                        
                        ldx BB_WA_FloorMinX,y             ; 
                        
.GetFloorPosY           tay                               ; PosY
                        
                        lda #$01                          ; 
                        sta BBZ_LiftTileHight             ; 
                        
.GetFoorMinX            txa                               ; 
                        
.DecFloorPosY           iny                               ; 
                        iny                               ; 
                        iny                               ; 
.LiftClearOld           jsr GravityLiftWipeOut            ; ac=PosX yr=PosY
                        
                        lda BBZ_ItemHiResPtrLo            ; 
                        sec                               ; 
                        sbc #$03                          ; 
                        tay                               ; 
                        and #$07                          ; .....###
                        cmp #$05                          ; 
                        bcc .FloatTileDrawNew             ; lower
                        
                        lda BBZ_ItemHiResPtrLo            ; 
                        sec                               ; 
                        sbc #<[BB_Scrn_HiResRowLen - $05] ; 
                        
.SavePtrLo              tay                               ; 
                        
                        lda BBZ_ItemHiResPtrHi            ; 
                        sbc #>[BB_Scrn_HiResRowLen - $05] ; 
                        sta BBZ_ItemHiResPtrHi            ; 
                        
.FloatTileDrawNew       sty BBZ_ItemHiResPtrLo            ; 
                        jsr GravityLiftDrawTile           ; 
                        
GravityLiftStepUpX      jmp FloatTileMoveStepIni          ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GravityLiftMove       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GravityLiftMove         subroutine                        ; 
                        stx BBZ_FloatTileWAOffLen         ; 
                        sty BBZ_FloatTileWAOffPosY        ; 
                        jsr BobMoveAdjustPosX             ; 
                        
                        lda BBZ_BobChkMaxPos              ; 
                        
                        ldx #$00                          ; 
                        stx BBZ_BobChkMaxPos              ; 
                        
                        cmp BB_WA_FloorMinX,y             ; 
                        bcc .ChkFloorMinX                 ; greater/equal
                        
                        cmp BB_WA_FloorMaxX,y             ; 
                        bcc .BobJumpMoveDown              ; lower
                        
.ChkFloorMinX           lda BBZ_BobChkMinPos              ; 
                        cmp BB_WA_FloorMinX,y             ; 
                        bcc GravityLiftStepUp             ; lower
                        
.ChkFloorMaxX           cmp BB_WA_FloorMaxX,y             ; 
                        bcc .BobJumpMoveDown              ; lower
                        
.GoGravityLiftStepUp    jmp GravityLiftStepUp             ; 
                        
.BobJumpMoveDown        inc BBZ_BobChkMaxPos              ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
.SpriteHight            adc #$15                          ; 
                        cmp BB_WA_FloorPosY,y             ; 
                        bne .GoGravityLiftStepUp          ; 
                        
                        cpy BBZ_BobOnFloorNo              ; 
GravityLiftMoveX        bne GravityLiftStepUpX            ; goto FloatTileMoveStepIni
; -------------------------------------------------------------------------------------------------------------- ;
; GravityLiftStepDown   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GravityLiftStepDown     subroutine                        ; 
.BobHasLanded           tax                               ; 
                        lda BB_WA_FloorMaxX,y             ; 
                        sec                               ; 
                        sbc BB_WA_FloorMinX,y             ; 
                        
                        lsr a                             ; /2
                        
                        clc                               ; 
                        adc BB_WA_FloorMinX,y             ; 
                        tay                               ; 
                        
                        lda BB_TabHiResAdrColLo,y         ; 
                        clc                               ; 
                        adc [BB_TabHiResAdrRowLo + $03],x ; 
                        sta BBZ_ItemHiResPtrLo            ; 
                        lda [BB_TabHiResAdrRowHi + $03],x ; 
                        adc BB_TabHiResAdrColHi,y         ; 
                        sta BBZ_ItemHiResPtrHi            ; 
                        
                        tya                               ; 
                        and #$03                          ; ......##
                        tax                               ; 
                        
                        ldy #$00                          ; 
                        lda (BBZ_ItemHiResPtr),y          ; 
                        and TabColorPosMasks,x            ; 
                        bne GravityLiftStepDownX          ; 
                        
                        ldy BBZ_FloatTileWAOffPosY        ; 
                        lda BB_WA_FloorPosY,y             ; 
                        
                        jsr GravityLiftSound              ; 
                        
.SavFloorPosY_01        pha                               ; 
.SavFloorPosY_02        pha                               ; 
                        
                        clc                               ; 
                        adc #$01                          ; 
                        sta BB_WA_FloorPosY,y             ; 
                        
                        inc BBZ_BobPosY                   ; 
                        
                        ldx BBZ_FloatTileWAOffLen         ; 
                        lda BB_WA_FloatTileLen,x          ; 
                        sta BBZ_LiftTileCols              ; 
                        
                        lda #$01                          ; 
                        sta BBZ_LiftTileHight             ; 
                        ldx BB_WA_FloorMinX,y             ; 
                        
.RestoreFloorPosY_02    pla                               ; 
                        
                        tay                               ; 
                        txa                               ; 
                        jsr GravityLiftWipeOut            ; 
                        
                        lda BBZ_ItemHiResPtrLo            ; 
                        clc                               ; 
                        adc #$03                          ; 
                        tay                               ; 
                        
                        and #$07                          ; .....###
                        cmp #$03                          ; 
                        bcs .GravityLiftDrawTile          ; greater/equal
                        
.AdjustHiResPtr         lda BBZ_ItemHiResPtrLo            ; 
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $05] ; 
                        tay                               ; 
                        lda BBZ_ItemHiResPtrHi            ; 
                        adc #>[BB_Scrn_HiResRowLen - $05] ; 
                        sta BBZ_ItemHiResPtrHi            ; 
                        
.GravityLiftDrawTile    sty BBZ_ItemHiResPtrLo            ; 
                        jsr GravityLiftDrawTile           ; 
                        
                        ldx BBZ_FloatTileWAOffPosY        ; 
                        lda BBZ_LiftTileCols              ; 
                        lsr a                             ; /2
                        clc                               ; 
                        adc BB_WA_FloorMinX,x             ; 
                        tax                               ; 
                        
.RestoreFloorPosY_01    pla                               ; 
                        tay                               ; 
                        
                        lda BB_TabHiResAdrRowLo,y         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta BBZ_ItemHiResPtrLo            ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_ItemHiResPtrHi            ; 
                        
                        txa                               ; 
                        and #$03                          ; ......##
                        tax                               ; 
                        
                        ldy #$00                          ; 
                        lda TabDrawLineColor_01,x         ; 
                        ora (BBZ_ItemHiResPtr),y          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
GravityLiftStepDownX    jmp FloatTileMoveStepIni          ; 
; -------------------------------------------------------------------------------------------------------------- ;
GoGravityLiftMove       jmp GravityLiftMove               ; 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileSpeedDec       dec BB_WA_FloatMoveSpeedDec,x     ; 

                        jmp FloatTileMoveStep             ; 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileMoveX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FloatTileMove         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileMove           subroutine                        ; 
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs FloatTileMoveX                ; greater/equal = sink or death
                        
                        dec BBZ_BobOnFloorNo              ; 
                        
                        ldy BBZ_CountFloorsFlows          ; floors and flow tiles
                        ldx BBZ_CountFlowTiles            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FloatTileMoveStep     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileMoveStep       subroutine                        ; 
.DecFloatTileWAOffLen   dey                               ; BBZ_FloatTileWAOffLen
.DecFloatTileWAOffPosY  dex                               ; BBZ_FloatTileWAOffPosY
                        bmi FloatTileMoveX                ; 
                        
                        lda BB_WA_FloatType,x             ; 
                        and #$c0                          ; ##......
.ChkGravityLift         cmp #$c0                          ; gravity lift
.WasGravityLift         beq GoGravityLiftMove             ; 
                        
                        lda BB_WA_FloatMoveSpeedDec,x     ; 
                        bne FloatTileSpeedDec             ; 
                        
                        lda BB_WA_FloatMoveSpeed,x        ; 
.SpeedInit              sta BB_WA_FloatMoveSpeedDec,x     ; 
                        
.GetMoveTypeLeave       lda BB_WA_FloatType,x             ; 
.GetStopOnLeave         asl a                             ; 
.ChkStopOnLeave         bcc .ChkStopPos                   ; 
                        
.WasStopOnLeave         cpy BBZ_BobOnFloorNo              ; #.......
                        bne .DecFloatTileWAOffLen         ; 
                        
.ChkStopPos             stx BBZ_FloatTileWAOffLen         ; 
                        sty BBZ_FloatTileWAOffPosY        ; 
                        
                        lda BB_WA_FloorMinX,y             ; 
.ChkStopPos_Le          cmp BB_WA_FloatMoveMinX,x         ; 
                        beq .GetMoveTypeStop              ; 
                        
.ChkStopPos_Ri          cmp BB_WA_FloatMoveMaxX,x         ; 
                        bne .GoFloatTileClear             ; start with a clear
                        
.GetMoveTypeStop        lda BB_WA_FloatType,x             ; 
                        asl a                             ; 
.GetStopWait            asl a                             ; .#......
.ChkStopWait            bcc .GetOneDirectional            ; 
                        
.WasStopWait            cpy BBZ_BobOnFloorNo              ; 
                        bne .DecFloatTileWAOffLen         ; 
                        
.GetOneDirectional      asl a                             ; ..#.....
.ChkOneDirectional      bcc .TurnMoveDir                  ; 
                        
.WasOneDirectional      lda BB_WA_FloatMoveMinX,x         ; 
                        cmp BB_WA_FloorMinX,y             ; 
                        bne .SetNewMinX                   ; 
                        
                        lda BB_WA_FloatMoveMaxX,x         ; 
                        jmp .SetNewMinX                   ; 
                        
.TurnMoveDir            lda BB_WA_FloatMoveDir,x          ; 
.Set2sComplement        eor #$ff                          ; ######## - flip all
                        clc                               ; 
                        adc #$01                          ; + $01
                        sta BB_WA_FloatMoveDir,x          ; 
                        
.GoFloatTileClear       jsr FloatTileClear                ; clear the old one first
                        
                        lda BB_WA_FloorMinX,y             ; 
                        
.SetNewMinX             clc                               ; 
                        adc BB_WA_FloatMoveDir,x          ; 
                        sta BB_WA_FloorMinX,y             ; 
                        
.SetNewMaxX             clc                               ; 
                        adc BB_WA_FloatTileLen,x          ; 
                        sta BB_WA_FloorMaxX,y             ; 
                        
                        sbc #$00                          ; 
                        cpy BBZ_BobOnFloorNo              ; 
                        bne .ChkMoveDir                   ; 
                        
.SaveMaxX               pha                               ; 
                        
.StepBobWithFloatTile   lda BBZ_BobPosX                   ; 
                        clc                               ; 
                        adc BB_WA_FloatMoveDir,x          ; 
                        sta BBZ_BobPosX                   ; 
                        
.RestoreMaxX            pla                               ; 
                        
.ChkMoveDir             inc BB_WA_FloatMoveDir,x          ; 
                        dec BB_WA_FloatMoveDir,x          ; 
                        bpl .SaveTargetX                  ; 
                        
                        lda BB_WA_FloorMinX,y             ; 
                        
.SaveTargetX            pha                               ; 
                        
                        lda BB_WA_FloatType,x             ; 
                        and #BB_WA_FloatTypeOneDir        ; perpetual - restart at MinX/MaxX if MaxX/MinX
                        beq .RestoreTargetX_02            ; 
                        
                        lda BB_WA_FloatMoveDir,x          ; 
.WasMoveDir_Right       bmi .ChkMinX                      ; 
                        
.ChkMaxX                lda BB_WA_FloorMaxX,y             ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        cmp BB_WA_FloatMoveMaxX,x         ; 
                        jmp .ChkTargetReached             ; 
                        
.ChkMinX                lda BB_WA_FloatMoveMinX,x         ; 
                        clc                               ; 
                        adc BB_WA_FloatTileLen,x          ; 
                        sbc #$00                          ; 
                        cmp BB_WA_FloorMinX,y             ; 
.ChkTargetReached       bcc .RestoreTargetX_02            ; lower
                        
.RestoreTargetX_01      pla                               ; 
                        jmp .DecFloatTileWAOffLen         ; 
                        
.RestoreTargetX_02      pla                               ; 
                        
                        ldx BB_WA_FloorPosY,y             ; 
                        tay                               ; 
                        
.GetFloatPieceHiResPtr  lda BB_TabHiResAdrRowLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,y         ; 
                        sta BBZ_FloatHiResPtrLo           ; 
                        
                        lda BB_TabHiResAdrRowHi,x         ; 
                        adc BB_TabHiResAdrColHi,y         ; 
                        sta BBZ_FloatHiResPtrHi           ; 
                        
                        tya                               ; 
                        and #$03                          ; ......##
                        tay                               ; 
                        
                        lda TabColorPosMasks,y            ; 
                        sta .__ColorPosMask               ; 
                        
                        ldy #$00                          ; 
                        ldx #$03                          ; 
.DrawNextFloatPiece     lda (BBZ_FloatHiResPtr),y         ; 
.__ColorPosMask         equ [* + $01]                     ;                     
                        ora #$00                          ; 
                        sta (BBZ_FloatHiResPtr),y         ; 
                        
                        inc BBZ_FloatHiResPtrLo           ; 
                        
                        lda BBZ_FloatHiResPtrLo           ; 
                        and #$07                          ; .....###
                        bne .DecFlowTileHight             ; 
                        
                        lda BBZ_FloatHiResPtrLo           ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_FloatHiResPtrLo           ; 
                        
                        lda BBZ_FloatHiResPtrHi           ; 
                        adc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_FloatHiResPtrHi           ; 
                        
.DecFlowTileHight       dex                               ; 
FloatTileMoveStepX      bne .DrawNextFloatPiece           ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FloatTileMoveStepIni  Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileMoveStepIni    subroutine                        ; 
                        ldx BBZ_FloatTileWAOffLen         ; 
                        ldy BBZ_FloatTileWAOffPosY        ; 
FloatTileMoveStepIniX   jmp FloatTileMoveStep             ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FloatTileClear        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileClear          subroutine                        ; 
                        lda BB_WA_FloatType,x             ; 
                        and #BB_WA_FloatTypeOneDir        ; perpetual move - start a new one at MinX if MaxX is reached
                        beq FloatTileClearStep            ; 
                        
                        lda BB_WA_FloatMoveDir,x          ; 
                        bpl .Move_Right                   ; 
                        
.Move_Left              lda BB_WA_FloorMaxX,y             ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        cmp BB_WA_FloatMoveMaxX,x         ; 
                        jmp .ChkTurnPoint                 ; 
                        
.Move_Right             lda BB_WA_FloatMoveMinX,x         ; 
                        clc                               ; 
                        adc BB_WA_FloatTileLen,x          ; 
                        sbc #$00                          ; 
                        cmp BB_WA_FloorMinX,y             ; 
.ChkTurnPoint           bcc FloatTileClearStep            ; lower
                        
FloatTileClearX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FloatTileClearStep    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FloatTileClearStep      subroutine                        ; 
                        lda BB_WA_FloatMoveDir,x          ; 
                        bpl .GetMinX                      ; 
                        
.GetMaxX                lda BB_WA_FloorMaxX,y             ; 
                        sec                               ; 
                        sbc #$01                          ; 
                        jmp .GetPosY                      ; 
                        
.GetMinX                lda BB_WA_FloorMinX,y             ; 
                        
.GetPosY                ldx BB_WA_FloorPosY,y             ; 
                        tay                               ; 
                        
.SetTilePtr_Start       lda [BB_TabHiResAdrRowLo + $02],x ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,y         ; 
                        sta BBZ_FloatHiResPtrLo           ; 
                        
                        lda [BB_TabHiResAdrRowHi + $02],x ; 
                        adc BB_TabHiResAdrColHi,y         ; 
                        sta BBZ_FloatHiResPtrHi           ; 
                        
.SetTilePtr_End         lda [BB_TabHiResAdrRowLo + $04],x ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,y         ; 
                        sta BBZ_FloatEndHiResPtrLo        ; 
                        
                        lda [BB_TabHiResAdrRowHi + $04],x ; 
                        adc BB_TabHiResAdrColHi,y         ; 
                        sta BBZ_FloatEndHiResPtrHi        ; 
                        
.SetTilePtr_Color       tya                               ; 
                        and #$03                          ; ......##
                        tay                               ; 
                        
                        lda TabPlatformColorClear,y       ; 
                        sta .__GetFloatColor              ; 
                        
                        ldx #$03                          ; 
                        ldy #$00                          ; 
.ClrNextFloatPiecePart  lda (BBZ_FloatHiResPtr),y         ; 
.__GetFloatColor        equ [* + $01]                     ;                     
                        and #$00                          ; 
                        ora (BBZ_FloatEndHiResPtr),y      ; 
                        sta (BBZ_FloatHiResPtr),y         ; 
                        
                        dec BBZ_FloatHiResPtrLo           ; 
                        lda BBZ_FloatHiResPtrLo           ; 
                        and #$07                          ; .....###
                        cmp #$07                          ; 
                        bne .DecTilePtr_End               ; 
                        
.DecTilePtr_Start       lda BBZ_FloatHiResPtrLo           ; 
                        clc                               ; 
                        adc #$01                          ; 
                        sec                               ; 
                        sbc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_FloatHiResPtrLo           ; 
                        
                        lda BBZ_FloatHiResPtrHi           ; 
                        sbc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_FloatHiResPtrHi           ; 
                        
.DecTilePtr_End         dec BBZ_FloatEndHiResPtrLo        ; 
                        
                        lda BBZ_FloatEndHiResPtrLo        ; 
                        and #$07                          ; .....###
                        cmp #$07                          ; 
                        bne .DecFloatPieceHight           ; 
                        
                        lda BBZ_FloatEndHiResPtrLo        ; 
                        clc                               ; 
                        adc #$01                          ; 
                        sec                               ; 
                        sbc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_FloatEndHiResPtrLo        ; 
                        
                        lda BBZ_FloatEndHiResPtrHi        ; 
                        sbc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_FloatEndHiResPtrHi        ; 
                        
.DecFloatPieceHight     dex                               ; 
                        bne .ClrNextFloatPiecePart        ; 
                        
                        ldx BBZ_FloatTileWAOffLen         ; 
                        ldy BBZ_FloatTileWAOffPosY        ; 
                        
FloatTileClearStepX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabPlatformColorClear   dc.b $3f ; ..###### - obsolete: same as TabDrawLineColorClear
                        dc.b $cf ; ##..####
                        dc.b $f3 ; ####..##
                        dc.b $fc ; ######..
; -------------------------------------------------------------------------------------------------------------- ;
TabScoreDigits          equ  *   ; 
TabScoreDigits_00       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 00
                        dc.b $44 ; .#...#.. 01
                        dc.b $44 ; .#...#.. 02
                        dc.b $44 ; .#...#.. 03
                        dc.b $54 ; .#.#.#.. 04
TabScoreDigits_Hight    equ  [* - TabScoreDigits] ; 
                        
TabScoreDigits_01       equ  [* - TabScoreDigits] ; 
                        dc.b $10 ; ...#.... 05
                        dc.b $50 ; .#.#.... 06
                        dc.b $10 ; ...#.... 07
                        dc.b $10 ; ...#.... 08
                        dc.b $54 ; .#.#.#.. 09
                        
TabScoreDigits_02       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 0a
                        dc.b $04 ; .....#.. 0b
                        dc.b $54 ; .#.#.#.. 0c
                        dc.b $40 ; .#...... 0d
                        dc.b $54 ; .#.#.#.. 0e
                        
TabScoreDigits_03       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 0f
                        dc.b $04 ; .....#.. 10
                        dc.b $54 ; .#.#.#.. 11
                        dc.b $04 ; .....#.. 12
                        dc.b $54 ; .#.#.#.. 13
                        
TabScoreDigits_04       equ  [* - TabScoreDigits] ; 
                        dc.b $44 ; .#...#.. 14
                        dc.b $44 ; .#...#.. 15
                        dc.b $54 ; .#.#.#.. 16
                        dc.b $04 ; .....#.. 17
                        dc.b $04 ; .....#.. 18
                        
TabScoreDigits_05       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 19
                        dc.b $40 ; .#...... 1a
                        dc.b $54 ; .#.#.#.. 1b
                        dc.b $04 ; .....#.. 1c
                        dc.b $54 ; .#.#.#.. 1d
                        
TabScoreDigits_06       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 1e
                        dc.b $40 ; .#...... 1f
                        dc.b $54 ; .#.#.#.. 20
                        dc.b $44 ; .#...#.. 21
                        dc.b $54 ; .#.#.#.. 22
                        
TabScoreDigits_07       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 23
                        dc.b $04 ; .....#.. 24
                        dc.b $04 ; .....#.. 25
                        dc.b $04 ; .....#.. 26
                        dc.b $04 ; .....#.. 27
                        
TabScoreDigits_08       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 28
                        dc.b $44 ; .#...#.. 29
                        dc.b $54 ; .#.#.#.. 2a
                        dc.b $44 ; .#...#.. 2b
                        dc.b $54 ; .#.#.#.. 2c
                        
TabScoreDigits_09       equ  [* - TabScoreDigits] ; 
                        dc.b $54 ; .#.#.#.. 2d
                        dc.b $44 ; .#...#.. 2e
                        dc.b $54 ; .#.#.#.. 2f
                        dc.b $04 ; .....#.. 30
                        dc.b $54 ; .#.#.#.. 31
                        
TabScoreDigits_Blank    equ  [* - TabScoreDigits] ; 
                        dc.b $00 ; ........ 32
                        dc.b $00 ; ........ 33
                        dc.b $00 ; ........ 34
                        dc.b $00 ; ........ 34
                        dc.b $00 ; ........ 36
; -------------------------------------------------------------------------------------------------------------- ;
; ItemScoreWipeOut      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemScoreWipeOut        subroutine                        ; 
.SetNextWaitTime        iny                               ; 
                        tya                               ; 
                        sta [BB_WA_ItemNo - $01],x        ; 
                        
.CheckScoreShowTimeMax  cmp #[Item_ShowScoreMax + $01]    ; 
                        bne .SetNextItemOffset            ; 
                        
.WipeOutItemScore       lda #$00                          ; 
                        sta [BB_WA_ItemNo - $01],x        ; 
                        
.GetItemScoreWidth      lda [BB_WA_ItemMaxX - $01],x      ; 
                        sta BBZ_ItemDataColsWork          ; 
                        
                        lda #$05                          ; 
.GetItemScoreHight      sta BBZ_ItemDataRowsWork          ; 
                        
                        jsr ItemGetPosWipeOut             ; 
                        
ItemScoreWipeOutX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemHandler           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemHandler             lda BBZ_BobPosX                   ; 
                        clc                               ; 
                        adc #$03                          ; 
                        sta BBZ_BobItemMinPosX            ; 
                        
                        adc #$02                          ; 
                        sta BBZ_BobItemMaxPosX            ; 
                        
                        lda BBZ_BobPosY                   ; 
                        clc                               ; 
                        adc #$21                          ; 
                        sta BBZ_BobItemMinPosY            ; 
                        
                        clc                               ; 
                        adc #$0f                          ; 
                        sta BBZ_BobItemMaxPosY            ; 
                        
                        ldx BBZ_CountItems                ; 
                        inx                               ; 
                        
.SetNextItemOffset      dex                               ; 
                        beq ItemScoreWipeOutX             ; exit - all items handled
                        
.CheckAvailability      ldy [BB_WA_ItemNo - $01],x        ; 
                        beq .SetNextItemOffset            ; taken already
                        
.CheckSwitches          cpy #Item_TubeSwitchNum1          ; suction tube switch numbers $f6 - $fa
                        bcs .CheckBobTouchesItem          ; greater/equal
                        
.CheckScoreShowTime     cpy #Item_ShowScore               ; 
                        bcs ItemScoreWipeOut              ; greater/equal 
                        
.CheckBobTouchesItem    lda BBZ_BobItemMinPosX            ; 
                        cmp [BB_WA_ItemMaxX - $01],x      ; 
                        bcs .SetNextItemOffset            ; 
                        
                        lda BBZ_BobItemMaxPosX            ; 
                        cmp [BB_WA_ItemPosX - $01],x      ; 
                        bcc .SetNextItemOffset            ; 
                        
                        lda BBZ_BobItemMinPosY            ; 
                        cmp [BB_WA_ItemMaxY - $01],x      ; 
                        bcs .SetNextItemOffset            ; 
                        
                        lda BBZ_BobItemMaxPosY            ; 
                        cmp [BB_WA_ItemPosY - $01],x      ; 
                        bcc .SetNextItemOffset            ; 
                        
.CheckBobDeath          lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs .SetNextItemOffset            ; greater/equal = sink or death
                        
                        lda BBZ_CannonStatus              ; 
                        cmp #BBZ_CannonStatusFly          ; 
                        bcs .SetNextItemOffset            ; greater/equal
                        
                        sty BB_NumItemJustTaken           ; 
                        
.ChkGallowsNoose        cpy #$23                          ; galgen strick
                        bne .ChkFoodBar                   ; 
                        
                        jsr BobSetDeath                   ; 
                        
.ChkFoodBar             cpy #$54                          ; kraftpille
                        bne .ChkMobileTube                ; 
                        
                        lda #$ff                          ; 
                        sta BBZ_BobMoveFoodBarTime        ; 
                        
.ChkMobileTube          cpy #$4f                          ; mobiles saugrohr
                        bne .ChkTubeSwitch                ; 
                        
                        inc BBZ_MobileTubeMove            ; BBZ_MobileTubeMoveOn
                        
.ChkTubeSwitch          tya                               ; 
                        sec                               ; 
                        sbc #Item_TubeSwitchNum1          ; 
                        bcc .ChkScoreToAdd                ; 
                        
.WasTubeSwitch          tay                               ; 
                        lda BB_WA_TubeSwitchDir,y         ; 
                        ora #$01                          ; .......#
                        sta BB_WA_TubeSwitchDir,y         ; 
                        bne .SetNextItemOffset            ; 
                        
.ChkScoreToAdd          lda BBZ_ScoreToAddItem            ; 
                        bne .SetNextItemOffset            ; 
                        
                        lda #$80                          ; 
                        sta BBZ_ToneTypeHight             ; 
                        
.SetSwitchEnemy         inc BBZ_EnemyFlipFlag             ; BBZ_EnemyFlipFlagYes
                        
.SaveRegs               txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        sec                               ; 
.ChkTNT                 sbc #$42                          ; no item TNT one
                        cmp #$03                          ; 
                        bcs .ClearItemIni                 ; greater/equal
                        
                        sec                               ; 
                        sed                               ; 
.AddAmountTNT           adc BBZ_AmoutTNT                  ; 
                        cld                               ; 
.SetAmountTNT           sta BBZ_AmoutTNT                  ; 
                        
.ClearItemIni           lda [BB_WA_ItemDataCols - $01],y  ; 
                        sta BBZ_ItemDataColsWork          ; 
                        
                        lda [BB_WA_ItemDataRows - $01],y  ; 
                        sta BBZ_ItemDataRowsWork          ; 
                        
                        lda [BB_WA_ItemDataScore - $01],y ; 
                        sta BBZ_ScoreToAddItem            ; 
                        
.ItemReplacedByScore    lda #Item_ShowScore               ; score start show time
                        sta [BB_WA_ItemNo - $01],x        ; 
                        
.GetClearItemPosition   jsr ItemGetPosWipeOut             ; 
                        
.RestoreRegs            pla                               ; 
                        tay                               ; 
                        pla                               ; 
                        tax                               ; 
                        
.GetClearItemPos        lda [BB_WA_ItemDataCols - $01],y; 
                        lsr a                             ; 
                        clc                               ; 
                        adc [BB_WA_ItemPosX - $01],x      ; 
                        sta BBZ_ItemScorePosX             ; 
                        
                        lda [BB_WA_ItemDataRows - $01],y  ; 
                        lsr a                             ; 
                        clc                               ; 
                        adc [BB_WA_ItemPosY - $01],x      ; 
                        sec                               ; 
                        sbc #$02                          ; 
                        cmp #$1e                          ; 
                        bcs .SubPosY                      ; greater/equal
                        
                        lda #$1e                          ; 
                        
.SubPosY                sec                               ; 
                        sbc #$1e                          ; 
                        sta BBZ_ItemScorePosY             ; 
                        
                        and #$07                          ; .....###
                        tay                               ; 
                        lda TabItemCorrPosY,y             ; correction
                        
                        clc                               ; 
                        adc BBZ_ItemScorePosY             ; 
                        sta BBZ_ItemScorePosY             ; 
                        
                        clc                               ; 
                        adc #$1e                          ; 
                        sta [BB_WA_ItemPosY - $01],x      ; 
                        
                        lda BBZ_ScoreToAddItem            ; 
                        bne ItemShowScore                 ; 
                        
.MarkItemCleared        sta [BB_WA_ItemNo - $01],x        ; $00
                        
ItemHandlerX            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemShowScore         Does    : 
;                       Expects : ac=BBZ_ScoreToAddItem
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemShowScore           subroutine                        ; 
                        ldy #$01                          ; $01 - score length 1-9
                        cmp #$0a                          ; 10
                        bcc .SetScoreLen                  ; lower
                        
                        iny                               ; $02 - score length 10-999
                        cmp #$64                          ; 1000
                        bcc .SetScoreLen                  ; lower
                        
                        iny                               ; $03 - score length 1000-9999
.SetScoreLen            sty .__ScoreLen                   ; 
                        
                        lda [TabItemScoreMaxLen - $01],y  ; $07 $0b $0f
                        sta [BB_WA_ItemMaxX - $01],x      ; 
                        
                        lsr a                             ; $02 $05 $07
                        eor #$ff                          ; $fd $fa $f8
                        sec                               ; 
                        adc BBZ_ItemScorePosX             ; 
                        cmp #$a0                          ; 
                        bcc .SetItemScorePosY             ; lower
                        
                        lda #$00                          ; 
                        
.SetItemScorePosY       sta BBZ_ItemScoreWork             ; 
                        and #$03                          ; 
                        eor #$ff                          ; 
                        sec                               ; 
                        adc BBZ_ItemScoreWork             ; 
                        sta [BB_WA_ItemPosX - $01],x      ; 
                        
                        tax                               ; 
                        
                        ldy BBZ_ItemScorePosY             ; 
                        lda BB_TabHiResAdrColLo,x         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrRowLo,y         ; 
                        sta BBZ_ItemHiResPtrLo            ; 
                        lda BB_TabHiResAdrColHi,x         ; 
                        adc BB_TabHiResAdrRowHi,y         ; 
                        sta BBZ_ItemHiResPtrHi            ; 
                        
                        tya                               ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        tay                               ; 
                        
                        txa                               ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        
                        clc                               ; 
                        adc BB_TabColorScrnPtrLo,y        ; 
                        sta .__ScoreColorPosLo            ; 
                        
                        lda BB_TabColorScrnPtrHi,y        ; 
                        adc #$00                          ; 
                        sta .__ScoreColorPosHi            ; 
                        
.GetScoreRndColor       lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$f0                          ; 
                        beq .GetScoreRndColor             ; 
                        
.__ScoreLen             equ [* + $01]                     ;                     
                        ldy #$03                          ; score length
.__ScoreColorPosLo      equ [* + $01]                     ;                     
.__ScoreColorPosHi      equ [* + $02]                     ;                     
.SetScoreRndColor       sta BB_PlaceHolder_8000,y         ; 
                        dey                               ; 
                        bpl .SetScoreRndColor             ; 
                        
                        ldx #BBZ_TabScore_1000            ; 
                        lda BBZ_ScoreToAddItem            ; always a multiple of $0a (10)
                        cmp #$0a                          ; 1 * 10 = 10
.Chk_1s                 bcc .Set_1s                       ; lower
                        
.Sub_1000_01            sbc #$64                          ; 100 * 10 * 1 = 1000
                        bcc .Correct_1000                 ; 
                        
.GetOffsetDigit_01      ldy #TabScoreDigits_01            ; 
.Sub_1000_02            sbc #$64                          ; 100 * 10 * 2 = 2000
                        bcc .Set_1000                     ; 
                        
.Sub_1000_03            sbc #$64                          ; 100 * 10 * 3 = 3000
.GetOffsetDigit_02      ldy #TabScoreDigits_02            ; 
                        
.Set_1000               sty D6510,x                       ; 
                        
                        inx                               ; 
                        
.Correct_1000           adc #$64                          ; 100 * 10 = 1000
                        
.CharHight_Ini          ldy #[$00 - TabScoreDigits_Hight] ; 
                        sec                               ; 
.CharHight_01           iny                               ; 
.CharHight_02           iny                               ; 
.CharHight_03           iny                               ; 
.CharHight_04           iny                               ; 
.CharHight_05           iny                               ; 
.Sub_10                 sbc #$0a                          ; 
                        bcs .CharHight_01                 ; 
                        
.Correct_10             adc #$0a                          ; 
.SetCount_10            sty D6510,x                       ; 
                        
                        inx                               ; 
                        
.Set_1s                 sta BBZ_CountOnes                 ; 
                        asl a                             ; *2
                        asl a                             ; *4 - ScoreDigit hight
                        adc BBZ_CountOnes                 ; 
                        sta D6510,x                       ; 
                        
.GetOffsetDigit_00      lda #TabScoreDigits_00            ; 
                        
.FillTheRest            inx                               ; 
                        sta D6510,x                       ; 
.GetOffsetDigit_Blank   lda #TabScoreDigits_Blank         ; 
.ChkFillMax             cpx #$7e                          ; 
                        bcc .FillTheRest                  ; lower
                        
.GetDigitHight          ldx #$05                          ; 
.GetNextItemScoreVal    ldy BBZ_TabScore_1000             ; 
                        inc BBZ_TabScore_1000             ; 
                        lda TabScoreDigits,y              ; 
                        
.DrawNext_1000          ldy #$00                          ; 
                        ora (BBZ_ItemHiResPtr),y          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        ldy BBZ_TabScore_100              ; 
                        inc BBZ_TabScore_100              ; 
                        lda TabScoreDigits,y              ; 
                        
.DrawNext_100           ldy #$08                          ; 
                        ora (BBZ_ItemHiResPtr),y          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        ldy BBZ_TabScore_10               ; 
                        inc BBZ_TabScore_10               ; 
                        lda TabScoreDigits,y              ; 
                        
.DrawNext_10            ldy #$10                          ; 
                        ora (BBZ_ItemHiResPtr),y          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        ldy BBZ_TabScore_1                ; 
                        inc BBZ_TabScore_1                ; 
                        lda TabScoreDigits,y              ; 
                        
.DrawNext_1             ldy #$18                          ; 
                        ora (BBZ_ItemHiResPtr),y          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        jsr ItemHiResPtrInc               ; 
                        
.DecDigitHight          dex                               ; 
.ChkDigitHight          bne .GetNextItemScoreVal          ; 
                        
ItemShowScoreX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemGetPosWipeOut     Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemGetPosWipeOut       subroutine                        ; 
                        lda [BB_WA_ItemPosY - $01],x      ; 
                        sec                               ; 
                        sbc #$1e                          ; 
                        tay                               ; 
                        lda [BB_WA_ItemPosX - $01],x      ; 
; -------------------------------------------------------------------------------------------------------------- ;
; GravityLiftWipeOut    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GravityLiftWipeOut      subroutine                        ; 
                        jsr GravityLiftWipeOutPrep        ; 
                        jmp .WipeOut_Left                 ; 
                        
.GetNextHiResPtr        jsr ItemHiResPtrInc               ; 
                        
.WipeOut_Left           ldy #$00                          ; 
                        lda (BBZ_ItemHiResPtr),y          ; 
                        and BBZ_LiftWipeOutValLeft        ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        ldy #$08                          ; 
                        ldx BBZ_LiftTileWidth             ; 
                        beq .WipeOut_Right                ; 
                        
                        clc                               ; 
.WipeOut_Mid            lda #$00                          ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
.SetNextWipeOutMid      tya                               ; 
                        adc #$08                          ; 
                        tay                               ; 
                        
.DecLiftTileWidth       dex                               ; 
                        bne .WipeOut_Mid                  ; 
                        
.WipeOut_Right          lda (BBZ_ItemHiResPtr),y          ; 
                        and BBZ_LiftWipeOutValRight       ; 
                        sta (BBZ_ItemHiResPtr),y          ; 
                        
                        dec BBZ_LiftTileHight             ; 
                        bne .GetNextHiResPtr              ; 
                        
GravityLiftWipeOutX     rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ItemHiResPtrInc       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ItemHiResPtrInc         subroutine                        ; 
                        inc BBZ_ItemHiResPtrLo            ; 
                        
                        lda BBZ_ItemHiResPtrLo            ; 
                        and #$07                          ; 
                        bne ItemHiResPtrIncX              ; 
                        
                        ldy BBZ_ItemHiResPtrLo            ; 
                        dey                               ; 
                        tya                               ; 
                        clc                               ; 
                        adc #<[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_ItemHiResPtrLo            ; 
                        
                        lda BBZ_ItemHiResPtrHi            ; 
                        adc #>[BB_Scrn_HiResRowLen - $07] ; 
                        sta BBZ_ItemHiResPtrHi            ; 
                        
ItemHiResPtrIncX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabItemCorrPosY         dc.b $00 ; 0
                        dc.b $00 ; 0
                        dc.b $00 ; 0
                        dc.b $00 ; 0
                        dc.b $ff ; -1
                        dc.b $fe ; -2
                        dc.b $fd ; -3
                        dc.b $fc ; -4
; -------------------------------------------------------------------------------------------------------------- ;
TabItemScoreMaxLen      dc.b $07 ; 
                        dc.b $0b ; 
                        dc.b $0f ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ScoreAdd              Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ScoreAdd                subroutine                        ; 
                        tay                               ; 
                        
                        lda #$00                          ; 
                        sta BB_WA_ScoresToAdd_1000000     ; 
                        sta BB_WA_ScoresToAdd_100000      ; 
                        sta BB_WA_ScoresToAdd_10000       ; 
                        
                        lda BB_TabScores_1000,y           ; 
                        sta BB_WA_ScoresToAdd_1000        ; 
                        
                        ldx BB_TabScores_100_10,y         ; 
                        txa                               ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; 
                        lsr a                             ; isolate left halfbyte - 100
                        sta BB_WA_ScoresToAdd_100         ; 
                        
                        txa                               ; 
                        and #$0f                          ; isolate right halfbyte - 10
                        sta BB_WA_ScoresToAdd_10          ; 
                        
                        ldx #BB_WA_Scores_LenAdd          ; 
                        ldy #BB_WA_Scores_P1_Off_10       ; offset to 10s - no ones to gain as score
                        clc                               ; 
                        
                        lda BBZ_ActivePlayer              ; 
                        bmi .GetAddScore                  ; player 1
                        
                        ldx #BB_WA_Scores_P2_Off_10       ; offset to 10s - no ones to gain as score
                        
.GetAddScore            lda BB_WA_ScoresToAdd,y           ; 
                        adc BB_WA_Scores,x                ; 
                        
                        cmp #$0a                          ; 
                        bcc .SetScore                     ; lower
                        
                        sbc #$0a                          ; 
                        
.SetScore               sta BB_WA_Scores,x                ; 
                        dex                               ; 
                        dey                               ; 
                        bpl .GetAddScore                  ; 
                        
                        jsr ScoreBlinkInit                ; 
                        asl BBZ_FlagScoreBlinkRate        ; 
                        
ScoreAddX               rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabTimeTics             dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $03 ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $02 ; 
                        dc.b $03 ; 
                        dc.b $03 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; TimeCountDown         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
TimeCountDown           subroutine                        ; 
                        dec BBZ_TimeTics                  ; 
                        bne ScoreAddX                     ; exit
                        
                        inc BBZ_TabTimerColorMidPos       ; 
                        
                        lda BBZ_TabTimerColorMidPos       ; 
                        and #$07                          ; .....###
                        tax                               ; 
                        lda TabTimeTics,x                 ; 
                        sta BBZ_TimeTics                  ; 
                        
                        ldx BBZ_TimeChrPos                ; 
                        cpx #$07                          ; 
                        bne .DecTimeChrPos                ; 
                        
                        lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
                        bcs ScoreAddX                     ; greater/equal = sink or death
                        
                        lda BBZ_CountFloorTilesToFlip     ; 
                        cmp BBZ_FloorPiecesFlipped        ; 
                        beq ScoreAddX                     ; exit
                        
.ChkTime                lda BB_WA_LevelTimesLo_1000       ; 
                        ora BB_WA_LevelTimesLo_100        ; 
                        ora BB_WA_LevelTimesLo_10         ; 
.TimeIsUp               beq ScoreAddX                     ; exit
                        
.DecTimeChrPos          dex                               ; 
                        bpl .SetTimeChrPos                ; 
                        
                        ldy #[BB_WA_LevelTimeLen - $01]   ; 
.CpyTime                lda BB_WA_LevelTimesLo_1000,y     ; 
                        sta BB_WA_LevelTimesHi_1000,y     ; 
                        dey                               ; 
                        bpl .CpyTime                      ; 
                        
                        ldx #[BB_WA_LevelTimeLen - $01]   ; 
.DecTime                dec BB_WA_LevelTimesLo_1000,x     ; 
                        lda BB_WA_LevelTimesLo_1000,x     ; 
                        cmp #$10                          ; "0"
                        beq .ChkTimeChrPos_00             ; 
                        bcs .IniTimeChrPos                ; greater
                        
                        lda #$19                          ; lower - set to "9"
                        sta BB_WA_LevelTimesLo_1000,x     ; 
                        
                        dex                               ; 
                        jmp .DecTime                      ; 
                        
.ChkTimeChrPos_00       cpx #$00                          ; 
                        beq .ClearTimesLo_1000            ; 
                        
                        lda BB_WA_LevelTimesHi_10,x       ; 
                        bne .IniTimeChrPos                ; 
                        
.ClearTimesLo_1000      lda #$00                          ; 
                        sta BB_WA_LevelTimesLo_1000,x     ; 
                        
.IniTimeChrPos          ldx #$07                          ; 
                        
                        lda BB_WA_LevelTimesLo_1000       ; 
                        ora BB_WA_LevelTimesLo_100        ; 
                        ora BB_WA_LevelTimesLo_10         ; 
                        bne .SetTimeChrPos                ; 
                        
                        jsr BobSetDeath                   ; 
                        
.SetTimeChrPos          stx BBZ_TimeChrPos                ; 
; -------------------------------------------------------------------------------------------------------------- ;
; StatusShowTime        Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
StatusShowTime          subroutine                        ; 
                        ldy #[BB_Scrn_StatusOffTime + BB_WA_LevelTimeLen - $01] ; 
.SetNextTimeOff         sty .__SavTimeOff                 ; 
                        
                        lda [BB_WA_LevelTimeLo - BB_Scrn_StatusOffTime],y ; 
                        cmp [BB_WA_LevelTimeHi - BB_Scrn_StatusOffTime],y ; 
                        beq .GotStatusItemOut             ; in ac
                        
                        pha                               ; 
                        
                        ldx BB_StatusRowPosPtrLo,y        ; 
                        stx BBZ_StatusTimeOutPtrLo        ; 
                        ldx BB_StatusRowPosPtrHi,y        ; 
                        stx BBZ_StatusTimeOutPtrHi        ; 
                        
                        ldx [BB_WA_LevelTimeHi - BB_Scrn_StatusOffTime],y ; 
                        lda #$07                          ; 
                        sec                               ; 
                        sbc BBZ_TimeChrPos                ; 
                        sta .__DrawDigitHight             ; 
                        
                        lda BB_StatusCharDataPtrLo,x      ; 
.__DrawDigitHight       equ [* + $01]                     ;                     
                        sbc #$00                          ; 
                        sta BBZ_StatusTimeGetPtrLo        ; 
                        lda BB_StatusCharDataPtrHi,x      ; 
                        sbc #$00                          ; 
                        sta BBZ_StatusTimeGetPtrHi        ; 
                        
                        ldy #$07                          ; 
                        ldx BBZ_TimeChrPos                ; 
.GetTimeGfxPart         lda (BBZ_StatusTimeGetPtr),y      ; 
                        sta (BBZ_StatusTimeOutPtr),y      ; 
                        dey                               ; 
                        dex                               ; 
                        bpl .GetTimeGfxPart               ; 
                        
                        pla                               ; 
                        
                        cpy #$ff                          ; 
                        beq .SetNextTimeByte              ; 
                        
                        tax                               ; 
                        lda BB_StatusCharDataPtrLo,x      ; 
                        sta .__DisplayTimePtrLo           ; 
                        lda BB_StatusCharDataPtrHi,x      ; 
                        sta .__DisplayTimePtrHi           ; 
                        ldx #$07                          ; 
.__DisplayTimePtrLo     equ [* + $01]                     ;                     
.__DisplayTimePtrHi     equ [* + $02]                     ;                     
.GetDisplayTime         lda BB_PlaceHolder_8000,x         ; 
                        sta (BBZ_StatusTimeOutPtr),y      ; 
                        dex                               ; 
                        dey                               ; 
                        bpl .GetDisplayTime               ; 
                        
                        jmp .SetNextTimeByte              ; 
                        
.GotStatusItemOut       jsr StatusItemOutPtr              ; in ac
                        
.__SavTimeOff           equ [* + $01]                     ;                     
.SetNextTimeByte        ldy #$00                          ; 
                        dey                               ; 
                        cpy #$12                          ; 
                        bcs .SetNextTimeOff               ; greater/equal
                        
StatusShowTimeX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSecMsgTextVarNum     dc.b $07 ; 
                        dc.b $43 ; 
                        dc.b $82 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IntroCheck_Fire_F7    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IntroCheck_Fire_F7      subroutine                        ; 
                        ldx #$17                          ; offset BBZ_CheckFireWaitP1
                        lda [CIAPRB + $f0]                ; CIA1(CIAPRB=$DC01) mirror: Data Port Register B
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        lsr a                             ; right
                        jsr JoyStickCheckFire             ; 
                        bcc IntroSetSubGame               ; start game
                        
                        lda GameOptsSticks                ; 
                        beq IntroCheck_F7                 ; 
                        
                        inx                               ; offset BBZ_CheckFireWaitP2
                        
                        lda [CIAPRA + $f0]                ; CIA1(CIAPRA=$DC00) mirror: Data Port Register A
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        lsr a                             ; right
                        jsr JoyStickCheckFire             ; 
                        bcc IntroSetSubGame               ; start game
; -------------------------------------------------------------------------------------------------------------- ;
; IntroCheck_F7         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IntroCheck_F7           subroutine                        ; 
                        lda #$68                          ; "f7"
                        ldx #BB_IrqSubID_GameStart        ; preset 
                        
IntroCheck_Fn           cmp BBZ_KeyPressed                ; 
                        bne IntroCheck_FnX                ; 
                        
                        stx __IrqDispatchSubID            ; 
                        
                        lda #BBZ_KeyPressedNone           ; 
                        sta BBZ_KeyPressed                ; 
                        
IntroCheck_FnX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
IntroSetSubGame         ldx #BB_IrqSubID_GameStart        ; 
                        stx __IrqDispatchSubID            ; 
                        
IntroSetNo_F5           sec                               ; 
IntroSetSubGameX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IntroCheck_F3         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IntroCheck_F3           subroutine                        ; 
                        lda #$66                          ; "f3"
                        ldx #BB_IrqSubID_GameOpts         ; preset
                        bne IntroCheck_Fn                 ; always
; -------------------------------------------------------------------------------------------------------------- ;
; IntroCheck_F5         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IntroCheck_F5           subroutine                        ; 
                        lda BBZ_KeyPressed                ; 
                        cmp #$65                          ; "f5"
                        bne IntroSetNo_F5                 ; 
                        
                        clc                               ; 
IntroCheck_F5X          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; IrqDispatchSub        Does    : 
;                       Expects : dispatch number in __IrqDispatchSubID
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IrqDispatchSub          subroutine                        ; 
__IrqDispatchSubID      equ [* + $01]                     ; number of sub to be dispatched
                        lda #$00                          ; 
                        bne .Dispatch                     ; 
                        
.Exit_NothingToDo       rts                               ; 
                        
.Dispatch               asl a                             ; *2
                        tax                               ; 
                        lda [TabIrqDispatchSub - $01],x   ; 
                        pha                               ; 
                        lda [TabIrqDispatchSub - $02],x   ; 
                        pha                               ; 
                        
.Reset                  lda #BB_IrqSubID_None             ; 
                        sta __IrqDispatchSubID            ; 
                        
IrqDispatchSubX         rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabIrqDispatchSub       dc.w [IrqDis_ScoreInputInit  - $01] ; sub $01
                        dc.w [IrqDis_ScoreShow       - $01] ; sub $02
                        dc.w [IrqDis_SwapPlayers     - $01] ; sub $03
                        dc.w [IrqDis_ColdStart       - $01] ; sub $04
                        dc.w [IrqDis_DemoStart       - $01] ; sub $05
                        dc.w [IrqDis_GameOpts        - $01] ; sub $06
                        dc.w [IrqDis_GameStart       - $01] ; sub $07
                        dc.w [IrqDis_LevelStart      - $01] ; sub $08
                        dc.w [IrqDis_GameOver        - $01] ; sub $09
                        dc.w [IrqDis_BirdsScore      - $01] ; sub $0a
; -------------------------------------------------------------------------------------------------------------- ;
; IRQ_GratulationOut    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_GratulationOut      subroutine                        ; 
                        pha                               ; 
                        txa                               ; 
                        pha                               ; 
                        tya                               ; 
                        pha                               ; 
                        
                        jsr IrqDispatchSub                ; set number in __IrqDispatchSubID
                        jsr CheckJoystick                 ; 
                        bcc .Start                        ; 
                        
                        lda BBZ_FireWorks_a2              ; 
                        bne .DecTimer_01                  ; 
                        
                        jmp .IncTimerAndExit              ; 
                        
.DecTimer_01            dec BBZ_FireWorks_9f              ; 
                        bne .IniLoop                      ; 
                        
                        lda #$3c                          ; 
                        sta BBZ_FireWorks_9f              ; 
                        
                        dec BBZ_FireWorks_a0              ; 
                        bne .IniLoop                      ; 
                        
.Start                  sei                               ; 
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffectSelOsc_01          ; 
                        
                        ldx #$00                          ; 
.RestoreZP              lda BB_CongratulationsSaveZP,x    ; 
                        sta D6510,x                       ; 
                        inx                               ; 
                        bne .RestoreZP                    ; 
                        
                        ldy #$06                          ; preset msgs maximum
                        
                        lda BBZ_ActivePlayer              ; 
                        bmi .SetPlayer_01                 ; player 1
                        
.SetPlayer_02           stx BB_LivesNo_P2                 ; 
                        sty BB_SecMsgLevelMax_P2          ; 
                        jmp .GoShowGameOver               ; 
                        
.SetPlayer_01           stx BB_LivesNo_P1                 ; 
                        sty BB_SecMsgLevelMax_P1          ; 
                        
.GoShowGameOver         lda #$01                          ; 
                        sta BBZ_MelodyType                ; 
                        sta BBZ_PlayerGameDataPtr         ; BBZ_PlayerGameDataP1
                        jmp IrqDis_GameOver               ; 
                        
.IniLoop                ldx #$02                          ; 
.Loop                   lda BBZ_FireWorks_9c,x            ; 
                        beq .ChkMin                       ; 
                        
                        dec BBZ_FireWorks_9c,x            ; 
                        jmp .DecLoopCount                 ; 
                        
.ChkMin                 lda BBZ_HiResPosX,x               ; 
                        bne .DecLoopCount                 ; 
                        
                        sta BBZCongratsSfxFreq            ; 
                        
.DecLoopCount           dex                               ; 
                        bpl .Loop                         ; 
                        
                        lda BBZCongratsSfxFreq            ; Oscillator Offset DataSfxFreq
                        inc BBZCongratsSfxFreq            ; 
                        ldx #$8f                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffectSelOsc_01          ; 
                        
.IncTimerAndExit        inc BBZ_IRQ_GameTimer             ; 
                        jsr GetKeyPressed                 ; in BBZ_KeyPressed
                        
                        lda #$fb                          ; 
                        jsr IRQ_IniNewRaster              ; ac=raster line
                        
IRQ_GratulationOutX     jmp IRQ_GameExit                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabCongratulations      dc.b $23 ; c
                        dc.b $2f ; o
                        dc.b $2e ; n
                        dc.b $27 ; g
                        dc.b $32 ; r
                        dc.b $21 ; a
                        dc.b $34 ; t
                        dc.b $35 ; u
                        dc.b $2c ; l
                        dc.b $21 ; a
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $2f ; o
                        dc.b $2e ; n
                        dc.b $33 ; s
                        dc.b $01 ; !
                        dc.b $80 ; <newline>
                        
                        dc.b $39 ; y
                        dc.b $2f ; o
                        dc.b $35 ; u
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $25 ; e
                        dc.b $38 ; x
                        dc.b $30 ; p
                        dc.b $25 ; e
                        dc.b $32 ; r
                        dc.b $34 ; t
                        dc.b $01 ; !
                        dc.b $80 ; <newline>
                        
                        dc.b $26 ; f
                        dc.b $2f ; o
                        dc.b $32 ; r
                        dc.b $00 ; <space> 
                        dc.b $27 ; g
                        dc.b $25 ; e
                        dc.b $34 ; t
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $2e ; n
                        dc.b $27 ; g
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $28 ; h
                        dc.b $29 ; i
                        dc.b $33 ; s
                        dc.b $00 ; <space> 
                        dc.b $26 ; f
                        dc.b $21 ; a
                        dc.b $32 ; r
                        dc.b $0c ; <komma>
                        dc.b $80 ; <newline>
                        
                        dc.b $39 ; y
                        dc.b $2f ; o
                        dc.b $35 ; u
                        dc.b $00 ; <space> 
                        dc.b $2d ; m
                        dc.b $21 ; a
                        dc.b $39 ; y
                        dc.b $00 ; <space> 
                        dc.b $33 ; s
                        dc.b $34 ; t
                        dc.b $21 ; a
                        dc.b $32 ; r
                        dc.b $34 ; t
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $28 ; h
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $27 ; g
                        dc.b $21 ; a
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $80 ; <newline>
                        
                        dc.b $21 ; a
                        dc.b $34 ; t
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $2e ; n
                        dc.b $39 ; y
                        dc.b $00 ; <space> 
                        dc.b $2c ; l
                        dc.b $25 ; e
                        dc.b $36 ; v
                        dc.b $25 ; e
                        dc.b $2c ; l
                        dc.b $00 ; <space> 
                        dc.b $39 ; y
                        dc.b $2f ; o
                        dc.b $35 ; u
                        dc.b $00 ; -
                        dc.b $24 ; d
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $29 ; i
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $22 ; b
                        dc.b $39 ; y
                        dc.b $80 ; <newline>
                        
                        dc.b $33 ; s
                        dc.b $25 ; e
                        dc.b $34 ; t
                        dc.b $34 ; t
                        dc.b $29 ; i
                        dc.b $2e ; n
                        dc.b $27 ; g
                        dc.b $00 ; <space> 
                        dc.b $33 ; s
                        dc.b $30 ; p
                        dc.b $25 ; e
                        dc.b $23 ; c
                        dc.b $29 ; i
                        dc.b $21 ; a
                        dc.b $2c ; l
                        dc.b $00 ; <space> 
                        dc.b $23 ; c
                        dc.b $2f ; o
                        dc.b $24 ; d
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $00 ; <space> 
                        dc.b $11 ; 1
                        dc.b $0d ; -
                        dc.b $12 ; 2
                        dc.b $15 ; 5
                        dc.b $80 ; <newline>
                        
                        dc.b $29 ; i
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $28 ; h
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $27 ; g
                        dc.b $21 ; a
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $24 ; d
                        dc.b $2a ; j
                        dc.b $35 ; u
                        dc.b $33 ; s
                        dc.b $34 ; t
                        dc.b $2d ; m
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $34 ; t
                        dc.b $80 ; <newline>
                        
                        dc.b $33 ; s
                        dc.b $23 ; c
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $21 ; a
                        dc.b $2e ; n
                        dc.b $24 ; d
                        dc.b $00 ; <space> 
                        dc.b $34 ; t
                        dc.b $28 ; h
                        dc.b $25 ; e
                        dc.b $2e ; n
                        dc.b $00 ; <space> 
                        dc.b $30 ; p
                        dc.b $32 ; r
                        dc.b $25 ; e
                        dc.b $33 ; s
                        dc.b $33 ; s
                        dc.b $29 ; i
                        dc.b $2e ; n
                        dc.b $27 ; g
                        dc.b $80 ; <newline>
                        
                        dc.b $02 ; "
                        dc.b $26 ; f
                        dc.b $17 ; 7
                        dc.b $0e ; .
                        dc.b $02 ; "
                        
                        dc.b $ff ; end of text data
; -------------------------------------------------------------------------------------------------------------- ;
; Congratulations       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
Congratulations         subroutine                        ; 
                        jsr WaitTunesEnd                  ; 
                        
                        sei                               ; 
                        
.InitSCROLY             sta SCROLY                        ; ........ - VIC($D011) VIC Control Register 1
                        sta BBZ_FireWorks_a2              ; 
                        
                        ldx #$fc                          ; no of pages $100-$fc=$04
                        ldy #>BB_Scrn_Color               ; start address high = $0800
                        jsr FillStoragePrepare            ; 
                        
                        lda #HR_RedBlue                   ; 
                        ldx #$40                          ; max fill level last page $100-$40=$c0
                        ldy #$28                          ; start fill level first page
                        jsr FillStorageWithAc             ; 
                        
                        lda #GREEN                        ; 
                        jsr FillColorRamWithAc            ; 
                        
                        ldx #$00                          ; 
.SaveZP                 lda D6510,x                       ; 
                        sta BB_CongratulationsSaveZP,x    ; 
                        inx                               ; 
                        bne .SaveZP                       ; 
                        
                        stx BBZ_CongratsTextChrPtr        ; $00
                        
                        lda #$2f                          ; '/' - enable level selection part 2
                        sta BB_LevelSelectCode_02         ; 
                        
                        lda #BBZ_TabDrawLineColor_03      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        sta BBZ_CountFloorTilesToFlip     ; 
                        jsr ResetKeyPressed               ; $05 -> $17 $18
                        jsr ScreenToBank_00               ; 
                        
                        ldy #<IRQ_GratulationOut          ; 
                        ldx #>IRQ_GratulationOut          ; 
                        lda #$fb                          ; 
                        jsr IRQ_SetNewRasterIRQ           ; xr=ptr_hi yr=ptr_lo ac=raster
                        
                        lda #$37                          ; 
.SetVicTextPosY         sta BBZ_DrawPosY                  ; 
                        lda #$01                          ; 
                        sta BBZ_DrawPosX                  ; 
                        
.GetNextVicTextChr      ldx BBZ_CongratsTextChrPtr        ; 
                        inc BBZ_CongratsTextChrPtr        ; 
                        
                        lda TabCongratulations,x          ; "Congratulations ..."
                        bpl .GoBeepViTextOut              ; 
                        
                        cmp #$ff                          ; end of text data 
                        beq FireWorksInit                 ; 
                        
.EnableLevelSelection   lda #$37                          ; '7'
                        sta BB_LevelSelectCode_01         ; enable level selection part 1
                        sta BB_LevelSelectCode_03         ; enable level selection part 3
                        
                        lda #BBZ_TabDrawLineColor_02      ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        
                        lda BBZ_DrawPosY                  ; 
                        clc                               ; 
                        adc #$0a                          ; 
                        bne .SetVicTextPosY               ; 
                        
.GoBeepViTextOut        jsr BeepVictoryTextOut            ; 
                        
CongratulationsX        jmp .GetNextVicTextChr            ; 
; -------------------------------------------------------------------------------------------------------------- ;
; BeepVictoryTextOut    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
BeepVictoryTextOut      subroutine                        ; 
                        pha                               ; save victory text chr
                        jsr PrintTextChar                 ; 
BeepWait                pla                               ; restore victory text chr
                        beq .WaitI                        ; 
                        
                        lda #$40                          ; Oscillator Offset DataSfxFreq
                        ldx #$47                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundEffectSelOsc_01          ; beep on
                        
.WaitI                  ldx #$03                          ; 
.Wait                   jsr TimerWaitFull                 ; 
                        
                        dex                               ; 
                        bne .Wait                         ; 
                        
                        jsr SoundEffectSelOsc_01          ; beep off
                        
BeepVictoryTextOutX     jmp TimerWaitFull                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FireWorksInit         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FireWorksInit           subroutine                        ; 
                        ldx #$28                          ; 
                        stx BBZ_FireWorks_9d              ; 
                        
                        ldx #$50                          ; 
                        stx BBZ_FireWorks_9c              ; 
                        
                        ldx #$3c                          ; 
                        stx BBZ_FireWorks_9f              ; 
                        stx BBZ_FireWorks_a0              ; 
                        stx BBZ_FireWorks_a2              ; 
                        
                        ldx #$00                          ; 
                        stx BBZ_LevelColor_04             ; 
                        stx BBZ_HiResPosY                 ; 
                        stx BBZ_HiResPosX                 ; 
                        stx BBZ_FireWorks_91              ; 
                        stx BBZ_LevelColor_02             ; 
                        stx BBZ_FireWorks_9e              ; 
                        
                        txa                               ; 
.ClrWorkAreas           sta BB_WA_Floor,x                 ; 
                        sta BB_WA_SpriteRaster,x          ; plus $35 (1st plus $34)
                        sta BB_WA_SpriteColor_P2,x        ; 
                        inx                               ; 
                        bne .ClrWorkAreas                 ; 
                        
FireWorksInitX          beq FireWorksShow                 ; always
; -------------------------------------------------------------------------------------------------------------- ;
A_7fe4                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
A_7ff0                  dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $fe ; 
                        dc.b $ba ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $ff ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
                        dc.b $aa ; 
                        dc.b $aa ; 
                        dc.b $10 ; 
                        dc.b $00 ; 
                        dc.b $00 ; 
A_7fff                  dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
A_PlaceHolder_8000      dc.w EternalLoop                  ; 
                        dc.w EternalLoop                  ; 
; -------------------------------------------------------------------------------------------------------------- ;
                        dc.b $c3 ; C
                        dc.b $C2 ; B
                        dc.b $cd ; M
                        dc.b $38 ; 8
                        dc.b $30 ; 0
; -------------------------------------------------------------------------------------------------------------- ;
EternalLoop             sei                               ; 
                        jmp EternalLoop                   ; 
; -------------------------------------------------------------------------------------------------------------- ;
; FireWorksShow         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FireWorksShow           subroutine                        ; 
                        ldx BBZ_FireWorksNum              ;  
                        
                        lda BBZ_FireWorks_9c,x            ; 
                        bne .ChkFireNoMax                 ; 
                        
                        lda BBZ_HiResPosX,x               ; 
                        sta BBZ_TabDrawLineColorPtr       ; 
                        bne .GetFireNo                    ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        ora #$0f                          ; ....####
                        sta BBZ_FireWorks_95,x            ; 
                        
                        txa                               ; 
                        clc                               ; 
                        adc #$f0                          ; ####....
                        jsr SetFireWorkSound              ; 
                        
.GetFireNo              ldx BBZ_FireWorksNum              ; 
                        txa                               ; 
                        asl a                             ; 
                        asl a                             ; 
                        sta BBZ_FireWorks_91              ; 
                        
                        txa                               ; 
                        clc                               ; 
                        adc #$f0                          ; 
                        jsr FireWorks                     ; 
                        
                        ldx BBZ_FireWorksNum              ; 
                        sta BBZ_HiResPosX,x               ; 
                        
.ChkFireNoMax           inx                               ; 
                        cpx #BBZ_FireWorksNumMax          ; 
                        bcc .SetFireNo                    ; lower
                        
                        ldx #BBZ_FireWorksNumMin          ; higher(eqal
                        
.SetFireNo              stx BBZ_FireWorksNum              ; 
                        
FireWorksShowX          jmp FireWorksShow                 ; loop till time is up
; -------------------------------------------------------------------------------------------------------------- ;
; FireWorks             Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
FireWorks               subroutine                        ; 
                        sta BBZ_GetDataBytePtrHi          ; 
                        
                        ldy #$00                          ; 
                        sty BBZ_FireWorksCount            ; 
                        sty BBZ_GetDataBytePtrLo          ; 
                        
.GetNextFireWorkData    ldy #$09                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        bne .GetColorPtr                  ; 
                        
                        jmp .SetNextFireWork              ; 
                        
.GetColorPtr            ldx BBZ_TabDrawLineColorPtr       ; 
                        bne .GetDataByte_01               ; 
                        
.GoGetDataByte_04       jmp .GetDataByte_04               ; 
                        
.GetDataByte_01         ldy #$08                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        bne .GetDataByte_02               ; 
                        
                        ldy #$00                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        cmp #$a0                          ; 
                        bcs .GoGetDataByte_04             ; 
                        
                        tax                               ; 
                        ldy #$02                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        cmp #$c0                          ; 
                        bcs .GoGetDataByte_04             ; 
                        
                        tay                               ; 
                        lda BB_TabHiResAdrRowLo,y         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta BBZ_FireWorksDataPtrLo        ; 
                        
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_FireWorksDataPtrHi        ; 
                        
                        txa                               ; 
                        and #$03                          ; 
                        tax                               ; 
                        
                        ldy #$00                          ; 
                        lda (BBZ_FireWorksDataPtr),y      ; 
                        and TabPlatformColorClear,x       ; 
                        sta (BBZ_FireWorksDataPtr),y      ; 
                        
.GetDataByte_02         ldy #$05                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        
                        ldy #$01                          ; 
                        clc                               ; 
                        adc (BBZ_GetDataBytePtr),y        ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        bcc .GetDataByte_03               ; 
                        
                        ldy #$04                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        
                        ldy #$00                          ; 
                        clc                               ; 
                        adc (BBZ_GetDataBytePtr),y        ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        
.GetDataByte_03         ldy #$07                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        
                        ldy #$03                          ; 
                        clc                               ; 
                        adc (BBZ_GetDataBytePtr),y        ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        bcc .GetDataByte_04               ; 
                        
                        ldy #$06                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        
                        ldy #$02                          ; 
                        clc                               ; 
                        adc (BBZ_GetDataBytePtr),y        ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        
.GetDataByte_04         ldy #$09                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        
                        sec                               ; 
                        sbc #$01                          ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        bne .GetNextParticle              ; 
                        
.SetNextFireWork        inc BBZ_FireWorksCount            ; 
                        jmp .IncDataBytePtr               ; 
                        
.ClearNextParticle      ldy #$09                          ; 
                        lda #$00                          ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        beq .SetNextFireWork              ; 
                        
.GetNextParticle        ldy #$00                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        cmp #$a0                          ; 
                        bcs .ClearNextParticle            ; 
                        
                        tax                               ; 
                        
                        ldy #$02                          ; 
                        lda (BBZ_GetDataBytePtr),y        ; 
                        cmp #$c0                          ; 
                        bcs .ClearNextParticle            ; 
                        
                        tay                               ; 
                        lda BB_TabHiResAdrRowLo,y         ; 
                        clc                               ; 
                        adc BB_TabHiResAdrColLo,x         ; 
                        sta BBZ_FireWorksDataPtrLo        ; 
                        lda BB_TabHiResAdrRowHi,y         ; 
                        adc BB_TabHiResAdrColHi,x         ; 
                        sta BBZ_FireWorksDataPtrHi        ; 
                        
                        txa                               ; 
                        and #$03                          ; 
                        tax                               ; 
                        ldy #$00                          ; 
                        lda (BBZ_FireWorksDataPtr),y      ; 
                        ldy #$08                          ; 
                        and TabDrawLineColor_03,x         ; 
                        sta (BBZ_GetDataBytePtr),y        ; 
                        bne .IncDataBytePtr               ; 
                        
                        txa                               ; 
                        clc                               ; 
                        adc BBZ_FireWorks_91              ; 
                        tax                               ; 
                        
                        lda TabDrawLineColor_01,x         ; 
                        ldy #$00                          ; 
                        ora (BBZ_FireWorksDataPtr),y      ; 
                        sta (BBZ_FireWorksDataPtr),y      ; 
                        
.IncDataBytePtr         lda BBZ_GetDataBytePtrLo          ; 
                        clc                               ; 
                        adc #$0a                          ; 
                        sta BBZ_GetDataBytePtrLo          ; 
                        cmp #$fa                          ; 
                        beq .ChkFireWorksMax              ; 
                        
                        jmp .GetNextFireWorkData          ; 
                        
.ChkFireWorksMax        lda BBZ_FireWorksCount            ; 
                        cmp #$19                          ; 
                        beq .Exit_00                      ; 
                        
.Exit_01                lda #$01                          ; 
                        rts                               ; 
                        
.Exit_00                lda #$00                          ; 
FireWorksX              rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetFireWorkSound      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetFireWorkSound        subroutine                        ; 
                        sta BBZ_FireWorksSfxPtrHi         ; 
                        
                        lda #$00                          ; 
                        sta BBZ_FireWorksSfxPtrLo         ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$7f                          ; .#######
                        adc #$10                          ; 
                        sta BBZ_FireWorksSfxAdd_1         ; 
                        
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$7f                          ; .#######
                        adc #$1c                          ; 
                        sta BBZ_FireWorksSfxAdd_2         ; 
                        
                        ldy #$00                          ; 
.GetNextFireWorkSfx     lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$03                          ; ......##
                        clc                               ; 
                        adc BBZ_FireWorksSfxAdd_1         ; 
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$03                          ; ......##
                        clc                               ; 
                        adc BBZ_FireWorksSfxAdd_2         ; 
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
                        lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
.GetFireWorksSfx_01     lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$03                          ; ......##
                        beq .GetFireWorksSfx_01           ; 
                        
                        sec                               ; 
                        sbc #$02                          ; 
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
.GetFireWorksSfx_02     lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        cmp #$0a                          ; 
                        bcc .GetFireWorksSfx_02           ; 
                        
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        iny                               ; 
.GetFireWorksSfx_03     lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$03                          ; 
                        beq .GetFireWorksSfx_03           ; 
                        
                        sec                               ; 
                        sbc #$02                          ; 
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
.GetFireWorksSfx_04     lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        cmp #$0a                          ; 
                        bcc .GetFireWorksSfx_04           ; 
                        
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
.GetFireWorksSfx_05     sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
.GetFireWorksSfx_06     lda RANDOM                        ; SID($D41B) Current State Osc3's Wave / Rand No Generator
                        and #$3f                          ; ..######
                        adc #$1e                          ; 
                        sta (BBZ_FireWorksSfxPtr),y       ; 
                        
                        iny                               ; 
                        cpy #$fa                          ; 
                        bne .GetNextFireWorkSfx           ; 
                        
SetFireWorkSoundX       rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckJoystick         Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckJoystick           subroutine                        ; 
                        ldx #$17                          ; offset BBZ_CheckFireWaitP1
                        
                        lda [CIAPRB + $f0]                ; CIA1(CIAPRB=$DC01) mirror: Data Port Register B
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        lsr a                             ; right
                        
                        ldy BBZ_ActivePlayer              ; 
                        bmi .GoCheckFire                  ; player 1
                        
                        ldy GameOptsSticks                ; 
                        beq .GoCheckFire                  ; one stick
                        
                        lda [CIAPRA + $f0]                ; CIA1(CIAPRA=$DC00) mirror: Data Port Register A
                        lsr a                             ; up
                        lsr a                             ; down
                        lsr a                             ; left
                        lsr a                             ; right
                        
                        inx                               ; offset BBZ_CheckFireWaitP2
                        
.GoCheckFire            jsr JoyStickCheckFire             ; 
                        bcc CheckJoystickX                ; 
                        
                        ldx BBZ_KeyPressed                ; 
                        inx                               ; 
                        beq CheckJoystickX                ; 
                        
                        ldx #BBZ_KeyPressedNone           ; 
                        stx BBZ_KeyPressed                ; 
                        
                        clc                               ; 
CheckJoystickX          rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; ResetKeyPressed       Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
ResetKeyPressed         subroutine                        ; 
                        lda #$05                          ; 
                        sta BBZ_CheckFireWaitP1           ; 
                        sta BBZ_CheckFireWaitP2           ; 
                        
                        lda #BBZ_KeyPressedNone           ; 
                        sta BBZ_KeyPressed                ; 
                        
ResetKeyPressedX        rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
; SetTonePing           Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetTonePing             subroutine                        ; 
                        stx BBZ_TonePingCount             ; 
                        sty BBZ_TonePingHeight            ; 
                        
                        lda #$10                          ; 
                        sta BBZ_TonePingSusRel            ; 
                        
SetTonePingX            rts                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabBobFlyHatDir         dc.b $00 ; 0
                        dc.b $00 ; 0
                        dc.b $01 ; 1
                        dc.b $ff ; -1
                        
                        dc.b $3c ; 
                        dc.b $18 ; 
                        dc.b $00 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; CheckCallXtraLevels   Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
CheckCallXtraLevels     subroutine                        ; 
                        lda BBZ_SpecialSfxTime            ; 
                        beq .ChkSuicideLevelNum           ; 
                        
                        dec BBZ_SpecialSfxTime            ; 
                        bne .ChkSuicideLevelNum           ; 
                        
.SwitchSpecialSoundOff  ldy #$00                          ; Time
                        ldx #$00                          ; Oscillator Ctrl/SustainRelease
                        jsr SoundLevelSpecial             ; 
                        
.ChkSuicideLevelNum     lda BBZ_LevelNumEquiv             ; 
                        cmp #BBZ_LevelNumEquiv_12         ; Level LL - Acid Rain
                        beq .GetKeyPressed                ; 
                        
                        cmp #BBZ_LevelNumEquiv_23         ; Level WW - Advanced Pulverizors
                        beq .GetKeyPressed                ; 
                        
                        cmp #BBZ_LevelNumEquiv_24         ; Level XX - Mutants On The Move
                        beq .GetKeyPressed                ; 
                        
                        cmp #BBZ_LevelNumEquiv_02         ; Level BB - Utility Hoist
                        beq .GetKeyPressed                ; 
                        
.CheckBobStatus         lda BBZ_BobMoveType               ; 
                        cmp #BBZ_BobMoveTypeSink          ; 
.Exit_AlreadyDead       bcs SetTonePingX                  ; greater/equal = sink or death
                        
.GetKeyPressed          ldy BBZ_KeyPressed                ; 
                        bmi .SetMovLvlXtraSub             ; 
                        
.IniCheckPhoneNum       ldy BBZ_PhoneNoPtr                ; 
                        lda TabPhoneNum,y                 ; 
                        iny                               ; set to next digit
                        cmp BBZ_KeyPressed                ; 
                        bne .DialedWrongNo                ; 
                        
                        cpy #$0a                          ; 
                        bcc .StoreNoPtr                   ; lower
                        
.DialedCorrectNo        jsr BobSetDeath                   ; 
                        
.DialedWrongNo          ldy #$00                          ; 
                        
.StoreNoPtr             sty BBZ_PhoneNoPtr                ; 
                        
.SetMovLvlXtraSub       lda BBZ_LevelNumEquiv             ; move level xtras
                        clc                               ; 
                        adc #[[TabAutoMoveLevel - TabAutoDrawLevel] / $02] ; point behind TabAutoDrawLevel
                        asl a                             ; 
                        tax                               ; 
; -------------------------------------------------------------------------------------------------------------- ;
SetLevelAutoDrawSub     lda TabAutoDrawLevelLo,x          ; 
                        sta BBZ_LevelXtraPtrLo            ; 
                        lda TabAutoDrawLevelHi,x          ; 
                        sta BBZ_LevelXtraPtrHi            ; 
                        
CheckCallXtraLevelsX    jmp (BBZ_LevelXtraPtr)            ; with routines of TabAutoMoveLevel
; -------------------------------------------------------------------------------------------------------------- ;
; SetLevelHandlers      Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
SetLevelHandlers        subroutine                        ; 
                        ldx #$00                          ; 
                        stx BBZ_PhoneNoPtr                ; 
                        
                        inx                               ; $01
                        stx __MoveSpritesSpeed            ; 
                        stx __SetSpriteXmitColor_P1       ; 
                        
                        inx                               ; $02 - RED
                        stx __SetSpriteXmitColor_P2       ; 
                        
                        ldx #$30                          ; ..##....
                        stx __GetSpriteMove_B1            ; 
                        
                        ldx #$c0                          ; ##......
                        stx __GetSpriteMove_B2            ; 
; -------------------------------------------------------------------------------------------------------------- ;
.IniTimerSyncChkLoops   ldx #$03                          ; 
                        
.IniTimerOffset         ldy #$03                          ; TodTimer - TODTEN/TODSEC/TODMIN/TODHRS
.IniTimerHrsPM          lda #$80                          ; #....... - PM for TODHRS
.ChkTimerSync           eor TODTEN,y                      ; CIA1($DC08) Time of Day Clock Tenths of Seconds
                        cmp TO2TEN,y                      ; CIA2($DD08) Time of Day Clock Tenths of Seconds
                        bne .SetNextTimerSyncChk          ; 
                        
.IniTimerMinSec         lda #$00                          ; TODTEN/TODSEC/TODMIN
                        dey                               ; 
                        bpl .ChkTimerSync                 ; 
; -------------------------------------------------------------------------------------------------------------- ;
; Init Level Automatic Action
; -------------------------------------------------------------------------------------------------------------- ;
.IniLevelSprtAutoMove   lda BBZ_LevelNumEquiv             ; 
                        asl a                             ; *2
                        tax                               ; 
.SetLevelSprtAutoMove   lda TabAutoMoveSpritesLo,x        ; 
                        sta __IrqGameMovSprtLo            ; 
                        lda TabAutoMoveSpritesHi,x        ; 
                        sta __IrqGameMovSprtHi            ; 
                        
.IniLevelAutoDrawSub    lda BBZ_LevelNumEquiv             ; 
                        asl a                             ; *2
                        tax                               ; 
.SetLevelAutoDrawSub    jmp SetLevelAutoDrawSub           ; with routines of TabAutoDrawLevel
; -------------------------------------------------------------------------------------------------------------- ;
.SetNextTimerSyncChk    dex                               ; 
                        bne .IniTimerOffset               ; 
                        
.BadLevelSprtAutoMove   ldx #$c0                          ; get bad offset - should lead to an game abend
SetLevelHandlersX       bne .SetLevelSprtAutoMove         ; always
; -------------------------------------------------------------------------------------------------------------- ;
TabAutoDrawLevel        equ  *        ; 
TabAutoDrawLevelLo      equ [* - $02] ; 
TabAutoDrawLevelHi      equ [* - $01] ; 
                        dc.w IRQ_DrawXtraLvl_00  ; 21 = UU - rts                        Rest Stop # 2
                        dc.w IRQ_DrawXtraLvl_00  ; 25 = YY - rts                        The Floating Transporter
                        dc.w IRQ_DrawXtraLvl_06  ; 06 = FF -     elevator               The Grain Elevator
                        dc.w IRQ_DrawXtraLvl_00  ; 10 = JJ - rts                        The Gravity Lift
                        dc.w IRQ_DrawXtraLvl_03  ; 03 = CC -     suction tubes          The Suction Tubes
                        dc.w IRQ_DrawXtraLvl_00  ; 17 = QQ - rts                        Bonus Level # 2
                        dc.w IRQ_DrawXtraLvl_18  ; 18 = RR -     suction tubes          Super Energy Food Bars
                        dc.w IRQ_DrawXtraLvl_14  ; 14 = NN -     suction tubes          Hydraulic Lifts
                        dc.w IRQ_DrawXtraLvl_20  ; 20 = TT -     suction tubes          Mobile Suction Unit
                        dc.w IRQ_DrawXtraLvl_19  ; 19 = SS -     suction tubes/elevator The Sliding Candelabra
                        dc.w IRQ_DrawXtraLvl_00  ; 05 = EE - rts                        Jumping 101
                        dc.w IRQ_DrawXtraLvl_02  ; 02 = BB -     utility hoist          Utility Hoist
                        dc.w IRQ_DrawXtraLvl_00  ; 09 = II - rts                        Bonus Level # 1
                        dc.w IRQ_DrawXtraLvl_00  ; 15 = OO - rts                        Yukon's Revenge
                        dc.w IRQ_DrawXtraLvl_00  ; 08 = HH - rts                        Luxury Transporters
                        dc.w IRQ_DrawXtraLvl_22  ; 22 = VV -     suction tubes/cannon   Advanced Cannon
                        dc.w IRQ_DrawXtraLvl_00  ; 13 = MM - rts                        Rest Stop # 1
                        dc.w IRQ_DrawXtraLvl_00  ; 01 = AA - rts                        Bob's Morning Calisthenics
                        dc.w IRQ_DrawXtraLvl_00  ; 11 = KK - rts                        The Super Slippery Slide
                        dc.w IRQ_DrawXtraLvl_12  ; 12 = LL -     acid rain              Acid Rain
                        dc.w IRQ_DrawXtraLvl_23  ; 23 = WW -     suction tubes          Advanced Pulverizors
                        dc.w IRQ_DrawXtraLvl_00  ; 04 = DD - rts                        Bob's Playroom
                        dc.w IRQ_DrawXtraLvl_00  ; 07 = GG - rts                        Yukon's Penthouse
                        dc.w IRQ_DrawXtraLvl_16  ; 16 = PP -     suction tubes          The Advanced Suction Tubes
                        dc.w IRQ_DrawXtraLvl_24  ; 24 = XX -     mutants                Mutants On The Move
                        dc.w IRQ_DrawXtraLvl_00  ; 26 =    - rts
; -------------------------------------------------------------------------------------------------------------- ;
TabAutoMoveLevel        equ  *        ; 
TabAutoMoveLevelLo      equ [* - $02] ; 
TabAutoMoveLevelHi      equ [* - $01] ; 
                        dc.w IRQ_MoveXtraLvl_00  ; 21 = UU - rts                        Rest Stop # 2
                        dc.w IRQ_MoveXtraLvl_00  ; 25 = YY - rts                        The Floating Transporter  
                        dc.w IRQ_MoveXtraLvl_06  ; 06 = FF -     elevator               The Grain Elevator
                        dc.w IRQ_MoveXtraLvl_00  ; 10 = JJ - rts                        The Gravity Lift
                        dc.w IRQ_MoveXtraLvl_03  ; 03 = CC -     suction tubes          The Suction Tubes
                        dc.w IRQ_MoveXtraLvl_00  ; 17 = QQ - rts                        Bonus Level # 2
                        dc.w IRQ_MoveXtraLvl_18  ; 18 = RR -     suction tubes/surprise Super Energy Food Bars
                        dc.w IRQ_MoveXtraLvl_14  ; 14 = NN -     suction tubes          Hydraulic Lifts
                        dc.w IRQ_MoveXtraLvl_20  ; 20 = TT -     suction tubes          Mobile Suction Unit
                        dc.w IRQ_MoveXtraLvl_19  ; 19 = SS -     suction tubes/elevator The Sliding Candelabra
                        dc.w IRQ_MoveXtraLvl_00  ; 05 = EE - rts                        Jumping 101
                        dc.w IRQ_MoveXtraLvl_02  ; 02 = BB -     utility hoist          Utility Hoist
                        dc.w IRQ_MoveXtraLvl_00  ; 09 = II - rts                        Bonus Level # 1
                        dc.w IRQ_MoveXtraLvl_00  ; 15 = OO - rts                        Yukon's Revenge
                        dc.w IRQ_MoveXtraLvl_00  ; 08 = HH - rts                        Luxury Transporters
                        dc.w IRQ_MoveXtraLvl_22  ; 22 = VV -     suction tubes/cannon   Advanced Cannon
                        dc.w IRQ_MoveXtraLvl_00  ; 13 = MM - rts                        Rest Stop # 1
                        dc.w IRQ_MoveXtraLvl_00  ; 01 = AA - rts                        Bob's Morning Calisthenics
                        dc.w IRQ_MoveXtraLvl_00  ; 11 = KK - rts                        The Super Slippery Slide
                        dc.w IRQ_MoveXtraLvl_12  ; 12 = LL -     acid rain              Acid Rain
                        dc.w IRQ_MoveXtraLvl_23  ; 23 = WW -     suction tubes          Advanced Pulverizors
                        dc.w IRQ_MoveXtraLvl_00  ; 04 = DD - rts                        Bob's Playroom
                        dc.w IRQ_MoveXtraLvl_00  ; 07 = GG - rts                        Yukon's Penthouse
                        dc.w IRQ_MoveXtraLvl_16  ; 16 = PP -     suction tubes          The Advanced Suction Tubes
                        dc.w IRQ_MoveXtraLvl_24  ; 24 = XX -     mutants                Mutants On The Move
                        dc.w IRQ_MoveXtraLvl_00  ; 26 =    - rts
; -------------------------------------------------------------------------------------------------------------- ;
TabAutoMoveSprites      equ  *        ; 
TabAutoMoveSpritesLo    equ [* - $02] ; 
TabAutoMoveSpritesHi    equ [* - $01] ; 
                        dc.w IRQ_MoveSpritesPrep ; 21 = UU - 
                        dc.w IRQ_MoveSpritesPrep ; 25 = YY - 
                        dc.w IRQ_MoveSpritesPrep ; 06 = FF - 
                        dc.w IRQ_MoveSpritesPrep ; 10 = JJ - 
                        dc.w IRQ_MoveSpritesPrep ; 03 = CC - 
                        dc.w IRQ_MoveSpritesPrep ; 17 = QQ - 
                        dc.w IRQ_MoveSpritesPrep ; 18 = RR - 
                        dc.w IRQ_MoveSpritesPrep ; 14 = NN - 
                        dc.w IRQ_MoveSpritesXtra ; 20 = TT - Mobile Suction Tube
                        dc.w IRQ_MoveSpritesPrep ; 19 = SS - 
                        dc.w IRQ_MoveSpritesPrep ; 05 = EE - 
                        dc.w IRQ_MoveSpritesXtra ; 02 = BB - Utility Hoist
                        dc.w IRQ_MoveSpritesPrep ; 09 = II - 
                        dc.w IRQ_MoveSpritesPrep ; 15 = OO - 
                        dc.w IRQ_MoveSpritesPrep ; 08 = HH - 
                        dc.w IRQ_MoveSpritesPrep ; 22 = VV - 
                        dc.w IRQ_MoveSpritesPrep ; 13 = MM - 
                        dc.w IRQ_MoveSpritesPrep ; 01 = AA - 
                        dc.w IRQ_MoveSpritesPrep ; 11 = KK - 
                        dc.w IRQ_MoveSpritesPrep ; 12 = LL - 
                        dc.w IRQ_MoveSpritesPrep ; 23 = WW - 
                        dc.w IRQ_MoveSpritesPrep ; 04 = DD - 
                        dc.w IRQ_MoveSpritesPrep ; 07 = GG - 
                        dc.w IRQ_MoveSpritesPrep ; 16 = PP - 
                        dc.w IRQ_MoveSpritesPrep ; 24 = XX - 
                        dc.w IRQ_MoveSpritesPrep ; 26 = Congratulations
; -------------------------------------------------------------------------------------------------------------- ;
IRQ_MoveXtraLvl_00      rts                      ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabHoistSpriteStoreLo   dc.b <BB_SpriteStore0c   ; $00 ; 
                        dc.b <BB_SpriteStore0d   ; $40 ; 
                        dc.b <BB_SpriteStore0e   ; $80 ; 
                        dc.b <BB_SpriteStoreLo00 ; $00 ; 
                        dc.b <BB_SpriteStoreLo01 ; $40 ; 
                        dc.b <BB_SpriteStoreLo02 ; $80 ; 
                        dc.b <BB_SpriteStoreLo03 ; $c0 ; 
                        dc.b <BB_SpriteStoreLo04 ; $00 ; 
                        dc.b <BB_SpriteStoreLo05 ; $40 ; 
                        
TabHoistSpriteStoreHi   dc.b >BB_SpriteStore0c   ; $0f ; 
                        dc.b >BB_SpriteStore0d   ; $0f ; 
                        dc.b >BB_SpriteStore0e   ; $0f ; 
                        dc.b >BB_SpriteStoreLo00 ; $03 ; 
                        dc.b >BB_SpriteStoreLo01 ; $03 ; 
                        dc.b >BB_SpriteStoreLo02 ; $03 ; 
                        dc.b >BB_SpriteStoreLo03 ; $03 ; 
                        dc.b >BB_SpriteStoreLo04 ; $04 ; 
                        dc.b >BB_SpriteStoreLo05 ; $04 ; 
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteHoistTop       dc.b $71, $c0, $00 ; .###...###..............
                        dc.b $5f, $40, $00 ; .#.#####.#..............
                        dc.b $75, $c0, $00 ; .###.#.###..............
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $00, $00, $00 ; ........................
                        dc.b $04, $00, $00 ; .....#..................
                        dc.b $04, $00, $00 ; .....#..................
                        dc.b $04, $00, $00 ; .....#..................
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteHoistCageTop   dc.b $04, $00      ; .....#..................
                        dc.b $7f, $c0      ; .#########..............
                        dc.b $c0, $60      ; ##.......##.............
; -------------------------------------------------------------------------------------------------------------- ;
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
;                       dc.b $80, $20, $00 ; #.........#.............
; -------------------------------------------------------------------------------------------------------------- ;
TabSpriteHoistCageBot   dc.b $80, $20      ; #.........#.............
                        dc.b $ff, $e0      ; ###########.............
                        dc.b $ff, $e0      ; ###########.............
                        dc.b $00, $00      ; ........................
; -------------------------------------------------------------------------------------------------------------- ;
; GetXtraSprtStorPtr    Does    : 
;                       Expects : 
;                       Returns : 
; -------------------------------------------------------------------------------------------------------------- ;
GetXtraSprtStorPtr      subroutine                        ; 
                        ldx #$ff                          ; 
                        sec                               ; 
.Count                  inx                               ; 
                        sbc #$15                          ; 
                        bcs .Count                        ; 
                        
                        adc #$15                          ; revert last subtraction
                        
                        sta BBZ_DrawHiResPtrLo            ; 
                        asl a                             ; *2
                        adc BBZ_DrawHiResPtrLo            ; *3
                        tay                               ; 
                        iny                               ; 
                        
                        lda TabHoistSpriteStoreLo,x       ; 
                        sta BBZ_DrawHiResPtrLo            ; 
                        lda TabHoistSpriteStoreHi,x       ; 
                        sta BBZ_DrawHiResPtrHi            ; 
                        
GetXtraSprtStorPtrX     rts                               ; 
; -----------------------------------------------------------------------------------------------------